/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl.DefaultLocationDataLoader;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.Locale;

public class DefaultLocationByMaterialGroupDataLoader
extends DefaultLocationDataLoader {
    public DefaultLocationByMaterialGroupDataLoader(Context ctx, String storageOrgUnitId) {
        super(ctx, storageOrgUnitId);
    }

    @Override
    public DefaultLocationDataLoader setCondition(String materialGroupId, String warehouseId) throws EASBizException, BOSException {
        if (this.canAdd(materialGroupId, warehouseId)) {
            if (this.getMaxSize() == this.index) {
                this.loadData();
                this.clear();
            }
            this.sb.append(" (t0.FMaterialGroupID = '").append(materialGroupId).append("' ").append("and t0.FWarehouseID = '").append(warehouseId).append("' ").append("and t0.FIsDefaultLocation = 1) or");
            ++this.index;
        }
        return this;
    }

    @Override
    public void getCollection(IRowSet rs, IObjectCollection collection) throws EASBizException, BOSException {
        try {
            while (null != rs && rs.next()) {
                LocationInfo locInfo = new LocationInfo();
                locInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                BOSUuid oldId = locInfo.getId();
                locInfo.setId(BOSUuid.create((BOSObjectType)locInfo.getBOSType()));
                locInfo.setNumber(rs.getString("fnumber"));
                locInfo.setName(rs.getString("fname"));
                locInfo.setString("locKey", rs.getString("FMaterialGroupID") + rs.getString("FWarehouseID"));
                collection.addObject((IObjectValue)locInfo);
                locInfo.setId(oldId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public String getSelectSql(String sql) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t0.FMaterialGroupID,t0.FWarehouseID,t1.fid,t1.fnumber,t1.fname_").append(LocaleUtils.getLocaleString((Locale)this.ctx.getLocale())).append(" fname ").append("  from T_DB_MaterialStorageAssign t0,T_DB_LOCATION t1 ").append("where t1.fid = t0.FLocationID ").append("and t0.FStorageOrgID = '").append(this.storageOrgUnitId).append("' and t0.FStorageAssignType = ").append(new Integer(1)).append(" and ( ");
        return sb.toString() + sql + " 1=2 ) ";
    }

    @Override
    protected String getMultiKeyValue(IRowSet rs) throws SQLException {
        return rs.getString("FMaterialGroupID") + rs.getString("FWarehouseID");
    }
}

