/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractSqlDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.Locale;

public class DefaultLocationDataLoader
extends AbstractSqlDataLoader {
    String storageOrgUnitId;
    public static final String LOCATIONMULTIKEY = "locKey";

    public DefaultLocationDataLoader(Context ctx, String storageOrgUnitId) {
        super(ctx);
        this.storageOrgUnitId = storageOrgUnitId;
    }

    public DefaultLocationDataLoader setCondition(String materialId, String warehouseId) throws EASBizException, BOSException {
        if (this.canAdd(materialId, warehouseId)) {
            if (this.getMaxSize() == this.index) {
                this.loadData();
                this.clear();
            }
            this.sb.append(" (t0.FMaterialID = '").append(materialId).append("' ").append("and t0.FWarehouseID = '").append(warehouseId).append("' ").append("and t0.FIsDefaultLocation = 1) or");
            ++this.index;
        }
        return this;
    }

    @Override
    public String getSelectSql(String sql) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t0.FMaterialID,t0.FWarehouseID,t1.fid,t1.fnumber,t1.fname_").append(LocaleUtils.getLocaleString((Locale)this.ctx.getLocale())).append(" fname ").append("  from T_DB_MaterialStorageAssign t0,T_DB_LOCATION t1 ").append("where t1.fid = t0.FLocationID ").append("and t0.FStorageOrgID = '").append(this.storageOrgUnitId).append("' and t0.FStorageAssignType = ").append(new Integer(0)).append(" and ( ");
        return sb.toString() + sql + " 1=2 ) ";
    }

    protected boolean canAdd(String materialId, String warehouseId) {
        return !EmptyUtil.isEmpty((String)materialId) && !EmptyUtil.isEmpty((String)warehouseId) && !this.checkDump(materialId, warehouseId);
    }

    protected boolean checkDump(String materialId, String warehouseId) {
        boolean flag = false;
        if (this.dumpMap.containsKey(materialId + warehouseId)) {
            flag = true;
        } else {
            this.dumpMap.put(materialId + warehouseId, null);
        }
        return flag;
    }

    @Override
    public void getCollection(IRowSet rs, IObjectCollection collection) throws EASBizException, BOSException {
        try {
            while (null != rs && rs.next()) {
                LocationInfo locInfo = new LocationInfo();
                locInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                BOSUuid oldId = locInfo.getId();
                locInfo.setId(BOSUuid.create((BOSObjectType)locInfo.getBOSType()));
                locInfo.setNumber(rs.getString("fnumber"));
                locInfo.setName(rs.getString("fname"));
                locInfo.setString(LOCATIONMULTIKEY, rs.getString("FMaterialID") + rs.getString("FWarehouseID"));
                collection.addObject((IObjectValue)locInfo);
                locInfo.setId(oldId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String getMultiKeyValue(IRowSet rs) throws SQLException {
        return rs.getString("FMaterialID") + rs.getString("FWarehouseID");
    }

    @Override
    public IObjectCollection createCollection() {
        return new LocationCollection();
    }

    @Override
    public void dealResult(Future future) throws EASBizException, BOSException {
        LocationCollection collection = (LocationCollection)future.getResult();
        int countj = collection.size();
        for (int j = 0; j < countj; ++j) {
            LocationInfo info = collection.get(j);
            String key = info.getString(LOCATIONMULTIKEY);
            this.result.put(key, info);
        }
    }
}

