/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeCollection;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractObjectDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;

public class DefaultProductTransactionTypeDataLoader
extends AbstractObjectDataLoader {
    public DefaultProductTransactionTypeDataLoader(Context ctx, SelectorItemCollection selector) {
        super(ctx, selector);
    }

    public DefaultProductTransactionTypeDataLoader(Context ctx, SelectorItemCollection selector, ObjectDataLoaderRequestQueue requestQueue) {
        super(ctx, selector);
        this.requestQueue = requestQueue;
    }

    public DefaultProductTransactionTypeDataLoader setCondition(String storageOrgUnitId, String adminOrgUnitId) throws EASBizException, BOSException {
        if (this.canAdd(storageOrgUnitId, adminOrgUnitId)) {
            if (this.getMaxSize() == this.index) {
                this.loadData();
                this.clear();
            }
            this.filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)storageOrgUnitId));
            this.filter.getFilterItems().add(new FilterItemInfo("adminDepartment", (Object)adminOrgUnitId));
            if (this.mask.length() > 0) {
                this.mask.append(" OR ");
            }
            this.mask.append("(#").append(this.index * 2).append(" AND #").append(this.index * 2 + 1).append(")");
            ++this.index;
        }
        return this;
    }

    @Override
    public IObjectCollection getCollection(EntityViewInfo view) throws EASBizException, BOSException {
        return ProductTransactionTypeFactory.getLocalInstance((Context)this.ctx).getProductTransactionTypeCollection(view);
    }

    protected boolean canAdd(String storageOrgUnitId, String adminOrgUnitId) {
        return !EmptyUtil.isEmpty((String)storageOrgUnitId) && !EmptyUtil.isEmpty((String)adminOrgUnitId) && !this.checkDump(storageOrgUnitId, adminOrgUnitId);
    }

    protected boolean checkDump(String storageOrgUnitId, String adminOrgUnitId) {
        boolean flag = false;
        if (this.dumpMap.containsKey(storageOrgUnitId + adminOrgUnitId)) {
            flag = true;
        } else {
            this.dumpMap.put(storageOrgUnitId + adminOrgUnitId, null);
        }
        return flag;
    }

    @Override
    public void dealResult(Future future) throws EASBizException, BOSException {
        ProductTransactionTypeCollection collection = (ProductTransactionTypeCollection)future.getResult();
        int countj = collection.size();
        for (int j = 0; j < countj; ++j) {
            ProductTransactionTypeInfo info = collection.get(j);
            this.result.put(info.getStorageOrgUnit().getId().toString() + info.getAdminDepartment().getId().toString(), info);
        }
    }
}

