/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.StandardRootingCollection;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractObjectDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;

public class DefaultStandardRootingDataLoader
extends AbstractObjectDataLoader {
    public DefaultStandardRootingDataLoader(Context ctx, SelectorItemCollection selector) {
        super(ctx, selector);
    }

    public DefaultStandardRootingDataLoader(Context ctx, SelectorItemCollection selector, ObjectDataLoaderRequestQueue requestQueue) {
        super(ctx, selector, requestQueue);
    }

    public DefaultStandardRootingDataLoader setCondition(String storageOrgUnitId, String materialId) throws EASBizException, BOSException {
        if (this.canAdd(storageOrgUnitId, materialId)) {
            if (this.getMaxSize() == this.index) {
                this.loadData();
                this.clear();
            }
            this.filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId));
            this.filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
            if (this.mask.length() > 0) {
                this.mask.append(" OR ");
            }
            this.mask.append("(#").append(this.index * 2).append(" AND #").append(this.index * 2 + 1).append(")");
            ++this.index;
        }
        return this;
    }

    @Override
    public IObjectCollection getCollection(EntityViewInfo view) throws EASBizException, BOSException {
        return StandardRootingFactory.getLocalInstance((Context)this.ctx).getStandardRootingCollection(view);
    }

    protected boolean canAdd(String storageOrgUnitId, String materialId) {
        return !EmptyUtil.isEmpty((String)storageOrgUnitId) && !EmptyUtil.isEmpty((String)materialId) && !this.checkDump(storageOrgUnitId, materialId);
    }

    protected boolean checkDump(String storageOrgUnitId, String materialId) {
        boolean flag = false;
        if (this.dumpMap.containsKey(storageOrgUnitId + materialId)) {
            flag = true;
        } else {
            this.dumpMap.put(storageOrgUnitId + materialId, null);
        }
        return flag;
    }

    @Override
    public void dealResult(Future future) throws EASBizException, BOSException {
        StandardRootingCollection collection = (StandardRootingCollection)future.getResult();
        int countj = collection.size();
        for (int j = 0; j < countj; ++j) {
            StandardRootingInfo info = collection.get(j);
            this.result.put(info.getStorageOrgUnit().getId().toString() + info.getMaterial().getId().toString(), info);
        }
    }
}

