/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryCollection;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryFactory;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractObjectDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;

public class MaterialRootingEntryDataLoader
extends AbstractObjectDataLoader {
    public MaterialRootingEntryDataLoader(Context ctx, SelectorItemCollection selector) {
        super(ctx, selector);
    }

    public MaterialRootingEntryDataLoader(Context ctx, SelectorItemCollection selector, ObjectDataLoaderRequestQueue requestQueue) {
        super(ctx, selector, requestQueue);
    }

    public MaterialRootingEntryDataLoader setCondition(String parentId) throws EASBizException, BOSException {
        if (this.canAdd(parentId)) {
            if (this.getMaxSize() == this.index) {
                this.loadData();
                this.clear();
            }
            this.filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentId));
            if (this.mask.length() > 0) {
                this.mask.append(" OR ");
            }
            this.mask.append("(#").append(this.index).append(")");
            ++this.index;
        }
        return this;
    }

    protected boolean canAdd(String parentId) {
        return !EmptyUtil.isEmpty((String)parentId) && !this.checkDump(parentId);
    }

    protected boolean checkDump(String parentId) {
        boolean flag = false;
        if (this.dumpMap.containsKey(parentId)) {
            flag = true;
        } else {
            this.dumpMap.put(parentId, null);
        }
        return flag;
    }

    @Override
    public IObjectCollection getCollection(EntityViewInfo view) throws EASBizException, BOSException {
        return MRWorkProcesEntryFactory.getLocalInstance((Context)this.ctx).getMRWorkProcesEntryCollection(view);
    }

    @Override
    public void dealResult(Future future) throws EASBizException, BOSException {
        MRWorkProcesEntryCollection collection = (MRWorkProcesEntryCollection)future.getResult();
        int countj = collection.size();
        for (int j = 0; j < countj; ++j) {
            MRWorkProcesEntryInfo info = collection.get(j);
            String key = info.getParent().getId().toString();
            if (this.result.containsKey(key)) {
                ((MRWorkProcesEntryCollection)this.result.get(key)).add(info);
                continue;
            }
            MRWorkProcesEntryCollection col = new MRWorkProcesEntryCollection();
            col.add(info);
            this.result.put(key, col);
        }
    }
}

