/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractObjectDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;

public class MultiMeasureUnitDataLoader
extends AbstractObjectDataLoader {
    public MultiMeasureUnitDataLoader(Context ctx, SelectorItemCollection selector) {
        super(ctx, selector);
    }

    public MultiMeasureUnitDataLoader(Context ctx, SelectorItemCollection selector, ObjectDataLoaderRequestQueue requestQueue) {
        super(ctx, selector, requestQueue);
    }

    public MultiMeasureUnitDataLoader setCondition(String materialId, String unitId) throws EASBizException, BOSException {
        if (this.canAdd(materialId, unitId)) {
            if (this.getMaxSize() == this.index) {
                this.loadData();
                this.clear();
            }
            this.filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
            this.filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitId));
            if (this.mask.length() > 0) {
                this.mask.append(" OR ");
            }
            this.mask.append("(#").append(this.index * 2).append(" AND #").append(this.index * 2 + 1).append(")");
            ++this.index;
        }
        return this;
    }

    @Override
    public IObjectCollection getCollection(EntityViewInfo view) throws EASBizException, BOSException {
        return MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx).getMultiMeasureUnitCollection(view);
    }

    protected boolean canAdd(String materialId, String unitId) {
        return !EmptyUtil.isEmpty((String)materialId) && !EmptyUtil.isEmpty((String)unitId) && !this.checkDump(materialId, unitId);
    }

    protected boolean checkDump(String materialId, String unitId) {
        boolean flag = false;
        if (this.dumpMap.containsKey(materialId + unitId)) {
            flag = true;
        } else {
            this.dumpMap.put(materialId + unitId, null);
        }
        return flag;
    }

    @Override
    public void dealResult(Future future) throws EASBizException, BOSException {
        MultiMeasureUnitCollection collection = (MultiMeasureUnitCollection)future.getResult();
        int countj = collection.size();
        for (int j = 0; j < countj; ++j) {
            MultiMeasureUnitInfo info = collection.get(j);
            this.result.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info);
        }
    }
}

