/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.PBOMCollection;
import com.kingdee.eas.mm.basedata.PBOMFactory;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractObjectDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;

public class PBomDataLoader
extends AbstractObjectDataLoader {
    public PBomDataLoader(Context ctx, SelectorItemCollection selector) {
        super(ctx, selector);
    }

    public PBomDataLoader(Context ctx, SelectorItemCollection selector, ObjectDataLoaderRequestQueue requestQueue) {
        super(ctx, selector, requestQueue);
    }

    public PBomDataLoader setCondition(String storageOrgUnitId, String bomId, String projectId, String trackNumberId) throws EASBizException, BOSException {
        if (this.canAdd(storageOrgUnitId, bomId, projectId, trackNumberId)) {
            if (this.getMaxSize() == this.index) {
                this.loadData();
                this.clear();
            }
            this.filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId));
            this.filter.getFilterItems().add(new FilterItemInfo("bom.id", (Object)bomId));
            if (null != projectId) {
                this.filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectId));
            } else {
                this.filter.getFilterItems().add(new FilterItemInfo("project.id", null, CompareType.EQUALS));
            }
            if (null != trackNumberId) {
                this.filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)trackNumberId));
            } else {
                this.filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", null, CompareType.EQUALS));
            }
            if (this.mask.length() > 0) {
                this.mask.append(" OR ");
            }
            this.mask.append("(#").append(this.index * 4).append(" AND #").append(this.index * 4 + 1).append(" AND #").append(this.index * 4 + 2).append(" AND #").append(this.index * 4 + 3).append(")");
            ++this.index;
        }
        return this;
    }

    protected boolean canAdd(String storageOrgUnitId, String bomId, String projectId, String trackNumberId) {
        return !EmptyUtil.isEmpty((String)storageOrgUnitId) && !EmptyUtil.isEmpty((String)bomId) && !this.checkDump(storageOrgUnitId, bomId, projectId, trackNumberId);
    }

    protected boolean checkDump(String storageOrgUnitId, String bomId, String projectId, String trackNumberId) {
        boolean flag = false;
        if (this.dumpMap.containsKey(storageOrgUnitId + bomId + projectId + trackNumberId)) {
            flag = true;
        } else {
            this.dumpMap.put(storageOrgUnitId + bomId + projectId + trackNumberId, null);
        }
        return flag;
    }

    @Override
    public IObjectCollection getCollection(EntityViewInfo view) throws EASBizException, BOSException {
        return PBOMFactory.getLocalInstance((Context)this.ctx).getCollection(view);
    }

    @Override
    public void dealResult(Future future) throws EASBizException, BOSException {
        IObjectCollection collection = future.getResult();
        String projectId = null;
        String trackNumberId = null;
        int countj = collection.size();
        for (int j = 0; j < countj; ++j) {
            PBOMInfo info = (PBOMInfo)collection.getObject(j);
            projectId = null == info.getProject() ? null : info.getProject().getId().toString();
            trackNumberId = null == info.getTrackNumber() ? null : info.getTrackNumber().getId().toString();
            String key = info.getStorageOrgUnit().getId().toString() + info.getBom().getId().toString() + projectId + trackNumberId;
            if (this.result.containsKey(key)) {
                ((PBOMCollection)this.result.get(key)).add(info);
                continue;
            }
            PBOMCollection col = new PBOMCollection();
            col.add(info);
            this.result.put(key, col);
        }
    }
}

