/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMEntryCollection;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.AbstractProcessor;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.PlannedOrderOutputsEntryCollection;
import com.kingdee.eas.mm.planning.PlannedOrderOutputsEntryInfo;
import java.math.BigDecimal;

public class BomExpendDealOutputs4StockProcessor
extends AbstractProcessor {
    public static final String BOMENTRYID = "bomentryid_ex";
    public static final String OPERATION = "operation_ex";
    public static final String OPERATIONNO = "operationno_ex";

    public BomExpendDealOutputs4StockProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
    }

    @Override
    public void innerDoing() throws EASBizException, BOSException {
        int count = this.collection.size();
        for (int i = 0; i < count; ++i) {
            PBOMInfo pbomInfo;
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
            if (null == mo.getRouting() || null == (pbomInfo = (PBOMInfo)mo.get("pBom_ex"))) continue;
            PlannedOrderInfo plannedOrderInfo = (PlannedOrderInfo)mo.get("plannedOrder_ex");
            PlannedOrderOutputsEntryCollection outputs = plannedOrderInfo.getOutputEntries();
            outputs.clear();
            PBOMEntryCollection pBomEntry = pbomInfo.getPbomEntry();
            int countj = pBomEntry.size();
            for (int j = 0; j < countj; ++j) {
                BigDecimal qty;
                PBOMEntryInfo pBomEntryInfo = pBomEntry.get(j);
                BomEntryInfo bi = pBomEntryInfo.getBomItem();
                if (null == bi || MaterialProductEnum.BYPRODUCT != bi.getOutputType() && MaterialProductEnum.RELATEDPRODUCT != bi.getOutputType()) continue;
                PlannedOrderOutputsEntryInfo info = new PlannedOrderOutputsEntryInfo();
                info.setMaterial(bi.getMaterial());
                info.setBaseUnit(bi.getBaseUnit());
                info.setUnit(bi.getUnit());
                if (Boolean.TRUE == (Boolean)mo.get("pBomFromBomExtend")) {
                    info.setBaseQty(bi.getBigDecimal("baseQty_ex"));
                    int prec = ((MultiMeasureUnitInfo)bi.get("multimeasureunit_ex")).getQtyPrecision();
                    BigDecimal conversationRate = ((MultiMeasureUnitInfo)bi.get("multimeasureunit_ex")).getBaseConvsRate();
                    qty = info.getBaseQty().divide(conversationRate, prec, 4);
                    info.setQty(qty);
                } else {
                    BigDecimal unitQty = null == pBomEntryInfo.getUnitQty() ? new BigDecimal("1") : pBomEntryInfo.getUnitQty();
                    int prec = ((MultiMeasureUnitInfo)bi.get("multimeasureunit_ex")).getQtyPrecision();
                    qty = unitQty.multiply(mo.getQty()).setScale(prec, 2);
                    info.setQty(qty);
                }
                info.setOutputType(bi.getOutputType());
                info.setString(BOMENTRYID, bi.getId().toString());
                info.setRemark(bi.getRemark());
                int lastWP = mo.getRouting().getMaterialRooting().getLastWP();
                if (0 == lastWP) {
                    lastWP = mo.getRouting().getMaterialRooting().getFirstWP();
                }
                int wpSeq = -1;
                wpSeq = Boolean.TRUE == (Boolean)mo.get("pBomFromBomExtend") ? lastWP : pBomEntryInfo.getRoutingItem().getWpSeq();
                info.put(OPERATIONNO, (Object)new Integer(wpSeq));
                ManufactureOrderTechnicsCollection technics = mo.getTechnics();
                int countk = technics.size();
                for (int k = 0; k < countk; ++k) {
                    ManufactureOrderTechnicsInfo _ = technics.get(k);
                    if (_.getOperationNo() != wpSeq) continue;
                    info.put(OPERATION, (Object)_.getOperation());
                    break;
                }
                outputs.add(info);
            }
        }
    }
}

