/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMEntryCollection;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.AbstractProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.WrapCollection;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ProcessorRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.request.AbstractProcessorRequest;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ClearReferenceProcessor
extends AbstractProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.ReleaseMemoryProcessor");
    public static final String MULTIMEASUREUNIT = "multimeasureunit_ex";
    public static final String MATERIALINVENTORY = "materialInventory_ex";
    public static final String MATERIALPLAN = "materialPlan_ex";
    public static final String BOMENTRYINFO = "bomEntryInfo_ex";
    public static final String PBOM = "pBom_ex";
    public static final String PLANNEDORDER = "plannedOrder_ex";
    private static final int MAXSIZE = 100;
    protected String[] cleanItems = null;
    private ProcessorRequestQueue processorRequestQueue;

    public ClearReferenceProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
    }

    public ClearReferenceProcessor(Context ctx, IObjectCollection collection, String[] cleanItems) {
        super(ctx, collection);
        this.cleanItems = cleanItems;
    }

    public ClearReferenceProcessor(Context ctx, IObjectCollection collection, ProcessorRequestQueue processorRequestQueue) {
        this(ctx, collection);
        this.processorRequestQueue = processorRequestQueue;
    }

    public ClearReferenceProcessor(Context ctx, IObjectCollection collection, String[] cleanItems, ProcessorRequestQueue processorRequestQueue) {
        this(ctx, collection, cleanItems);
        this.processorRequestQueue = processorRequestQueue;
    }

    @Override
    public void innerDoing() throws EASBizException, BOSException {
        int i;
        ArrayList<Future> futureList = new ArrayList<Future>();
        int size = this.collection.size();
        int begin = 0;
        int end = 0;
        int time = size % this.getMaxSize() == 0 ? size / this.getMaxSize() : size / this.getMaxSize() + 1;
        for (i = 0; i < time; ++i) {
            begin = this.getMaxSize() * i;
            end = i + 1 < time ? this.getMaxSize() * (i + 1) : size;
            Future future = new Future();
            final int start = begin;
            final int over = end;
            final IObjectCollection cols = this.collection;
            AbstractProcessorRequest request = new AbstractProcessorRequest(future, this){

                @Override
                public void doing() {
                    WrapCollection data = new WrapCollection(cols);
                    try {
                        for (int i = start; i < over; ++i) {
                            ManufactureOrderInfo mo = (ManufactureOrderInfo)cols.getObject(i);
                            ClearReferenceProcessor.this.clean(mo);
                        }
                        this.future.setData(data);
                    }
                    catch (Exception e) {
                        logger.info((Object)(ClearReferenceProcessor.this.getLogDesc() + " ERROR:"), (Throwable)e);
                        this.future.setException(e);
                    }
                }
            };
            if (null != this.processorRequestQueue) {
                logger.info((Object)(this.getLogDesc() + " main thread user blockedQueue! "));
                try {
                    this.processorRequestQueue.putRequest(request);
                }
                catch (InterruptedException e) {
                    logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
                    logger.info((Object)(this.getLogDesc() + " main thread put request error: " + e.getMessage()));
                    future.setException(e);
                }
            } else {
                logger.info((Object)(this.getLogDesc() + " main thread user itselef! "));
                request.doing();
            }
            futureList.add(future);
        }
        logger.info((Object)"begin waiting");
        int count = futureList.size();
        for (i = 0; i < count; ++i) {
            Future future = (Future)futureList.get(i);
            future.getResult();
        }
        logger.info((Object)"end waiting");
    }

    protected void clean(ManufactureOrderInfo mo) {
        ClearReferenceProcessor.clean(mo, this.cleanItems);
    }

    protected static void cleanBomEntryInfo(ManufactureOrderInfo mo) {
        ManufactureOrderStockCollection stocks = mo.getStocks();
        if (null != stocks) {
            int countj = stocks.size();
            for (int j = 0; j < countj; ++j) {
                ManufactureOrderStockInfo stock = stocks.get(j);
                stock.put(BOMENTRYINFO, null);
            }
        }
    }

    protected static void cleanMultiMeasureUnitInfo(ManufactureOrderInfo mo) {
        ManufactureOrderStockCollection stocks;
        int j;
        int countj;
        PBOMEntryCollection pBomEntry;
        PBOMInfo pBom = (PBOMInfo)mo.get(PBOM);
        if (null != pBom && null != (pBomEntry = pBom.getPbomEntry())) {
            countj = pBomEntry.size();
            for (j = 0; j < countj; ++j) {
                PBOMEntryInfo pBomEntryInfo = pBomEntry.get(j);
                BomEntryInfo bi = pBomEntryInfo.getBomItem();
                bi.put(MULTIMEASUREUNIT, null);
            }
        }
        if (null != (stocks = mo.getStocks())) {
            countj = stocks.size();
            for (j = 0; j < countj; ++j) {
                ManufactureOrderStockInfo stock = stocks.get(j);
                stock.put(MULTIMEASUREUNIT, null);
            }
        }
    }

    protected static void cleanMaterialPlanInfo(ManufactureOrderInfo mo) {
        mo.put(MATERIALPLAN, null);
        ManufactureOrderStockCollection stocks = mo.getStocks();
        if (null != stocks) {
            int countj = stocks.size();
            for (int j = 0; j < countj; ++j) {
                ManufactureOrderStockInfo stock = stocks.get(j);
                stock.put(MATERIALPLAN, null);
            }
        }
    }

    protected static void cleanMaterialInventoryInfo(ManufactureOrderInfo mo) {
        mo.put(MATERIALINVENTORY, null);
    }

    protected static void cleanPbom(ManufactureOrderInfo mo) {
        mo.put(PBOM, null);
    }

    protected static void cleanPlannedOrder(ManufactureOrderInfo mo) {
        mo.put(PLANNEDORDER, null);
    }

    public static void clean(ManufactureOrderInfo mo, String[] cleanItems) {
        if (null == mo) {
            return;
        }
        if (null == cleanItems) {
            ClearReferenceProcessor.cleanPlannedOrder(mo);
            ClearReferenceProcessor.cleanMaterialInventoryInfo(mo);
            ClearReferenceProcessor.cleanPbom(mo);
            ClearReferenceProcessor.cleanMaterialPlanInfo(mo);
            ClearReferenceProcessor.cleanMultiMeasureUnitInfo(mo);
            ClearReferenceProcessor.cleanBomEntryInfo(mo);
        } else {
            for (String _ : cleanItems) {
                if (PLANNEDORDER.equals(_)) {
                    ClearReferenceProcessor.cleanPlannedOrder(mo);
                    continue;
                }
                if (PBOM.equals(_)) {
                    ClearReferenceProcessor.cleanPbom(mo);
                    continue;
                }
                if (MATERIALINVENTORY.equals(_)) {
                    ClearReferenceProcessor.cleanMaterialInventoryInfo(mo);
                    continue;
                }
                if (MATERIALPLAN.equals(_)) {
                    ClearReferenceProcessor.cleanMaterialPlanInfo(mo);
                    continue;
                }
                if (MULTIMEASUREUNIT.equals(_)) {
                    ClearReferenceProcessor.cleanMultiMeasureUnitInfo(mo);
                    continue;
                }
                if (!BOMENTRYINFO.equals(_)) continue;
                ClearReferenceProcessor.cleanBomEntryInfo(mo);
            }
        }
    }

    protected int getMaxSize() {
        return 100;
    }
}

