/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl.DefaultLocationByMaterialGroupDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl.DefaultLocationDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl.MaterialGroupDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.AbstractProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocationProcessor4StockProcessor
extends AbstractProcessor {
    private List warehouseList;
    private List materialList;
    private String storageOrgUnitId;
    private int begin;
    private int end;

    @Override
    public void innerDoing() throws EASBizException, BOSException {
        DefaultLocationDataLoader loader = new DefaultLocationDataLoader(this.ctx, this.storageOrgUnitId);
        int count = this.materialList.size();
        for (int i = 0; i < count; ++i) {
            loader.setCondition((String)this.materialList.get(i), (String)this.warehouseList.get(i));
        }
        loader.loadData();
        Map map = loader.getResultMap();
        String multiKey = "";
        ArrayList<String> warehouseList = new ArrayList<String>();
        ArrayList<String> materialGroupList = new ArrayList<String>();
        for (int i = this.begin; i < this.end; ++i) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
            ManufactureOrderStockCollection stocks = mo.getStocks();
            int countj = stocks.size();
            for (int j = 0; j < countj; ++j) {
                ManufactureOrderStockInfo stock = stocks.get(j);
                if (null == stock.getWarehouse() || null != stock.getLocation()) continue;
                multiKey = stock.getMaterial().getId().toString() + stock.getWarehouse().getId().toString();
                if (map.containsKey(multiKey)) {
                    stock.setLocation((LocationInfo)map.get(multiKey));
                    continue;
                }
                materialGroupList.add(stock.getMaterial().getId().toString());
                warehouseList.add(stock.getWarehouse().getId().toString());
            }
        }
        if (!materialGroupList.isEmpty() && !warehouseList.isEmpty() && materialGroupList.size() == warehouseList.size()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("materialGroup.id"));
            MaterialGroupDataLoader materialGroupDataLoader = new MaterialGroupDataLoader(this.ctx, sic);
            int count2 = materialGroupList.size();
            for (int i = 0; i < count2; ++i) {
                materialGroupDataLoader.setCondition((String)materialGroupList.get(i));
            }
            materialGroupDataLoader.loadData();
            map = materialGroupDataLoader.getResultMap();
            multiKey = "";
            DefaultLocationByMaterialGroupDataLoader defaultLocationByMaterialGroupDataLoader = new DefaultLocationByMaterialGroupDataLoader(this.ctx, this.storageOrgUnitId);
            int count3 = materialGroupList.size();
            for (int i = 0; i < count3; ++i) {
                MaterialInfo mi = (MaterialInfo)map.get((String)materialGroupList.get(i));
                if (null == mi) continue;
                defaultLocationByMaterialGroupDataLoader.setCondition(mi.getMaterialGroup().getId().toString(), (String)warehouseList.get(i));
            }
            defaultLocationByMaterialGroupDataLoader.loadData();
            Map mapLocation = defaultLocationByMaterialGroupDataLoader.getResultMap();
            for (int i = this.begin; i < this.end; ++i) {
                ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
                ManufactureOrderStockCollection stocks = mo.getStocks();
                int countj = stocks.size();
                for (int j = 0; j < countj; ++j) {
                    ManufactureOrderStockInfo stock = stocks.get(j);
                    if (null == stock.getWarehouse() || null != stock.getLocation()) continue;
                    String materialGroupId = null;
                    MaterialInfo mi = (MaterialInfo)map.get((String)materialGroupList.get(i));
                    if (null != mi) {
                        materialGroupId = mi.getMaterialGroup().getId().toString();
                    }
                    if (!mapLocation.containsKey(multiKey = materialGroupId + stock.getWarehouse().getId().toString())) continue;
                    stock.setLocation((LocationInfo)mapLocation.get(multiKey));
                }
            }
        }
    }

    public LocationProcessor4StockProcessor(Context ctx, IObjectCollection collection, List materialList, List warehouseList, String storageOrgUnitId) {
        super(ctx, collection);
        this.materialList = materialList;
        this.warehouseList = warehouseList;
        this.storageOrgUnitId = storageOrgUnitId;
        this.begin = 0;
        this.end = collection.size();
    }

    public LocationProcessor4StockProcessor(Context ctx, IObjectCollection collection, List materialList, List warehouseList, String storageOrgUnitId, int begin, int end) {
        super(ctx, collection);
        this.materialList = materialList;
        this.warehouseList = warehouseList;
        this.storageOrgUnitId = storageOrgUnitId;
        this.begin = begin;
        this.end = end;
    }
}

