/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl.MultiMeasureUnitDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.AbstractProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.RefindBomProcessor4TechnicsProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Map;

public class MOHeaderDataProcessor
extends AbstractProcessor {
    private ObjectDataLoaderRequestQueue requestQueue;

    public MOHeaderDataProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
        this.addBeforeProcessor(new RefindBomProcessor4TechnicsProcessor(ctx, collection));
    }

    public MOHeaderDataProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue requestQueue) {
        super(ctx, collection);
        this.requestQueue = requestQueue;
        this.addBeforeProcessor(new RefindBomProcessor4TechnicsProcessor(ctx, collection));
    }

    @Override
    public void innerDoing() throws EASBizException, BOSException {
        ManufactureOrderInfo mo;
        int i;
        MultiMeasureUnitDataLoader mmuLoader = this.loadMultiMeasureUnitInfo();
        mmuLoader.loadData();
        Map map = mmuLoader.getResultMap();
        String multiKey = "";
        int count = this.collection.size();
        for (i = 0; i < count; ++i) {
            mo = (ManufactureOrderInfo)this.collection.getObject(i);
            multiKey = mo.getMaterial().getId().toString() + mo.getUnit().getId().toString();
            mo.put("multimeasureunit_ex", (MultiMeasureUnitInfo)map.get(multiKey));
        }
        count = this.collection.size();
        for (i = 0; i < count; ++i) {
            mo = (ManufactureOrderInfo)this.collection.getObject(i);
            this.setMOHeaderDefaultDate(mo);
        }
    }

    protected void setMOHeaderDefaultDate(ManufactureOrderInfo mo) {
        String sourceBillTypeID = mo.getSourceBillType().getId().toString();
        MaterialPlanInfo materialPlanInfo = (MaterialPlanInfo)mo.get("materialPlan_ex");
        MaterialInventoryInfo materialInventoryInfo = (MaterialInventoryInfo)mo.get("materialInventory_ex");
        BomInfo bomInfo = (BomInfo)mo.get("bominfo_ex");
        MultiMeasureUnitInfo mmu = (MultiMeasureUnitInfo)mo.get("multimeasureunit_ex");
        if (sourceBillTypeID.equals("9XXvbVGlRtym/0qtqeIXXrhE1B8=")) {
            mo.setPlanBeginDate(MMCommonUtils.clearTime((Timestamp)mo.getPlanBeginDate()));
            mo.setPlanEndDate(MMCommonUtils.clearTime((Timestamp)mo.getPlanEndDate()));
            if (mo.getDispatcher() == null) {
                mo.setDispatcher(materialPlanInfo.getPlanner());
            }
            if (mo.getPlanOrgUnit() == null) {
                mo.setPlanOrgUnit(materialPlanInfo.getPlanOrg());
            }
            if (mo.getBizType() == null && null != mo.getTransactionType()) {
                mo.setBizType(mo.getTransactionType().getBizType());
            }
            if (null == mo.getDefaultWarehous()) {
                mo.setDefaultWarehous(materialInventoryInfo.getDefaultWarehouse());
            }
            int unitPrec = 4;
            if (bomInfo != null) {
                mo.setBomNum(bomInfo.getNumber());
                mo.setYield(bomInfo.getYield());
                if (null != mmu) {
                    unitPrec = mmu.getQtyPrecision();
                }
                BigDecimal yield = bomInfo.getYield().divide(new BigDecimal("100.00"), 4, 4);
                BigDecimal deliveryQty = mo.getQty().multiply(yield).setScale(unitPrec, 3);
                mo.setDeliveryQty(deliveryQty);
            } else {
                if (null == mo.getYield()) {
                    mo.setYield(new BigDecimal("100.00"));
                }
                mo.setDeliveryQty(mo.getQty());
            }
            if (materialPlanInfo.getRcvInHightLimit() != null) {
                mo.setExtraRatio(materialPlanInfo.getRcvInHightLimit());
                BigDecimal extraRatio = materialPlanInfo.getRcvInHightLimit().divide(new BigDecimal("100.00"), 4, 4).add(new BigDecimal("1.0"));
                BigDecimal extraQty = mo.getQty().multiply(extraRatio).setScale(unitPrec, 4);
                mo.setExtraUpperLimit(extraQty);
            } else {
                mo.setExtraRatio(SysConstant.BIGZERO);
                mo.setExtraUpperLimit(mo.getQty());
            }
            if (materialPlanInfo.getRcvInLowLimit() != null) {
                mo.setLackRatio(materialPlanInfo.getRcvInLowLimit());
                BigDecimal lackRatio = new BigDecimal("1.0").subtract(materialPlanInfo.getRcvInLowLimit().divide(new BigDecimal("100.00"), 4, 4));
                BigDecimal lackQty = mo.getQty().multiply(lackRatio).setScale(unitPrec, 4);
                mo.setLackLowerLimit(lackQty);
            } else {
                mo.setLackRatio(SysConstant.BIGZERO);
                mo.setLackLowerLimit(mo.getQty());
            }
            if (materialPlanInfo.getRcvInHightLimit() == null && materialPlanInfo.getRcvInLowLimit() == null) {
                mo.setExtraRatio(SysConstant.BIGZERO);
                mo.setExtraUpperLimit(SysConstant.BIGZERO);
                mo.setLackRatio(SysConstant.BIGZERO);
                mo.setLackLowerLimit(SysConstant.BIGZERO);
            }
            if (!materialPlanInfo.isIsStorageLimit() || mo.getTransactionType().isIsWPManagement()) {
                mo.setIsLimitedQty(false);
            } else {
                mo.setIsLimitedQty(true);
            }
        }
    }

    protected MultiMeasureUnitDataLoader loadMultiMeasureUnitInfo() throws EASBizException, BOSException {
        SelectorItemCollection mmuSic = new SelectorItemCollection();
        mmuSic.add(new SelectorItemInfo("*"));
        MultiMeasureUnitDataLoader mmuLoader = new MultiMeasureUnitDataLoader(this.ctx, mmuSic, this.requestQueue);
        int count = this.collection.size();
        for (int i = 0; i < count; ++i) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
            mmuLoader.setCondition(mo.getMaterial().getId().toString(), mo.getUnit().getId().toString());
        }
        return mmuLoader;
    }
}

