/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.AbstractProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.WrapCollection;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ProcessorRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.request.AbstractProcessorRequest;
import com.kingdee.eas.mm.mo.app.service.order.util.MoRefactUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ManufactureOrderSubmitProcessor
extends AbstractProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.ManufactureOrderSubmitProcessor");
    private ProcessorRequestQueue processorRequestQueue;
    protected BatchActionResults results;
    protected static final int MAXSIZE = 100;

    public ManufactureOrderSubmitProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
    }

    public ManufactureOrderSubmitProcessor(Context ctx, IObjectCollection collection, ProcessorRequestQueue processorRequestQueue) {
        this(ctx, collection);
        this.processorRequestQueue = processorRequestQueue;
    }

    public BatchActionResults getResults() {
        return this.results;
    }

    @Override
    public void innerDoing() throws EASBizException, BOSException {
        int i;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer mask = new StringBuffer();
        int index = 0;
        int countk = this.collection.size();
        for (int k = 0; k < countk; ++k) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(k);
            filterInfo.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)mo.getId().toString()));
            if (mask.length() > 0) {
                mask.append(" OR ");
            }
            mask.append("(#").append(index).append(")");
            ++index;
        }
        filterInfo.setMaskString(mask.toString());
        IBOTRelation ib = BOTRelationFactory.getLocalInstance((Context)this.ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("relationEntries.*"));
        view.setFilter(filterInfo);
        view.setSelector(selector);
        BOTRelationCollection infos = ib.getCollection(view);
        Connection cn = null;
        IORMappingDAO idao = null;
        try {
            cn = EJBFactory.getConnection((Context)this.ctx);
            idao = ORMappingDAO.getInstance((BOSObjectType)new BOTRelationInfo().getBOSType(), (Context)this.ctx, (Connection)cn);
            idao.delete(filterInfo);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        final BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[this.collection.size()];
        BatchExecuteParamsEntry entry = null;
        for (int i2 = 0; i2 < this.collection.size(); ++i2) {
            ManufactureOrderInfo moinfo = (ManufactureOrderInfo)this.collection.getObject(i2);
            MoRefactUtils.updateStock(moinfo);
            entries[i2] = entry = new BatchExecuteParamsEntry(new Class[]{ManufactureOrderInfo.class, BOTRelationCollection.class}, new Object[]{moinfo, null});
        }
        ArrayList<Future> futureList = new ArrayList<Future>();
        final ArrayList batchResultList = new ArrayList();
        int size = this.collection.size();
        int begin = 0;
        int end = 0;
        int time = size % this.getMaxSize() == 0 ? size / this.getMaxSize() : size / this.getMaxSize() + 1;
        for (i = 0; i < time; ++i) {
            begin = this.getMaxSize() * i;
            end = i + 1 < time ? this.getMaxSize() * (i + 1) : size;
            Future future = new Future();
            final int start = begin;
            final int over = end;
            final IObjectCollection cols = this.collection;
            AbstractProcessorRequest request = new AbstractProcessorRequest(future, this){

                @Override
                public void doing() {
                    WrapCollection data = new WrapCollection(cols);
                    try {
                        IManufactureOrder imo = ManufactureOrderFactory.getLocalInstance(ManufactureOrderSubmitProcessor.this.ctx);
                        BatchExecuteParamsEntry[] entries1 = new BatchExecuteParamsEntry[over - start];
                        int k = 0;
                        for (int i = start; i < over; ++i) {
                            entries1[k++] = entries[i];
                        }
                        BatchExecuteResult result11 = imo.batchExecute("submitRelations", new Class[]{CoreBillBaseInfo.class, BOTRelationCollection.class}, entries1);
                        BatchActionResults results = (BatchActionResults)result11.getBatchResult();
                        batchResultList.add(results);
                        this.future.setData(data);
                    }
                    catch (EASBizException e) {
                        logger.info((Object)(ManufactureOrderSubmitProcessor.this.getLogDesc() + " ERROR:"), (Throwable)e);
                        this.future.setException((Exception)((Object)e));
                    }
                    catch (BOSException e) {
                        logger.info((Object)(ManufactureOrderSubmitProcessor.this.getLogDesc() + " ERROR:"), (Throwable)e);
                        this.future.setException((Exception)((Object)e));
                    }
                    catch (Exception e) {
                        logger.info((Object)(ManufactureOrderSubmitProcessor.this.getLogDesc() + " ERROR:"), (Throwable)e);
                        this.future.setException(e);
                    }
                }
            };
            if (null != this.processorRequestQueue) {
                logger.info((Object)(this.getLogDesc() + " main thread user blockedQueue! "));
                try {
                    this.processorRequestQueue.putRequest(request);
                }
                catch (InterruptedException e) {
                    logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
                    logger.info((Object)(this.getLogDesc() + " main thread put request error: " + e.getMessage()));
                    future.setException(e);
                }
            } else {
                logger.info((Object)(this.getLogDesc() + " main thread user itselef! "));
                request.doing();
            }
            futureList.add(future);
        }
        logger.info((Object)"begin waiting");
        int count = futureList.size();
        for (i = 0; i < count; ++i) {
            Future future = (Future)futureList.get(i);
            future.getResult();
        }
        logger.info((Object)"end waiting");
        int k = 0;
        for (BatchActionResults result : batchResultList) {
            if (0 == k) {
                this.results = result;
            } else {
                this.results.mergeResults(result);
            }
            ++k;
            logger.info((Object)("submit mo ids: " + result.getAllIDs().length));
        }
        try {
            cn = EJBFactory.getConnection((Context)this.ctx);
            idao = ORMappingDAO.getInstance((BOSObjectType)new BOTRelationInfo().getBOSType(), (Context)this.ctx, (Connection)cn);
            for (int i3 = 0; i3 < infos.size(); ++i3) {
                idao.addNewBatch((IObjectValue)infos.get(i3));
            }
            idao.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected int getMaxSize() {
        return 100;
    }
}

