/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.PBOMEntryCollection;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.MaterialReplaceTypeEnum;
import com.kingdee.eas.mm.mo.OrderStockTransferTypeEnum;
import com.kingdee.eas.mm.mo.PickTypeEnum;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.AbstractBuildStockProcessor4StockProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ProcessorRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.SqlDataLoaderRequestQueue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public class NotReExpendBuildStockProcessor4StockProcessor
extends AbstractBuildStockProcessor4StockProcessor {
    @Override
    protected void buildStockByMo(StorageOrgUnitInfo headSou, OrgUnitCollection storageOrgUnitCollection, ManufactureOrderInfo mo, List warehouseList, List materialList) throws EASBizException, BOSException {
        int lineSeq = 0;
        if (null == mo.getRouting()) {
            return;
        }
        ManufactureOrderStockCollection stocks = mo.getStocks();
        HashMap<Integer, OperationInfo> operationMap = new HashMap<Integer, OperationInfo>();
        ManufactureOrderTechnicsCollection technics = mo.getTechnics();
        ManufactureOrderTechnicsInfo techInfo = null;
        if (technics != null) {
            int countk = technics.size();
            for (int k = 0; k < countk; ++k) {
                techInfo = technics.get(k);
                operationMap.put(techInfo.getOperationNo(), techInfo.getOperation());
            }
        }
        int firstWP = null == mo.getTechnics() ? 0 : mo.getTechnics().get(0).getOperationNo();
        int countj = stocks.size();
        for (int j = 0; j < countj; ++j) {
            LocationInfo locInfo;
            ManufactureOrderStockInfo stockInfo = stocks.get(j);
            BomEntryInfo bi = (BomEntryInfo)stockInfo.get("bomEntryInfo_ex");
            MaterialPlanInfo mi = (MaterialPlanInfo)stockInfo.get("materialPlan_ex");
            MultiMeasureUnitInfo mmui = (MultiMeasureUnitInfo)stockInfo.get("multimeasureunit_ex");
            MaterialInventoryInfo minv = (MaterialInventoryInfo)stockInfo.get("materialInventory_ex");
            if (stockInfo.isIsStockAllot() && null != stockInfo.getReceiptStroageOrgUnit()) {
                StorageOrgUnitInfo issueStorageOrgUnit = stockInfo.getReceiptStroageOrgUnit();
                if (mo.getStorageOrgUnit().getId().toString().equals(issueStorageOrgUnit.getId().toString())) {
                    stockInfo.setTransferType(OrderStockTransferTypeEnum.WAREHOUSE);
                } else if (storageOrgUnitCollection.containsKey((Object)issueStorageOrgUnit.getId())) {
                    stockInfo.setTransferType(OrderStockTransferTypeEnum.STORAGE);
                } else {
                    stockInfo.setTransferType(OrderStockTransferTypeEnum.FINANCE);
                }
            } else {
                stockInfo.setTransferType(OrderStockTransferTypeEnum.NULL);
            }
            if (stockInfo.getWarehouse() == null && minv != null) {
                stockInfo.setWarehouse(minv.getDefaultWarehouse());
            }
            if ((MaterialProvideTypeEnum.CURRENTORGPROVIDE == stockInfo.getProvideType() || MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE == stockInfo.getProvideType()) && MaterialIssueModeEnum.PRODUCEISSMODE == stockInfo.getIssueMode()) {
                stockInfo.setPickType(PickTypeEnum.INNERORG);
            } else if (MaterialProvideTypeEnum.SPANORGPROVIDE == stockInfo.getProvideType()) {
                if (storageOrgUnitCollection.containsKey((Object)stockInfo.getStorageOrgUnit().getId())) {
                    stockInfo.setPickType(PickTypeEnum.OTHERSTORAGE);
                } else {
                    stockInfo.setPickType(PickTypeEnum.OTHERCOMPANY);
                }
            } else {
                stockInfo.setPickType(PickTypeEnum.NULL);
            }
            stockInfo.setActureLossRatio(SysConstant.BIGZERO);
            stockInfo.setActIssueQty(SysConstant.BIGZERO);
            stockInfo.setActIssueBaseQty(SysConstant.BIGZERO);
            stockInfo.setActLossQty(SysConstant.BIGZERO);
            stockInfo.setActLossBaseQty(SysConstant.BIGZERO);
            stockInfo.setRejectedQty(SysConstant.BIGZERO);
            stockInfo.setRejectedBaseQty(SysConstant.BIGZERO);
            stockInfo.setFeedingQty(SysConstant.BIGZERO);
            stockInfo.setFeedingBaseQty(SysConstant.BIGZERO);
            stockInfo.setMaterialFeedingQty(SysConstant.BIGZERO);
            stockInfo.setMaterialFeedingBaseQty(SysConstant.BIGZERO);
            stockInfo.setScrapQty(SysConstant.BIGZERO);
            stockInfo.setScrapBaseQty(SysConstant.BIGZERO);
            stockInfo.setMaterialScrapQty(SysConstant.BIGZERO);
            stockInfo.setMaterialScrapBaseQty(SysConstant.BIGZERO);
            stockInfo.setWipQty(SysConstant.BIGZERO);
            stockInfo.setWipBaseQty(SysConstant.BIGZERO);
            stockInfo.setTotalDirectReceiveQty(SysConstant.BIGZERO);
            stockInfo.setTotalDirectReceiveBaseQty(SysConstant.BIGZERO);
            stockInfo.setTotalReceiptQty(SysConstant.BIGZERO);
            stockInfo.setTotalReceiptBaseQty(SysConstant.BIGZERO);
            stockInfo.setReplaceRatio(SysConstant.BIGZERO);
            stockInfo.setUnitReplaceQty(SysConstant.BIGZERO);
            stockInfo.setMatReplaceType(MaterialReplaceTypeEnum.NONE);
            stockInfo.setIsReplaced(false);
            stockInfo.setLineSeq(Integer.toString(++lineSeq * 10));
            stockInfo.setReplaceGroupFlag(0);
            stockInfo.setScrapExpr(null == mi ? 10620 : mi.getScrapRateExpression().getValue());
            stockInfo.setIsQtyLimit(null == mi ? false : mi.isIsQuotaControl());
            if (stockInfo.isIsQtyLimit() && null != mi) {
                stockInfo.setExtraRatio(mi.getIssInHightLimit());
            } else {
                stockInfo.setExtraRatio(SysConstant.BIGZERO);
            }
            stockInfo.setLackRatio(mi.getIssInLowLimit());
            int operationNo = firstWP;
            PBOMEntryInfo pBomEntryInfo = this.matchPBOMEntry((PBOMInfo)mo.get("pBom_ex"), bi);
            if (null != pBomEntryInfo && null != pBomEntryInfo.getRoutingItem()) {
                operationNo = pBomEntryInfo.getRoutingItem().getWpSeq();
            } else if (bi != null && operationMap.containsKey(bi.getOperationNo())) {
                operationNo = bi.getOperationNo();
            }
            stockInfo.setOperationNo(operationNo);
            if (operationMap.containsKey(operationNo)) {
                stockInfo.setOperation((OperationInfo)operationMap.get(operationNo));
            }
            LocationInfo locationInfo = locInfo = null == bi ? null : bi.getLocation();
            if (null != stockInfo.getWarehouse() && null == locInfo) {
                ProductTransactionTypeInfo pttInfo;
                if (stockInfo.isIsBackflush() && null != (pttInfo = mo.getTransactionType()) && null != pttInfo.getDefaultBFLocation() && pttInfo.getDefaultBFWarehouse().getId().toString().equals(stockInfo.getWarehouse().getId().toString())) {
                    locInfo = pttInfo.getDefaultBFLocation();
                }
                if (null == locInfo && stockInfo.getWarehouse().isHasLocation()) {
                    materialList.add(stockInfo.getMaterial().getId().toString());
                    warehouseList.add(stockInfo.getWarehouse().getId().toString());
                }
            }
            stockInfo.setLocation(locInfo);
            int prec = null == mmui ? 4 : mmui.getQtyPrecision();
            BigDecimal extraRatio = new BigDecimal("1.0").add(stockInfo.getExtraRatio().divide(new BigDecimal("100.00"), 4, 4).setScale(prec, 4));
            BigDecimal lackRatio = new BigDecimal("1.0").subtract(stockInfo.getLackRatio().divide(new BigDecimal("100.00"), 4, 4).setScale(prec, 4));
            BigDecimal pickExtraQty = stockInfo.getPlannedQty().multiply(extraRatio).setScale(prec, 4);
            BigDecimal pickLackQty = stockInfo.getPlannedQty().multiply(lackRatio).setScale(prec, 4);
            stockInfo.setPickExtraQty(pickExtraQty);
            stockInfo.setPickLackQty(pickLackQty);
            stockInfo.setUnReceiptBaseQty(stockInfo.getPlannedBaseQty());
            stockInfo.setUnReceiptQty(stockInfo.getPlannedQty());
            stockInfo.setOriginalPlanBaseQty(stockInfo.getPlannedBaseQty());
            stockInfo.setOriginalPlanQty(stockInfo.getPlannedQty());
        }
    }

    protected PBOMEntryInfo matchPBOMEntry(PBOMInfo pBom, BomEntryInfo bomEntry) {
        PBOMEntryInfo returnInfo = null;
        if (null != pBom && null != bomEntry) {
            PBOMEntryCollection pBomEntry = pBom.getPbomEntry();
            int countj = pBomEntry.size();
            for (int j = 0; j < countj; ++j) {
                PBOMEntryInfo pBomEntryInfo = pBomEntry.get(j);
                BomEntryInfo bi = pBomEntryInfo.getBomItem();
                if (!bi.getId().toString().equals(bomEntry.getId().toString())) continue;
                returnInfo = pBomEntryInfo;
            }
        }
        return returnInfo;
    }

    public NotReExpendBuildStockProcessor4StockProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
    }

    public NotReExpendBuildStockProcessor4StockProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue requestQueue) {
        super(ctx, collection);
    }

    public NotReExpendBuildStockProcessor4StockProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue objectDataLoaderRequestQueue, SqlDataLoaderRequestQueue sqlDataLoaderRequestQueue, ProcessorRequestQueue processorRequestQueue) {
        super(ctx, collection, objectDataLoaderRequestQueue, sqlDataLoaderRequestQueue, processorRequestQueue);
    }
}

