/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.IProductTransactionType;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeCollection;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl.DefaultProductTransactionTypeDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.AbstractProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;
import java.util.HashMap;
import java.util.Map;

public class ProductTransactionProcessor
extends AbstractProcessor {
    private ObjectDataLoaderRequestQueue requestQueue;

    public ProductTransactionProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
    }

    public ProductTransactionProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue requestQueue) {
        super(ctx, collection);
        this.requestQueue = requestQueue;
    }

    @Override
    public void innerDoing() throws EASBizException, BOSException {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int count = this.collection.size();
        for (int i = 0; i < count; ++i) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
            String sourceBillTypeID = mo.getSourceBillType().getId().toString();
            MaterialPlanInfo materialPlanInfo = (MaterialPlanInfo)mo.get("materialPlan_ex");
            if (!sourceBillTypeID.equals("9XXvbVGlRtym/0qtqeIXXrhE1B8=")) continue;
            if (mo.getAdminOrgUnit() == null) {
                mo.setAdminOrgUnit(materialPlanInfo.getDutyDepartment());
            }
            if (mo.getTransactionType() != null) continue;
            if (materialPlanInfo.getProductTranType() == null || MMBasedataStatusEnum.OPEN != materialPlanInfo.getProductTranType().getStatus()) {
                String multiKey = this.getMultiKey4DefaultProductionTransanctionType(mo);
                map.put(new Integer(i), multiKey);
                continue;
            }
            mo.setTransactionType(materialPlanInfo.getProductTranType());
        }
        if (!map.isEmpty()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("bizType.*"));
            sic.add(new SelectorItemInfo("defaultBFWarehouse.*"));
            sic.add(new SelectorItemInfo("defaultBFLocation.*"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"vGXRx5fFSsCYz9Zv7CzzgyQHQ1w="));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
            DefaultProductTransactionTypeDataLoader loader = new DefaultProductTransactionTypeDataLoader(this.ctx, sic, this.requestQueue);
            loader.setFixedFilter(filterInfo);
            int count2 = this.collection.size();
            for (int i = 0; i < count2; ++i) {
                ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
                if (null == mo.getAdminOrgUnit()) continue;
                loader.setCondition(mo.getStorageOrgUnit().getId().toString(), mo.getAdminOrgUnit().getId().toString());
            }
            loader.loadData();
            Map resultMap = loader.getResultMap();
            for (Integer seq : map.keySet()) {
                String multiKey = (String)map.get(seq);
                ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(seq.intValue());
                mo.setTransactionType((ProductTransactionTypeInfo)resultMap.get(multiKey));
            }
        }
        ProductTransactionTypeInfo _ = null;
        int count3 = this.collection.size();
        for (int i = 0; i < count3; ++i) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
            if (null != mo.getTransactionType()) continue;
            if (null == _) {
                _ = this.getDefaultTransType(this.ctx, mo.getStorageOrgUnit().getId().toString(), "vGXRx5fFSsCYz9Zv7CzzgyQHQ1w=");
            }
            mo.setTransactionType(_);
        }
    }

    protected String getMultiKey4DefaultProductionTransanctionType(ManufactureOrderInfo mo) {
        String multiKey = mo.getStorageOrgUnit().getId().toString() + (null == mo.getAdminOrgUnit() ? "" : mo.getAdminOrgUnit().getId().toString());
        return multiKey;
    }

    protected ProductTransactionTypeInfo getDefaultTransType(Context ctx, String orgID, String bizTypeID) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgID));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)bizTypeID));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("defaultBFWarehouse.*"));
        sic.add(new SelectorItemInfo("defaultBFLocation.*"));
        viewInfo.setSelector(sic);
        IProductTransactionType ptType = ProductTransactionTypeFactory.getLocalInstance((Context)ctx);
        ProductTransactionTypeCollection prodCol = ptType.getProductTransactionTypeCollection(viewInfo);
        ProductTransactionTypeInfo type = null;
        if (prodCol.size() > 0) {
            type = prodCol.get(0);
        }
        return type;
    }
}

