/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.PBOMEntryCollection;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.MaterialReplaceTypeEnum;
import com.kingdee.eas.mm.mo.OrderStockTransferTypeEnum;
import com.kingdee.eas.mm.mo.PickTypeEnum;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.AbstractBuildStockProcessor4StockProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ProcessorRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.SqlDataLoaderRequestQueue;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ReExpendBuildStockProcessor4StockProcessor
extends AbstractBuildStockProcessor4StockProcessor {
    @Override
    protected void buildStockByMo(StorageOrgUnitInfo headSou, OrgUnitCollection storageOrgUnitCollection, ManufactureOrderInfo mo, List warehouseList, List materialList) throws EASBizException, BOSException {
        int lineSeq = 0;
        if (null == mo.getRouting()) {
            return;
        }
        ManufactureOrderStockCollection stocks = new ManufactureOrderStockCollection();
        HashMap<Integer, OperationInfo> operationMap = new HashMap<Integer, OperationInfo>();
        ManufactureOrderTechnicsCollection technics = mo.getTechnics();
        ManufactureOrderTechnicsInfo techInfo = null;
        if (technics != null) {
            int countk = technics.size();
            for (int k = 0; k < countk; ++k) {
                techInfo = technics.get(k);
                operationMap.put(techInfo.getOperationNo(), techInfo.getOperation());
            }
        }
        int firstWP = mo.getRouting().getMaterialRooting().getFirstWP();
        PBOMInfo pBom = (PBOMInfo)mo.get("pBom_ex");
        if (null == pBom) {
            return;
        }
        Timestamp beginDate = mo.getPlanBeginDate();
        Timestamp endDate = mo.getPlanEndDate();
        PBOMEntryCollection pBomEntry = pBom.getPbomEntry();
        int countj = pBomEntry.size();
        for (int j = 0; j < countj; ++j) {
            PBOMEntryInfo pBomEntryInfo = pBomEntry.get(j);
            BomEntryInfo bi = pBomEntryInfo.getBomItem();
            if (MaterialProductEnum.BYPRODUCT == bi.getOutputType() || MaterialProductEnum.RELATEDPRODUCT == bi.getOutputType() || bi.getEffectiveDate().after(endDate) || bi.getDisableDate().before(beginDate)) continue;
            ManufactureOrderStockInfo stockInfo = new ManufactureOrderStockInfo();
            stockInfo.setMaterial(bi.getMaterial());
            stockInfo.setUnit(bi.getUnit());
            stockInfo.setBaseUnit(bi.getBaseUnit());
            stockInfo.setBomEntryID(bi.getId().toString());
            stockInfo.setProvideType(bi.getProvideType());
            stockInfo.setStorageOrgUnit(bi.getSupplyOrgUnit());
            stockInfo.setIsStockAllot(bi.isIsStockTransfer());
            stockInfo.setReceiptStroageOrgUnit(bi.getTransferOrgUnit());
            stockInfo.setReceiptStock(bi.getTransferWarehouse());
            if (stockInfo.isIsStockAllot() && null != stockInfo.getReceiptStroageOrgUnit()) {
                StorageOrgUnitInfo issueStorageOrgUnit = stockInfo.getReceiptStroageOrgUnit();
                if (mo.getStorageOrgUnit().getId().toString().equals(issueStorageOrgUnit.getId().toString())) {
                    stockInfo.setTransferType(OrderStockTransferTypeEnum.WAREHOUSE);
                } else if (storageOrgUnitCollection.containsKey((Object)issueStorageOrgUnit.getId())) {
                    stockInfo.setTransferType(OrderStockTransferTypeEnum.STORAGE);
                } else {
                    stockInfo.setTransferType(OrderStockTransferTypeEnum.FINANCE);
                }
            } else {
                stockInfo.setTransferType(OrderStockTransferTypeEnum.NULL);
            }
            stockInfo.setIssueMode(bi.getIssMode());
            if (null != bi.getDefaultWarehouse()) {
                stockInfo.setWarehouse(bi.getDefaultWarehouse());
            } else if (!bi.isIsBackFlush() && null != bi.get("materialInventory_ex")) {
                stockInfo.setWarehouse(((MaterialInventoryInfo)bi.get("materialInventory_ex")).getDefaultWarehouse());
            }
            if ((MaterialProvideTypeEnum.CURRENTORGPROVIDE == stockInfo.getProvideType() || MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE == stockInfo.getProvideType()) && MaterialIssueModeEnum.PRODUCEISSMODE == stockInfo.getIssueMode()) {
                stockInfo.setPickType(PickTypeEnum.INNERORG);
            } else if (MaterialProvideTypeEnum.SPANORGPROVIDE == stockInfo.getProvideType()) {
                if (storageOrgUnitCollection.containsKey((Object)stockInfo.getStorageOrgUnit().getId())) {
                    stockInfo.setPickType(PickTypeEnum.OTHERSTORAGE);
                } else {
                    stockInfo.setPickType(PickTypeEnum.OTHERCOMPANY);
                }
            } else {
                stockInfo.setPickType(PickTypeEnum.NULL);
            }
            stockInfo.setDemandTime(null == bi.getTimestamp("demandDate_ex") ? mo.getPlanBeginDate() : bi.getTimestamp("demandDate_ex"));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(stockInfo.getDemandTime());
            calendar.add(5, bi.getLeadtime());
            stockInfo.setDemandTime(new Timestamp(calendar.getTimeInMillis()));
            stockInfo.setIsBackflush(bi.isIsBackFlush());
            stockInfo.setNewnetWeight(bi.getNetWeight());
            stockInfo.setBlkSize(bi.getBlkSize());
            stockInfo.setSpecifiedLength(bi.getSpecifiedLength());
            stockInfo.setAssyLocation(bi.getBlueprint());
            stockInfo.setActureLossRatio(SysConstant.BIGZERO);
            stockInfo.setActIssueQty(SysConstant.BIGZERO);
            stockInfo.setActIssueBaseQty(SysConstant.BIGZERO);
            stockInfo.setActLossQty(SysConstant.BIGZERO);
            stockInfo.setActLossBaseQty(SysConstant.BIGZERO);
            stockInfo.setRejectedQty(SysConstant.BIGZERO);
            stockInfo.setRejectedBaseQty(SysConstant.BIGZERO);
            stockInfo.setFeedingQty(SysConstant.BIGZERO);
            stockInfo.setFeedingBaseQty(SysConstant.BIGZERO);
            stockInfo.setMaterialFeedingQty(SysConstant.BIGZERO);
            stockInfo.setMaterialFeedingBaseQty(SysConstant.BIGZERO);
            stockInfo.setScrapQty(SysConstant.BIGZERO);
            stockInfo.setScrapBaseQty(SysConstant.BIGZERO);
            stockInfo.setMaterialScrapQty(SysConstant.BIGZERO);
            stockInfo.setMaterialScrapBaseQty(SysConstant.BIGZERO);
            stockInfo.setWipQty(SysConstant.BIGZERO);
            stockInfo.setWipBaseQty(SysConstant.BIGZERO);
            stockInfo.setTotalDirectReceiveQty(SysConstant.BIGZERO);
            stockInfo.setTotalDirectReceiveBaseQty(SysConstant.BIGZERO);
            stockInfo.setTotalReceiptQty(SysConstant.BIGZERO);
            stockInfo.setTotalReceiptBaseQty(SysConstant.BIGZERO);
            stockInfo.setReplaceRatio(SysConstant.BIGZERO);
            stockInfo.setUnitReplaceQty(SysConstant.BIGZERO);
            stockInfo.setMatReplaceType(MaterialReplaceTypeEnum.NONE);
            stockInfo.setIsReplaced(false);
            stockInfo.setLineSeq(Integer.toString(++lineSeq * 10));
            stockInfo.setReplaceGroupFlag(0);
            if (bi.getMaterialInventory() != null && bi.getMaterialInventory().getScrapRateExpression() != null) {
                stockInfo.setScrapExpr(bi.getMaterialInventory().getScrapRateExpression().getValue());
            } else {
                stockInfo.setScrapExpr(10620);
            }
            stockInfo.setIsQtyLimit(null == bi.getMaterialInventory() ? false : bi.getMaterialInventory().isIsQuotaControl());
            if (stockInfo.isIsQtyLimit() && null != bi.getMaterialInventory()) {
                stockInfo.setExtraRatio(bi.getMaterialInventory().getIssInHightLimit());
            } else {
                stockInfo.setExtraRatio(SysConstant.BIGZERO);
            }
            stockInfo.setLackRatio(null == bi.getMaterialInventory() ? SysConstant.BIGZERO : bi.getMaterialInventory().getIssInLowLimit());
            int operationNo = firstWP;
            if (null != pBomEntryInfo.getRoutingItem()) {
                operationNo = pBomEntryInfo.getRoutingItem().getWpSeq();
            } else if (operationMap.containsKey(bi.getOperationNo())) {
                operationNo = bi.getOperationNo();
            }
            stockInfo.setOperationNo(operationNo);
            if (operationMap.containsKey(operationNo)) {
                stockInfo.setOperation((OperationInfo)operationMap.get(operationNo));
            }
            LocationInfo locInfo = bi.getLocation();
            if (null != stockInfo.getWarehouse() && null == locInfo) {
                ProductTransactionTypeInfo pttInfo;
                if (stockInfo.isIsBackflush() && null != (pttInfo = mo.getTransactionType()) && null != pttInfo.getDefaultBFLocation() && pttInfo.getDefaultBFWarehouse().getId().toString().equals(stockInfo.getWarehouse().getId().toString())) {
                    locInfo = pttInfo.getDefaultBFLocation();
                }
                if (null == locInfo && stockInfo.getWarehouse().isHasLocation()) {
                    materialList.add(stockInfo.getMaterial().getId().toString());
                    warehouseList.add(stockInfo.getWarehouse().getId().toString());
                }
            }
            stockInfo.setLocation(locInfo);
            BigDecimal unitQty = null == pBomEntryInfo.getUnitQty() ? new BigDecimal("1") : pBomEntryInfo.getUnitQty();
            stockInfo.setUnitQty(unitQty);
            BigDecimal scrapRatio = SysConstant.BIGZERO;
            scrapRatio = bi.getScrapRatio().divide(new BigDecimal("100.00"), 4, 2);
            BigDecimal lossRatio = scrapRatio.multiply(new BigDecimal("100.00")).setScale(2, 2);
            stockInfo.setLossRatio(lossRatio);
            int prec = ((MultiMeasureUnitInfo)bi.get("multimeasureunit_ex")).getQtyPrecision();
            BigDecimal qty1 = unitQty.multiply(mo.getQty()).setScale(prec + 2, 4);
            BigDecimal qty = qty1.setScale(prec, 2);
            if (MMUtils.isRoundDown((BigDecimal)qty)) {
                qty = qty1.setScale(prec, 1);
            }
            stockInfo.setQty(qty);
            BigDecimal planedQty = qty;
            if (mo.getTransactionType().isIsConsiderLossRatio() && null != bi.getMaterialInventory()) {
                MaterialScrapRateExpressionEnum materialScrapRateExpression = bi.getMaterialInventory().getScrapRateExpression();
                planedQty = MaterialScrapRateExpressionEnum.BYDIVIDE == materialScrapRateExpression ? qty.divide(new BigDecimal("1.0").subtract(scrapRatio), prec, 2) : qty.multiply(new BigDecimal("1.0").add(scrapRatio)).setScale(prec, 2);
            }
            BigDecimal extraRatio = new BigDecimal("1.0").add(stockInfo.getExtraRatio().divide(new BigDecimal("100.00"), 4, 4).setScale(prec, 4));
            BigDecimal lackRatio = new BigDecimal("1.0").subtract(stockInfo.getLackRatio().divide(new BigDecimal("100.00"), 4, 4).setScale(prec, 4));
            BigDecimal pickExtraQty = planedQty.multiply(extraRatio).setScale(prec, 4);
            BigDecimal pickLackQty = planedQty.multiply(lackRatio).setScale(prec, 4);
            stockInfo.setPickExtraQty(pickExtraQty);
            stockInfo.setPickLackQty(pickLackQty);
            stockInfo.setPlannedQty(planedQty);
            stockInfo.setTotalReceiptQty(SysConstant.BIGZERO);
            stockInfo.setUnReceiptQty(planedQty);
            stockInfo.setLossQty(planedQty.subtract(qty));
            stockInfo.setOriginalPlanQty(planedQty);
            stocks.add(stockInfo);
        }
        if (stocks != null) {
            stocks = this.getDistinctStocks(stocks);
        }
        mo.put("stocks", (Object)stocks);
    }

    private ManufactureOrderStockCollection getDistinctStocks(ManufactureOrderStockCollection stocks) {
        ManufactureOrderStockCollection newStocks = new ManufactureOrderStockCollection();
        HashMap<String, ManufactureOrderStockInfo> stocksMap = new HashMap<String, ManufactureOrderStockInfo>();
        ManufactureOrderStockInfo stockInfo = null;
        String key2 = null;
        Iterator iter = stocks.iterator();
        while (iter.hasNext()) {
            stockInfo = (ManufactureOrderStockInfo)iter.next();
            key2 = this.getRecKeyString((IObjectValue)stockInfo);
            if (stocksMap.containsKey(key2)) {
                ManufactureOrderStockInfo existStockInfo = (ManufactureOrderStockInfo)stocksMap.get(key2);
                existStockInfo.setUnitQty(existStockInfo.getUnitQty().add(stockInfo.getUnitQty()));
                existStockInfo.setQty(existStockInfo.getQty().add(stockInfo.getQty()));
                existStockInfo.setPlannedQty(existStockInfo.getPlannedQty().add(stockInfo.getPlannedQty()));
                existStockInfo.setLossQty(existStockInfo.getLossQty().add(stockInfo.getLossQty()));
                existStockInfo.setPickExtraQty(existStockInfo.getPickExtraQty().add(stockInfo.getPickExtraQty()));
                existStockInfo.setPickLackQty(existStockInfo.getPickLackQty().add(stockInfo.getPickLackQty()));
                continue;
            }
            stocksMap.put(key2, stockInfo);
        }
        for (String key2 : stocksMap.keySet()) {
            newStocks.add((ManufactureOrderStockInfo)stocksMap.get(key2));
        }
        return newStocks;
    }

    public String getRecKeyString(IObjectValue model) {
        String recKey = "";
        MaterialInfo materialInfo = (MaterialInfo)model.get("material");
        int operationNo = model.getInt("operationNo");
        recKey = materialInfo != null ? materialInfo.getId().toString() : "MATERIAL_NULL";
        recKey = recKey + "!";
        recKey = recKey + operationNo;
        return recKey;
    }

    public ReExpendBuildStockProcessor4StockProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
    }

    public ReExpendBuildStockProcessor4StockProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue objectDataLoaderRequestQueue, SqlDataLoaderRequestQueue sqlDataLoaderRequestQueue) {
        super(ctx, collection);
    }

    public ReExpendBuildStockProcessor4StockProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue objectDataLoaderRequestQueue, SqlDataLoaderRequestQueue sqlDataLoaderRequestQueue, ProcessorRequestQueue processorRequestQueue) {
        super(ctx, collection, objectDataLoaderRequestQueue, sqlDataLoaderRequestQueue, processorRequestQueue);
    }
}

