/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMExtendFacadeFactory;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.AbstractProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.BomExpendDealOutputs4StockProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.BomExpendTempTableProcessor4StockProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.ReExpendBuildStockProcessor4StockProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ProcessorRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.SqlDataLoaderRequestQueue;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ReExtendStockProcessor4StockProcessor
extends AbstractProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.ReExtendStockProcessor4StockProcessor");
    private ObjectDataLoaderRequestQueue objectDataLoaderRequestQueue;
    private SqlDataLoaderRequestQueue sqlDataLoaderRequestQueue;
    public static final String INSERT_SQL = "INSERT INTO TABLE (FStorageorgUnitID,FMaterialID,FDate,FBaseQty,FTraceID,FBOMID,FTrackNumberID,FProjectID)VALUES(?,?,?,?,?,?,?,?)";
    public static final String DEFAULTNUMBER = "999999999";

    @Override
    public void innerDoing() throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" create table tableExp (FStorageorgUnitID varchar(44) not null, ").append("FMaterialID varchar(44),   ").append("FDate Datetime not null, ").append("FBaseQty NUMERIC(21,8) not null default 0,  ").append("FTraceID varchar(44),   ").append("FBOMID varchar(44)  not null, ").append("FTrackNumberID varchar(44),  ").append("FProjectID varchar(44) )  ");
        String table = MMUtils.createTmpTable((Context)this.ctx, (String)sb.toString());
        Connection conn = null;
        PreparedStatement batchStatement = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean flag = false;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            batchStatement = conn.prepareStatement(INSERT_SQL.replaceAll("TABLE", table));
            int count = this.collection.size();
            for (int i = 0; i < count; ++i) {
                ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
                if (null != mo.get("pBom_ex")) continue;
                flag = true;
                map.put(mo.getId().toString(), null);
                batchStatement.setString(1, mo.getStorageOrgUnit().getId().toString());
                batchStatement.setString(2, mo.getMaterial().getId().toString());
                batchStatement.setDate(3, new Date(mo.getPlanBeginDate().getTime()));
                batchStatement.setBigDecimal(4, mo.getBaseQty());
                batchStatement.setString(5, mo.getId().toString());
                batchStatement.setString(6, mo.getBomID());
                batchStatement.setString(7, null == mo.getTrackNumber() ? DEFAULTNUMBER : mo.getTrackNumber().getId().toString());
                batchStatement.setString(8, null == mo.getProject() ? DEFAULTNUMBER : mo.getProject().getId().toString());
                batchStatement.addBatch();
            }
            if (flag) {
                batchStatement.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        logger.info((Object)("create table for bomexpend and table name is : " + table));
        if (flag && null != (table = BOMExtendFacadeFactory.getLocalInstance((Context)this.ctx).getBOMExpandResult(table, true))) {
            logger.info((Object)("invoke bomexpend ! and table name is: " + table));
            BomExpendTempTableProcessor4StockProcessor processor = new BomExpendTempTableProcessor4StockProcessor(this.ctx, this.collection, table, this.objectDataLoaderRequestQueue, this.sqlDataLoaderRequestQueue);
            processor.doing();
            ReExtendStockProcessor4StockProcessor.releaseTempTable(this.ctx, table);
        }
    }

    public ReExtendStockProcessor4StockProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
        this.addAfterProcessor(new BomExpendDealOutputs4StockProcessor(ctx, collection)).addAfterProcessor(new ReExpendBuildStockProcessor4StockProcessor(ctx, collection));
    }

    public ReExtendStockProcessor4StockProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue objectDataLoaderRequestQueue, SqlDataLoaderRequestQueue sqlDataLoaderRequestQueue) {
        super(ctx, collection);
        this.objectDataLoaderRequestQueue = objectDataLoaderRequestQueue;
        this.sqlDataLoaderRequestQueue = sqlDataLoaderRequestQueue;
        this.addAfterProcessor(new BomExpendDealOutputs4StockProcessor(ctx, collection));
        this.addAfterProcessor(new ReExpendBuildStockProcessor4StockProcessor(ctx, collection, objectDataLoaderRequestQueue, sqlDataLoaderRequestQueue));
    }

    public ReExtendStockProcessor4StockProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue objectDataLoaderRequestQueue, SqlDataLoaderRequestQueue sqlDataLoaderRequestQueue, ProcessorRequestQueue processorRequestQueue) {
        super(ctx, collection);
        this.objectDataLoaderRequestQueue = objectDataLoaderRequestQueue;
        this.sqlDataLoaderRequestQueue = sqlDataLoaderRequestQueue;
        this.addAfterProcessor(new BomExpendDealOutputs4StockProcessor(ctx, collection));
        this.addAfterProcessor(new ReExpendBuildStockProcessor4StockProcessor(ctx, collection, objectDataLoaderRequestQueue, sqlDataLoaderRequestQueue, processorRequestQueue));
    }

    public static void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }
}

