/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.IStandardRooting;
import com.kingdee.eas.mm.basedata.PBOMCollection;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.mo.IStandardRooting4ManufactureOrderFacade;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.StandardRooting4ManufactureOrderFacadeFactory;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl.DefaultStandardRootingDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.AbstractProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.PBomProcessor4StockProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.PBomSetDataProcessor4StockProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;
import java.util.Map;

public class StandardRootingProcessor4TechnicsProcessor
extends AbstractProcessor {
    private ObjectDataLoaderRequestQueue requestQueue;

    @Override
    public void innerDoing() throws EASBizException, BOSException {
        SelectorItemCollection defaultSic = new SelectorItemCollection();
        defaultSic.add(new SelectorItemInfo("*"));
        defaultSic.add(new SelectorItemInfo("materialRooting.id"));
        defaultSic.add(new SelectorItemInfo("materialRooting.firstWP"));
        defaultSic.add(new SelectorItemInfo("materialRooting.lastWP"));
        IStandardRooting routing = StandardRootingFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((ManufactureOrderInfo)this.collection.getObject(0)).getStorageOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"-"));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(defaultSic);
        CoreBaseCollection col = routing.getCollection(viewInfo);
        StandardRootingInfo standardRootingInfo = (StandardRootingInfo)col.get(0);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("materialRooting.id"));
        selectorItemCollection.add(new SelectorItemInfo("materialRooting.firstWP"));
        selectorItemCollection.add(new SelectorItemInfo("materialRooting.lastWP"));
        DefaultStandardRootingDataLoader loader = new DefaultStandardRootingDataLoader(this.ctx, selectorItemCollection, this.requestQueue);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(60)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isMainRooting", (Object)Boolean.TRUE));
        loader.setFixedFilter(filterInfo);
        int count = this.collection.size();
        for (int i = 0; i < count; ++i) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
            PBOMInfo pbomInfo = this.findRootingByPbom(mo);
            if (null == pbomInfo) {
                loader.setCondition(mo.getStorageOrgUnit().getId().toString(), mo.getMaterial().getId().toString());
                continue;
            }
            mo.put("pBom_ex", pbomInfo);
            mo.setRouting(pbomInfo.getRouting());
        }
        loader.loadData();
        Map map = loader.getResultMap();
        String multiKey = "";
        int count2 = this.collection.size();
        for (int i = 0; i < count2; ++i) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
            if (null != mo.getRouting()) continue;
            multiKey = mo.getStorageOrgUnit().getId().toString() + mo.getMaterial().getId().toString();
            if (map.containsKey(multiKey)) {
                mo.setRouting((StandardRootingInfo)map.get(multiKey));
                continue;
            }
            if (mo.getTransactionType().isIsWPManagement()) {
                if (mo.getTransactionType().isIsAutoGenerateWP()) {
                    mo.setRouting(standardRootingInfo);
                    continue;
                }
                mo.setRouting(null);
                continue;
            }
            mo.setRouting(standardRootingInfo);
        }
        IStandardRooting4ManufactureOrderFacade sr = StandardRooting4ManufactureOrderFacadeFactory.getLocalInstance(this.ctx);
        int count3 = this.collection.size();
        for (int i = 0; i < count3; ++i) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i);
            sr.resetStandardRooting(mo);
        }
    }

    protected PBOMInfo findRootingByPbom(ManufactureOrderInfo mo) {
        PBOMInfo pbomInfo = null;
        PBOMCollection pboms = (PBOMCollection)mo.get("pBom_ex");
        if (null != pboms && !pboms.isEmpty()) {
            int count = pboms.size();
            for (int i = 0; i < count; ++i) {
                PBOMInfo _ = pboms.get(i);
                StandardRootingInfo __ = _.getRouting();
                if (!__.isIsMainRooting()) continue;
                pbomInfo = _;
                break;
            }
            if (null == pbomInfo) {
                pbomInfo = pboms.get(0);
            }
        }
        if (null != pbomInfo) {
            for (int j = pbomInfo.getPbomEntry().size() - 1; j >= 0; --j) {
                if (null != pbomInfo.getPbomEntry().get(j).getBomItem().getMaterial()) continue;
                pbomInfo.getPbomEntry().removeObject(j);
            }
        }
        return pbomInfo;
    }

    public StandardRootingProcessor4TechnicsProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
        this.addBeforeProcessor(new PBomProcessor4StockProcessor(ctx, collection));
        this.addAfterProcessor(new PBomSetDataProcessor4StockProcessor(ctx, collection));
    }

    public StandardRootingProcessor4TechnicsProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue requestQueue) {
        super(ctx, collection);
        this.addBeforeProcessor(new PBomProcessor4StockProcessor(ctx, collection, requestQueue));
        this.addAfterProcessor(new PBomSetDataProcessor4StockProcessor(ctx, collection, requestQueue));
        this.requestQueue = requestQueue;
    }
}

