/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.CSEntrustTypeEnum;
import com.kingdee.eas.mm.basedata.ControlStrategyInfo;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryCollection;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryInfo;
import com.kingdee.eas.mm.basedata.OverRunMeasureEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl.MultiMeasureUnitDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.AbstractProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.RootingExpendProcessor4TechnicsProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.StandardRootingProcessor4TechnicsProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.WrapCollection;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ProcessorRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.request.AbstractProcessorRequest;
import com.kingdee.eas.scm.common.util.SCMConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class TechnicsProcessor
extends AbstractProcessor {
    private ProcessorRequestQueue processorRequestQueue;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.TechnicsProcessor");
    private static final int MAXSIZE = 50;

    @Override
    public void innerDoing() throws EASBizException, BOSException {
        int i;
        SelectorItemCollection mmuSic = new SelectorItemCollection();
        mmuSic.add(new SelectorItemInfo("*"));
        MultiMeasureUnitDataLoader mmuLoader = new MultiMeasureUnitDataLoader(this.ctx, mmuSic);
        int count = this.collection.size();
        for (int i2 = 0; i2 < count; ++i2) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i2);
            mmuLoader.setCondition(mo.getMaterial().getId().toString(), mo.getUnit().getId().toString());
        }
        mmuLoader.loadData();
        Map map = mmuLoader.getResultMap();
        String multiKey = "";
        int count2 = this.collection.size();
        for (int i3 = 0; i3 < count2; ++i3) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)this.collection.getObject(i3);
            multiKey = mo.getMaterial().getId().toString() + mo.getUnit().getId().toString();
            mo.put("multimeasureunit_ex", (MultiMeasureUnitInfo)map.get(multiKey));
        }
        ArrayList<Future> futureList = new ArrayList<Future>();
        int size = this.collection.size();
        int begin = 0;
        int end = 0;
        int time = size % this.getMaxSize() == 0 ? size / this.getMaxSize() : size / this.getMaxSize() + 1;
        for (i = 0; i < time; ++i) {
            begin = this.getMaxSize() * i;
            end = i + 1 < time ? this.getMaxSize() * (i + 1) : size;
            Future future = new Future();
            final int start = begin;
            final int over = end;
            final IObjectCollection cols = this.collection;
            AbstractProcessorRequest request = new AbstractProcessorRequest(future, this){

                @Override
                public void doing() {
                    WrapCollection data = new WrapCollection(cols);
                    try {
                        for (int i = start; i < over; ++i) {
                            ManufactureOrderInfo mo = (ManufactureOrderInfo)cols.getObject(i);
                            if (null == mo.getRouting()) continue;
                            TechnicsProcessor.this.buildTechnicsByMo(mo);
                        }
                        this.future.setData(data);
                    }
                    catch (EASBizException e) {
                        logger.info((Object)(TechnicsProcessor.this.getLogDesc() + " ERROR:"), (Throwable)e);
                        this.future.setException((Exception)((Object)e));
                    }
                    catch (BOSException e) {
                        logger.info((Object)(TechnicsProcessor.this.getLogDesc() + " ERROR:"), (Throwable)e);
                        this.future.setException((Exception)((Object)e));
                    }
                    catch (Exception e) {
                        logger.info((Object)(TechnicsProcessor.this.getLogDesc() + " ERROR:"), (Throwable)e);
                        this.future.setException(e);
                    }
                }
            };
            if (null != this.processorRequestQueue) {
                logger.info((Object)(this.getLogDesc() + " main thread user blockedQueue! "));
                try {
                    this.processorRequestQueue.putRequest(request);
                }
                catch (InterruptedException e) {
                    logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
                    logger.info((Object)(this.getLogDesc() + " main thread put request error: " + e.getMessage()));
                    future.setException(e);
                }
            } else {
                logger.info((Object)(this.getLogDesc() + " main thread user itselef! "));
                request.doing();
            }
            futureList.add(future);
        }
        logger.info((Object)"begin waiting");
        int count3 = futureList.size();
        for (i = 0; i < count3; ++i) {
            Future future = (Future)futureList.get(i);
            future.getResult();
        }
        logger.info((Object)"end waiting");
    }

    public TechnicsProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
        this.addBeforeProcessor(new StandardRootingProcessor4TechnicsProcessor(ctx, collection)).addBeforeProcessor(new RootingExpendProcessor4TechnicsProcessor(ctx, collection));
    }

    public TechnicsProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue requestQueue) {
        super(ctx, collection);
        this.addBeforeProcessor(new StandardRootingProcessor4TechnicsProcessor(ctx, collection, requestQueue)).addBeforeProcessor(new RootingExpendProcessor4TechnicsProcessor(ctx, collection, requestQueue));
    }

    public TechnicsProcessor(Context ctx, IObjectCollection collection, ObjectDataLoaderRequestQueue objectDataLoaderRequestQueue, ProcessorRequestQueue processorRequestQueue) {
        this(ctx, collection, objectDataLoaderRequestQueue);
        this.processorRequestQueue = processorRequestQueue;
    }

    protected void buildTechnicsByMo(ManufactureOrderInfo mo) throws EASBizException, BOSException {
        ManufactureOrderTechnicsCollection technicsCol = new ManufactureOrderTechnicsCollection();
        MRWorkProcesEntryCollection wkCol = mo.getRouting().getMaterialRooting().getWorkProcess();
        MaterialPlanInfo mpi = (MaterialPlanInfo)mo.get("materialPlan_ex");
        if (wkCol != null && wkCol.size() > 0) {
            for (int i = 0; i < wkCol.size(); ++i) {
                MRWorkProcesEntryInfo wkInfo = wkCol.get(i);
                ManufactureOrderTechnicsInfo techInfo = new ManufactureOrderTechnicsInfo();
                techInfo.setEarlistWoktime(mo.getPlanBeginDate());
                techInfo.setEarlistCmpTime(mo.getPlanEndDate());
                techInfo.setLastWorktime(mo.getPlanBeginDate());
                techInfo.setLastCmpTime(mo.getPlanEndDate());
                if (wkInfo.getWorkCenter() != null) {
                    techInfo.setAdminOrgUnit(wkInfo.getWorkCenter().getAdminOrgUnit());
                }
                techInfo.setFinishedQty(SysConstant.BIGZERO);
                techInfo.setIntoQty(SysConstant.BIGZERO);
                techInfo.setOutQty(SysConstant.BIGZERO);
                techInfo.setTestQty(SysConstant.BIGZERO);
                techInfo.setPassQty(SysConstant.BIGZERO);
                techInfo.setScrapQty(SysConstant.BIGZERO);
                techInfo.setRepairQty(SysConstant.BIGZERO);
                techInfo.setRepReportQty(SysConstant.BIGZERO);
                techInfo.setRepMoveInQty(SysConstant.BIGZERO);
                techInfo.setRepMoveOutQty(SysConstant.BIGZERO);
                techInfo.setConcessionQty(SysConstant.BIGZERO);
                techInfo.setConcessionBaseQty(SysConstant.BIGZERO);
                techInfo.setTotalMaterialScrapQty(SysConstant.BIGZERO);
                techInfo.setTotalManufactureScrapQty(SysConstant.BIGZERO);
                techInfo.setTotalSplitQty(SysConstant.BIGZERO);
                techInfo.setTotalDispatchQty(SysConstant.BIGZERO);
                techInfo.setUnDispatchQty(mo.getQty());
                techInfo.setUnit(mo.getUnit());
                techInfo.setBaseUnit(mo.getBaseUnit());
                techInfo.setQty(mo.getQty());
                techInfo.setOperQty(mo.getQty());
                techInfo.setWorkcenter(wkInfo.getWorkCenter());
                techInfo.setEntrustType(wkInfo.getEntrustType() == null ? CSEntrustTypeEnum.NONE : wkInfo.getEntrustType());
                techInfo.setEntrustSupplier(wkInfo.getEntrustSupplier());
                techInfo.setSubRouting(wkInfo.getChildRooting());
                techInfo.setOperation(wkInfo.getOperation());
                techInfo.setOperationNo(wkInfo.getWpSeq());
                techInfo.setTimeUnit(wkInfo.getTimeUnit());
                techInfo.setIsCheckPoint(wkInfo.isIsCheckPoint());
                techInfo.setIsKeyOP(wkInfo.isIsImportantWP());
                techInfo.setIsReportPoint(wkInfo.isIsReportPoint());
                techInfo.setQueuingTime(wkInfo.getQueueTime());
                techInfo.setPrepareTime(wkInfo.getPreparedTime());
                techInfo.setWaitingTime(wkInfo.getWaittingTime());
                techInfo.setWorkTime(wkInfo.getMachiningTime());
                techInfo.setMovingTime(wkInfo.getTransferTime());
                if ("-".equalsIgnoreCase(mo.getRouting().getNumber())) {
                    if (mpi.isIsReportingLimit()) {
                        techInfo.setOverrunMeasure(OverRunMeasureEnum.REFUSE);
                        techInfo.setTotalQtyUpper(mpi.getRptInHightLimit());
                        techInfo.setTotalQtyLower(mpi.getRptInLowLimit());
                    } else {
                        techInfo.setOverrunMeasure(OverRunMeasureEnum.NOT_CONTROL);
                        techInfo.setTotalQtyUpper(mpi.getRptInHightLimit());
                        techInfo.setTotalQtyLower(mpi.getRptInLowLimit());
                    }
                } else {
                    techInfo.setOverrunMeasure(wkInfo.getOverrunMeasure());
                    techInfo.setTotalQtyUpper(wkInfo.getRealProductQtyHigh());
                    techInfo.setTotalQtyLower(wkInfo.getRealProductQtyLow());
                }
                techInfo.setProcessBatch(wkInfo.getProcessBatch());
                ControlStrategyInfo cs = wkInfo.getControlStrategy();
                techInfo.setControlStrategy(cs);
                if (techInfo.getEntrustType() == CSEntrustTypeEnum.NONE || techInfo.getEntrustType() == CSEntrustTypeEnum.OPERATIONENTRUST) {
                    techInfo.setStorageOrgUnit(mo.getStorageOrgUnit());
                } else {
                    techInfo.setStorageOrgUnit(wkInfo.getCooStorageOrgUnit());
                }
                MultiMeasureUnitInfo mmu = (MultiMeasureUnitInfo)mo.get("multimeasureunit_ex");
                int unitPrec = null == mmu ? 4 : mmu.getQtyPrecision();
                BigDecimal totalQtyUpper = new BigDecimal("1.0").add(techInfo.getTotalQtyUpper().divide(new BigDecimal("100.00"), 4, 4)).setScale(unitPrec, 4);
                BigDecimal totalUpperQty = techInfo.getQty().multiply(totalQtyUpper).setScale(unitPrec, 4);
                techInfo.setTotalUpperQty(totalUpperQty);
                technicsCol.add(techInfo);
                if (i == wkCol.size() - 1) {
                    techInfo.setIsPickingPoint(true);
                } else {
                    techInfo.setIsPickingPoint(false);
                }
                techInfo.setOperationRemark(wkInfo.getOperationRemark());
                BigDecimal zero = SCMConstant.BIGDECIMAL_ZERO;
                techInfo.setTheoreticalLaborCost(wkInfo.getLaborCost() == null ? zero : wkInfo.getLaborCost());
                techInfo.setActualLaborCost(techInfo.getTheoreticalLaborCost());
                techInfo.setTheoreticalScrapLaborCost(wkInfo.getScrapLaborCost() == null ? zero : wkInfo.getScrapLaborCost());
                techInfo.setActualScrapLaborCost(techInfo.getTheoreticalScrapLaborCost());
                techInfo.setTheoreticalMatScrapLaborCost(wkInfo.getMatScrapLaborCost() == null ? zero : wkInfo.getMatScrapLaborCost());
                techInfo.setActualMatScrapLaborCost(techInfo.getTheoreticalMatScrapLaborCost());
                techInfo.setValuationType(wkInfo.getValuationType());
            }
            TechnicsProcessor.addToMo(mo, technicsCol);
        }
    }

    protected static void addToMo(ManufactureOrderInfo mo, ManufactureOrderTechnicsCollection techCol) {
        if (techCol != null) {
            int i;
            mo.put("technics", (Object)techCol);
            int lastop = 0;
            for (i = 0; i < techCol.size(); ++i) {
                if (techCol.get(i).getOperationNo() <= lastop) continue;
                lastop = techCol.get(i).getOperationNo();
            }
            mo.setLastOperNo(lastop);
            int size = techCol.size();
            for (i = 0; i < size; ++i) {
                ManufactureOrderTechnicsInfo info = techCol.get(i);
                if (info.getAdminOrgUnit() == null) {
                    info.setAdminOrgUnit(mo.getAdminOrgUnit());
                }
                if (info.getAdminOrgUnit() != null) continue;
                info.setAdminOrgUnit(((MaterialPlanInfo)mo.get("materialPlan_ex")).getDutyDepartment());
            }
        } else {
            mo.put("technics", (Object)new ManufactureOrderTechnicsCollection());
        }
    }

    protected int getMaxSize() {
        return 50;
    }
}

