/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.request;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractObjectDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.WrapCollection;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.request.AbstractDataLoaderRequest;
import org.apache.log4j.Logger;

public class ObjectDataLoaderRequest
extends AbstractDataLoaderRequest {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.request.ObjectDataLoaderRequest");
    FilterInfo filter;
    SelectorItemCollection selector;
    String mask;
    EntityViewInfo view1 = new EntityViewInfo();

    public ObjectDataLoaderRequest(Future future, AbstractObjectDataLoader loader, FilterInfo filter, SelectorItemCollection selector, String mask) {
        super(future, loader);
        this.filter = filter;
        this.selector = selector;
        this.mask = mask;
    }

    @Override
    public void doing() {
        long start = System.currentTimeMillis();
        IObjectCollection collection = null;
        try {
            this.filter.setMaskString(this.mask);
            if (!((AbstractObjectDataLoader)this.loader).getFixedFilter().isNull()) {
                this.filter.mergeFilter(((AbstractObjectDataLoader)this.loader).getFixedFilter(), "and");
            }
            this.view1.setFilter(this.filter);
            this.view1.setSelector(this.selector);
            if (null != ((AbstractObjectDataLoader)this.loader).getSorter() && !((AbstractObjectDataLoader)this.loader).getSorter().isEmpty()) {
                this.view1.setSorter(((AbstractObjectDataLoader)this.loader).getSorter());
            }
            collection = ((AbstractObjectDataLoader)this.loader).getCollection(this.view1);
            start = (System.currentTimeMillis() - start) / 1000L;
            logger.info((Object)(this.loader.getLogDesc() + " and entityview is: " + this.view1.toString() + " \r\n  collection.size()= " + collection.size() + " \r\n spend: " + start + " S"));
            WrapCollection data = new WrapCollection(collection);
            this.future.setData(data);
        }
        catch (BOSException e) {
            this.future.setException((Exception)((Object)e));
        }
        catch (EASBizException e) {
            this.future.setException((Exception)((Object)e));
        }
        catch (Exception e) {
            this.future.setException((Exception)((Object)new BOSException(e.getMessage(), (Throwable)e)));
        }
    }
}

