/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.vo;

import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.mo.app.release.enhancement.vo.FactoryCalendarVO;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class ClassTeamEntryInfoVO {
    public static final BigDecimal ONEDAY = new BigDecimal("24");
    public static final BigDecimal NEGONE = new BigDecimal("-1");
    private BigDecimal startTime = SysConstant.BIGZERO;
    private BigDecimal endTime = SysConstant.BIGZERO;
    private BigDecimal workTimes = null;

    public ClassTeamEntryInfoVO(Time startTime, Time endTime) {
        this.startTime = this.transTime2BigDecimal(startTime);
        this.endTime = this.transTime2BigDecimal(endTime);
        if (0 <= startTime.compareTo(endTime)) {
            this.endTime = this.endTime.add(ONEDAY);
            this.workTimes = new BigDecimal((double)(endTime.getTime() + 86400000L - startTime.getTime()) / 3600000.0);
        } else {
            this.workTimes = new BigDecimal((double)(endTime.getTime() - startTime.getTime()) / 3600000.0);
        }
        this.workTimes = this.workTimes.setScale(2, 4);
    }

    public ClassTeamEntryInfoVO(BigDecimal startTime, BigDecimal endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public boolean containsTime(Time time, int leadDay) {
        BigDecimal _ = this.transTime2BigDecimal(time);
        return this.containsTime(_, leadDay);
    }

    public boolean containsTime(BigDecimal time, int leadDay) {
        return time.compareTo(this.endTime.add(ONEDAY.multiply(new BigDecimal(leadDay)))) < 0;
    }

    public BigDecimal findStartTime(Time time, int leadDay) {
        return this.findStartTime(this.transTime2BigDecimal(time), leadDay);
    }

    public BigDecimal findStartTime(BigDecimal time, int leadDay) {
        BigDecimal _ = NEGONE;
        _ = time.compareTo(this.startTime.add(ONEDAY.multiply(new BigDecimal(leadDay)))) < 0 ? this.startTime.add(ONEDAY.multiply(new BigDecimal(leadDay))) : time;
        return _;
    }

    public BigDecimal findEndTime(BigDecimal time, int leadDay, BigDecimal workTimes) {
        BigDecimal seg1 = time.setScale(0, 1);
        BigDecimal b1 = time.subtract(seg1);
        BigDecimal seg2 = workTimes.setScale(0, 1);
        BigDecimal b2 = workTimes.subtract(seg2);
        int b3 = b1.multiply(new BigDecimal("100")).add(b2.multiply(new BigDecimal("60"))).intValue();
        int i = b3 % 60;
        float f = (float)i / 100.0f;
        int k = b3 / 60;
        BigDecimal result = seg1.add(seg2).add(new BigDecimal(k)).add(new BigDecimal(f).setScale(2, 4));
        return result;
    }

    public BigDecimal getLeavingWorkTimes(BigDecimal time, boolean referenceStartTime) {
        BigDecimal referenceTime = referenceStartTime ? this.startTime : this.endTime;
        BigDecimal workTime = null;
        if (referenceStartTime) {
            BigDecimal b2;
            BigDecimal seg1 = time.setScale(0, 1);
            int i = seg1.intValue() / 24;
            seg1 = seg1.subtract(new BigDecimal(i * 24));
            BigDecimal seg2 = referenceTime.setScale(0, 1);
            BigDecimal b1 = time.subtract(seg1.add(new BigDecimal(i * 24)));
            if (b1.compareTo(b2 = referenceTime.subtract(seg2)) < 0) {
                seg1 = seg1.subtract(new BigDecimal("1"));
                b1 = b1.add(new BigDecimal("60"));
            }
            workTime = b1.subtract(b2).divide(new BigDecimal("0.6"), 4).add(seg1.subtract(seg2));
        } else {
            BigDecimal b2;
            BigDecimal seg1 = referenceTime.setScale(0, 1);
            BigDecimal seg2 = time.setScale(0, 1);
            int i = seg2.intValue() / 24;
            seg2 = seg2.subtract(new BigDecimal(i * 24));
            BigDecimal b1 = referenceTime.subtract(seg1);
            if (b1.compareTo(b2 = time.subtract(seg2.add(new BigDecimal(i * 24)))) < 0) {
                seg1 = seg1.subtract(new BigDecimal("1"));
                b1 = b1.add(new BigDecimal("60"));
            }
            workTime = b1.subtract(b2).divide(new BigDecimal("0.60"), 4).add(seg1.subtract(seg2));
        }
        return this.getWorkTimes().subtract(workTime).setScale(2, 4);
    }

    public BigDecimal getWorkTimes() {
        return this.workTimes;
    }

    public BigDecimal getStartTime() {
        return this.startTime;
    }

    public BigDecimal getEndTime() {
        return this.endTime;
    }

    protected BigDecimal transTime2BigDecimal(Time time) {
        return new BigDecimal(time.getHours() + "." + time.getMinutes());
    }

    public Timestamp getBeginWorkDate(FactoryCalendarVO calendarHelper, Timestamp beginTime) {
        return this.getWorkDate(calendarHelper, beginTime, true);
    }

    public Timestamp getEndWorkDate(FactoryCalendarVO calendarHelper, Timestamp beginTime) {
        return this.getWorkDate(calendarHelper, beginTime, false);
    }

    protected Timestamp getWorkDate(FactoryCalendarVO calendarHelper, Timestamp beginTime, boolean isStartTime) {
        boolean isNegate;
        BigDecimal _ = isStartTime ? this.startTime : this.endTime;
        boolean bl = isNegate = 0 < SysConstant.BIGZERO.compareTo(_);
        if (0 < SysConstant.BIGZERO.compareTo(_)) {
            _ = _.negate();
        }
        BigDecimal leadDay = _.divide(ONEDAY, 0, 3);
        if (isNegate) {
            leadDay = leadDay.negate();
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(beginTime);
        Date workDate = calendarHelper.getWorkDate(new Timestamp(c1.getTimeInMillis()), leadDay.intValue(), isStartTime);
        c1.setTime(workDate);
        String[] str = _.toString().split("\\.");
        c1.set(11, Integer.valueOf(str[0]) - leadDay.abs().intValue() * 24);
        c1.set(12, Integer.valueOf(str[1]));
        return new Timestamp(c1.getTimeInMillis());
    }

    public boolean containsEndTime(BigDecimal time, int leadDay) {
        return time.add(ONEDAY.multiply(new BigDecimal(leadDay))).compareTo(this.startTime) > 0;
    }

    public BigDecimal findEndTime1(BigDecimal time, int leadDay) {
        BigDecimal _ = NEGONE;
        _ = time.compareTo(this.endTime) > 0 ? this.endTime : time;
        return _;
    }

    public BigDecimal findStartTime1(BigDecimal time, int leadDay, BigDecimal workTimes) {
        BigDecimal seg2;
        BigDecimal b2;
        BigDecimal seg1 = time.setScale(0, 1);
        BigDecimal b1 = time.subtract(seg1);
        if (b1.compareTo(b2 = workTimes.subtract(seg2 = workTimes.setScale(0, 1)).multiply(new BigDecimal("0.60"))) < 0) {
            seg1 = seg1.subtract(new BigDecimal("1"));
            b1 = b1.add(new BigDecimal("60"));
        }
        BigDecimal result = seg1.subtract(seg2).add(b1.subtract(b2).divide(new BigDecimal("100"), 4));
        return result.setScale(2, 4);
    }

    public void setStartTime(BigDecimal startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(BigDecimal endTime) {
        this.endTime = endTime;
    }
}

