/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.vo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.FactoryCalendarEntryCollection;
import com.kingdee.eas.mm.basedata.FactoryCalendarEntryFactory;
import com.kingdee.eas.mm.basedata.FactoryCalendarEntryInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FactoryCalendarVO {
    private Context ctx;
    private String storageOrgUnitId;
    private Date firstDay;
    private Date lastDay;
    private Map dateMap = new HashMap();
    private Map seqMap = new HashMap();

    public FactoryCalendarVO(Context ctx, String storageOrgUnitId) {
        this.ctx = ctx;
        this.storageOrgUnitId = storageOrgUnitId;
    }

    public void init() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)this.storageOrgUnitId, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("workDate"));
        sic.add(new SelectorItemInfo("workDateSeq"));
        sic.add(new SelectorItemInfo("nextWorkDaySeq"));
        sic.add(new SelectorItemInfo("preWorkDaySeq"));
        sic.add(new SelectorItemInfo("yearSeq"));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("seq"));
        view.setFilter(filter);
        view.setSelector(sic);
        view.setSorter(sorter);
        FactoryCalendarEntryCollection fce = FactoryCalendarEntryFactory.getLocalInstance((Context)this.ctx).getFactoryCalendarEntryCollection(view);
        int count = fce.size();
        for (int i = 0; i < count; ++i) {
            FactoryCalendarEntryInfo info = fce.get(i);
            FactoryCalendarInfoVO vo = new FactoryCalendarInfoVO(info);
            this.addVO(vo);
            if (i == 0) {
                this.firstDay = info.getWorkDate();
                continue;
            }
            if (i != count - 1) continue;
            this.lastDay = info.getWorkDate();
        }
    }

    protected void addVO(FactoryCalendarInfoVO vo) {
        Date workDate = vo.workDate;
        int workDateSeq = vo.workDateSeq;
        String multiKey = String.valueOf(workDateSeq);
        this.dateMap.put(workDate, vo);
        this.seqMap.put(multiKey, vo);
    }

    public Date getWorkDate(Date date, int leadDay, boolean isPreFind) {
        Date returnDate = null;
        Date _ = this.simpleDate(date);
        FactoryCalendarInfoVO vo = (FactoryCalendarInfoVO)this.dateMap.get(_);
        if (null == vo) {
            returnDate = isPreFind ? this.firstDay : this.lastDay;
        } else {
            int seq = 0;
            if (0 != vo.workDateSeq) {
                seq = vo.workDateSeq + leadDay;
            } else {
                seq = isPreFind ? vo.preWorkDaySeq : vo.nextWorkDaySeq;
                seq += leadDay;
            }
            vo = (FactoryCalendarInfoVO)this.seqMap.get(String.valueOf(seq));
            returnDate = null == vo ? (isPreFind ? this.firstDay : this.lastDay) : vo.workDate;
        }
        return returnDate;
    }

    public void clear() {
        this.dateMap.clear();
        this.seqMap.clear();
    }

    protected Date simpleDate(Date theDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    class FactoryCalendarInfoVO {
        Date workDate;
        int workDateSeq;
        int nextWorkDaySeq;
        int preWorkDaySeq;
        int yearSeq;

        public FactoryCalendarInfoVO(FactoryCalendarEntryInfo info) {
            this.workDate = info.getWorkDate();
            this.workDateSeq = info.getWorkDateSeq();
            this.nextWorkDaySeq = info.getNextWorkDaySeq();
            this.preWorkDaySeq = info.getPreWorkDaySeq();
            this.yearSeq = info.getYearSeq();
        }
    }
}

