/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.vo;

import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.OprTimeUnitEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import java.math.BigDecimal;

public class OperationTimeVO {
    private BigDecimal queuingTime = SysConstant.BIGZERO;
    private BigDecimal workTime = SysConstant.BIGZERO;
    private BigDecimal moveTime = SysConstant.BIGZERO;

    public OperationTimeVO(ManufactureOrderTechnicsInfo info, BigDecimal moQty) {
        BigDecimal processBatchNum = new BigDecimal(0.0);
        processBatchNum = info.getProcessBatch();
        OprTimeUnitEnum unit = info.getTimeUnit();
        this.queuingTime = OperationTimeVO.transferTime(unit, info.getQueuingTime());
        this.workTime = processBatchNum != null && processBatchNum.compareTo(SysConstant.BIGZERO) > 0 ? info.getWorkTime().multiply(moQty).divide(processBatchNum, 2, 4) : info.getWorkTime();
        this.workTime = OperationTimeVO.transferTime(unit, info.getPrepareTime().add(this.workTime));
        this.moveTime = OperationTimeVO.transferTime(unit, info.getMovingTime().add(info.getWaitingTime()));
    }

    public static BigDecimal transferTime(OprTimeUnitEnum unit, BigDecimal time) {
        if (unit != null && unit.getValue() == 3) {
            return time.divide(new BigDecimal(60), 2, 4);
        }
        if (unit != null && unit.getValue() == 4) {
            return time.divide(new BigDecimal(3600), 2, 4);
        }
        return time;
    }

    public BigDecimal getQueuingTime() {
        return this.queuingTime;
    }

    public BigDecimal getWorkTime() {
        return this.workTime;
    }

    public BigDecimal getMoveTime() {
        return this.moveTime;
    }
}

