/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.mo.app.service.EmmServiceDefine;
import com.kingdee.eas.mm.mo.app.service.IService;
import com.kingdee.eas.mm.mo.app.service.StdServiceDefine;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class MOServiceFactory {
    public static final String STD = "std";
    public static final String EMM = "emm";

    private static String getServiceClass(String key) {
        return StdServiceDefine.serviceDefine.get(key) != null ? StdServiceDefine.serviceDefine.get(key) : EmmServiceDefine.serviceDefine.get(key);
    }

    public static IService getIService(Context ctx, String actionName, BatchActionResults batchResults) throws BOSException {
        String key = "";
        if (batchResults.getObjCollection() != null) {
            Object isEmm = batchResults.getObjCollection().getObject(0).get("isEmm");
            key = !Boolean.parseBoolean(isEmm == null ? "false" : isEmm.toString()) ? STD : EMM;
        } else {
            String id = batchResults.getToDoIdsList().get(0).toString();
            try {
                key = MOServiceFactory.getKeyById(ctx, id);
            }
            catch (Exception e) {
                key = STD;
            }
        }
        key = key + "_" + actionName;
        if (!EmmServiceDefine.serviceDefine.containsKey(key)) {
            key = "std_" + actionName;
        }
        return MOServiceFactory.initIService(key, ctx, batchResults);
    }

    private static String getKeyById(Context ctx, String id) throws BOSException, SQLException {
        String key = "";
        StringBuffer getBizBillType = new StringBuffer();
        getBizBillType.append("select FIsEmm from T_MM_ManufactureOrder where fid ='").append(id).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getBizBillType.toString());
        while (rowSet != null && rowSet.next()) {
            Integer seq = new Integer(rowSet.getInt("FIsEmm"));
            if (seq == 0) {
                key = STD;
                continue;
            }
            key = EMM;
        }
        return key;
    }

    public static IService getLoopIService(Context ctx, String actionName, IObjectValue model) throws BOSException {
        if (model == null || model.get("isEmm") == null) {
            throw new BOSException("\u670d\u52a1\u7c7b\u83b7\u53d6\u5931\u8d25");
        }
        String key = "";
        key = !Boolean.parseBoolean(model.get("isEmm").toString()) ? STD : EMM;
        if (!EmmServiceDefine.serviceDefine.containsKey(key = key + "_" + actionName)) {
            key = "std_" + actionName;
        }
        return MOServiceFactory.initLoopIService(key, ctx, model);
    }

    public IService getLoopIServiceById(Context ctx, String actionName, String id) throws BOSException {
        return null;
    }

    private static IService initIService(String key, Context ctx, BatchActionResults batchResults) throws BOSException {
        String className = MOServiceFactory.getServiceClass(key);
        try {
            IService serviceOb = (IService)Class.forName(className).newInstance();
            serviceOb.init(ctx, batchResults);
            return serviceOb;
        }
        catch (Exception e) {
            throw new BOSException("\u670d\u52a1\u7c7b\u83b7\u53d6\u5931\u8d25");
        }
    }

    private static IService initLoopIService(String key, Context ctx, IObjectValue model) throws BOSException {
        String className = MOServiceFactory.getServiceClass(key);
        try {
            IService serviceOb = (IService)Class.forName(className).newInstance();
            serviceOb.initForLoop(ctx, model);
            return serviceOb;
        }
        catch (Exception e) {
            throw new BOSException("\u670d\u52a1\u7c7b\u83b7\u53d6\u5931\u8d25");
        }
    }

    public static <T> T getGenericIService(Context ctx, String actionName, IObjectValue model) throws BOSException {
        if (model == null || model.get("isEmm") == null) {
            throw new BOSException("\u670d\u52a1\u7c7b\u83b7\u53d6\u5931\u8d25");
        }
        String key = "";
        key = !Boolean.parseBoolean(model.get("isEmm").toString()) ? STD : EMM;
        if (!EmmServiceDefine.serviceDefine.containsKey(key = key + "_" + actionName)) {
            key = "std_" + actionName;
        }
        return (T)MOServiceFactory.initLoopIService(key, ctx, model);
    }
}

