/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.service.order;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.app.CalculateWipUtil;
import com.kingdee.eas.mm.mo.app.MOFinish;
import com.kingdee.eas.mm.mo.app.service.Service;
import com.kingdee.eas.mm.mo.app.service.order.util.MoRefactUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AlterService
extends Service {
    private static final long serialVersionUID = -379652924873210188L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.order.service.AlterService");

    protected void doCommon() throws BOSException, EASBizException {
        this.doAlert(this.ctx, this.batchResults);
    }

    protected void doCommonCheck() throws BOSException, EASBizException {
        this.alertBatchCheck(this.ctx, this.batchResults);
    }

    protected void afterCommonHandle() throws BOSException, EASBizException {
    }

    private void alertBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        if (col != null && col.size() > 0) {
            Map mMap = MoRefactUtils.batchGetMaterialRelationInfos(ctx, col);
            for (int i = 0; i < col.size(); ++i) {
                ManufactureOrderInfo mo = (ManufactureOrderInfo)col.getObject(i);
                this.synchronizeMOInfo(ctx, mo);
                col.setObject(i, (IObjectValue)mo);
                MoRefactUtils.submitCheck(ctx, batchResults, mo, mMap);
            }
        }
    }

    protected void synchronizeMOInfo(Context ctx, ManufactureOrderInfo mo) throws EASBizException, BOSException {
        ManufactureOrderInfo dbData = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(mo.getId()));
        this.synchronizeHeadData(mo, dbData);
        ManufactureOrderStockCollection stockCol = mo.getStocks();
        ManufactureOrderStockCollection dbStockCol = dbData.getStocks();
        block0: for (int i = 0; i < stockCol.size(); ++i) {
            ManufactureOrderStockInfo stockInfo = stockCol.get(i);
            for (int j = 0; j < dbStockCol.size(); ++j) {
                ManufactureOrderStockInfo dbStockData = dbStockCol.get(j);
                if (!dbStockData.getId().equals((Object)stockInfo.getId())) continue;
                this.synchronizeStockData(stockInfo, dbStockData);
                continue block0;
            }
        }
        ManufactureOrderTechnicsCollection technicsCol = mo.getTechnics();
        ManufactureOrderTechnicsCollection dbTechnicsCol = dbData.getTechnics();
        block2: for (int i = 0; i < technicsCol.size(); ++i) {
            ManufactureOrderTechnicsInfo technicsInfo = technicsCol.get(i);
            for (int j = 0; j < dbTechnicsCol.size(); ++j) {
                ManufactureOrderTechnicsInfo dbTechnicsData = dbTechnicsCol.get(j);
                if (!dbTechnicsData.getId().equals((Object)technicsInfo.getId())) continue;
                this.synchronizeTechnicsData(technicsInfo, dbTechnicsData);
                continue block2;
            }
        }
        ManufactureOrderExpectOutputCollection outputCol = mo.getExpectOutputs();
        ManufactureOrderExpectOutputCollection dbOutputCol = dbData.getExpectOutputs();
        block4: for (int i = 0; i < outputCol.size(); ++i) {
            ManufactureOrderExpectOutputInfo outputInfo = outputCol.get(i);
            for (int j = 0; j < dbOutputCol.size(); ++j) {
                ManufactureOrderExpectOutputInfo dbOutputData = dbOutputCol.get(j);
                if (!dbOutputData.getId().equals((Object)outputInfo.getId())) continue;
                this.synchronizeExpectOutputData(outputInfo, dbOutputData);
                continue block4;
            }
        }
    }

    protected void synchronizeHeadData(ManufactureOrderInfo mo, ManufactureOrderInfo dbData) {
        mo.setTotalSplitQty(dbData.getTotalSplitQty());
        mo.setTotalSplitBaseQty(dbData.getTotalSplitBaseQty());
        mo.setToStroreQty(dbData.getToStroreQty());
        mo.setToStoreBaseQty(dbData.getToStoreBaseQty());
        mo.setFinishedQty(dbData.getFinishedQty());
        mo.setFinishedBaseQty(dbData.getFinishedBaseQty());
        mo.setActureQty(dbData.getActureQty());
        mo.setActureBaseQty(dbData.getActureBaseQty());
        mo.setPassQty(dbData.getPassQty());
        mo.setPassBaseQty(dbData.getPassBaseQty());
        mo.setConcessionQty(dbData.getConcessionQty());
        mo.setConcessionBaseQty(dbData.getConcessionBaseQty());
        mo.setScrapQty(dbData.getScrapQty());
        mo.setScrapBaseQty(dbData.getScrapBaseQty());
        mo.setRepairQty(dbData.getRepairQty());
        mo.setRepairBaseQty(dbData.getRepairBaseQty());
        mo.setTotalDirectSendQty(dbData.getTotalDirectSendQty());
        mo.setTotalDirectSendBaseQty(dbData.getTotalDirectSendBaseQty());
        mo.setTestedQty(dbData.getTestedQty());
        mo.setTestedBaseQty(dbData.getTestedBaseQty());
        mo.setUnToStoreQty(dbData.getUnToStoreQty());
        mo.setUnToStoreBaseQty(dbData.getUnToStoreBaseQty());
        mo.setUnTestedQty(dbData.getUnToStoreQty());
        mo.setUnTestedBaseQty(dbData.getUnToStoreBaseQty());
        mo.setUnRepairQty(dbData.getUnRepairQty());
        mo.setUnRepairBaseQty(dbData.getUnRepairBaseQty());
    }

    protected void synchronizeStockData(ManufactureOrderStockInfo stockInfo, ManufactureOrderStockInfo dbStockData) {
        stockInfo.setActIssueQty(dbStockData.getActIssueQty());
        stockInfo.setActIssueBaseQty(dbStockData.getActIssueBaseQty());
        stockInfo.setRejectedQty(dbStockData.getRejectedQty());
        stockInfo.setRejectedBaseQty(dbStockData.getRejectedBaseQty());
        stockInfo.setUnIssueQty(dbStockData.getUnIssueQty());
        stockInfo.setUnIssueBaseQty(dbStockData.getUnIssueBaseQty());
        stockInfo.setScrapQty(dbStockData.getScrapQty());
        stockInfo.setScrapBaseQty(dbStockData.getScrapBaseQty());
        stockInfo.setMaterialScrapQty(dbStockData.getMaterialScrapQty());
        stockInfo.setMaterialScrapBaseQty(dbStockData.getMaterialScrapBaseQty());
        stockInfo.setFeedingQty(dbStockData.getFeedingQty());
        stockInfo.setFeedingBaseQty(dbStockData.getFeedingBaseQty());
        stockInfo.setMaterialFeedingQty(dbStockData.getMaterialFeedingQty());
        stockInfo.setMaterialFeedingBaseQty(dbStockData.getMaterialFeedingBaseQty());
        stockInfo.setTotalDirectReceiveQty(dbStockData.getTotalDirectReceiveQty());
        stockInfo.setTotalDirectReceiveBaseQty(dbStockData.getTotalDirectReceiveBaseQty());
        stockInfo.setTotalReceiptQty(dbStockData.getTotalReceiptQty());
        stockInfo.setTotalReceiptBaseQty(dbStockData.getTotalReceiptBaseQty());
        stockInfo.setUnReceiptQty(dbStockData.getUnReceiptQty());
        stockInfo.setUnReceiptBaseQty(dbStockData.getUnReceiptBaseQty());
        stockInfo.setToStoreQty(dbStockData.getToStoreQty());
        stockInfo.setToStoreBaseQty(dbStockData.getToStoreBaseQty());
        stockInfo.setTotalDSTransferQty(dbStockData.getTotalDSTransferQty());
        stockInfo.setTotalDSTransferBaseQty(dbStockData.getTotalDSTransferBaseQty());
        stockInfo.setAssociateQty(dbStockData.getAssociateQty());
    }

    protected void synchronizeTechnicsData(ManufactureOrderTechnicsInfo technicsInfo, ManufactureOrderTechnicsInfo dbTechnicsData) {
        technicsInfo.setTotalSplitQty(dbTechnicsData.getTotalSplitQty());
        technicsInfo.setTotalSplitBaseQty(dbTechnicsData.getTotalSplitBaseQty());
        technicsInfo.setTotalDispatchQty(dbTechnicsData.getTotalDispatchQty());
        technicsInfo.setTotalDispatchBaseQty(dbTechnicsData.getTotalDispatchBaseQty());
        technicsInfo.setUnDispatchQty(dbTechnicsData.getUnDispatchQty());
        technicsInfo.setUnDispatchBaseQty(dbTechnicsData.getUnDispatchBaseQty());
        technicsInfo.setFinishedQty(dbTechnicsData.getFinishedQty());
        technicsInfo.setFinishedBaseQty(dbTechnicsData.getFinishedBaseQty());
        technicsInfo.setRepReportQty(dbTechnicsData.getRepReportQty());
        technicsInfo.setRepReportBaseQty(dbTechnicsData.getRepReportBaseQty());
        technicsInfo.setTestQty(dbTechnicsData.getTestQty());
        technicsInfo.setTestBaseQty(dbTechnicsData.getTestBaseQty());
        technicsInfo.setPassQty(dbTechnicsData.getPassQty());
        technicsInfo.setPassBaseQty(dbTechnicsData.getPassBaseQty());
        technicsInfo.setConcessionQty(dbTechnicsData.getConcessionQty());
        technicsInfo.setConcessionBaseQty(dbTechnicsData.getConcessionBaseQty());
        technicsInfo.setScrapQty(dbTechnicsData.getScrapQty());
        technicsInfo.setScrapBaseQty(dbTechnicsData.getScrapBaseQty());
        technicsInfo.setTotalManufactureScrapQty(dbTechnicsData.getTotalManufactureScrapQty());
        technicsInfo.setTotalManufactureScrapBaseQty(dbTechnicsData.getTotalManufactureScrapBaseQty());
        technicsInfo.setTotalMaterialScrapQty(dbTechnicsData.getTotalMaterialScrapQty());
        technicsInfo.setTotalMaterialScrapBaseQty(dbTechnicsData.getTotalMaterialScrapBaseQty());
        technicsInfo.setRepairQty(dbTechnicsData.getRepairQty());
        technicsInfo.setRepairBaseQty(dbTechnicsData.getRepairBaseQty());
        technicsInfo.setIntoQty(dbTechnicsData.getIntoQty());
        technicsInfo.setIntoBaseQty(dbTechnicsData.getIntoBaseQty());
        technicsInfo.setRepMoveInQty(dbTechnicsData.getRepMoveInQty());
        technicsInfo.setRepMoveInBaseQty(dbTechnicsData.getRepMoveInBaseQty());
        technicsInfo.setOutQty(dbTechnicsData.getOutQty());
        technicsInfo.setOutBaseQty(dbTechnicsData.getOutBaseQty());
        technicsInfo.setRepMoveOutQty(dbTechnicsData.getRepMoveOutQty());
        technicsInfo.setRepMoveOutBaseQty(dbTechnicsData.getRepMoveOutBaseQty());
        technicsInfo.setAssociateQty(dbTechnicsData.getAssociateQty());
    }

    protected void synchronizeExpectOutputData(ManufactureOrderExpectOutputInfo outputInfo, ManufactureOrderExpectOutputInfo dbOutputData) {
        outputInfo.setFinishedQty(outputInfo.getFinishedQty());
        outputInfo.setFinishedBaseQty(outputInfo.getFinishedBaseQty());
        outputInfo.setPassQty(outputInfo.getPassQty());
        outputInfo.setPassBaseQty(outputInfo.getPassBaseQty());
        outputInfo.setScrapQty(outputInfo.getScrapQty());
        outputInfo.setScrapBaseQty(outputInfo.getScrapBaseQty());
        outputInfo.setToStoreQty(outputInfo.getToStoreQty());
        outputInfo.setToStoreBaseQty(outputInfo.getToStoreBaseQty());
        outputInfo.setAssociateQty(outputInfo.getAssociateQty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doAlert(Context ctx, BatchActionResults results) throws EASBizException, BOSException {
        IObjectCollection col = results.getObjCollection();
        ManufactureOrderInfo mo = null;
        if (col != null && col.size() > 0) {
            mo = (ManufactureOrderInfo)col.getObject(0);
        }
        IObjectPK[] pks = results.getToDoPkArray();
        IObjectPK pk = null;
        if (pks != null && pks.length > 0) {
            pk = pks[0];
        }
        if (mo == null || pk == null) {
            return;
        }
        BillBaseStatusEnum dbStatus = BillBaseStatusEnum.SUBMITED;
        BigDecimal alterBeforeQty = mo.getQty();
        BigDecimal alterBeforeBaseQty = mo.getBaseQty();
        MoRefactUtils.updateStock(mo);
        UserInfo auditor = mo.getAuditor();
        Timestamp auditTime = mo.getAuditTime();
        ManufactureOrderInfo dbData = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(mo.getId()));
        dbStatus = dbData.getBaseStatus();
        alterBeforeQty = dbData.getQty();
        alterBeforeBaseQty = dbData.getBaseQty();
        auditor = dbData.getAuditor();
        auditTime = dbData.getAuditTime();
        mo.setAuditor(auditor);
        mo.setAuditTime(auditTime);
        mo.setBaseStatus(dbStatus);
        IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
        BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("B2aZSVXaSx6qxdfekgCmrEY+1VI="));
        mo.setBillType(billTypeInfo);
        if (mo.getLot() != null) {
            mo.setLot(mo.getLot().trim());
        }
        String tempTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            Object[] params;
            StringBuffer updateSql;
            if (mo.getId() != null) {
                StringBuffer sqlBuf = new StringBuffer();
                sqlBuf.append("create table t_tmpstock(fid varchar(44),fstorageorgunitid varchar(44))");
                try {
                    tempTableName = pool.createTempTable(sqlBuf.toString());
                    StringBuffer insertSql = new StringBuffer();
                    insertSql.append("insert into ").append(tempTableName).append("(fid,fstorageorgunitid)").append(" select fid,fstorageorgunitid from t_mm_mftorderstock where fparentid = ?");
                    DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{mo.getId().toString()});
                }
                catch (Exception e1) {
                    throw new BOSException((Throwable)e1);
                }
            }
            this.innerUpdate(ctx, pk, (IObjectValue)mo);
            MoRefactUtils.afterSubmit(ctx, new String[]{mo.getId().toString()});
            LotFacadeFactory.getLocalInstance((Context)ctx).manufactureOrderDeleteLotSource(new String[]{pk.toString()});
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"alter", (BOSObjectType)mo.getBOSType(), (IObjectPK)pk, (String)mo.getNumber(), (String)"mm_manufactureOrder_alter");
            BigDecimal diffQty = alterBeforeQty.subtract(mo.getQty());
            BigDecimal diffBaseQty = alterBeforeBaseQty.subtract(mo.getBaseQty());
            if (mo.getSourceBillType() != null && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(mo.getSourceBillType().getId().toString())) {
                String srcBillEntryID = mo.getSrcBillEntryID();
                updateSql = new StringBuffer();
                updateSql.append(" UPDATE  t_sd_saleorderentry  ");
                updateSql.append(" SET  ");
                updateSql.append("   FTotalProductQty = FTotalProductQty - ?, ");
                updateSql.append("   FTotalunProductQty = FTotalunProductQty +? , ");
                updateSql.append("   FTotalBaseProductQty = FTotalBaseProductQty -? , ");
                updateSql.append("   FTotalBaseunProductQty = FTotalBaseunProductQty +?   ");
                updateSql.append("WHERE  t_sd_saleorderentry.fid =?");
                params = new Object[]{diffQty, diffQty, diffBaseQty, diffBaseQty, srcBillEntryID};
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
            } else if (mo.getSourceBillType() != null && "B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(mo.getSourceBillType().getId().toString())) {
                String sourceBillId = mo.getSourceBillId();
                updateSql = new StringBuffer();
                updateSql.append(" UPDATE  T_MM_ManufactureOrder  ");
                updateSql.append(" SET  ");
                updateSql.append("   FRepairQty = FRepairQty - ?, ");
                updateSql.append("   FunRepairQty = FunRepairQty +? , ");
                updateSql.append("   FRepairBaseQty = FRepairBaseQty -? , ");
                updateSql.append("   FunRepairBaseQty = FunRepairBaseQty +?   ");
                updateSql.append("WHERE  FID =?");
                params = new Object[]{diffQty, diffQty, diffBaseQty, diffBaseQty, sourceBillId};
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
            }
            String moId = mo.getId().toString();
            String[] sqls = new String[4];
            StringBuffer updateSql2 = new StringBuffer();
            updateSql2.append("update T_MM_ManufactureOrder as mo set").append(" (FPassQty,FPassBaseQty,FConcessionQty,FConcessionBaseQty,FFinishedQty,FFinishedBaseQty,FActureQty,FActureBaseQty)=").append(" (select isnull(mot.FPassQty,0),isnull(mot.FPassBaseQty,0),isnull(mot.FConcessionQty,0),isnull(mot.FConcessionBaseQty,0)").append(" ,isnull(mot.FPassQty+mot.FConcessionQty,0), isnull(mot.FPassBaseQty+mot.FConcessionBaseQty,0)").append(" ,isnull(mot.FPassQty+mot.FConcessionQty,0), isnull(mot.FPassBaseQty+mot.FConcessionBaseQty,0)").append(" from T_MM_MFTOrderTechnics mot where mot.FParentID=mo.FID and mot.FOperationNo=mo.FLastOperNo").append(" and mo.FID='").append(moId).append("')").append(" where mo.FID='").append(moId).append("'");
            sqls[0] = updateSql2.toString();
            updateSql2.setLength(0);
            updateSql2.append("update T_MM_ManufactureOrder as mo set").append(" (FFinishedQty,FFinishedBaseQty,FActureQty,FActureBaseQty)=").append(" (select (case when ttype.FFinishedQty=10 then mo.FFinishedQty+mo.FScrapQty else mo.FFinishedQty end),").append(" (case when ttype.FFinishedQty=10 then mo.FFinishedBaseQty+mo.FScrapBaseQty else mo.FFinishedBaseQty end),").append(" mo.FActureQty+mo.FScrapQty, mo.FActureBaseQty+mo.FScrapBaseQty").append(" from T_MM_ProductTransactionType ttype where ttype.fid = mo.FTransactionTypeID").append(" and mo.FID='").append(moId).append("')").append(" where mo.FID='").append(moId).append("'");
            sqls[1] = updateSql2.toString();
            updateSql2.setLength(0);
            updateSql2.append("delete from T_MM_CompletionRes where FParentID in (").append(" select rep.FID from T_MM_CompletionReport rep").append(" inner join T_MM_MFTOrderTechnics mot on mot.fid = rep.FProcessID ").append(" inner join T_MM_ManufactureOrder mo on mot.FParentID=mo.FID and mot.FOperationNo<>mo.FLastOperNo").append(" where rep.FSourceBillType1='10' and mo.FID='").append(moId).append("'").append(" )");
            sqls[2] = updateSql2.toString();
            updateSql2.setLength(0);
            updateSql2.append("delete from T_MM_CompletionRes where FParentID in (").append(" select rep.FID from T_MM_CompletionReport rep").append(" inner join T_MM_DisTaskDispatchEntry dise on rep.FDispWorkProcessID = dise.FID").append(" inner join T_MM_MFTOrderTechnics mot on dise.FSourceBillEntryID = mot.FID ").append(" inner join T_MM_ManufactureOrder mo on mot.FParentID=mo.FID and mot.FOperationNo<>mo.FLastOperNo").append(" where rep.FSourceBillType1='20' and mo.FID='").append(moId).append("'").append(" )");
            sqls[3] = updateSql2.toString();
            SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
            MoRefactUtils.afterAudit(ctx, results);
            try {
                this.updateReqPlanData(ctx, results.getToDoIdsList(), 701, tempTableName);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            MOFinish.dealWithMOFinish(ctx, pk);
            String[] idStrArray = new String[]{mo.getId().toString()};
            CalculateWipUtil.updateWipForMoOrders(ctx, idStrArray);
            if (tempTableName == null) return;
        }
        catch (Throwable throwable) {
            if (tempTableName == null) throw throwable;
            pool.releaseTable(tempTableName);
            throw throwable;
        }
        pool.releaseTable(tempTableName);
    }
}

