/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.service.order;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.service.Service;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class DeleteService
extends Service {
    private static final long serialVersionUID = -379652924873210188L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.order.service.DeleteService");

    protected void doCommon() throws BOSException, EASBizException {
        String[] ids = this.sortMoIdListByMoLongnumber(this.ctx, this.batchResults.getToDoIdsArray());
        for (int i = 0; i < ids.length; ++i) {
            super._delete(this.ctx, (IObjectPK)new ObjectUuidPK(ids[i]));
        }
    }

    protected void doCommonCheck() throws BOSException, EASBizException {
        this.deleteBatchCheck(this.ctx, this.batchResults);
        String[] ids = this.sortMoIdListByMoLongnumber(this.ctx, this.batchResults.getToDoIdsArray());
        for (int n = 0; n < ids.length; ++n) {
            BizReference ref = null;
            try {
                ref = ReferenceDAO.getReference((Context)this.ctx, (BOSUuid)BOSUuid.read((String)ids[n]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ref == null) continue;
            ObjectReferedException exception = new ObjectReferedException((Object)ref, (Throwable)new BizReferenceException(BizReferenceException.BIZ_REFENCED));
            this.batchResults.addError(ids[n], exception.getCause().getMessage());
        }
    }

    protected void afterCommonHandle() throws BOSException, EASBizException {
        try {
            this.updateReqPlanData(this.ctx, this.batchResults.getToDoIdsList(), 104, null);
        }
        catch (Exception exc) {
            throw new BOSException((Throwable)exc);
        }
    }

    private void deleteBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        if (col != null && col.size() > 0) {
            List todos = batchResults.getToDoIdsList();
            for (int i = 0; i < col.size(); ++i) {
                String moid = null;
                String msg = null;
                ArrayList<String> ids = new ArrayList<String>();
                ManufactureOrderInfo mo = (ManufactureOrderInfo)col.getObject(i);
                moid = mo.getId() == null ? "NEWID" : mo.getId().toString();
                StringBuffer ksqlBuf = new StringBuffer();
                ksqlBuf.append("SELECT  mo.FID as FID, ");
                ksqlBuf.append("   mo.FBaseStatus as FBaseStatus, ");
                ksqlBuf.append("   mo.FBirthType as FBirthType, ");
                ksqlBuf.append("   bt.FDestObjectID  as FDestObjectID ");
                ksqlBuf.append("FROM  T_mm_manufactureorder  mo  ");
                ksqlBuf.append("   LEFT  JOIN  T_bot_Relation  bt  ");
                ksqlBuf.append("     ON  mo.fid = bt.FSrcObjectID  ");
                ksqlBuf.append("WHERE  mo.flongnumber  LIKE  '%").append(mo.getId().toString()).append("!%'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksqlBuf.toString());
                try {
                    while (rs != null && rs.next()) {
                        String childId = rs.getString("FID");
                        int status = rs.getInt("FBaseStatus");
                        int birthtype = rs.getInt("FBirthType");
                        String destObjectID = rs.getString("FDestObjectID");
                        if (status != 1 && status != 2) {
                            msg = DeleteService.getString(ctx, "Exists_ModifiedChild_noDelete");
                            break;
                        }
                        if (birthtype != 30) {
                            msg = DeleteService.getString(ctx, "Exists_otherChild_noDelete");
                            break;
                        }
                        if (!StringUtils.isEmpty((String)destObjectID)) {
                            msg = DeleteService.getString(ctx, "Exists_BOTPChild_noDelete");
                            break;
                        }
                        ids.add(childId);
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                if (StringUtils.isEmpty(msg)) {
                    if (!batchResults.isToDo(moid)) continue;
                    IManufactureOrder iManufactureOrder = ManufactureOrderFactory.getLocalInstance(ctx);
                    for (int k = 0; k < ids.size(); ++k) {
                        ObjectUuidPK moPK = new ObjectUuidPK((String)ids.get(k));
                        if (todos.contains(moPK)) continue;
                        iManufactureOrder.deleteNoCheck((IObjectPK)moPK);
                    }
                    continue;
                }
                batchResults.addError(moid, msg);
            }
        }
    }

    private String[] sortMoIdListByMoLongnumber(Context ctx, String[] toDoIds) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])toDoIds);
        StringBuffer ksqlBuf = new StringBuffer();
        ksqlBuf.append(" SELECT  fid  ");
        ksqlBuf.append(" FROM  T_MM_ManufactureOrder  ");
        ksqlBuf.append(" WHERE  fid  IN   (").append(idStr).append(")  ");
        ksqlBuf.append("   ORDER  BY  flongnumber  DESC");
        String[] sortIDs = new String[toDoIds.length];
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksqlBuf.toString());
        try {
            int i = 0;
            while (rs.next()) {
                sortIDs[i++] = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sortIDs;
    }
}

