/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.service.order;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.app.EntrustTypeEnum;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.MOBirthTypeEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderSyncException;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.app.CalculateWipUtil;
import com.kingdee.eas.mm.mo.app.service.Service;
import com.kingdee.eas.mm.mo.app.service.order.util.MoRefactUtils;
import com.kingdee.eas.mm.mo.util.MOUntil;
import com.kingdee.eas.mm.mo.util.NumericUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class SyncStockService
extends Service {
    private static final long serialVersionUID = -379652924873210188L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.order.service.SyncStockService");
    private Map hasDest = null;

    protected void doCommon() throws BOSException, EASBizException {
    }

    protected void doCommonCheck() throws BOSException, EASBizException {
        this.syncStockCheck(this.ctx, this.batchResults);
    }

    protected void afterCommonHandle() throws BOSException, EASBizException {
    }

    private void syncStockCheck(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        List ids = batchResults.getToDoIdsList();
        if (ids != null && ids.size() > 0) {
            String moid = null;
            String msg = null;
            for (int i = 0; i < ids.size(); ++i) {
                moid = ids.toArray()[i].toString();
                ManufactureOrderInfo moInfo = (ManufactureOrderInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)moid)));
                if (moInfo.getBomID() != null) continue;
                msg = SyncStockService.getString(ctx, "SYNC_BOM_ISNULL");
                batchResults.addError(moid, msg);
            }
        }
    }

    public void syncStockSingle() throws BOSException, EASBizException {
        ManufactureOrderInfo moInfo = (ManufactureOrderInfo)this.model;
        ObjectUuidPK pk = new ObjectUuidPK(moInfo.getId());
        this.checkBeforeSyncStock(this.ctx, (IObjectValue)moInfo);
        MMCommonUtils.objectValueSort((IObjectCollection)moInfo.getTechnics(), (boolean)true, (String)"operationNo");
        ManufactureOrderStockCollection newStockCol = this.getLatestStockForSync(this.ctx, (IObjectValue)moInfo);
        if (newStockCol == null || newStockCol.get(0) == null) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.BOMEXPANDISNULL_CANNOTSYNCSTOCK);
        }
        ManufactureOrderStockCollection orderStockCol = moInfo.getStocks();
        StringBuffer getHasDestSql = new StringBuffer();
        getHasDestSql.append("select st.fid entryid from T_MM_mftorderstock st INNER JOIN T_BOT_RELATIONENTRY botEntry ");
        getHasDestSql.append(" on botEntry.FSrcEntryID = st.fid where st.fparentid =  '");
        getHasDestSql.append(moInfo.getId().toString());
        getHasDestSql.append("' union all ");
        getHasDestSql.append("select st.fid entryid from T_MM_mftorderstock st INNER JOIN T_IM_MaterialReqBillEntry mrbe ");
        getHasDestSql.append(" on mrbe.fcorebillentryid = st.fid where st.fparentid =  '");
        getHasDestSql.append(moInfo.getId().toString());
        getHasDestSql.append("' union all ");
        getHasDestSql.append("select st.fid entryid from T_MM_MFTOrderExpectOutput st INNER JOIN T_BOT_RELATIONENTRY botEntry ");
        getHasDestSql.append(" on botEntry.FSrcEntryID = st.fid where st.fparentid =  '");
        getHasDestSql.append(moInfo.getId().toString());
        getHasDestSql.append("'");
        this.hasDest = new HashMap();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)getHasDestSql.toString());
        try {
            while (rs.next()) {
                String entryId = rs.getString("entryid");
                this.hasDest.put(entryId, entryId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList insertKeyCol = new ArrayList();
        ArrayList updateKeyCol = new ArrayList();
        ArrayList deleteKeyCol = new ArrayList();
        this.getStateList(this.ctx, (IObjectCollection)newStockCol, (IObjectCollection)orderStockCol, insertKeyCol, updateKeyCol, deleteKeyCol);
        this.syncStock_addRec(this.ctx, (IObjectCollection)orderStockCol, (IObjectCollection)newStockCol, insertKeyCol);
        this.syncStock_updateStock(this.ctx, orderStockCol, newStockCol, updateKeyCol);
        this.syncStock_deleteStock(this.ctx, orderStockCol, deleteKeyCol);
        this.reBuildStockLineSeq(moInfo);
        ManufactureOrderExpectOutputCollection newExpectOutputs = this.getExpectOutPutForSync(this.ctx, (IObjectValue)moInfo);
        ManufactureOrderExpectOutputCollection orderExpectOutputs = moInfo.getExpectOutputs();
        insertKeyCol = new ArrayList();
        updateKeyCol = new ArrayList();
        deleteKeyCol = new ArrayList();
        this.getStateList(this.ctx, (IObjectCollection)newExpectOutputs, (IObjectCollection)orderExpectOutputs, insertKeyCol, updateKeyCol, deleteKeyCol);
        this.syncStock_addRec(this.ctx, (IObjectCollection)orderExpectOutputs, (IObjectCollection)newExpectOutputs, insertKeyCol);
        this.syncStock_updateExpectOutput(this.ctx, orderExpectOutputs, newExpectOutputs, updateKeyCol);
        this.syncStock_deleteExpectOutput(this.ctx, orderExpectOutputs, deleteKeyCol);
        this._update(this.ctx, (IObjectPK)pk, (IObjectValue)moInfo);
        this.afterSynchronization(this.ctx, new String[]{pk.toString()}, null, null);
        if (moInfo.getBaseStatus() == BillBaseStatusEnum.SUBMITED || moInfo.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
            int bizAction = moInfo.getBaseStatus() == BillBaseStatusEnum.AUDITED ? 701 : 102;
            try {
                BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
                entry.add((Object)pk);
                BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{entry};
                this.updateReqPlanData(this.ctx, entries, bizAction, null);
            }
            catch (Exception exc) {
                throw new BOSException((Throwable)exc);
            }
        }
    }

    private void reBuildStockLineSeq(ManufactureOrderInfo moInfo) {
        if (moInfo == null || moInfo.getStocks() == null || moInfo.getStocks().size() <= 0) {
            return;
        }
        HashMap<String, String> lineSeqMap = new HashMap<String, String>();
        ManufactureOrderStockCollection stocks = moInfo.getStocks();
        Iterator curIterator = stocks.iterator();
        while (curIterator.hasNext()) {
            ManufactureOrderStockInfo curStockInfo = (ManufactureOrderStockInfo)curIterator.next();
            if (curStockInfo.isIsReplaced()) {
                lineSeqMap.put(curStockInfo.getLineSeq(), curStockInfo.getLineSeq());
                continue;
            }
            curStockInfo.setLineSeq("0");
        }
        int lineSeq = 0;
        int stockCnt = stocks.size();
        for (int curIdx = 0; curIdx < stockCnt; ++curIdx) {
            ManufactureOrderStockInfo curStockInfo = stocks.get(curIdx);
            if (curStockInfo.isIsReplaced()) continue;
            ++lineSeq;
            while (lineSeqMap.containsKey(Integer.toString(lineSeq * 10))) {
                ++lineSeq;
            }
            curStockInfo.setLineSeq(Integer.toString(lineSeq * 10));
        }
    }

    protected boolean checkBeforeSyncStock(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ManufactureOrderInfo moInfo = (ManufactureOrderInfo)model;
        if (moInfo.getBaseStatus().getValue() != 2 && moInfo.getBaseStatus().getValue() != 4 && moInfo.getBaseStatus().getValue() != 5) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.STATUSINVALID_CANNOTSYNCSTOCK);
        }
        if (moInfo.getBomID() == null || moInfo.getBomID().equals("")) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.BOMISNULL_CANNOTSYNCSTOCK);
        }
        IBom ibom = BomFactory.getLocalInstance((Context)ctx);
        BomInfo bomInfo = ibom.getBomInfo((IObjectPK)new ObjectUuidPK(moInfo.getBomID()));
        if (!bomInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.BOMUNAUDITED_CANNOTSYNCSTOCK);
        }
        if (moInfo.getMaterial() == null) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.MATERIALISNULL_CANNOTSYNCSTOCK);
        }
        if (moInfo.getTransactionType() == null) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.TRANSACTIONTYPEISNULL_CANNOTSYNCSTOCK);
        }
        if (moInfo.getTotalSplitBaseQty().compareTo(SysConstant.BIGZERO) > 0) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.MOSPLITED_CANNOTSYNCSTOCK);
        }
        if (moInfo.getBirthType() == MOBirthTypeEnum.SPLIT) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.FROMSPLIT_CANNOTSYNCSTOCK);
        }
        return true;
    }

    protected ManufactureOrderStockCollection getLatestStockForSync(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManufactureOrderStockCollection stockCol;
        ProductTransactionTypeInfo transInfo;
        ManufactureOrderInfo moInfo = (ManufactureOrderInfo)model;
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (moInfo.getRouting() != null) {
            param.put("ROUTINGID", moInfo.getRouting().getId().toString());
        } else {
            param.put("ROUTINGID", null);
        }
        param.put("STORAGEORG", moInfo.getStorageOrgUnit());
        param.put("BASEUNIT", moInfo.getBaseUnit());
        param.put("BILL_UNIT", moInfo.getUnit());
        param.put("BILL_QTY", moInfo.getQty());
        param.put("BEGINTIME", moInfo.getPlanBeginDate());
        param.put("ENDTIME", moInfo.getPlanEndDate());
        BomInfo bom = new BomInfo();
        bom.setId(BOSUuid.read((String)moInfo.getBomID()));
        param.put("BOM", bom);
        param.put("projectID", moInfo.getProject());
        param.put("trackID", moInfo.getTrackNumber());
        param.put("MATERIAL", moInfo.getMaterial());
        param.put("TRANSTYPE", moInfo.getTransactionType());
        param.put("RECALC", Boolean.TRUE);
        param.put("IsRoutingChange", new Boolean(true));
        ManufactureOrderTechnicsCollection techCol = moInfo.getTechnics();
        Iterator iter = techCol.iterator();
        HashMap<Integer, ManufactureOrderTechnicsInfo> techMap = new HashMap<Integer, ManufactureOrderTechnicsInfo>();
        while (iter.hasNext()) {
            ManufactureOrderTechnicsInfo techInfo = (ManufactureOrderTechnicsInfo)iter.next();
            techMap.put(new Integer(techInfo.getOperationNo()), techInfo);
        }
        param.put("OPERMAP", techMap);
        MOUntil.getDefaultRouting(ctx, moInfo.getMaterial().getId().toString(), moInfo.getStorageOrgUnit().getId().toString(), moInfo.getTransactionType(), param, null);
        ManufactureOrderStockCollection stocks = ManufactureOrderFactory.getLocalInstance(ctx).bomExpand(param);
        if (stocks != null) {
            stocks = MoRefactUtils.getDistinctStocks(stocks);
        }
        if ((transInfo = moInfo.getTransactionType()) != null && transInfo.getBizType() != null && (transInfo.getBizType().getId().toString().equals("yRPu9BAfSRuIIEu9QnyxviQHQ1w=") || transInfo.getBizType().getId().toString().equals("PF40lAXWJXTgU6hCqMCewyQHQ1w=")) && (stockCol = moInfo.getStocks()) != null && stockCol.size() > 0) {
            for (int i = 0; i < stockCol.size(); ++i) {
                ManufactureOrderStockInfo stInfo = stockCol.get(i);
                if (stInfo.getMaterial() == null || moInfo.getMaterial() == null || !stInfo.getMaterial().getId().toString().equals(moInfo.getMaterial().getId().toString())) continue;
                stocks.add(stInfo);
            }
        }
        if (stocks == null) {
            return new ManufactureOrderStockCollection();
        }
        int firstEffectOperNO = 0;
        if (moInfo.getBirthType() == MOBirthTypeEnum.REFORM) {
            int reformOper = MoRefactUtils.getSplitOperNo(ctx, moInfo.getId().toString());
            int size = techCol.size();
            for (int i = 0; i < size; ++i) {
                if (techCol.get(i).getOperationNo() < reformOper) continue;
                firstEffectOperNO = techCol.get(i).getOperationNo();
                break;
            }
            iter = stocks.iterator();
            while (iter.hasNext()) {
                ManufactureOrderStockInfo stockInfo = (ManufactureOrderStockInfo)iter.next();
                if (stockInfo.getOperationNo() >= firstEffectOperNO) continue;
                iter.remove();
            }
        } else {
            firstEffectOperNO = moInfo.getFirstOperNo();
        }
        MoRefactUtils.updateStockOper(ctx, stocks, 0, firstEffectOperNO, techMap);
        this.updateStockPickDept(ctx, moInfo, stocks, 0, firstEffectOperNO, techMap);
        return stocks;
    }

    private void updateStockPickDept(Context ctx, ManufactureOrderInfo moInfo, ManufactureOrderStockCollection moStockCol, int startOperNO, int defaultOperNo, HashMap techMap) {
        ManufactureOrderStockInfo stockInfo = null;
        int size = moStockCol.size();
        for (int i = 0; i < size; ++i) {
            stockInfo = (ManufactureOrderStockInfo)moStockCol.getObject(i);
            int operationNo = stockInfo.getOperationNo();
            if (operationNo <= startOperNO) continue;
            if (!techMap.containsKey(new Integer(operationNo))) {
                operationNo = defaultOperNo;
            }
            ManufactureOrderTechnicsInfo techInfo = (ManufactureOrderTechnicsInfo)techMap.get(new Integer(operationNo));
            stockInfo.setOperationNo(operationNo);
            stockInfo.setOperation(techInfo.getOperation());
            stockInfo.setWorkcenter(techInfo.getWorkcenter());
            if (!techInfo.getEntrustType().equals((Object)EntrustTypeEnum.INNER)) {
                stockInfo.setPickDept(techInfo.getAdminOrgUnit());
                continue;
            }
            stockInfo.setPickDept(moInfo.getAdminOrgUnit());
        }
    }

    protected void getStateList(Context ctx, IObjectCollection newStockCol, IObjectCollection oldStockCol, Collection insertKeyCol, Collection updateKeyCol, Collection deleteKeyCol) throws EASBizException, BOSException {
        boolean find;
        String recKey2 = "";
        HashSet<String> newStockSet = new HashSet<String>();
        HashSet<String> oldStockSet = new HashSet<String>();
        IObjectValue model2 = null;
        Iterator iter = null;
        Iterator oldIter = null;
        for (IObjectValue model2 : newStockCol) {
            recKey2 = this.getRecKeyString(model2);
            newStockSet.add(recKey2);
        }
        for (IObjectValue model2 : oldStockCol) {
            recKey2 = this.getRecKeyString(model2);
            oldStockSet.add(recKey2);
        }
        iter = newStockSet.iterator();
        String oldRecKey2 = "";
        while (iter.hasNext()) {
            find = false;
            recKey2 = (String)iter.next();
            for (String oldRecKey2 : oldStockSet) {
                if (!recKey2.equals(oldRecKey2)) continue;
                find = true;
                break;
            }
            if (!find) {
                insertKeyCol.add(recKey2);
                continue;
            }
            updateKeyCol.add(recKey2);
        }
        oldIter = oldStockSet.iterator();
        while (oldIter.hasNext()) {
            find = false;
            oldRecKey2 = (String)oldIter.next();
            for (String recKey2 : newStockSet) {
                if (!recKey2.equals(oldRecKey2)) continue;
                find = true;
                break;
            }
            if (find) continue;
            deleteKeyCol.add(oldRecKey2);
        }
    }

    protected void syncStock_addRec(Context ctx, IObjectCollection stockCol, IObjectCollection newStockCol, Collection insertKeyCol) throws EASBizException, BOSException {
        IObjectValue entryInfo = null;
        String recKey = "";
        int size = newStockCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = newStockCol.getObject(i);
            recKey = this.getRecKeyString(entryInfo);
            if (!insertKeyCol.contains(recKey)) continue;
            if (entryInfo instanceof ManufactureOrderStockInfo) {
                ((ManufactureOrderStockInfo)entryInfo).setSourceBillEntrySeq(-99999);
            }
            stockCol.addObject(entryInfo);
        }
    }

    protected void syncStock_updateStock(Context ctx, ManufactureOrderStockCollection stockCol, ManufactureOrderStockCollection newStockCol, Collection updateKeyCol) throws EASBizException, BOSException {
        int index;
        if (updateKeyCol.size() == 0) {
            return;
        }
        ManufactureOrderStockInfo newStockInfo = null;
        ManufactureOrderStockInfo stockInfo = null;
        String recKey = "";
        HashMap<String, ArrayList> hm = new HashMap<String, ArrayList>();
        ArrayList list = null;
        int size = stockCol.size();
        for (index = 0; index < size; ++index) {
            stockInfo = stockCol.get(index);
            if (stockInfo.isIsReplaced() || !updateKeyCol.contains(recKey = this.getRecKeyString((IObjectValue)stockInfo))) continue;
            if (hm.containsKey(recKey)) {
                list = (ArrayList)hm.get(recKey);
                list.add(stockInfo);
                continue;
            }
            list = new ArrayList();
            list.add(stockInfo);
            hm.put(recKey, list);
        }
        for (index = newStockCol.size() - 1; index >= 0; --index) {
            newStockInfo = newStockCol.get(index);
            recKey = this.getRecKeyString((IObjectValue)newStockInfo);
            if (!updateKeyCol.contains(recKey) || !hm.containsKey(recKey)) continue;
            list = (ArrayList)hm.get(recKey);
            int size2 = list.size();
            for (int i = 0; i < size2; ++i) {
                stockInfo = (ManufactureOrderStockInfo)list.get(i);
                if (i == 0) {
                    this.updateStockInfo(ctx, stockInfo, newStockInfo);
                    continue;
                }
                this.deleteRecFromStockCol(ctx, stockCol, stockInfo);
            }
        }
    }

    protected void syncStock_updateExpectOutput(Context ctx, ManufactureOrderExpectOutputCollection expectOutputCol, ManufactureOrderExpectOutputCollection newExpectOutputCol, Collection updateKeyCol) throws EASBizException, BOSException {
        int index;
        if (updateKeyCol.size() == 0) {
            return;
        }
        ManufactureOrderExpectOutputInfo newExpectOutputInfo = null;
        ManufactureOrderExpectOutputInfo expectOutputInfo = null;
        String recKey = "";
        HashMap<String, ArrayList> hm = new HashMap<String, ArrayList>();
        ArrayList list = null;
        int size = expectOutputCol.size();
        for (index = 0; index < size; ++index) {
            expectOutputInfo = expectOutputCol.get(index);
            recKey = this.getRecKeyString((IObjectValue)expectOutputInfo);
            if (!updateKeyCol.contains(recKey)) continue;
            if (hm.containsKey(recKey)) {
                list = (ArrayList)hm.get(recKey);
                list.add(expectOutputInfo);
                continue;
            }
            list = new ArrayList();
            list.add(expectOutputInfo);
            hm.put(recKey, list);
        }
        for (index = newExpectOutputCol.size() - 1; index >= 0; --index) {
            newExpectOutputInfo = newExpectOutputCol.get(index);
            recKey = this.getRecKeyString((IObjectValue)newExpectOutputInfo);
            if (!updateKeyCol.contains(recKey) || !hm.containsKey(recKey)) continue;
            list = (ArrayList)hm.get(recKey);
            int size2 = list.size();
            for (int i = 0; i < size2; ++i) {
                expectOutputInfo = (ManufactureOrderExpectOutputInfo)list.get(i);
                if (i == 0) {
                    expectOutputInfo.setOutputType(newExpectOutputInfo.getOutputType());
                    expectOutputInfo.setDefaultWarehous(newExpectOutputInfo.getDefaultWarehous());
                    BigDecimal qty = NumericUtil.emptyToZero(newExpectOutputInfo.getQty());
                    BigDecimal baseQty = NumericUtil.emptyToZero(newExpectOutputInfo.getBaseQty());
                    baseQty = baseQty.max(expectOutputInfo.getFinishedBaseQty()).max(expectOutputInfo.getToStoreBaseQty());
                    expectOutputInfo.setBaseQty(baseQty);
                    if (!StringUtils.equalsIgnoreCase((String)expectOutputInfo.getUnit().getId().toString(), (String)newExpectOutputInfo.getUnit().getId().toString())) {
                        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
                        MultiMeasureUnitInfo mmuInfo = multiUnit.getMultiUnit(expectOutputInfo.getMaterial().getId().toString(), expectOutputInfo.getUnit().getId().toString());
                        qty = baseQty.divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4);
                    } else {
                        qty = qty.max(expectOutputInfo.getFinishedQty()).max(expectOutputInfo.getToStoreQty());
                    }
                    expectOutputInfo.setQty(qty);
                    continue;
                }
                this.deleteRecFromExpectOutputCol(ctx, expectOutputCol, expectOutputInfo);
            }
        }
    }

    protected void syncStock_deleteStock(Context ctx, ManufactureOrderStockCollection stockCol, Collection deleteKeyCol) throws EASBizException, BOSException {
        ManufactureOrderStockInfo stockInfo = null;
        String recKey = "";
        for (int index = stockCol.size() - 1; index >= 0; --index) {
            stockInfo = stockCol.get(index);
            if (stockInfo.isIsReplaced() || !deleteKeyCol.contains(recKey = this.getRecKeyString((IObjectValue)stockInfo))) continue;
            this.deleteRecFromStockCol(ctx, stockCol, stockInfo);
        }
    }

    protected void syncStock_deleteExpectOutput(Context ctx, ManufactureOrderExpectOutputCollection expectOutputCol, Collection deleteKeyCol) throws EASBizException, BOSException {
        ManufactureOrderExpectOutputInfo expectOutputInfo = null;
        String recKey = "";
        for (int index = expectOutputCol.size() - 1; index >= 0; --index) {
            expectOutputInfo = expectOutputCol.get(index);
            recKey = this.getRecKeyString((IObjectValue)expectOutputInfo);
            if (!deleteKeyCol.contains(recKey)) continue;
            this.deleteRecFromExpectOutputCol(ctx, expectOutputCol, expectOutputInfo);
        }
    }

    protected void deleteRecFromStockCol(Context ctx, ManufactureOrderStockCollection stockCol, ManufactureOrderStockInfo stockInfo) throws EASBizException, BOSException {
        HashSet<String> destEntityHS = new HashSet<String>();
        destEntityHS.add("500AB75E");
        destEntityHS.add("7606B3CD");
        destEntityHS.add("2239F30A");
        destEntityHS.add("5C2A1F0C");
        destEntityHS.add("76C9F8D8");
        destEntityHS.add("BFBCAD51");
        boolean isHasDest = this.checkEntryHasDestObject(ctx, stockInfo.getId().toString(), destEntityHS);
        if (!isHasDest) {
            stockCol.removeObject((IObjectValue)stockInfo);
        } else {
            BigDecimal plannedQty = stockInfo.getPlannedQty();
            BigDecimal plannedBaseQty = stockInfo.getPlannedBaseQty();
            stockInfo.setPlannedQty(new BigDecimal(0));
            stockInfo.setPlannedBaseQty(new BigDecimal(0));
            stockInfo.setQty(new BigDecimal(0));
            stockInfo.setBaseQty(new BigDecimal(0));
            stockInfo.setUnitQty(new BigDecimal(0));
            stockInfo.setUnitBaseQty(new BigDecimal(0));
            stockInfo.setPickExtraQty(new BigDecimal(0));
            stockInfo.setPickExtraBaseQty(new BigDecimal(0));
            stockInfo.setPickLackQty(new BigDecimal(0));
            stockInfo.setPickLackBaseQty(new BigDecimal(0));
            stockInfo.setUnIssueQty(stockInfo.getUnIssueQty().subtract(plannedQty));
            stockInfo.setUnIssueBaseQty(stockInfo.getUnIssueBaseQty().subtract(plannedBaseQty));
            stockInfo.setUnReceiptQty(stockInfo.getPlannedQty().subtract(stockInfo.getTotalReceiptQty()));
            stockInfo.setUnReceiptBaseQty(stockInfo.getPlannedBaseQty().subtract(stockInfo.getTotalReceiptBaseQty()));
            stockInfo.setAssociateQty(stockInfo.getPlannedQty().subtract(stockInfo.getAssociateQty()));
        }
    }

    protected void deleteRecFromExpectOutputCol(Context ctx, ManufactureOrderExpectOutputCollection expectOutputCol, ManufactureOrderExpectOutputInfo expectOutputInfo) throws EASBizException, BOSException {
        HashSet<String> destEntityHS = new HashSet<String>();
        destEntityHS.add("FA1292B4");
        destEntityHS.add("DFBE5164");
        boolean isHasDest = this.checkEntryHasDestObject(ctx, expectOutputInfo.getId().toString(), destEntityHS);
        if (!isHasDest) {
            BigDecimal FIN_PAS_SCR = expectOutputInfo.getFinishedQty().add(expectOutputInfo.getPassQty()).add(expectOutputInfo.getScrapQty());
            if (FIN_PAS_SCR.compareTo(new BigDecimal(0)) == 0) {
                expectOutputCol.removeObject((IObjectValue)expectOutputInfo);
            }
        } else {
            BigDecimal updateQty = expectOutputInfo.getFinishedQty();
            updateQty = updateQty.max(expectOutputInfo.getToStoreQty());
            expectOutputInfo.setQty(updateQty);
        }
    }

    public String getRecKeyString(IObjectValue model) {
        String recKey = "";
        MaterialInfo materialInfo = (MaterialInfo)model.get("material");
        int operationNo = model.getInt("operationNo");
        recKey = materialInfo != null ? materialInfo.getId().toString() : "MATERIAL_NULL";
        recKey = recKey + "!";
        recKey = recKey + operationNo;
        return recKey;
    }

    public boolean checkEntryHasDestObject(Context ctx, String srcEntryId, Set destTypes) throws BOSException {
        boolean hasDestObject = false;
        for (Map.Entry entry : this.hasDest.entrySet()) {
            String keyId = (String)entry.getKey();
            if (!srcEntryId.equals(keyId)) continue;
            hasDestObject = true;
            break;
        }
        return hasDestObject;
    }

    protected void updateStockInfo(Context ctx, ManufactureOrderStockInfo oldStockInfo, ManufactureOrderStockInfo newStockInfo) throws EASBizException, BOSException {
        HashSet<String> destEntityHS = new HashSet<String>();
        destEntityHS.add("500AB75E");
        destEntityHS.add("7606B3CD");
        destEntityHS.add("2239F30A");
        destEntityHS.add("5C2A1F0C");
        destEntityHS.add("76C9F8D8");
        destEntityHS.add("BFBCAD51");
        boolean hasDestObject = this.checkEntryHasDestObject(ctx, oldStockInfo.getId().toString(), destEntityHS);
        BigDecimal oldPlannedQty = oldStockInfo.getPlannedQty();
        oldStockInfo.setUnitBaseQty(newStockInfo.getUnitBaseQty());
        oldStockInfo.setBaseQty(newStockInfo.getBaseQty());
        oldStockInfo.setLossBaseQty(newStockInfo.getLossBaseQty());
        oldStockInfo.setUnIssueBaseQty(oldStockInfo.getUnIssueBaseQty().add(newStockInfo.getPlannedBaseQty()).subtract(oldStockInfo.getPlannedBaseQty()));
        oldStockInfo.setPlannedBaseQty(newStockInfo.getPlannedBaseQty());
        oldStockInfo.setUnReceiptBaseQty(oldStockInfo.getPlannedBaseQty().subtract(oldStockInfo.getTotalReceiptBaseQty()));
        oldStockInfo.setIsQtyLimit(newStockInfo.isIsQtyLimit());
        oldStockInfo.setExtraRatio(newStockInfo.getExtraRatio());
        oldStockInfo.setLackRatio(newStockInfo.getLackRatio());
        oldStockInfo.setPickExtraBaseQty(newStockInfo.getPickExtraBaseQty());
        oldStockInfo.setPickLackBaseQty(newStockInfo.getPickLackBaseQty());
        if (StringUtils.equalsIgnoreCase((String)newStockInfo.getUnit().getId().toString(), (String)oldStockInfo.getUnit().getId().toString())) {
            oldStockInfo.setUnitQty(newStockInfo.getUnitQty());
            oldStockInfo.setQty(newStockInfo.getQty());
            oldStockInfo.setLossQty(newStockInfo.getLossQty());
            oldStockInfo.setUnIssueQty(oldStockInfo.getUnIssueQty().add(newStockInfo.getPlannedQty()).subtract(oldPlannedQty));
            oldStockInfo.setPlannedQty(newStockInfo.getPlannedQty());
            oldStockInfo.setUnReceiptQty(oldStockInfo.getPlannedQty().subtract(oldStockInfo.getTotalReceiptQty()));
            oldStockInfo.setPickExtraQty(newStockInfo.getPickExtraQty());
            oldStockInfo.setPickLackQty(newStockInfo.getPickLackQty());
        } else {
            IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)oldStockInfo.getMaterial().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)oldStockInfo.getUnit().getId().toString()));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add("baseConvsRate");
            sic.add("qtyPrecision");
            viewInfo.setSelector(sic);
            MultiMeasureUnitCollection coll = immu.getMultiMeasureUnitCollection(viewInfo);
            MultiMeasureUnitInfo mmuInfo = coll.get(0);
            oldStockInfo.setUnitQty(oldStockInfo.getUnitBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setQty(oldStockInfo.getBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setLossQty(oldStockInfo.getLossBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setUnIssueQty(oldStockInfo.getUnIssueBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setPlannedQty(oldStockInfo.getPlannedBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setUnReceiptQty(oldStockInfo.getUnReceiptBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setPickExtraQty(oldStockInfo.getPickExtraBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setPickLackQty(oldStockInfo.getPickLackBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
        }
        oldStockInfo.setLossRatio(newStockInfo.getLossRatio());
        oldStockInfo.setAssociateQty(oldStockInfo.getAssociateQty().add(oldStockInfo.getPlannedQty().subtract(oldPlannedQty)));
        oldStockInfo.setMatReplaceType(newStockInfo.getMatReplaceType());
        oldStockInfo.setAssyLocation(newStockInfo.getAssyLocation());
        oldStockInfo.setBlkSize(newStockInfo.getBlkSize());
        oldStockInfo.setSpecifiedLength(newStockInfo.getSpecifiedLength());
        if (!hasDestObject) {
            oldStockInfo.setProvideType(newStockInfo.getProvideType());
            oldStockInfo.setStorageOrgUnit(newStockInfo.getStorageOrgUnit());
            oldStockInfo.setIssueMode(newStockInfo.getIssueMode());
            oldStockInfo.setPickType(newStockInfo.getPickType());
            oldStockInfo.setWarehouse(newStockInfo.getWarehouse());
            oldStockInfo.setLocation(newStockInfo.getLocation());
            oldStockInfo.setIsStockAllot(newStockInfo.isIsStockAllot());
            oldStockInfo.setReceiptStroageOrgUnit(newStockInfo.getReceiptStroageOrgUnit());
            oldStockInfo.setReceiptStock(newStockInfo.getReceiptStock());
            oldStockInfo.setTransferType(newStockInfo.getTransferType());
            oldStockInfo.setIsBackflush(newStockInfo.isIsBackflush());
        }
    }

    protected ManufactureOrderExpectOutputCollection getExpectOutPutForSync(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManufactureOrderInfo moInfo = (ManufactureOrderInfo)model;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("MATERIAL", moInfo.getMaterial());
        param.put("BASEUNIT", moInfo.getBaseUnit());
        param.put("STORAGEORG", moInfo.getStorageOrgUnit());
        param.put("BILL_QTY", moInfo.getQty());
        param.put("BILL_UNIT", moInfo.getUnit());
        param.put("BEGINTIME", moInfo.getPlanBeginDate());
        param.put("ENDTIME", moInfo.getPlanEndDate());
        param.put("SPLIT_QTY", new BigDecimal(0));
        BomInfo bom = new BomInfo();
        bom.setId(BOSUuid.read((String)moInfo.getBomID()));
        param.put("BOM", bom);
        if (moInfo.getRouting() != null) {
            param.put("ROUTINGID", moInfo.getRouting().getId().toString());
        } else {
            param.put("ROUTINGID", null);
        }
        HashMap<String, Object> retData = new HashMap<String, Object>();
        retData.put("LOTNUMBER", moInfo.getLot());
        retData.put("TECHNICS", (Object)moInfo.getTechnics());
        MoRefactUtils.getExpectOutput(ctx, param, retData);
        ManufactureOrderExpectOutputCollection expectOutputs = (ManufactureOrderExpectOutputCollection)((Object)retData.get("EXPECTOUTPUTS"));
        Iterator iter = null;
        ManufactureOrderTechnicsCollection techCol = moInfo.getTechnics();
        iter = techCol.iterator();
        HashMap<Integer, ManufactureOrderTechnicsInfo> techMap = new HashMap<Integer, ManufactureOrderTechnicsInfo>();
        while (iter.hasNext()) {
            ManufactureOrderTechnicsInfo techInfo = (ManufactureOrderTechnicsInfo)iter.next();
            techMap.put(new Integer(techInfo.getOperationNo()), techInfo);
        }
        if (moInfo.getBirthType() == MOBirthTypeEnum.REFORM) {
            int reformOper;
            int firstEffectOperNO = reformOper = MoRefactUtils.getSplitOperNo(ctx, moInfo.getId().toString());
            int size = techCol.size();
            for (int i = 0; i < size; ++i) {
                if (techCol.get(i).getOperationNo() < reformOper) continue;
                firstEffectOperNO = techCol.get(i).getOperationNo();
                break;
            }
            iter = expectOutputs.iterator();
            while (iter.hasNext()) {
                ManufactureOrderExpectOutputInfo expectOutputInfo = (ManufactureOrderExpectOutputInfo)iter.next();
                if (expectOutputInfo.getOperationNo() >= firstEffectOperNO) continue;
                iter.remove();
            }
        }
        MoRefactUtils.updateExpectOutputOper(ctx, expectOutputs, 0, moInfo.getLastOperNo(), techMap);
        return expectOutputs;
    }

    private void afterSynchronization(Context ctx, String[] orderIdArray, String[] stocksIdArray, String[] technicsIdArray) throws BOSException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] batchUpdateSQLArray = new String[3];
        String orderIds = SQLUtil.arrayToString((Object[])orderIdArray);
        stringBuffer.setLength(0);
        stringBuffer.append("update T_MM_MFTOrderStock as t0  ");
        stringBuffer.append("set (FBaseQty,FLossBaseQty,FPlannedBaseQty,FOriginalPlanBaseQty,FUnReceiptBaseQty,FTotalReceiptBaseQty,FPickExtraBaseQty,FPickLackBaseQty) = ");
        stringBuffer.append("(select round(decimal(t0.FQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision),");
        stringBuffer.append("round(decimal(t0.FLossQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ");
        stringBuffer.append("round(decimal(t0.FPlannedQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ");
        stringBuffer.append("round(decimal(t0.FOriginalPlanQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ");
        stringBuffer.append("round(decimal(t0.FUnReceiptQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ");
        stringBuffer.append("round(decimal(t0.FTotalReceiptQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ");
        stringBuffer.append("round(decimal(t0.FPickExtraQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ");
        stringBuffer.append("round(decimal(t0.FPickLackQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision) ");
        stringBuffer.append("from t_bd_multimeasureunit t2 , t_bd_multimeasureunit t3 ");
        stringBuffer.append("where t0.FMaterialID = t2.FMaterialID and t0.FUnitID = t2.fmeasureunitid ");
        stringBuffer.append("and t0.FMaterialID = t3.FMaterialID and t0.FBaseUnitID = t3.fmeasureunitid ");
        stringBuffer.append("and t0.FParentID in (").append(orderIds).append(") ");
        stringBuffer.append("and t0.FSourceBillEntrySeq = ").append(-99999).append(")");
        batchUpdateSQLArray[0] = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringBuffer.append("update T_MM_MFTOrderStock as t0 ");
        stringBuffer.append("set (FUnIssueQty,FUnIssueBaseQty,FAssociateQty) = ");
        stringBuffer.append("(select  t0.FPlannedQty-t0.FActIssueQty+t0.FRejectedQty,t0.FPlannedBaseQty-t0.FActIssueBaseQty+t0.FRejectedBaseQty,").append(" case when t0.FIsQtyLimit=1 then ").append("round(to_decimal(t0.FPickExtraBaseQty,21,8),b1.FQtyPrecision)-t0.FActIssueBaseQty+t0.FRejectedBaseQty ").append(" else t0.FPlannedBaseQty-t0.FActIssueBaseQty+t0.FRejectedBaseQty ").append(" end ");
        stringBuffer.append("from t_bd_multimeasureunit  b1 ");
        stringBuffer.append("where t0.FMaterialID = b1.FMaterialID and t0.FBaseUnitID = b1.fmeasureunitid ");
        stringBuffer.append("and t0.FParentID in (").append(orderIds).append(") ");
        stringBuffer.append("and t0.FSourceBillEntrySeq = ").append(-99999).append(") ");
        batchUpdateSQLArray[1] = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringBuffer.append("update T_MM_MFTOrderStock set FSourceBillEntrySeq = 0 ");
        stringBuffer.append("where FParentID in (").append(orderIds).append(") ");
        stringBuffer.append("and FSourceBillEntrySeq = ").append(-99999);
        batchUpdateSQLArray[2] = stringBuffer.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])batchUpdateSQLArray);
        CalculateWipUtil.updateWipForMoOrders(ctx, orderIdArray);
    }
}

