/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.service.order;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.mo.MOUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.MOUpdaterMOOrder;
import com.kingdee.eas.mm.mo.app.MOUpdaterSaleOrder;
import com.kingdee.eas.mm.mo.app.service.Service;
import com.kingdee.eas.mm.mo.app.util.MOCostObjectUtil;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class UnAuditService
extends Service {
    private static final long serialVersionUID = -379652924873210188L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.order.service.UnAuditService");

    protected void doCommon() throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])this.batchResults.getToDoIdsArray());
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_MFTOrderTechnics as t0  ").append("set (FIntoQty,FIntoBaseQty) = ").append("(select 0,0 ").append("from T_MM_ManufactureOrder t1 ").append("where t1.FFirstOperNo = t0.FOperationNo ").append("and t1.FID = t0.FParentID ").append("and t1.FID in (").append(idStr).append(") ").append(") ");
        DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
        LotFacadeFactory.getLocalInstance((Context)this.ctx).manufactureOrderDeleteLotSource(this.batchResults.getToDoIdsArray());
        MOCostObjectUtil.removeCostObject(this.ctx, idStr);
    }

    protected void doCommonCheck() throws BOSException, EASBizException {
        this.unAuditBatchCheck(this.ctx, this.batchResults);
    }

    protected void afterCommonHandle() throws BOSException, EASBizException {
        BillUpdater billUpdater = new MOUpdaterSaleOrder(this.ctx);
        billUpdater.setBatchResults(this.batchResults);
        billUpdater.setAuditAction(false);
        billUpdater.execute();
        billUpdater = new MOUpdaterMOOrder(this.ctx);
        billUpdater.setBatchResults(this.batchResults);
        billUpdater.setAuditAction(false);
        billUpdater.execute();
        try {
            this.updateReqPlanData(this.ctx, this.batchResults.getToDoIdsList(), 109, null);
        }
        catch (Exception exc) {
            throw new BOSException((Throwable)exc);
        }
    }

    private void unAuditBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] allIDs = batchResults.getAllIDs();
        if (allIDs != null && allIDs.length > 0) {
            for (int i = 0; i < allIDs.length; ++i) {
                ManufactureOrderInfo mo = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(allIDs[i]));
                try {
                    this.checkUnAuditInParam(ctx, mo);
                    continue;
                }
                catch (SCMBillException ex) {
                    batchResults.addError(allIDs[i], ex.getMessage());
                }
            }
        }
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select distinct FSrcObjectID from t_bot_Relation ").append("where FSrcObjectID in (").append(idStr).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            String msg = null;
            while (rs != null && rs.next()) {
                msg = UnAuditService.getString(ctx, "HAS_FOLLOWBILL");
                batchResults.addError(rs.getString("FSrcObjectID"), msg);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select mo.FID,mo.FBirthType,mor.FChildId from T_MM_ManufactureOrder mo LEFT JOIN T_MM_MOSplitRecord mor ON mo.fid=mor.FParentId where mo.FID in (").append(idStr).append(") ");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String msg = null;
            while (iRowSet != null && iRowSet.next()) {
                String id = iRowSet.getString("FID");
                int birthType = iRowSet.getInt("FBirthType");
                String childid = iRowSet.getString("FChildId");
                if (birthType == 10 || birthType == 20) {
                    msg = UnAuditService.getString(ctx, "SPLIT_BILL_NO_UNAUDIT");
                    batchResults.addError(id, msg);
                    continue;
                }
                if (StringUtils.isEmpty((String)childid)) continue;
                msg = UnAuditService.getString(ctx, "HAS_SPLIT_BILL_NO_UNAUDIT");
                batchResults.addError(id, msg);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (ManufactureOrderFactory.getLocalInstance(ctx).chkSrcMoClosed()) {
            batchResults = MOUtil.checkMOClose(ctx, batchResults, idStr, "T_MM_ManufactureOrder", BatchActionEnum.UNAUDIT);
        }
    }

    private boolean checkUnAuditInParam(Context ctx, ManufactureOrderInfo mo) throws BOSException, EASBizException {
        if (mo != null && mo.getBillType() != null) {
            String billTypeId = mo.getBillType().getId().toString();
            String orgUnitID = mo.getStorageOrgUnit().getId().toString();
            boolean isCanUnAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId);
            if (strCanUnAudit != null && strCanUnAudit.trim().length() != 0 && strCanUnAudit.trim().toLowerCase().equals("1")) {
                isCanUnAudit = true;
            }
            if (!isCanUnAudit) {
                throw new SCMBillException(SCMBillException.CHECK_UNAUDIT_PARAM);
            }
        }
        return true;
    }
}

