/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.service.order;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.service.Service;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class UnReleaseService
extends Service {
    private static final long serialVersionUID = -379652924873210188L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.order.service.UnReleaseService");

    protected void doCommon() throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])this.batchResults.getToDoIdsArray());
        String[] sqls = new String[1];
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_ManufactureOrder   ").append(" set FBaseStatus = ").append(4).append(" where fid in (").append(idStr).append(")  ");
        sqls[0] = updateSql.toString();
        SQLUtil.batchExecuteSql((Context)this.ctx, (String[])sqls);
    }

    protected void doCommonCheck() throws BOSException, EASBizException {
        this.unReleasedBatchCheck(this.ctx, this.batchResults);
    }

    protected void afterCommonHandle() throws BOSException, EASBizException {
    }

    private void unReleasedBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        List ids = batchResults.getToDoIdsList();
        if (ids != null && ids.size() > 0) {
            String moid = null;
            String msg = null;
            for (int i = 0; i < ids.size(); ++i) {
                moid = ids.toArray()[i].toString();
                ManufactureOrderInfo moInfo = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)moid)));
                if (moInfo.getBaseStatus() != BillBaseStatusEnum.RELEASED) {
                    msg = UnReleaseService.getString(ctx, "NotReleasedForUnReleased");
                    throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{msg});
                }
                HashSet<String> excluded = new HashSet<String>();
                excluded.add("6F0D8519");
                if (!this.ifHaveDestBills(ctx, moid, excluded)) continue;
                msg = UnReleaseService.getString(ctx, "Exists_BOTP_bill_noUnReleased");
                throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{msg});
            }
        }
    }

    private boolean ifHaveDestBills(Context ctx, String billIdString, Set excludedDestEntity) throws BOSException {
        boolean rtn = false;
        StringBuffer selectSql = new StringBuffer();
        String excludedDest = "'null'";
        if (excludedDestEntity != null && excludedDestEntity.size() > 0) {
            excludedDest = SQLUtil.setToString((Set)excludedDestEntity);
        }
        selectSql.append("select distinct FSrcObjectID from t_bot_Relation").append(" where FSrcObjectID = '").append(billIdString).append("'").append(" and FDestEntityID not in (").append(excludedDest).append(")").append(" union all ").append(" select distinct FSrcObjectID from t_bot_Relation").append(" where FSrcObjectID in").append(" (select FDestObjectID from t_bot_Relation where FSrcObjectID = '").append(billIdString).append("'").append(" and FDestEntityID in (").append(excludedDest).append("))").append(" and FDestEntityID not in (").append(excludedDest).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            if (rs != null && rs.next()) {
                rtn = true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return rtn;
    }
}

