/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.service.order.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.app.LotFrameManu;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.CSEntrustTypeEnum;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.OperationFactory;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.ScheduleTypeEnum;
import com.kingdee.eas.mm.basedata.WPControlStrategyEnum;
import com.kingdee.eas.mm.basedata.app.EntrustTypeEnum;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.MOBirthTypeEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.app.util.MOCostObjectUtil;
import com.kingdee.eas.mm.mo.util.MORootingUtil;
import com.kingdee.eas.mm.mo.util.MOStockUtil;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.project.WBSTypeEnum;
import com.kingdee.eas.mm.project.app.WriteBackWBSFacadeControllerBean;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MoRefactUtils {
    private static final String REGEX_L = "\\{";
    private static final String REGEX_R = "\\}";

    public static void lotNumberCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        HashSet orderSet = (HashSet)batchResults.getToDoIdsSet();
        IObjectCollection col = batchResults.getObjCollection();
        String msg = null;
        ManufactureOrderCollection orderCollection = null;
        IManufactureOrder order = ManufactureOrderFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        ev.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orderSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        orderCollection = col != null ? (ManufactureOrderCollection)col : order.getManufactureOrderCollection(ev);
        MaterialInfo materialInfo = null;
        ManufactureOrderInfo mo = null;
        StorageOrgUnitInfo storageOrgUnit = null;
        for (int i = 0; i < orderCollection.size(); ++i) {
            mo = (ManufactureOrderInfo)orderCollection.getObject(i);
            materialInfo = mo.getMaterial();
            storageOrgUnit = mo.getStorageOrgUnit();
            String id = mo.getId().toString();
            if (storageOrgUnit == null || materialInfo == null) continue;
            boolean isIsLotNumber = MoRefactUtils.getIsIsLotNumber(ctx, materialInfo, storageOrgUnit);
            LotFrame lotFrame = new LotFrame();
            lotFrame.setMainBizOrg(storageOrgUnit.getId().toString());
            lotFrame.setMaterial(materialInfo.getId().toString());
            List lotList = new ArrayList<LotFrame>();
            lotList.add(lotFrame);
            lotList = LotRuleFactory.getLocalInstance((Context)ctx).fillLotFramesNoSerial(lotList);
            if (lotList != null && lotList.size() > 0) {
                lotFrame = (LotFrame)lotList.get(0);
            }
            boolean isLotRule = false;
            if (lotFrame != null && lotFrame.getLotRule() != null) {
                isLotRule = true;
            }
            LotParamValueInfo lotParamInfo = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(storageOrgUnit.getId().toString());
            boolean isManufacturePlan = lotParamInfo.isManufacturePlan();
            boolean isManufactureOrder = lotParamInfo.isManufactureOrder();
            if (!isIsLotNumber) continue;
            if (isLotRule) {
                if (isManufacturePlan) {
                    if (mo.getLot() != null && !mo.getLot().trim().equals("")) continue;
                    msg = MoRefactUtils.getString(ctx, "LOT_NOT_NULL");
                    batchResults.addError(id, msg);
                    continue;
                }
                if (!isManufactureOrder || mo.getLot() != null && !mo.getLot().trim().equals("")) continue;
                msg = MoRefactUtils.getString(ctx, "LOT_NOT_NULL");
                batchResults.addError(id, msg);
                continue;
            }
            if (isManufacturePlan) {
                if (mo.getLot() != null && !mo.getLot().trim().equals("")) continue;
                msg = MoRefactUtils.getString(ctx, "LOT_NOT_NULL");
                batchResults.addError(id, msg);
                continue;
            }
            if (!isManufactureOrder || mo.getLot() != null && !mo.getLot().trim().equals("")) continue;
            msg = MoRefactUtils.getString(ctx, "LOT_NOT_NULL");
            batchResults.addError(id, msg);
        }
    }

    public static String getString(Context ctx, String resourceName) {
        String path = "com.kingdee.eas.mm.mo.ManufactureOrderResource";
        String strTemp = ResourceBase.getString((String)path, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    public static boolean getIsIsLotNumber(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnit) throws EASBizException, BOSException {
        MaterialInventoryInfo materialInv;
        SCMEntryDataVO vo = new SCMEntryDataVO();
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        vo.setMaterialInfos(new MaterialInfo[]{materialInfo});
        vo.setStorageOrgUnitInfos(new StorageOrgUnitInfo[]{storageOrgUnit});
        vo.setIsLoadingMaterialPlan(true);
        vo.setIsLoadingMaterialInventory(true);
        vo.setIsLoadingMaterialInfo(false);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
        String key = materialInfo.getId().toString() + storageOrgUnit.getId().toString();
        Map miInfoMap = voResult.getMaterialInventoryInfos();
        return miInfoMap != null && miInfoMap.get(key) != null && (materialInv = (MaterialInventoryInfo)voResult.getMaterialInventoryInfos().get(key)).isIsLotNumber();
    }

    public static void lotNumberCheck(Context ctx, ManufactureOrderInfo mo) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = null;
        MaterialInfo materialInfo = null;
        materialInfo = mo.getMaterial();
        storageOrgUnit = mo.getStorageOrgUnit();
        if (storageOrgUnit == null) {
            return;
        }
        if (materialInfo == null) {
            return;
        }
        boolean isIsLotNumber = MoRefactUtils.getIsIsLotNumber(ctx, materialInfo, storageOrgUnit);
        if (!isIsLotNumber) {
            return;
        }
        LotFrame lotFrame = new LotFrame();
        lotFrame.setMainBizOrg(storageOrgUnit.getId().toString());
        lotFrame.setMaterial(materialInfo.getId().toString());
        List lotList = new ArrayList<LotFrame>();
        lotList.add(lotFrame);
        lotList = LotRuleFactory.getLocalInstance((Context)ctx).fillLotFramesNoSerial(lotList);
        if (lotList != null && lotList.size() > 0) {
            lotFrame = (LotFrame)lotList.get(0);
        }
        boolean isLotRule = false;
        if (lotFrame != null && lotFrame.getLotRule() != null) {
            isLotRule = true;
        }
        LotParamValueInfo lotParamInfo = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(storageOrgUnit.getId().toString());
        boolean isManufacturePlan = lotParamInfo.isManufacturePlan();
        boolean isManufactureOrder = lotParamInfo.isManufactureOrder();
        boolean isManufactureProseee = lotParamInfo.isManufactureProseee();
        PlannedOrderInfo planorderinfo = null;
        if (mo.getSourceBillId() != null) {
            try {
                planorderinfo = (PlannedOrderInfo)PlannedOrderFactory.getLocalInstance((Context)ctx).getCoreBillBaseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)mo.getSourceBillId())));
            }
            catch (ObjectNotFoundException e) {
                planorderinfo = null;
            }
        }
        if (isIsLotNumber) {
            if (isManufacturePlan) {
                if (isManufactureOrder) {
                    if (isManufactureProseee) {
                        if (planorderinfo != null && planorderinfo.getLot() != null) {
                            mo.setLot(planorderinfo.getLot().trim());
                        } else if (isLotRule) {
                            MoRefactUtils.dealLotRule(ctx, mo);
                        } else {
                            mo.setLot(null);
                        }
                    } else if (isLotRule) {
                        MoRefactUtils.dealLotRule(ctx, mo);
                    } else {
                        mo.setLot(null);
                    }
                } else if (planorderinfo != null && planorderinfo.getLot() != null) {
                    mo.setLot(planorderinfo.getLot().trim());
                } else if (isLotRule) {
                    MoRefactUtils.dealLotRule(ctx, mo);
                } else {
                    mo.setLot(null);
                }
            } else if (isManufactureOrder) {
                if (isLotRule) {
                    MoRefactUtils.dealLotRule(ctx, mo);
                } else {
                    mo.setLot(null);
                }
            }
        }
    }

    public static void dealLotRule(Context ctx, ManufactureOrderInfo manuorderInfo) throws EASBizException, BOSException {
        LotFrame lotFrame = LotRuleFactory.getLocalInstance((Context)ctx).getLotFrameExtend(manuorderInfo.getMaterial().getId().toString(), manuorderInfo.getStorageOrgUnit().getId().toString());
        if (lotFrame != null && lotFrame.getLotRule() != null) {
            LotFrameManu lot = new LotFrameManu();
            lot.setSeq(lotFrame.getSeq());
            lot.setSysDate(lotFrame.getSysDate());
            lot.setCurrentSerial(lotFrame.getCurrentSerial());
            lot.setLotRule(lotFrame.getLotRule());
            lot.setBillNumber(manuorderInfo.getNumber());
            lot.setMainBizOrg(manuorderInfo.getStorageOrgUnit().getNumber());
            lot.setMaterial(manuorderInfo.getMaterial().getNumber());
            lot.setMfg((Date)manuorderInfo.getPlanEndDate());
            lot.setBizDate(manuorderInfo.getBizDate());
            String lotNo = lot.getLotNumber();
            manuorderInfo.setLot(lotNo);
        } else {
            manuorderInfo.setLot(null);
        }
    }

    public static Map batchGetMaterialRelationInfos(Context ctx, IObjectCollection col) throws BOSException, EASBizException {
        HashMap rtnMap = new HashMap();
        HashMap mMap = new HashMap();
        for (int i = 0; i < col.size(); ++i) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)col.getObject(i);
            String keyVal = mo.getStorageOrgUnit().getId().toString() + "&" + mo.getMaterial().getId().toString();
            ArrayList<String> lst = new ArrayList<String>();
            lst.add(mo.getStorageOrgUnit().getId().toString());
            lst.add(mo.getMaterial().getId().toString());
            if (mMap.containsKey(keyVal)) continue;
            mMap.put(keyVal, lst);
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("select a.fOrgUnit,a.fmaterialid,a.FISCONFIGABLE,a.FMANUFACTURESTRATEGYID,mst.fnumber as FMANUFACTURESTRATEGYNum,b.fname_");
        strBuf.append(ctx.getLocale()).append(" as fmaterialName,a.FIsolatedRule ");
        strBuf.append(" from t_bd_materialplan a inner join t_bd_material b on a.fmaterialid = b.fid ");
        strBuf.append(" inner join T_BD_ManufactureStrategy mst on a.FMANUFACTURESTRATEGYID = mst.fid ");
        strBuf.append(" where ");
        int inner = 0;
        int allCnt = 0;
        StringBuffer sbf = new StringBuffer();
        Iterator it = mMap.keySet().iterator();
        while (it.hasNext()) {
            ++allCnt;
            String key = (String)it.next();
            List mu = (List)mMap.get(key);
            if (++inner == 1) {
                sbf.append("(a.forgunit = '").append(mu.get(0)).append("' and a.fmaterialid = '").append(mu.get(1)).append("')");
            } else {
                sbf.append(" or (a.forgunit = '").append(mu.get(0)).append("' and a.fmaterialid = '").append(mu.get(1)).append("')");
            }
            if ((inner != 500 || allCnt >= mMap.size()) && allCnt != mMap.size()) continue;
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)(strBuf.toString() + sbf.toString()));
            try {
                while (rows.next()) {
                    String keyString = rows.getString("fOrgUnit") + "&" + rows.getString("fmaterialid");
                    ArrayList<Object> vLst = new ArrayList<Object>();
                    vLst.add(new Integer(rows.getInt("FISCONFIGABLE")));
                    vLst.add(rows.getString("FMANUFACTURESTRATEGYID"));
                    vLst.add(rows.getString("FMANUFACTURESTRATEGYNum"));
                    vLst.add(rows.getString("fmaterialName"));
                    vLst.add(rows.getString("FIsolatedRule"));
                    rtnMap.put(keyString, vLst);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            inner = 0;
            sbf.setLength(0);
        }
        return rtnMap;
    }

    public static void submitCheck(Context ctx, BatchActionResults batchResults, ManufactureOrderInfo mo, Map mMap) throws BOSException, EASBizException {
        ManufactureOrderExpectOutputCollection outCol;
        int rowCount;
        ManufactureOrderStockCollection stockCol;
        String msg = null;
        HashMap crossOrgMap = new HashMap();
        HashSet<String> crossOrgSet = new HashSet<String>();
        MaterialInfo materialInfo = mo.getMaterial();
        StorageOrgUnitInfo stor = mo.getStorageOrgUnit();
        String materialID = materialInfo.getId().toString();
        String storageOrgUnitID = stor.getId().toString();
        String mapKey = storageOrgUnitID + "&" + materialID;
        String id = null;
        id = mo.getId() == null ? "NEWID" : mo.getId().toString();
        boolean isRootSuccess = true;
        if (mo.getRouting() == null && (mo.getTechnics() == null || mo.getTechnics().size() < 1)) {
            isRootSuccess = MORootingUtil.autoGenDefaultRooting(ctx, mo, true);
        }
        if (mo.getTechnics() == null || mo.getTechnics().size() < 1) {
            isRootSuccess = false;
        } else {
            MORootingUtil.setOprNo4Entry(mo);
        }
        boolean isStocksEmpty = false;
        if (MOBirthTypeEnum.SPLIT != mo.getBirthType() && MOBirthTypeEnum.REFORM != mo.getBirthType() && (mo.getStocks() == null || mo.getStocks().size() < 1)) {
            isStocksEmpty = true;
        }
        if (batchResults.isToDo(id) && !isRootSuccess) {
            msg = MoRefactUtils.getString(ctx, "Technics_IsNotNull");
            batchResults.addError(id, msg);
        } else if (batchResults.isToDo(id) && isStocksEmpty) {
            msg = MoRefactUtils.getString(ctx, "Stock_IsNotNull");
            batchResults.addError(id, msg);
        } else if (batchResults.isToDo(id)) {
            ManufactureOrderTechnicsCollection tecCol = mo.getTechnics();
            MMCommonUtils.objectValueSort((IObjectCollection)tecCol, (boolean)true, (String)"operationNo");
            ProductTransactionTypeInfo transType = mo.getTransactionType();
            AdminOrgUnitInfo adInfo = mo.getAdminOrgUnit();
            boolean adorgInTechadsFlag = false;
            String cheAdminInTEOrg = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"CheAdminIsInTecEntryOrg");
            boolean cheAdminInTEOrgFlag = Boolean.valueOf(cheAdminInTEOrg);
            boolean entryAdmOrgNullFlag = false;
            for (int j = 0; j < tecCol.size(); ++j) {
                ManufactureOrderTechnicsInfo entry = tecCol.get(j);
                if (entry.getEntrustType() != null && entry.getEntrustType().equals((Object)CSEntrustTypeEnum.INNERCOOPERATE)) {
                    if (j > 0 && !mo.getTechnics().get(j - 1).isIsReportPoint()) {
                        msg = MoRefactUtils.getString(ctx, "OUTWP_LAS_OR_NEXT_ISNOT_REPORPOINT");
                        batchResults.addError(id, msg);
                    }
                    if (j < mo.getTechnics().size() - 1 && !mo.getTechnics().get(j + 1).isIsReportPoint()) {
                        msg = MoRefactUtils.getString(ctx, "OUTWP_LAS_OR_NEXT_ISNOT_REPORPOINT");
                        batchResults.addError(id, msg);
                    }
                }
                if (transType != null && transType.isIsWPManagement()) {
                    if (entry.getWorkcenter() == null) {
                        msg = MoRefactUtils.getString(ctx, "WORKCENTER");
                        batchResults.addError(id, msg);
                    }
                    if (entry.getEntrustType() != null && entry.getEntrustType().equals((Object)CSEntrustTypeEnum.OPERATIONENTRUST) && !entry.isIsReportPoint()) {
                        msg = MoRefactUtils.getString(ctx, "OUTWP_ISNOT_REPORPOINT");
                        batchResults.addError(id, msg);
                    }
                }
                if (transType != null && EqualsUtil.equals((IntEnum)transType.getWPControlStrategy(), (IntEnum)WPControlStrategyEnum.ORDER_CON_STRATEGY) && entry.getControlStrategy() == null) {
                    msg = MoRefactUtils.getString(ctx, "CONTROLSTRATEGY_IS_NULL");
                    batchResults.addError(id, msg);
                }
                if (!entryAdmOrgNullFlag && entry.getAdminOrgUnit() == null) {
                    entryAdmOrgNullFlag = true;
                }
                if (!cheAdminInTEOrgFlag || adorgInTechadsFlag || adInfo == null || entry.getAdminOrgUnit() == null || !adInfo.getId().toString().equals(entry.getAdminOrgUnit().getId().toString())) continue;
                adorgInTechadsFlag = true;
            }
            if (entryAdmOrgNullFlag) {
                msg = MoRefactUtils.getString(ctx, "TECH_ADMIN_ORG_MUST_NOT_NULL");
                batchResults.addError(id, msg);
            }
            if (cheAdminInTEOrgFlag && !adorgInTechadsFlag) {
                msg = MoRefactUtils.getString(ctx, "AdOrgInTechAds");
                batchResults.addError(id, msg);
            }
        }
        if (batchResults.isToDo(id)) {
            stockCol = mo.getStocks();
            BizTypeInfo bizType = mo.getBizType();
            for (int j = 0; j < stockCol.size(); ++j) {
                Integer seq;
                ManufactureOrderStockInfo entry = stockCol.get(j);
                if ("vGXRx5fFSsCYz9Zv7CzzgyQHQ1w=".equalsIgnoreCase(bizType.getId().toString()) && materialID.equals(entry.getMaterial().getId().toString())) {
                    seq = new Integer(entry.getSeq());
                    batchResults.addError(id, MoRefactUtils.getMessage(ctx, "STOCKERROR", new String[]{seq.toString()}));
                }
                if (!entry.getMaterial().isUseAsstAttrRelation() || !entry.isIsBackflush()) continue;
                seq = new Integer(entry.getSeq());
                batchResults.addError(id, MoRefactUtils.getMessage(ctx, "REFUSEBACKFLUSH", new String[]{seq.toString()}));
            }
        }
        if (batchResults.isToDo(id)) {
            stockCol = mo.getStocks();
            for (int j = 0; j < stockCol.size(); ++j) {
                List<String> seqList;
                ManufactureOrderStockInfo entry = stockCol.get(j);
                if (entry.getProvideType() != MaterialProvideTypeEnum.SPANORGPROVIDE && entry.getProvideType() != MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE) continue;
                String keyID = entry.getMaterial().getId().toString() + "_" + entry.getStorageOrgUnit().getId().toString();
                if (crossOrgMap.containsKey(keyID)) {
                    seqList = (List)crossOrgMap.get(keyID);
                    seqList.add(String.valueOf(entry.getProvideType().getValue()));
                } else {
                    seqList = new ArrayList();
                    seqList.add(String.valueOf(entry.getProvideType().getValue()));
                    crossOrgMap.put(keyID, seqList);
                }
                if (crossOrgSet.contains(keyID)) continue;
                crossOrgSet.add(keyID);
            }
        }
        if (batchResults.isToDo(id) && (rowCount = (outCol = mo.getExpectOutputs()).size()) > 1) {
            HashSet<String> opMaterial = new HashSet<String>();
            ManufactureOrderExpectOutputInfo outInfo = null;
            for (int j = 0; j < rowCount; ++j) {
                outInfo = outCol.get(j);
                String outKey = outInfo.getOperationNo() + "-" + outInfo.getMaterial().getId().toString();
                if (opMaterial.contains(outKey)) {
                    msg = MoRefactUtils.getString(ctx, "OUTPUT_MATERIAL_DUP");
                    batchResults.addError(id, msg);
                    break;
                }
                opMaterial.add(outKey);
            }
        }
        if (mMap != null && mMap.get(mapKey) != null) {
            int isConfig;
            List lst = (List)mMap.get(mapKey);
            int n = isConfig = lst.get(0) != null ? (Integer)lst.get(0) : 0;
            if (isConfig == 1 && mo.getProject() == null && mo.getTrackNumber() == null) {
                msg = MoRefactUtils.getMessage(ctx, "PROJECT_TRACKNUM_NOT_NULL", new String[]{lst.get(2) != null ? (String)lst.get(2) : ""});
                batchResults.addError(id, msg);
            }
            if ((mo.getSourceBillType() != null && !"9XXvbVGlRtym/0qtqeIXXrhE1B8=".equals(mo.getSourceBillType().getId().toString()) || mo.getSourceBillType() == null) && lst.get(1) != null) {
                String strategy = (String)lst.get(1);
                String strategyNumber = (String)lst.get(2);
                String materialName = (String)lst.get(3);
                String isolatedRule = (String)lst.get(4);
                if (strategy.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || strategy.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                    if (isolatedRule.equals("ITEM") && mo.getProject() == null) {
                        msg = MoRefactUtils.getMessage(ctx, "ETO_PROJECT_NOT_NULL", new String[]{materialName, strategyNumber});
                        batchResults.addError(id, msg);
                    } else if (isolatedRule.equals("ITEM_TRACKNO")) {
                        if (mo.getProject() == null) {
                            msg = MoRefactUtils.getMessage(ctx, "ETO_PROJECT_NOT_NULL", new String[]{materialName, strategyNumber});
                            batchResults.addError(id, msg);
                        }
                        if (mo.getTrackNumber() == null) {
                            msg = MoRefactUtils.getMessage(ctx, "MTO_TRACKNUMBER_NOT_NULL", new String[]{materialName, strategyNumber});
                            batchResults.addError(id, msg);
                        }
                    }
                } else if ((strategy.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategy.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategy.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategy.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) && mo.getTrackNumber() == null) {
                    msg = MoRefactUtils.getMessage(ctx, "MTO_TRACKNUMBER_NOT_NULL", new String[]{materialName, strategyNumber});
                    batchResults.addError(id, msg);
                }
            }
        }
        if (batchResults.isToDo(id)) {
            ScheduleTypeEnum scheduleType = mo.getScheduleType();
            if (scheduleType != null && scheduleType.getValue() != 10) {
                boolean hasCalendar;
                boolean isSupplyClassTerm = MoRefactUtils.isSupplyClassTerm(ctx, mo);
                if (!isSupplyClassTerm) {
                    msg = MoRefactUtils.getString(ctx, "Not_SupplyClassTerm");
                    batchResults.addError(id, msg);
                }
                if (!(hasCalendar = MoRefactUtils.hasProjectCalendar(ctx, mo.getStorageOrgUnit().getId().toString()))) {
                    msg = MoRefactUtils.getString(ctx, "Not_FACTORYCALENDAR");
                    batchResults.addError(id, msg);
                }
            }
            Set outSet = MMUtils.getCrossOrgMaterialSupplyOrgSet((Context)ctx, crossOrgSet);
            for (String materialOrg : outSet) {
                String[] array = materialOrg.split("_");
                String sqlMaterialName = "select fname_" + MoRefactUtils.getLocale() + " as name from T_BD_Material where fid='" + array[0] + "'";
                String sqlOrgName = "select fname_" + MoRefactUtils.getLocale() + " as name from T_ORG_Storage where fid='" + array[1] + "'";
                String materialName = "";
                String orgName = "";
                IRowSet rs_m = DbUtil.executeQuery((Context)ctx, (String)sqlMaterialName);
                IRowSet rs_o = DbUtil.executeQuery((Context)ctx, (String)sqlOrgName);
                try {
                    while (rs_m != null && rs_m.next()) {
                        materialName = rs_m.getString("name");
                    }
                    while (rs_o != null && rs_o.next()) {
                        orgName = rs_o.getString("name");
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                List tmpList = (List)crossOrgMap.get(materialOrg);
                for (int k = 0; k < tmpList.size(); ++k) {
                    String provideTypeName = MaterialProvideTypeEnum.getEnum((int)Integer.parseInt(tmpList.get(k).toString())).getAlias();
                    String msgInfo = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"MID_AUDIT_CHECK", (String[])new String[]{provideTypeName, materialName, orgName});
                    batchResults.addError(id, msgInfo);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isSupplyClassTerm(Context ctx, ManufactureOrderInfo mo) throws BOSException, EASBizException {
        HashMap<String, String> classTermMap = new HashMap<String, String>();
        ManufactureOrderTechnicsCollection technicsCol = mo.getTechnics();
        ManufactureOrderTechnicsInfo info = null;
        HashSet<String> workCenterIds = new HashSet<String>();
        int n = technicsCol.size();
        for (int i = 0; i < n; ++i) {
            info = technicsCol.get(i);
            if (info.getWorkcenter() == null) return false;
            if (info.getWorkcenter().getId() == null) {
                return false;
            }
            workCenterIds.add(info.getWorkcenter().getId().toString());
        }
        StringBuffer sqlSB = new StringBuffer("");
        sqlSB.setLength(0);
        sqlSB.append(" select t1.fid,t1.FClassTeamID from T_MM_WorkCenter t1 ").append(" where t1.fid in ( ").append(SQLUtil.arrayToString((Object[])workCenterIds.toArray())).append(")");
        ArrayList paramLst = new ArrayList();
        paramLst.clear();
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
        try {
            while (rs.next()) {
                if (rs.getString("FClassTeamID") == null) return false;
                if (rs.getString("FClassTeamID").length() == 0) {
                    return false;
                }
                classTermMap.put(rs.getString("fid"), rs.getString("FClassTeamID"));
            }
        }
        catch (SQLException sqlExp) {
            throw new SQLDataException(sqlExp);
        }
        int i = 0;
        int n2 = technicsCol.size();
        while (i < n2) {
            info = technicsCol.get(i);
            if (!classTermMap.containsKey(info.getWorkcenter().getId().toString())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getMessage(Context ctx, String key, String[] parameters) {
        String message = MoRefactUtils.getString(ctx, key);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parameters.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), parameters[i]);
        }
        return message;
    }

    private static Locale getLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            return new Locale("L2");
        }
    }

    public static boolean hasProjectCalendar(Context ctx, String storageOrgID) throws BOSException, EASBizException {
        String sql = "select FID from T_MM_FactoryCalendar where FStorageOrgUnitID = '" + storageOrgID + "' and FIsDefault=1";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (set.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static void updateCostObject(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        HashSet orderSet = (HashSet)batchResults.getToDoIdsSet();
        MOCostObjectUtil.updateCostObject(ctx, orderSet);
        MOCostObjectUtil.updateOutputCostObject(ctx, orderSet);
    }

    public static void manualFinishBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        List ids = batchResults.getToDoIdsList();
        if (ids != null && ids.size() > 0) {
            for (int i = 0; i < ids.size(); ++i) {
                String moid = null;
                String msg = null;
                moid = ids.toArray()[i].toString();
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add(new SelectorItemInfo("transactionType.isWPManagement"));
                selectorItemCollection.add(new SelectorItemInfo("id"));
                IManufactureOrder order = ManufactureOrderFactory.getLocalInstance(ctx);
                ManufactureOrderInfo moInfo = (ManufactureOrderInfo)order.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)moid)), selectorItemCollection);
                if (moInfo.getTransactionType().isIsWPManagement()) continue;
                msg = MoRefactUtils.getString(ctx, "MO_NOTWPMANAGE_CANNOTFINISH");
                batchResults.addError(moid, msg);
            }
        }
    }

    public static void updateStock(ManufactureOrderInfo moInfo) {
        if (moInfo == null || moInfo.getStocks() == null || moInfo.getStocks().size() <= 0) {
            return;
        }
        int stockCnt = moInfo.getStocks().size();
        for (int curStockIdx = 0; curStockIdx < stockCnt; ++curStockIdx) {
            CSEntrustTypeEnum entrustType;
            ManufactureOrderStockInfo curStockInfo = moInfo.getStocks().get(curStockIdx);
            curStockInfo.setPickDept(MOStockUtil.getDefaultPickDept(moInfo, curStockInfo));
            if (!curStockInfo.isIsBackflush()) continue;
            ManufactureOrderTechnicsInfo techInfo = MOStockUtil.getOwnedTechnicsInfo(moInfo, curStockInfo);
            CSEntrustTypeEnum cSEntrustTypeEnum = entrustType = techInfo == null ? CSEntrustTypeEnum.NONE : techInfo.getEntrustType();
            if (!CSEntrustTypeEnum.OPERATIONENTRUST.equals((Object)entrustType) && !CSEntrustTypeEnum.INNERCOOPERATE.equals((Object)entrustType)) continue;
            curStockInfo.setIsBackflush(false);
        }
    }

    public static void afterSubmit(Context ctx, String[] idarray) throws BOSException, EASBizException {
        int iner = 0;
        int allCnt = 0;
        StringBuffer sbf = new StringBuffer();
        for (int i = 0; i < idarray.length; ++i) {
            ++allCnt;
            if (++iner == 1) {
                sbf.append("'").append(idarray[i]).append("'");
            } else {
                sbf.append(",'").append(idarray[i]).append("'");
            }
            if ((i != 300 || allCnt >= idarray.length) && allCnt != idarray.length) continue;
            String[] sqls = new String[5];
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update T_MM_ManufactureOrder as t0  ").append("set (FFirstOperNo,FLastOperNo) = ").append("(select firstOp,lastOp from ").append("(select t1.FParentID,min(FOperationNo) firstOp,max(FOperationNo) lastOp ").append("from T_MM_MFTOrderTechnics t1 ").append("where t1.FParentID in (").append(sbf.toString()).append(") ").append("group by t1.FParentID) t2 ").append("where t0.FID = t2.FParentID )");
            updateSql.append(" where  t0.FID in (").append(sbf.toString()).append(")").append(" and isnull(t0.fbirthtype, 0) = ").append(0);
            sqls[0] = updateSql.toString();
            updateSql.setLength(0);
            updateSql.append("update T_MM_ManufactureOrder as t0  ").append("set (FLackLowerLimitBase,FExtraUpperLimitBase,FDeliveryBaseQty ,FunRepairBaseQty) = ").append("(select round(decimal(t0.FLackLowerLimit * t1.FBaseConvsRate,21,8),t2.FQtyPrecision),").append("round(decimal(t0.FExtraUpperLimit * t1.FBaseConvsRate,21,8),t2.FQtyPrecision), ").append("round(decimal(t0.FDeliveryQty * t1.FBaseConvsRate,21,8),t2.FQtyPrecision), ").append("round(decimal(t0.FunRepairQty * t1.FBaseConvsRate,21,8),t2.FQtyPrecision)").append("from t_bd_multimeasureunit t1,t_bd_multimeasureunit t2 ").append("where t0.FMaterialID = t1.FMaterialID and t0.FUnitID = t1.fmeasureunitid ").append("and t0.FMaterialID = t2.FMaterialID and t0.FBaseUnitID = t2.fmeasureunitid) ");
            updateSql.append(" where t0.fid in(").append(sbf.toString()).append(")");
            sqls[1] = updateSql.toString();
            updateSql.setLength(0);
            updateSql.append("update T_MM_MFTOrderTechnics as t0  ").append("set (FBaseQty) = ").append("(select t1.FBaseQty ").append("from T_MM_ManufactureOrder t1 ").append("where t0.FParentID = t1.FID) ");
            updateSql.append("where exists(select 1 from T_MM_ManufactureOrder T1 WHERE t0.FParentID = t1.FID AND t1.FID IN (").append(sbf.toString()).append("))");
            sqls[2] = updateSql.toString();
            updateSql.setLength(0);
            updateSql.append("update T_MM_MFTOrderStock as t0  ").append("set (FBaseQty,FUnitbaseQty,FLossBaseQty,FPlannedBaseQty,FOriginalPlanBaseQty,FUnReceiptBaseQty,FTotalReceiptBaseQty,FPickExtraBaseQty,FPickLackBaseQty) = ").append("(select round(decimal(t0.FQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision),").append("round(decimal(t0.FUnitQty * t2.FBaseConvsRate,21,8),8), ").append("round(decimal(t0.FLossQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FPlannedQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FOriginalPlanQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FUnReceiptQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FTotalReceiptQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FPickExtraQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FPickLackQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision) ").append("from t_bd_multimeasureunit t2 , T_MM_ManufactureOrder t1 ,t_bd_multimeasureunit t3 ").append("where t0.FParentID = t1.FID ").append("and t0.FMaterialID = t2.FMaterialID and t0.FUnitID = t2.fmeasureunitid ").append(" and t0.FMaterialID = t3.FMaterialID and t0.FBaseUnitID = t3.fmeasureunitid ").append("and t1.FID in (").append(sbf.toString()).append(") ").append(")");
            updateSql.append(" where exists(select 1 from t_mm_manufactureorder t1 where t0.fparentid = t1.fid AND t1.FID IN (").append(sbf.toString()).append("))");
            sqls[3] = updateSql.toString();
            updateSql.setLength(0);
            updateSql.append("update T_MM_MFTOrderStock as t0  ").append("set (FWorkcenterID,FOperationID) = ").append("(select FWorkcenterID,FOperationID ").append("from T_MM_MFTOrderTechnics t1 ").append(" where t0.FOperationNo = t1.FOperationNo and t1.fparentid=t0.fparentid").append(")").append("where t0.FParentID in (").append(sbf.toString()).append(") ");
            sqls[4] = updateSql.toString();
            try {
                SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
            }
            catch (BOSException bosException) {
                Throwable throwable = bosException.getCause();
                if (throwable instanceof SQLException) {
                    String sqlState = ((SQLException)throwable).getSQLState();
                    String message = ((SQLException)throwable).getMessage();
                    if (sqlState != null && sqlState.equalsIgnoreCase("22003")) {
                        throw new ManufactureOrderException(ManufactureOrderException.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    if (message != null && message.toLowerCase().indexOf("numeric") > -1) {
                        throw new ManufactureOrderException(ManufactureOrderException.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                }
                throw bosException;
            }
            iner = 1;
            sbf.setLength(0);
        }
    }

    public static void afterAudit(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        MoRefactUtils.updateCostObject(ctx, batchResults);
        String[] sqls = new String[6];
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_ManufactureOrder ").append("set FUnToStoreQty =  FExtraUpperLimit-FToStroreQty,FUnToStoreBaseQty = FExtraUpperLimitBase-FToStoreBaseQty ").append("where FID in (").append(idStr).append(") ").append("and FIsLimitedQty=1 ");
        sqls[0] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_ManufactureOrder ").append("set FUnToStoreQty = FQty-FTotalSplitQty-FToStroreQty,FUnToStoreBaseQty = FBaseQty-FTotalSplitBaseQty-FToStoreBaseQty ").append("where FID in (").append(idStr).append(") ").append("and FIsLimitedQty=0 ");
        sqls[1] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_ManufactureOrder ").append("set FUnRepairQty = FQty-FTotalSplitQty-FRepairQty,FUnRepairBaseQty = FBaseQty-FTotalSplitBaseQty-FRepairBaseQty ").append("where FID in (").append(idStr).append(") ");
        sqls[2] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderStock as t0 ").append("set (FUnReceiptQty,FUnReceiptBaseQty,FUnIssueQty,FUnIssueBaseQty,FAssociateQty) = ").append("(select t0.FPlannedQty-t0.FTotalReceiptQty,t0.FPlannedBaseQty-t0.FTotalReceiptBaseQty,t0.FPlannedQty-t0.FActIssueQty+t0.FRejectedQty,t0.FPlannedBaseQty-t0.FActIssueBaseQty+t0.FRejectedBaseQty,").append(" case when t0.FIsQtyLimit=1 then ").append("round(to_decimal(t0.FPickExtraBaseQty,21,8),b1.FQtyPrecision)-t0.FActIssueBaseQty+t0.FRejectedBaseQty ").append(" else t0.FPlannedBaseQty-t0.FActIssueBaseQty+t0.FRejectedBaseQty ").append(" end ").append("from t_bd_multimeasureunit  b1 ").append("where t0.FMaterialID = b1.FMaterialID and t0.FBaseUnitID = b1.fmeasureunitid) ").append(" where t0.FParentID in (").append(idStr).append(") ");
        sqls[3] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderTechnics as t0  ").append("set (FUnFinishQty,FUnFinishBaseQty,FUnMoveOutQty,FUnMoveOutBaseQty,FUnTestQty,FUnTestBaseQty,FUnDispatchQty,FUnDispatchBaseQty) = ").append("(select t0.FQty  - t0.FFinishedQty , t0.FBaseQty - t0.FFinishedBaseQty ,t0.FQty,t0.FBaseQty,t0.FQty,t0.FBaseQty,").append("t0.FQTY - t0.FTotalSplitQty - t0.FTotalDispatchQty,").append("round(decimal((t0.FQTY - t0.FTotalSplitQty - t0.FTotalDispatchQty) * t2.FBaseConvsRate,21,8),t3.FQtyPrecision)").append(" from t_bd_multimeasureunit t2 , T_MM_ManufactureOrder t1 ,t_bd_multimeasureunit t3 ").append("where t0.FParentID = t1.FID ").append(" and t1.FMaterialID = t2.FMaterialID and t1.FUnitID = t2.fmeasureunitid ").append(" and t1.FMaterialID = t3.FMaterialID and t1.FBaseUnitID = t3.fmeasureunitid ").append("and t1.FID in (").append(idStr).append(") ").append(")");
        sqls[4] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderTechnics as t0  ").append("set (FIntoQty,FIntoBaseQty) = ").append("(select t0.FQty,t0.FBaseQty ").append("from T_MM_ManufactureOrder t1 ").append("where t1.FFirstOperNo = t0.FOperationNo ").append("and t1.FID = t0.FParentID ").append("and t1.FID in (").append(idStr).append(") ").append(") ");
        sqls[5] = updateSql.toString();
        try {
            SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        }
        catch (BOSException bosException) {
            Throwable throwable = bosException.getCause();
            if (throwable instanceof SQLException) {
                String sqlState = ((SQLException)throwable).getSQLState();
                String message = ((SQLException)throwable).getMessage();
                if (sqlState != null && sqlState.equalsIgnoreCase("22003")) {
                    throw new ManufactureOrderException(ManufactureOrderException.NUMERIC_VALUE_OUT_OF_RANGE);
                }
                if (message != null && message.toLowerCase().indexOf("numeric") > -1) {
                    throw new ManufactureOrderException(ManufactureOrderException.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
            throw bosException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void afterAuditWriteBackWBS(Context ctx, BatchActionResults batchResults, int bizAction) throws BOSException, EASBizException {
        StringBuffer tempTableSql = new StringBuffer();
        tempTableSql.append("CREATE TABLE TEMP_WRITEBACKWBS (").append("FBizDate DATETIME,").append("FPROJECTID VARCHAR(44),").append("FMaterialID VARCHAR(44),").append("FTrackNumberID VARCHAR(44),").append("FStorageOrgUnitID VARCHAR(44) )");
        String tempTableName = "";
        try {
            try {
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(tempTableSql.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("INSERT INTO ").append(tempTableName).append(" (FBizDate,FPROJECTID,FMaterialID,FTrackNumberID,FStorageOrgUnitID) ").append(" SELECT FAUDITTIME FBizDate,FProjectID,FMaterialID,FTrackID,FStorageOrgUnitID FROM T_MM_ManufactureOrder M ").append(" WHERE EXISTS(").append(" SELECT 1 fROM T_MM_ManufactureOrder M1 ").append(" WHERE M.FProjectID=M1.FProjectID AND M.FMaterialID=M1.FMaterialID AND M.FStorageOrgUnitID=M1.FStorageOrgUnitID ").append(" AND (M.FTrackID is null and M1.FTrackID is null or M.FTrackID=M1.FTrackID ) ").append(" AND M1.FID IN (").append(idStr).append(" )").append(" AND M.FBaseStatus=").append(4).append(" )");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            WriteBackWBSFacadeControllerBean wbsFacade = new WriteBackWBSFacadeControllerBean();
            wbsFacade.batchWriteBackByDate(ctx, tempTableName, bizAction, WBSTypeEnum.MANUFACTURE);
        }
        finally {
            if (tempTableName != null) {
                TempTablePool pool = TempTablePool.getInstance((Context)ctx);
                pool.releaseTable(tempTableName);
            }
        }
    }

    public static void getExpectOutput(Context ctx, Map inParam, Map retData) throws EASBizException, BOSException {
        ManufactureOrderExpectOutputCollection expectOutputs = new ManufactureOrderExpectOutputCollection();
        retData.put("EXPECTOUTPUTS", expectOutputs);
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)inParam.get("STORAGEORG");
        MaterialInfo moMaterialInfo = (MaterialInfo)inParam.get("MATERIAL");
        BomInfo bomInfo = (BomInfo)inParam.get("BOM");
        if (bomInfo == null) {
            return;
        }
        String bomID = bomInfo.getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("unit.*"));
        sic.add(new SelectorItemInfo("baseUnit.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("materialPlan.*"));
        sic.add(new SelectorItemInfo("entrys.material.*"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.*"));
        sic.add(new SelectorItemInfo("entrys.unit.*"));
        sic.add(new SelectorItemInfo("entrys.materialInventory.*"));
        sic.add(new SelectorItemInfo("entrys.defaultWarehouse.*"));
        bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectStringPK(bomID), sic);
        Timestamp moBeginDate = (Timestamp)inParam.get("BEGINTIME");
        Timestamp moEndDate = (Timestamp)inParam.get("ENDTIME");
        MeasureUnitInfo moBaseUnit = (MeasureUnitInfo)inParam.get("BASEUNIT");
        MeasureUnitInfo moUnit = (MeasureUnitInfo)inParam.get("BILL_UNIT");
        BigDecimal moQty = (BigDecimal)inParam.get("BILL_QTY");
        BigDecimal moSplitQty = (BigDecimal)inParam.get("SPLIT_QTY");
        if (moSplitQty == null) {
            moSplitQty = SysConstant.BIGZERO;
        }
        String lotNumber = (String)inParam.get("LOTNUMBER");
        ManufactureOrderTechnicsCollection technicsCol = (ManufactureOrderTechnicsCollection)((Object)retData.get("TECHNICS"));
        int lastOperNo = 0;
        OperationInfo lastOperationInfo = null;
        if (technicsCol != null && technicsCol.size() > 0) {
            MMCommonUtils.objectValueSort((IObjectCollection)technicsCol, (boolean)true, (String)"operationNo");
            ManufactureOrderTechnicsInfo maxTechnicInfo = technicsCol.get(technicsCol.size() - 1);
            lastOperationInfo = maxTechnicInfo.getOperation();
            lastOperNo = maxTechnicInfo.getOperationNo();
        }
        IRowSet rowSet = ManufactureOrderFactory.getLocalInstance(ctx).getWpSeq(inParam);
        HashMap<String, Object[]> pBomMap = new HashMap<String, Object[]>();
        try {
            while (rowSet != null && rowSet.next()) {
                String bomItemID = rowSet.getString("FBomItemID");
                Integer wpSeq = new Integer(rowSet.getInt("FWpSeq"));
                String operationID = rowSet.getString("FOperationID");
                OperationInfo operationInfo = OperationFactory.getLocalInstance((Context)ctx).getOperationInfo((IObjectPK)new ObjectStringPK(operationID));
                pBomMap.put(bomItemID, new Object[]{wpSeq, operationInfo});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        BigDecimal orderBaseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)moMaterialInfo.getId().toString(), (MeasureUnitInfo)moUnit, (MeasureUnitInfo)moBaseUnit, (BigDecimal)moQty.subtract(moSplitQty));
        BigDecimal productBaseQty = bomInfo.getProductBaseQty();
        BomEntryCollection bomEntrys = bomInfo.getEntrys();
        for (BomEntryInfo bomEntryInfo : bomEntrys) {
            MaterialPlanInfo materialInventory;
            String bomEntryId = bomEntryInfo.getId().toString();
            Integer operationNo = null;
            OperationInfo opInfo = null;
            if (pBomMap.get(bomEntryId) != null) {
                Object[] opo = (Object[])pBomMap.get(bomEntryId);
                operationNo = (Integer)opo[0];
                opInfo = (OperationInfo)opo[1];
            }
            MaterialScrapRateExpressionEnum scrapRateExpression = (materialInventory = bomEntryInfo.getMaterialInventory()) == null ? null : materialInventory.getScrapRateExpression();
            ConsumeTypeEnum consumeType = bomEntryInfo.getConsumeType();
            BigDecimal consumeFixBaseQty = bomEntryInfo.getConsumeFixBaseQty();
            BigDecimal baseProportion = bomEntryInfo.getBaseProportion();
            BigDecimal scrapRatio = bomEntryInfo.getScrapRatio();
            Date effectiveDate = bomEntryInfo.getEffectiveDate();
            Date disableDate = bomEntryInfo.getDisableDate();
            BigDecimal bomCoefficient = bomInfo.getBaseUnit().getCoefficient();
            BigDecimal bomEntryCoefficient = bomEntryInfo.getBaseUnit().getCoefficient();
            BigDecimal baseExchangeRate = bomCoefficient.divide(bomEntryCoefficient, 8, 4);
            if (moEndDate == null || effectiveDate == null || moBeginDate == null || disableDate == null || moEndDate == null || moEndDate.before(effectiveDate) || moBeginDate.after(disableDate) || DateTimeUtils.dayEquals((Date)moBeginDate, (Date)disableDate) || !MaterialProductEnum.RELATEDPRODUCT.equals((Object)bomEntryInfo.getOutputType()) && !MaterialProductEnum.BYPRODUCT.equals((Object)bomEntryInfo.getOutputType())) continue;
            MaterialInfo expMaterial = bomEntryInfo.getMaterial();
            ManufactureOrderExpectOutputInfo outputInfo = new ManufactureOrderExpectOutputInfo();
            outputInfo.setMaterial(expMaterial);
            outputInfo.setOutputType(bomEntryInfo.getOutputType());
            outputInfo.setOperationNo(operationNo == null ? lastOperNo : operationNo);
            outputInfo.setOperation(opInfo == null ? lastOperationInfo : opInfo);
            outputInfo.setUnit(bomEntryInfo.getUnit());
            outputInfo.setBaseUnit(bomEntryInfo.getBaseUnit());
            BigDecimal tempQty = MoRefactUtils.getExpectOutputQty(ctx, orderBaseQty, scrapRateExpression, productBaseQty, consumeType, consumeFixBaseQty, baseProportion, scrapRatio);
            outputInfo.setBaseQty(tempQty.divide(baseExchangeRate, 8, 4).multiply(baseExchangeRate));
            outputInfo.setQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)outputInfo.getMaterial().getId().toString(), (MeasureUnitInfo)outputInfo.getBaseUnit(), (MeasureUnitInfo)outputInfo.getUnit(), (BigDecimal)outputInfo.getBaseQty()));
            outputInfo.setAssistUnit(expMaterial.getAssistUnit());
            outputInfo.setAssistQty(MoRefactUtils.getAssistUnitQty(ctx, outputInfo.getMaterial(), outputInfo.getUnit(), outputInfo.getQty(), outputInfo.getAssistUnit()));
            outputInfo.setFinishedQty(SysConstant.BIGZERO);
            outputInfo.setPassQty(SysConstant.BIGZERO);
            outputInfo.setScrapQty(SysConstant.BIGZERO);
            outputInfo.setToStoreQty(SysConstant.BIGZERO);
            outputInfo.setDefaultWarehous(bomEntryInfo.getDefaultWarehouse());
            outputInfo.setCostObect(MOCostObjectUtil.getCostObject(ctx, outputInfo.getMaterial(), storageOrgUnitInfo, null, null, false, false));
            outputInfo.setRemark(outputInfo.getRemark());
            if (MoRefactUtils.getIsIsLotNumber(ctx, expMaterial, storageOrgUnitInfo)) {
                outputInfo.setLot(lotNumber);
            } else {
                outputInfo.setLot(null);
            }
            expectOutputs.add(outputInfo);
        }
        retData.put("EXPECTOUTPUTS", expectOutputs);
    }

    public static ManufactureOrderStockCollection getDistinctStocks(ManufactureOrderStockCollection stocks) {
        ManufactureOrderStockCollection newStocks = new ManufactureOrderStockCollection();
        HashMap<String, ManufactureOrderStockInfo> stocksMap = new HashMap<String, ManufactureOrderStockInfo>();
        ManufactureOrderStockInfo stockInfo = null;
        String key2 = null;
        Iterator iter = stocks.iterator();
        while (iter.hasNext()) {
            stockInfo = (ManufactureOrderStockInfo)iter.next();
            key2 = MoRefactUtils.getRecKeyString((IObjectValue)stockInfo);
            if (stocksMap.containsKey(key2)) {
                ManufactureOrderStockInfo existStockInfo = (ManufactureOrderStockInfo)stocksMap.get(key2);
                existStockInfo.setUnitBaseQty(existStockInfo.getUnitBaseQty().add(stockInfo.getUnitBaseQty()));
                existStockInfo.setUnitQty(existStockInfo.getUnitQty().add(stockInfo.getUnitQty()));
                existStockInfo.setBaseQty(existStockInfo.getBaseQty().add(stockInfo.getBaseQty()));
                existStockInfo.setQty(existStockInfo.getQty().add(stockInfo.getQty()));
                existStockInfo.setPlannedBaseQty(existStockInfo.getPlannedBaseQty().add(stockInfo.getPlannedBaseQty()));
                existStockInfo.setPlannedQty(existStockInfo.getPlannedQty().add(stockInfo.getPlannedQty()));
                existStockInfo.setLossBaseQty(existStockInfo.getLossBaseQty().add(stockInfo.getLossBaseQty()));
                existStockInfo.setLossQty(existStockInfo.getLossQty().add(stockInfo.getLossQty()));
                existStockInfo.setPickExtraBaseQty(existStockInfo.getPickExtraBaseQty().add(stockInfo.getPickExtraBaseQty()));
                existStockInfo.setPickExtraQty(existStockInfo.getPickExtraQty().add(stockInfo.getPickExtraQty()));
                existStockInfo.setPickLackBaseQty(existStockInfo.getPickLackBaseQty().add(stockInfo.getPickLackBaseQty()));
                existStockInfo.setPickLackQty(existStockInfo.getPickLackQty().add(stockInfo.getPickLackQty()));
                continue;
            }
            stocksMap.put(key2, stockInfo);
        }
        for (String key2 : stocksMap.keySet()) {
            newStocks.add((ManufactureOrderStockInfo)stocksMap.get(key2));
        }
        return newStocks;
    }

    public static String getRecKeyString(IObjectValue model) {
        String recKey = "";
        MaterialInfo materialInfo = (MaterialInfo)model.get("material");
        int operationNo = model.getInt("operationNo");
        recKey = materialInfo != null ? materialInfo.getId().toString() : "MATERIAL_NULL";
        recKey = recKey + "!";
        recKey = recKey + operationNo;
        return recKey;
    }

    private static BigDecimal getExpectOutputQty(Context ctx, BigDecimal orderBaseQty, MaterialScrapRateExpressionEnum scrapRateExpression, BigDecimal productBaseQty, ConsumeTypeEnum consumeType, BigDecimal consumeFixBaseQty, BigDecimal baseProportion, BigDecimal scrapRatio) throws EASBizException, BOSException {
        BigDecimal outputBaseQty = SysConstant.BIGZERO;
        BigDecimal ONE = new BigDecimal("1.0");
        BigDecimal PERCENT = new BigDecimal("100.0");
        int PREC = 8;
        BigDecimal byDivide = ONE.subtract(scrapRatio.divide(PERCENT, PREC, 4));
        BigDecimal byMutiple = ONE.add(scrapRatio.divide(PERCENT, PREC, 4));
        baseProportion = baseProportion.divide(PERCENT, PREC, 4);
        if (consumeType.equals((Object)ConsumeTypeEnum.VariableAmount)) {
            if (scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                if (!productBaseQty.equals(SysConstant.BIGZERO) && !byDivide.equals(SysConstant.BIGZERO)) {
                    outputBaseQty = orderBaseQty.divide(productBaseQty, PREC, 4).multiply(consumeFixBaseQty).divide(byDivide, PREC, 4);
                }
            } else if (scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE) && !productBaseQty.equals(SysConstant.BIGZERO)) {
                outputBaseQty = orderBaseQty.divide(productBaseQty, PREC, 4).multiply(consumeFixBaseQty).multiply(byMutiple);
            }
        } else if (consumeType.equals((Object)ConsumeTypeEnum.Proportion)) {
            if (scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                if (!byDivide.equals(SysConstant.BIGZERO)) {
                    outputBaseQty = orderBaseQty.multiply(baseProportion).divide(byDivide, PREC, 4);
                }
            } else if (scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                outputBaseQty = orderBaseQty.multiply(baseProportion).multiply(byMutiple);
            }
        }
        return outputBaseQty;
    }

    public static BigDecimal getAssistUnitQty(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo eoUnitInfo, BigDecimal qty, MeasureUnitInfo assistUnitInfo) throws EASBizException, BOSException {
        if (MoRefactUtils.isNullOrIdIsNull(materialInfo) || MoRefactUtils.isNullOrIdIsNull(assistUnitInfo) || qty == null || qty.doubleValue() == 0.0) {
            return SysConstant.BIGZERO;
        }
        return SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)eoUnitInfo, (MeasureUnitInfo)assistUnitInfo, (BigDecimal)qty);
    }

    public static boolean isNullOrIdIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)((String)obj));
        }
        if (obj instanceof CoreBaseInfo) {
            return ((CoreBaseInfo)obj).getId() == null;
        }
        return false;
    }

    public static void updateExpectOutputOper(Context ctx, ManufactureOrderExpectOutputCollection moExpectOutPutCol, int startOperNO, int defaultOperNo, Map techMap) throws EASBizException, BOSException {
        ManufactureOrderExpectOutputInfo entryInfo = null;
        int size = moExpectOutPutCol.size();
        for (int i = 0; i < size; ++i) {
            ManufactureOrderTechnicsInfo techInfo;
            entryInfo = (ManufactureOrderExpectOutputInfo)moExpectOutPutCol.getObject(i);
            int operationNo = entryInfo.getOperationNo();
            if (operationNo <= startOperNO) continue;
            if (techMap.containsKey(new Integer(operationNo))) {
                techInfo = (ManufactureOrderTechnicsInfo)techMap.get(new Integer(operationNo));
                entryInfo.setOperation(techInfo.getOperation());
                continue;
            }
            entryInfo.setOperationNo(defaultOperNo);
            techInfo = (ManufactureOrderTechnicsInfo)techMap.get(new Integer(defaultOperNo));
            entryInfo.setOperation(techInfo.getOperation());
        }
    }

    public static void updateStockOper(Context ctx, ManufactureOrderStockCollection moStockCol, int startOperNO, int defaultOperNo, Map techMap) throws EASBizException, BOSException {
        ManufactureOrderStockInfo stockInfo = null;
        int size = moStockCol.size();
        for (int i = 0; i < size; ++i) {
            ManufactureOrderTechnicsInfo techInfo;
            stockInfo = (ManufactureOrderStockInfo)moStockCol.getObject(i);
            int operationNo = stockInfo.getOperationNo();
            if (operationNo <= startOperNO) continue;
            if (techMap.containsKey(new Integer(operationNo))) {
                techInfo = (ManufactureOrderTechnicsInfo)techMap.get(new Integer(operationNo));
                stockInfo.setOperation(techInfo.getOperation());
                stockInfo.setWorkcenter(techInfo.getWorkcenter());
                if (techInfo.getEntrustType().equals((Object)EntrustTypeEnum.ENTRUST)) continue;
                stockInfo.setPickDept(techInfo.getAdminOrgUnit());
                continue;
            }
            stockInfo.setOperationNo(defaultOperNo);
            techInfo = (ManufactureOrderTechnicsInfo)techMap.get(new Integer(defaultOperNo));
            stockInfo.setOperation(techInfo.getOperation());
            stockInfo.setWorkcenter(techInfo.getWorkcenter());
            if (techInfo.getEntrustType().equals((Object)EntrustTypeEnum.ENTRUST)) continue;
            stockInfo.setPickDept(techInfo.getAdminOrgUnit());
        }
    }

    public static int getSplitOperNo(Context ctx, String id) throws EASBizException, BOSException {
        int operNo = 0;
        String sql_getSplitOperNo = "SELECT distinct FSplitOperationNo FROM T_MM_MOSplitRecord WHERE FChildId = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_getSplitOperNo, (Object[])new Object[]{id});
        try {
            if (rs.next()) {
                operNo = rs.getInt("FSplitOperationNo");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return operNo;
    }
}

