/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.mm.mo.GetStockCanToDoConditionInfo;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCalculateInv {
    protected Context ctx;
    protected String tempStockTable;
    protected String orgId;
    protected static final String planVersionNumber = "901";

    public AbstractCalculateInv(Context ctx, String tempStockTable, String orgId) {
        this.ctx = ctx;
        this.tempStockTable = tempStockTable;
        this.orgId = orgId;
    }

    public Map get() throws BOSException {
        HashMap result = new HashMap();
        String tempTableName = null;
        String tempTableNameSum = null;
        try {
            String[] tempTableArray = this.genBillTempByTempTable(this.ctx, this.tempStockTable);
            tempTableName = tempTableArray[0];
            tempTableNameSum = tempTableArray[1];
            StringBuffer oqls = this.getOqlsByTempTable(this.orgId, tempTableNameSum, tempTableName);
            DbUtil.execute((Context)this.ctx, (String)oqls.toString());
            this.invReverse(result, tempTableNameSum);
            HashMap hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
            if (!StringUtils.isEmpty(tempTableName)) {
                pool.releaseTable(tempTableName);
            }
            if (!StringUtils.isEmpty(tempTableNameSum)) {
                pool.releaseTable(tempTableNameSum);
            }
        }
    }

    protected void invReverse(Map result, String tempTableNameSum) throws BOSException, SQLException {
        StringBuffer clearStr = new StringBuffer();
        clearStr.append("update ");
        clearStr.append(this.tempStockTable);
        clearStr.append(" set FInvBaseQty=0");
        DbUtil.execute((Context)this.ctx, (String)clearStr.toString());
        StringBuffer updateInvReverse = new StringBuffer();
        updateInvReverse.append("update ");
        updateInvReverse.append(this.tempStockTable);
        updateInvReverse.append(" t set FInvBaseQty=");
        updateInvReverse.append("(select FSumBaseQty from ");
        updateInvReverse.append(tempTableNameSum);
        updateInvReverse.append(" where ");
        StringBuffer whereStr = this.getWhereStr();
        updateInvReverse.append(whereStr);
        updateInvReverse.append(") where exists(select 1 from ");
        updateInvReverse.append(tempTableNameSum);
        updateInvReverse.append(" where ");
        updateInvReverse.append(whereStr);
        updateInvReverse.append(")");
        DbUtil.execute((Context)this.ctx, (String)updateInvReverse.toString());
        StringBuffer updateInvQty = new StringBuffer();
        updateInvReverse.append("update ");
        updateInvReverse.append(this.tempStockTable);
        updateInvReverse.append(" t set FInvQty=");
        updateInvReverse.append(" ROUND(Decimal(FInvBaseQty/FBaseConvsRate,21,8),FQtyPrecision)");
        DbUtil.execute((Context)this.ctx, (String)updateInvReverse.toString());
        StringBuffer querySql = new StringBuffer();
        querySql.setLength(0);
        querySql.append("select FID,FInvBaseQty,FInvQty,FBaseUnitId,FQtyPrecision from ");
        querySql.append(this.tempStockTable);
        IRowSet moStockRs = DBUtil.executeQuery((Context)this.ctx, (String)querySql.toString());
        while (moStockRs.next()) {
            BigDecimal invBaseQty = moStockRs.getBigDecimal("FInvBaseQty");
            BigDecimal invQty = moStockRs.getBigDecimal("FInvQty");
            int pre = moStockRs.getInt("FQtyPrecision");
            invQty.setScale(pre);
            String stockID = moStockRs.getString("FID");
            String baseUnitID = moStockRs.getString("FBaseUnitId");
            GetStockCanToDoConditionInfo info = new GetStockCanToDoConditionInfo();
            if (invBaseQty.compareTo(new BigDecimal("0")) <= 0) {
                invBaseQty = new BigDecimal("0");
            }
            if (invQty.compareTo(new BigDecimal("0")) <= 0) {
                invQty = new BigDecimal("0");
            }
            info.setBaseUnitID(baseUnitID);
            info.setBaseQty(invBaseQty);
            info.setQty(invQty);
            result.put(stockID, info);
        }
    }

    protected abstract StringBuffer getWhereStr();

    protected abstract String[] genBillTempByTempTable(Context var1, String var2) throws BOSException;

    protected abstract StringBuffer getOqlsByTempTable(String var1, String var2, String var3);
}

