/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.mm.mo.GetStockCanToDoConditionInfo;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCalculateOccupy {
    protected Context ctx;
    protected String tempStockTable;
    protected String orgId;

    public AbstractCalculateOccupy(Context ctx, String tempStockTable, String orgId) {
        this.ctx = ctx;
        this.tempStockTable = tempStockTable;
        this.orgId = orgId;
    }

    public Map get() throws BOSException {
        HashMap hashMap;
        HashMap result = new HashMap();
        String tempTableName = null;
        String tempTableNameSum = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        String stockTempTable = null;
        try {
            stockTempTable = this.arrangeStockData();
            String[] tempTableArray = this.genBillTempByTempTable(this.ctx, this.tempStockTable);
            tempTableName = tempTableArray[0];
            tempTableNameSum = tempTableArray[1];
            StringBuffer oqls = this.getOqlsByTempTable(this.orgId, tempTableNameSum, tempTableName, stockTempTable);
            DbUtil.execute((Context)this.ctx, (String)oqls.toString());
            this.occupyReverse(result, tempTableNameSum);
            hashMap = result;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (!StringUtils.isEmpty((String)stockTempTable)) {
                    pool.releaseTable(stockTempTable);
                }
                if (!StringUtils.isEmpty(tempTableName)) {
                    pool.releaseTable(tempTableName);
                }
                if (!StringUtils.isEmpty(tempTableNameSum)) {
                    pool.releaseTable(tempTableNameSum);
                }
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)stockTempTable)) {
            pool.releaseTable(stockTempTable);
        }
        if (!StringUtils.isEmpty((String)tempTableName)) {
            pool.releaseTable(tempTableName);
        }
        if (!StringUtils.isEmpty((String)tempTableNameSum)) {
            pool.releaseTable(tempTableNameSum);
        }
        return hashMap;
    }

    private String arrangeStockData() throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        StringBuffer moTempStr = new StringBuffer();
        moTempStr.append("create table t_temp_moorder (");
        moTempStr.append("KSQL_SEQ INT IDENTITY (10, 10) NOT NULL,");
        moTempStr.append("FID VARCHAR(44),");
        moTempStr.append("FOrgUnitId VARCHAR(44),");
        moTempStr.append("FMaterialID VARCHAR(44),");
        moTempStr.append("FProjectId VARCHAR(44),");
        moTempStr.append("FTrackId VARCHAR(44))");
        StringBuffer moStockTempStr = new StringBuffer();
        moStockTempStr.append("create table t_temp_moStock (");
        moStockTempStr.append("KSQL_SEQ INT IDENTITY (10, 10) NOT NULL,");
        moStockTempStr.append("FID VARCHAR(44),");
        moStockTempStr.append("FMoId VARCHAR(44),");
        moStockTempStr.append("FPlannedBaseQty NUMERIC(21,8) DEFAULT 0,");
        moStockTempStr.append("FActIssueBaseQty NUMERIC(21,8) DEFAULT 0,");
        moStockTempStr.append("FRejectedBaseQty NUMERIC(21,8) DEFAULT 0,");
        moStockTempStr.append("FOrgUnitId VARCHAR(44),");
        moStockTempStr.append("FWareHouseId VARCHAR(44),");
        moStockTempStr.append("FMaterialID VARCHAR(44),");
        moStockTempStr.append("FProjectId VARCHAR(44),");
        moStockTempStr.append("FTrackId VARCHAR(44),");
        moStockTempStr.append("FMaterialPlanId VARCHAR(44),");
        moStockTempStr.append("FManufactureStrategyId VARCHAR(44),");
        moStockTempStr.append("FIsolatedRule VARCHAR(20))");
        String moTempTable = null;
        String stockTempTable = null;
        try {
            moTempTable = pool.createTempTable(moTempStr.toString());
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into ").append(moTempTable);
            insertSql.append("(KSQL_SEQ,FID,FOrgUnitId,FMaterialID,FProjectId,FTrackId)");
            insertSql.append(" select mo.fid,mo.FStorageOrgUnitId,mo.FMaterialID,mo.FProjectID,mo.FTrackID from");
            insertSql.append(" T_MM_ManufactureOrder mo");
            insertSql.append(" inner join  t_mm_ProductTransactionType pt on pt.fid=mo.ftransactiontypeid ");
            insertSql.append(" where (mo.fbasestatus = 5 or mo.fbasestatus = 8) ");
            insertSql.append(" and mo.FStorageOrgUnitId='");
            insertSql.append(this.orgId);
            insertSql.append("' and ((mo.fisautofinished=1 AND pt.fistotalpicking<>1) OR mo.fisautofinished=0)");
            insertSql.append(" and not exists(select 1 from ");
            insertSql.append(this.tempStockTable);
            insertSql.append(" where FMoId = mo.fid)");
            DBUtil.execute((Context)this.ctx, (String)insertSql.toString());
            pool.createIndex(moTempTable, "FID", true, false);
            stockTempTable = pool.createTempTable(moStockTempStr.toString());
            insertSql.setLength(0);
            insertSql.append("insert into ").append(stockTempTable);
            insertSql.append("(KSQL_SEQ,FID,FMoId,FPlannedBaseQty,FActIssueBaseQty,FRejectedBaseQty,");
            insertSql.append("FOrgUnitId,FWareHouseId,FMaterialID,FProjectId,FTrackId,FMaterialPlanId,");
            insertSql.append("FManufactureStrategyId,FIsolatedRule)");
            insertSql.append(" select stock.fid as stockFid ,mo.fid as moFid,stock.FPlannedBaseQty,stock.FActIssueBaseQty,stock.FRejectedBaseQty,");
            insertSql.append(" mo.FOrgUnitId,stock.FWareHouseId,stock.FMaterialID,mo.FProjectId,mo.FTrackId,");
            insertSql.append(" materialplan.FID as materialPlanId,materialplan.FManufactureStrategyId,materialplan.FIsolatedRule");
            insertSql.append(" from ");
            insertSql.append(" T_MM_MFTOrderStock stock inner join ");
            insertSql.append(moTempTable);
            insertSql.append(" mo on mo.FID = stock.FParentID ");
            this.genWarehouseConnect(insertSql);
            insertSql.append(" inner join T_BD_MaterialPlan materialplan on materialplan.fMaterialId=stock.FMaterialID and materialplan.forgunit=mo.FOrgUnitId ").append("\r\n");
            insertSql.append(" where stock.fisbackflush = 0 and stock.FIssueMode = 11010");
            insertSql.append(" and (stock.FProvideType = 10910 or stock.FProvideType = 10920) ");
            this.genWarehouseScopeStr(insertSql);
            DBUtil.execute((Context)this.ctx, (String)insertSql.toString());
            StringBuffer updateStrategySql = new StringBuffer();
            updateStrategySql.append("update ");
            updateStrategySql.append(stockTempTable);
            updateStrategySql.append(" set FProjectId = null ");
            updateStrategySql.append(" where FProjectId is not null and FManufactureStrategyId != '");
            updateStrategySql.append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            updateStrategySql.append("'");
            DBUtil.execute((Context)this.ctx, (String)updateStrategySql.toString());
            updateStrategySql.setLength(0);
            updateStrategySql.append("update ");
            updateStrategySql.append(stockTempTable);
            updateStrategySql.append(" set FTrackId = null ");
            updateStrategySql.append(" where FTrackId is not null and FManufactureStrategyId != '");
            updateStrategySql.append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=");
            updateStrategySql.append("' and FManufactureStrategyId != '");
            updateStrategySql.append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=");
            updateStrategySql.append("' and FManufactureStrategyId != '");
            updateStrategySql.append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            updateStrategySql.append("'");
            DBUtil.execute((Context)this.ctx, (String)updateStrategySql.toString());
            updateStrategySql.setLength(0);
            updateStrategySql.append("update ");
            updateStrategySql.append(stockTempTable);
            updateStrategySql.append(" set FTrackId = null ");
            updateStrategySql.append(" where FTrackId is not null and FManufactureStrategyId = '");
            updateStrategySql.append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            updateStrategySql.append("' and FIsolatedRule = 'ITEM'");
            DBUtil.execute((Context)this.ctx, (String)updateStrategySql.toString());
            updateStrategySql.setLength(0);
            updateStrategySql.append("update ");
            updateStrategySql.append(stockTempTable);
            updateStrategySql.append(" set FTrackId = '");
            updateStrategySql.append("EgkAAABc3X0Ibpg9");
            updateStrategySql.append("'");
            updateStrategySql.append(" where FTrackId is  null");
            DBUtil.execute((Context)this.ctx, (String)updateStrategySql.toString());
            updateStrategySql.setLength(0);
            updateStrategySql.append("update ");
            updateStrategySql.append(stockTempTable);
            updateStrategySql.append(" set FProjectId = '");
            updateStrategySql.append("EgkAAABc3Xza3gXu");
            updateStrategySql.append("'");
            updateStrategySql.append(" where FProjectId is null");
            DBUtil.execute((Context)this.ctx, (String)updateStrategySql.toString());
            pool.createIndex(stockTempTable, "FMaterialID,FProjectId,FTrackId", false, false);
            pool.createIndex(stockTempTable, "KSQL_SEQ", false, false);
        }
        catch (Exception e) {
            if (!StringUtils.isEmpty(stockTempTable)) {
                pool.releaseTable(moTempTable);
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty(moTempTable)) {
                pool.releaseTable(moTempTable);
            }
        }
        return stockTempTable;
    }

    protected void occupyReverse(Map result, String tempTableNameSum) throws BOSException, SQLException {
        StringBuffer clearStr = new StringBuffer();
        clearStr.append("update ");
        clearStr.append(this.tempStockTable);
        clearStr.append(" set FOccupyBaseQty=0");
        DbUtil.execute((Context)this.ctx, (String)clearStr.toString());
        StringBuffer updateOccupyReverse = new StringBuffer();
        updateOccupyReverse.append("update ");
        updateOccupyReverse.append(this.tempStockTable);
        updateOccupyReverse.append(" t set FOccupyBaseQty=");
        updateOccupyReverse.append("(select FSumBaseQty from ");
        updateOccupyReverse.append(tempTableNameSum);
        updateOccupyReverse.append(" where ");
        StringBuffer whereStr = this.getWhereStr();
        updateOccupyReverse.append(whereStr);
        updateOccupyReverse.append(") where exists(select 1 from ");
        updateOccupyReverse.append(tempTableNameSum);
        updateOccupyReverse.append(" where ");
        updateOccupyReverse.append(whereStr);
        updateOccupyReverse.append(")");
        DbUtil.execute((Context)this.ctx, (String)updateOccupyReverse.toString());
        StringBuffer updateOccupyQty = new StringBuffer();
        updateOccupyQty.append("update ");
        updateOccupyQty.append(this.tempStockTable);
        updateOccupyQty.append(" t set FOccupyQty=");
        updateOccupyQty.append(" ROUND(Decimal(FOccupyBaseQty/FBaseConvsRate,21,8),FQtyPrecision)");
        DbUtil.execute((Context)this.ctx, (String)updateOccupyQty.toString());
        StringBuffer querySql = new StringBuffer();
        querySql.setLength(0);
        querySql.append("select FID,FOccupyBaseQty,FOccupyQty,FBaseUnitId,FQtyPrecision from ");
        querySql.append(this.tempStockTable);
        IRowSet moStockRs = DBUtil.executeQuery((Context)this.ctx, (String)querySql.toString());
        while (moStockRs.next()) {
            BigDecimal OccupyBaseQty = moStockRs.getBigDecimal("FOccupyBaseQty");
            BigDecimal OccupyQty = moStockRs.getBigDecimal("FOccupyQty");
            int pre = moStockRs.getInt("FQtyPrecision");
            OccupyQty.setScale(pre);
            String stockID = moStockRs.getString("FID");
            String baseUnitID = moStockRs.getString("FBaseUnitId");
            GetStockCanToDoConditionInfo info = new GetStockCanToDoConditionInfo();
            if (OccupyBaseQty.compareTo(new BigDecimal("0")) <= 0) {
                OccupyBaseQty = new BigDecimal("0");
            }
            if (OccupyQty.compareTo(new BigDecimal("0")) <= 0) {
                OccupyQty = new BigDecimal("0");
            }
            info.setBaseUnitID(baseUnitID);
            info.setBaseQty(OccupyBaseQty);
            info.setQty(OccupyQty);
            result.put(stockID, info);
        }
    }

    protected abstract StringBuffer getWhereStr();

    protected abstract String[] genBillTempByTempTable(Context var1, String var2) throws BOSException;

    protected abstract StringBuffer getOqlsByTempTable(String var1, String var2, String var3, String var4);

    protected abstract void genWarehouseConnect(StringBuffer var1);

    protected abstract void genWarehouseScopeStr(StringBuffer var1);
}

