/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.verify.IMMVerifyManager;
import com.kingdee.eas.mm.common.app.verify.MMVerifyManager;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.util.MOMaterialInfoUtil;
import com.kingdee.eas.mm.mo.app.util.MOMultiMeasureUnitUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MOAutoCloseUtil {
    public static Object[] getMOForAutoClose(Context ctx, String tempTableName) throws BOSException {
        String tempTable = "";
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Object[] result = new Object[2];
        try {
            tempTable = pool.createTempTable("create table tempTable (FID VARCHAR(44),FOrgUnitID VARCHAR(44),FMaterialID VARCHAR(44),FUnitID VARCHAR(44),FType INT)");
            String queryString = "select FSourceBillID from " + tempTableName;
            HashSet<String> moIdSet = new HashSet<String>();
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryString, (Object[])new Object[0]);
                while (rs.next()) {
                    moIdSet.add(rs.getString("FSourceBillID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (moIdSet.size() == 0) {
                return result;
            }
            result[0] = MOAutoCloseUtil.getMOForAutoClose(ctx, moIdSet);
            StringBuffer buildTempSql = new StringBuffer();
            buildTempSql.append("insert into ").append(tempTable).append("(FID, FOrgUnitID, FMaterialID,FUnitID)");
            buildTempSql.append("select fid,fstorageorgunitid, fmaterialid, FUnitID from T_MM_ManufactureOrder where fid in (select FSourceBillID from ").append(tempTableName).append(" )");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            buildTempSql.setLength(0);
            buildTempSql.append("insert into ").append(tempTable).append("(FID, FOrgUnitID, FMaterialID,FUnitID)");
            buildTempSql.append("select t1.fid,t2.FOrgUnitID, t1.fmaterialid, t1.FUnitID from t_Mm_Mftorderstock t1 inner join ");
            buildTempSql.append(tempTable);
            buildTempSql.append(" t2 on t1.fparentid = t2.fid");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            buildTempSql.setLength(0);
            buildTempSql.append("insert into ").append(tempTable).append("(FMaterialID,FUnitID,FType)");
            buildTempSql.append("select distinct fmaterialid, FUnitID, 1 from  ").append(tempTable);
            buildTempSql.append(" where FType is null");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            buildTempSql.setLength(0);
            buildTempSql.append("delete from ").append(tempTable).append(" where  fid is not null");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            result[1] = tempTable;
        }
        catch (Exception e) {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static ManufactureOrderCollection getMOForAutoClose(Context ctx, Set moIdSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)moIdSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        evi.setSelector(MOAutoCloseUtil.getMOSelectorForAutoClose());
        ManufactureOrderCollection moCol = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(evi);
        return moCol;
    }

    public static SelectorItemCollection getMOSelectorForAutoClose() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("isAutoFinished"));
        sic.add(new SelectorItemInfo("isManuFinished"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("passQty"));
        sic.add(new SelectorItemInfo("concessionQty"));
        sic.add(new SelectorItemInfo("scrapQty"));
        sic.add(new SelectorItemInfo("deliveryQty"));
        sic.add(new SelectorItemInfo("lastOperNo"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("totalSplitQty"));
        sic.add(new SelectorItemInfo("toStroreQty"));
        sic.add(new SelectorItemInfo("lackLowerLimit"));
        sic.add(new SelectorItemInfo("stocks.id"));
        sic.add(new SelectorItemInfo("stocks.issueMode"));
        sic.add(new SelectorItemInfo("stocks.plannedQty"));
        sic.add(new SelectorItemInfo("stocks.lackRatio"));
        sic.add(new SelectorItemInfo("stocks.actIssueQty"));
        sic.add(new SelectorItemInfo("stocks.rejectedQty"));
        sic.add(new SelectorItemInfo("stocks.feedingQty"));
        sic.add(new SelectorItemInfo("stocks.materialFeedingQty"));
        sic.add(new SelectorItemInfo("stocks.scrapQty"));
        sic.add(new SelectorItemInfo("stocks.materialScrapQty"));
        sic.add(new SelectorItemInfo("stocks.material.id"));
        sic.add(new SelectorItemInfo("stocks.unit.id"));
        sic.add(new SelectorItemInfo("stocks.issueMode"));
        sic.add(new SelectorItemInfo("stocks.isBackflush"));
        sic.add(new SelectorItemInfo("technics.id"));
        sic.add(new SelectorItemInfo("technics.isReportPoint"));
        sic.add(new SelectorItemInfo("technics.passQty"));
        sic.add(new SelectorItemInfo("technics.concessionQty"));
        sic.add(new SelectorItemInfo("technics.finishedQty"));
        sic.add(new SelectorItemInfo("technics.totalQtyLower"));
        sic.add(new SelectorItemInfo("technics.operationNo"));
        sic.add(new SelectorItemInfo("technics.scrapQty"));
        sic.add(new SelectorItemInfo("transactionType.id"));
        sic.add(new SelectorItemInfo("transactionType.finishedQty"));
        sic.add(new SelectorItemInfo("transactionType.isAutoFinish"));
        sic.add(new SelectorItemInfo("transactionType.isReachStoreQtyLLimit"));
        sic.add(new SelectorItemInfo("transactionType.isTotalPicking"));
        sic.add(new SelectorItemInfo("transactionType.totalPicking"));
        sic.add(new SelectorItemInfo("transactionType.isCompleteReport"));
        sic.add(new SelectorItemInfo("transactionType.isWPManagement"));
        return sic;
    }

    public static void autoCloseFromMRBByCR(Context ctx, String sourceDataTable, boolean isIgnoreBackflush) throws BOSException, EASBizException {
        String tempTable = "";
        try {
            Object[] result = MOAutoCloseUtil.getMOForAutoClose(ctx, sourceDataTable);
            ManufactureOrderCollection moCol = (ManufactureOrderCollection)((Object)result[0]);
            tempTable = (String)result[1];
            if (MOMaterialInfoUtil.isNullCol((IObjectCollection)moCol)) {
                return;
            }
            Map paramMap = MOAutoCloseUtil.prepareParamMap(ctx, tempTable, moCol, isIgnoreBackflush);
            BatchActionResults batchResults = BatchActionResults.populateActionResults((IObjectCollection)moCol);
            IMMVerifyManager moVerify = MOAutoCloseUtil.getVerifyManager(ctx, "MOAutoCloseManagerFromMRBByCR", paramMap, batchResults);
            moVerify.verify();
            if (batchResults.getToDoIdsSet().size() == 0) {
                return;
            }
            MOAutoCloseUtil.executeClose(ctx, batchResults);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
    }

    private static Map prepareParamMap(Context ctx, String tempTable, ManufactureOrderCollection moCol, boolean isIgnoreBackflush) throws BOSException {
        Map<String, Integer> multiMeasureUnitMap = MOMultiMeasureUnitUtil.getMultiMeasureUnit(ctx, moCol, tempTable);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("manufactureOrderColection", (Object)moCol);
        paramMap.put("multiMeasureUnitMap", multiMeasureUnitMap);
        paramMap.put("isIgnoreBackflush", isIgnoreBackflush);
        return paramMap;
    }

    protected static IMMVerifyManager getVerifyManager(Context ctx, String verifyManagerName, Map paramMap, BatchActionResults batchResults) throws BOSException, EASBizException {
        return new MMVerifyManager(ctx, MOAutoCloseUtil.getVerifyXmlFile(), verifyManagerName, paramMap, batchResults);
    }

    protected static String getVerifyXmlFile() {
        return "com.kingdee.eas.mm.mo.app.verify.ManufactureOrderVerify";
    }

    public static void executeClose(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String idSubToZeroString = MOAutoCloseUtil.idSubString(ctx, idStr);
        String[] sqls = new String[2];
        StringBuffer updateSql = new StringBuffer();
        StringBuffer updateToZeroSql = new StringBuffer();
        updateSql.append("update T_MM_MFTOrderStock  ").append("set FActureLossRatio = case ").append(" when (FActIssueQty -FRejectedQty+ FFeedingQty + FMaterialFeedingQty-FMaterialScrapQty-FQty ) <=0 then 0 ").append(" when FScrapExpr = 10620 then ").append("        case when FQty <= 0 then 0 else ").append("            round(to_decimal(((FActIssueQty -FRejectedQty+ FFeedingQty + FMaterialFeedingQty-FMaterialScrapQty)/FQty - 1) * 100,21,8),2) end ").append("   else case when (FActIssueQty -FRejectedQty+ FFeedingQty + FMaterialFeedingQty-FMaterialScrapQty ) <=0 then 0 else ").append("             round(to_decimal((1- FQty/(FActIssueQty -FRejectedQty+ FFeedingQty + FMaterialFeedingQty-FMaterialScrapQty)) * 100,21,8),2) end ").append("end, ").append("FActLossQty = case when FActIssueQty -FRejectedQty+ FFeedingQty + FMaterialFeedingQty-FMaterialScrapQty - FQty<=0 ").append(" then 0 else FActIssueQty -FRejectedQty+ FFeedingQty + FMaterialFeedingQty-FMaterialScrapQty - FQty end,").append("FActLossBaseQty = case when FActIssueBaseQty + FFeedingBaseQty + FMaterialFeedingBaseQty - FBaseQty-FRejectedBaseQty- FMaterialScrapBaseQty<=0 ").append(" then 0 else FActIssueBaseQty + FFeedingBaseQty + FMaterialFeedingBaseQty - FBaseQty-FRejectedBaseQty- FMaterialScrapBaseQty end ").append("where FParentID in (").append(idStr).append(") ");
        updateToZeroSql.append("update T_MM_MFTOrderStock  ").append("set  FWipQty = 0, FWipBaseQty = 0 ").append("where FParentID in ('").append(idSubToZeroString).append("') ");
        sqls[0] = updateSql.toString();
        sqls[1] = updateToZeroSql.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        LotFacadeFactory.getLocalInstance((Context)ctx).manufactureOrderCloseLot(batchResults.getToDoIdsArray());
        MOAutoCloseUtil.onlyUpdateCloseStatus(ctx, batchResults);
        ManufactureOrderFactory.getLocalInstance(ctx).setCloseTime(batchResults);
    }

    private static void onlyUpdateCloseStatus(Context ctx, BatchActionResults batchResults) throws BOSException {
        if (batchResults.getToDoIdsSet() != null && batchResults.getToDoIdsSet().size() > 0) {
            String[] sqlUpStatus = new String[]{"update t_mm_manufactureorder set fbasestatus = 7 where fid in  ( select mo.fid from  t_mm_manufactureorder mo inner join T_MM_PRODUCTTRANSACTIONTYPE pt on mo.ftransactionTypeid = pt.fid  where mo.fid in ( " + SQLUtil.setToString((Set)batchResults.getToDoIdsSet()) + " ) and pt.FIsWPManagement = 1 )", "update t_mm_manufactureorder set fbasestatus = 7 where fid in  ( select mo.fid from  t_mm_manufactureorder mo inner join T_MM_PRODUCTTRANSACTIONTYPE pt on mo.ftransactionTypeid = pt.fid  where mo.fid in ( " + SQLUtil.setToString((Set)batchResults.getToDoIdsSet()) + " ) and pt.FIsWPManagement = 0 )", "update t_mm_manufactureorder mo2 set  FActureEndDate =  (select case when max(m.FBizDate)>mo2.FActureEndDate then max(m.FBizDate)         else ISNUll(mo2.FActureEndDate, max(m.FBizDate))          end  from t_im_manufacturerecbill m  inner join t_im_manufacturerecbillEntry me on me.FParentID = m.fid  where m.FBaseStatus=4 and me.FManuBillID = mo2.fid) where fid in  (select mo.fid from  t_mm_manufactureorder mo inner join T_MM_PRODUCTTRANSACTIONTYPE pt on mo.ftransactionTypeid = pt.fid  where mo.fid in ( " + SQLUtil.setToString((Set)batchResults.getToDoIdsSet()) + " ) and pt.FIsWPManagement = 0 )"};
            SQLUtil.batchExecuteSql((Context)ctx, (String[])sqlUpStatus);
        }
    }

    private static String idSubString(Context ctx, String idStr) throws BOSException {
        String idSubStr = null;
        HashSet<String> idSubToZeroSet = new HashSet<String>();
        StringBuffer subIdSql = new StringBuffer();
        subIdSql.append("select mo.FId as ID,transType.FIsSetWIPQtyToZero as IsZero ").append("from t_mm_manufactureOrder mo ").append(" inner join t_mm_ProductTransactionType transType on mo.fTransactionTypeId = transType.FId ").append(" where mo.Fid in (").append(idStr).append(") ").append("and transType.FIsSetWIPQtyToZero = 1 ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)subIdSql.toString());
            while (rs.next()) {
                String moId = rs.getString("ID");
                idSubToZeroSet.add(moId);
            }
            if (idSubToZeroSet != null) {
                idSubStr = StringUtils.arrayToString((Object[])idSubToZeroSet.toArray(), (String)"','");
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        return idSubStr;
    }

    public static void checkProductTransactionTypeForCR(Context ctx, String sourceDataTable) throws BOSException, ManufactureOrderException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fnumber ");
        selectSql.append(" from T_MM_ManufactureOrder mo, ").append(sourceDataTable).append(" s,  ").append(" T_IM_ManufactureRecBill t, ").append("T_mm_completionReport cr,").append(" T_MM_ProductTransactionType pt").append(" where s.fSourceBillID = cr.fid and cr.FDmesOrderID = mo.fid  and t.fid = s.fbillid ").append(" and mo.FTransactionTypeID = pt.fid and pt.FIsWPManagement = 0");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            int i = 0;
            HashMap<String, String> errMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                String billNumber = rs.getString("fnumber");
                errMap.put(billNumber, "1");
                ++i;
            }
            if (!errMap.isEmpty()) {
                throw new ManufactureOrderException(ManufactureOrderException.WRONGPTISNOTWPMANAGEMENT, errMap.keySet().toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void checkProductTransactionTypeForCRToOIW(Context ctx, String sourceDataTable) throws BOSException, ManufactureOrderException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fnumber ");
        selectSql.append(" from T_MM_ManufactureOrder mo, ").append(sourceDataTable).append(" s,  ").append(" T_IM_OtherInWarehsBill t, ").append("T_mm_completionReport cr,").append(" T_MM_ProductTransactionType pt").append(" where s.fSourceBillID = cr.fid and cr.FDmesOrderID = mo.fid  and t.fid = s.fbillid ").append(" and mo.FTransactionTypeID = pt.fid and pt.FIsWPManagement = 0");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            int i = 0;
            HashMap<String, String> errMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                String billNumber = rs.getString("fnumber");
                errMap.put(billNumber, "1");
                ++i;
            }
            if (!errMap.isEmpty()) {
                throw new ManufactureOrderException(ManufactureOrderException.WRONGPTISNOTWPMANAGEMENTOIW, errMap.keySet().toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static boolean checkMOCloseForCRToOIW(Context ctx, String sourceDataTable) throws BOSException, ManufactureOrderException {
        boolean isMOclose = false;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fnumber ");
        selectSql.append(" from T_MM_ManufactureOrder mo, ").append(sourceDataTable).append(" s,  ").append(" T_IM_OtherInWarehsBill t, ").append("T_mm_completionReport cr").append(" where s.fSourceBillID = cr.fid and cr.FDmesOrderID = mo.fid  and  mo.fBaseStatus in (6,7,11)  and t.fid = s.fbillid ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            int i = 0;
            HashMap<String, String> errMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                isMOclose = true;
                String billID = rs.getString("fnumber");
                errMap.put(billID, "1");
                ++i;
            }
            if (isMOclose) {
                throw new ManufactureOrderException(ManufactureOrderException.MO_CLOSED, errMap.keySet().toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isMOclose;
    }

    public static boolean checkMOCloseForCR(Context ctx, String sourceDataTable) throws BOSException, ManufactureOrderException {
        boolean isMOclose = false;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fnumber ");
        selectSql.append(" from T_MM_ManufactureOrder mo, ").append(sourceDataTable).append(" s,  ").append(" T_IM_ManufactureRecBill t, ").append("T_mm_completionReport cr").append(" where s.fSourceBillID = cr.fid and cr.FDmesOrderID = mo.fid  and  mo.fBaseStatus in (6,7,11)  and t.fid = s.fbillid ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            int i = 0;
            HashMap<String, String> errMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                isMOclose = true;
                String billID = rs.getString("fnumber");
                errMap.put(billID, "1");
                ++i;
            }
            if (isMOclose) {
                throw new ManufactureOrderException(ManufactureOrderException.MO_CLOSED, errMap.keySet().toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isMOclose;
    }

    public static void checkProductTransactionTypeForMO(Context ctx, String sourceDataTable) throws BOSException, ManufactureOrderException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fnumber ");
        selectSql.append(" from T_MM_ManufactureOrder mo, ").append(sourceDataTable).append(" s,  ").append(" T_IM_ManufactureRecBill t ").append(", T_MM_ProductTransactionType pt ").append(" where s.fSourceBillID = mo.fid and s.FBillID = t.fid ").append(" and mo.FTransactionTypeID = pt.fid and pt.FIsWPManagement = 1");
        selectSql.append(" and t.FSourceBillTypeID = '").append("B2aZSVXaSx6qxdfekgCmrEY+1VI=").append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            int i = 0;
            HashMap<String, String> errMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                String billNumber = rs.getString("fnumber");
                errMap.put(billNumber, "1");
                ++i;
            }
            if (!errMap.isEmpty()) {
                throw new ManufactureOrderException(ManufactureOrderException.WRONGPTISWPMANAGEMENT, errMap.keySet().toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void autoCloseFromMRBByMO(Context ctx, String sourceDataTable, boolean ignoreBackflush) throws BOSException, EASBizException {
        String tempTable = "";
        try {
            Object[] result = MOAutoCloseUtil.getMOForAutoClose(ctx, sourceDataTable);
            ManufactureOrderCollection moCol = (ManufactureOrderCollection)((Object)result[0]);
            tempTable = (String)result[1];
            if (MOMaterialInfoUtil.isNullCol((IObjectCollection)moCol)) {
                return;
            }
            for (int i = moCol.size() - 1; i >= 0; --i) {
                ManufactureOrderInfo order = moCol.get(i);
                if (!order.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) continue;
                moCol.remove(order);
            }
            if (MOMaterialInfoUtil.isNullCol((IObjectCollection)moCol)) {
                return;
            }
            Map paramMap = MOAutoCloseUtil.prepareParamMap(ctx, tempTable, moCol, ignoreBackflush);
            BatchActionResults batchResults = BatchActionResults.populateActionResults((IObjectCollection)moCol);
            IMMVerifyManager moVerify = MOAutoCloseUtil.getVerifyManager(ctx, "MOAutoCloseManagerFromMRBByMO", paramMap, batchResults);
            moVerify.verify();
            if (batchResults.getToDoIdsSet().size() == 0) {
                return;
            }
            MOAutoCloseUtil.executeClose(ctx, batchResults);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
    }

    public static void moCloseCheck(Context ctx, BatchActionResults batchResults, String managerName) throws BOSException, EASBizException {
        ManufactureOrderCollection moCol = MOAutoCloseUtil.getMOForAutoClose(ctx, batchResults.getToDoIdsSet());
        if (MOMaterialInfoUtil.isNullCol((IObjectCollection)moCol)) {
            return;
        }
        String tempTable = "";
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            try {
                tempTable = pool.createTempTable("create table tempTable (FID VARCHAR(44), FOrgUnitID VARCHAR(44), FMaterialID VARCHAR(44), FUnitID VARCHAR(44), FType INT)");
            }
            catch (Exception e) {
                new BOSException((Throwable)e);
            }
            StringBuffer buildTempSql = new StringBuffer();
            buildTempSql.append("insert into ").append(tempTable).append("(FID, FOrgUnitID, FMaterialID,FUnitID)");
            buildTempSql.append("select fid,fstorageorgunitid, fmaterialid, FUnitID from T_MM_ManufactureOrder where ");
            buildTempSql.append(" fid in (");
            buildTempSql.append(SQLUtil.setToString((Set)batchResults.getToDoIdsSet()));
            buildTempSql.append(")");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            buildTempSql.setLength(0);
            buildTempSql.append("insert into ").append(tempTable).append("(FID, FOrgUnitID, FMaterialID,FUnitID)");
            buildTempSql.append("select t1.fid,t2.FOrgUnitID, t1.fmaterialid, t1.FUnitID from t_Mm_Mftorderstock t1 inner join ");
            buildTempSql.append(tempTable);
            buildTempSql.append(" t2 on t1.fparentid = t2.fid");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            buildTempSql.setLength(0);
            buildTempSql.append("insert into ").append(tempTable).append("(FMaterialID,FUnitID,FType)");
            buildTempSql.append("select distinct fmaterialid, FUnitID, 1 from  ").append(tempTable);
            buildTempSql.append(" where FType is null");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            buildTempSql.setLength(0);
            buildTempSql.append("delete from ").append(tempTable).append(" where  fid is not null");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            Map paramMap = MOAutoCloseUtil.prepareParamMap(ctx, tempTable, moCol, false);
            IMMVerifyManager moVerify = MOAutoCloseUtil.getVerifyManager(ctx, managerName, paramMap, batchResults);
            moVerify.verify();
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
    }

    public static void moCloseSimpleCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        ManufactureOrderCollection moCol = MOAutoCloseUtil.getMOForAutoClose(ctx, batchResults.getToDoIdsSet());
        if (MOMaterialInfoUtil.isNullCol((IObjectCollection)moCol)) {
            return;
        }
        HashMap<String, ManufactureOrderCollection> paramMap = new HashMap<String, ManufactureOrderCollection>();
        paramMap.put("manufactureOrderColection", moCol);
        try {
            IMMVerifyManager moVerify = MOAutoCloseUtil.getVerifyManager(ctx, "MOCloseSimpleManager", paramMap, batchResults);
            moVerify.verify();
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
    }
}

