/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.mm.basedata.PickingEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MOAutoFinishUtil {
    public static Object[] getMOForAutoFinish(Context ctx, String tempTableName) throws BOSException {
        String tempTable = "";
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Object[] result = new Object[2];
        try {
            tempTable = pool.createTempTable("create table tempTable (FID VARCHAR(44),FOrgUnitID VARCHAR(44),FMaterialID VARCHAR(44),FUnitID VARCHAR(44),FType INT)");
            String queryString = "select FSourceBillID from " + tempTableName;
            HashSet<String> moIdSet = new HashSet<String>();
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryString, (Object[])new Object[0]);
                while (rs.next()) {
                    moIdSet.add(rs.getString("FSourceBillID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (moIdSet.size() == 0) {
                return result;
            }
            result[0] = MOAutoFinishUtil.getMOForAutoFinish(ctx, moIdSet);
            StringBuffer buildTempSql = new StringBuffer();
            buildTempSql.append("insert into ").append(tempTable).append("(FID, FOrgUnitID, FMaterialID,FUnitID)");
            buildTempSql.append("select fid,fstorageorgunitid, fmaterialid, FUnitID from T_MM_ManufactureOrder where fid in (select FSourceBillID from ").append(tempTableName).append(" ) and FIsManuFinished = 0");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            buildTempSql.setLength(0);
            buildTempSql.append("insert into ").append(tempTable).append("(FID, FOrgUnitID, FMaterialID,FUnitID)");
            buildTempSql.append("select t1.fid,t2.FOrgUnitID, t1.fmaterialid, t1.FUnitID from t_Mm_Mftorderstock t1 inner join ");
            buildTempSql.append(tempTable);
            buildTempSql.append(" t2 on t1.fparentid = t2.fid");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            buildTempSql.setLength(0);
            buildTempSql.append("insert into ").append(tempTable).append("(FMaterialID,FUnitID,FType)");
            buildTempSql.append("select distinct fmaterialid, FUnitID, 1 from  ").append(tempTable);
            buildTempSql.append(" where FType is null");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            buildTempSql.setLength(0);
            buildTempSql.append("insert into ").append(tempTable).append("(FOrgUnitID,FMaterialID,FType)");
            buildTempSql.append("select distinct FOrgUnitID, FMaterialID, 2 from  ").append(tempTable);
            buildTempSql.append(" where FType is null");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            buildTempSql.setLength(0);
            buildTempSql.append("delete from ").append(tempTable).append(" where  fid is not null");
            DbUtil.execute((Context)ctx, (String)buildTempSql.toString());
            result[1] = tempTable;
        }
        catch (Exception e) {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static ManufactureOrderCollection getMOForAutoFinish(Context ctx, Set moIdSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)moIdSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("isManuFinished", (Object)Boolean.FALSE, CompareType.EQUALS));
        evi.setFilter(fi);
        evi.setSelector(MOAutoFinishUtil.getMOSelectorForAutoFinish());
        ManufactureOrderCollection moCol = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(evi);
        return moCol;
    }

    public static SelectorItemCollection getMOSelectorForAutoFinish() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("passQty"));
        sic.add(new SelectorItemInfo("concessionQty"));
        sic.add(new SelectorItemInfo("scrapQty"));
        sic.add(new SelectorItemInfo("deliveryQty"));
        sic.add(new SelectorItemInfo("lastOperNo"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("totalSplitQty"));
        sic.add(new SelectorItemInfo("isAutoFinished"));
        sic.add(new SelectorItemInfo("stocks.id"));
        sic.add(new SelectorItemInfo("stocks.issueMode"));
        sic.add(new SelectorItemInfo("stocks.plannedQty"));
        sic.add(new SelectorItemInfo("stocks.lackRatio"));
        sic.add(new SelectorItemInfo("stocks.actIssueQty"));
        sic.add(new SelectorItemInfo("stocks.rejectedQty"));
        sic.add(new SelectorItemInfo("stocks.feedingQty"));
        sic.add(new SelectorItemInfo("stocks.materialFeedingQty"));
        sic.add(new SelectorItemInfo("stocks.scrapQty"));
        sic.add(new SelectorItemInfo("stocks.materialScrapQty"));
        sic.add(new SelectorItemInfo("stocks.material.id"));
        sic.add(new SelectorItemInfo("stocks.unit.id"));
        sic.add(new SelectorItemInfo("stocks.issueMode"));
        sic.add(new SelectorItemInfo("stocks.isBackflush"));
        sic.add(new SelectorItemInfo("technics.id"));
        sic.add(new SelectorItemInfo("technics.isReportPoint"));
        sic.add(new SelectorItemInfo("technics.passQty"));
        sic.add(new SelectorItemInfo("technics.concessionQty"));
        sic.add(new SelectorItemInfo("technics.finishedQty"));
        sic.add(new SelectorItemInfo("technics.totalQtyLower"));
        sic.add(new SelectorItemInfo("technics.operationNo"));
        sic.add(new SelectorItemInfo("technics.scrapQty"));
        sic.add(new SelectorItemInfo("transactionType.id"));
        sic.add(new SelectorItemInfo("transactionType.finishedQty"));
        sic.add(new SelectorItemInfo("transactionType.isAutoFinish"));
        sic.add(new SelectorItemInfo("transactionType.isReachStoreQtyLLimit"));
        sic.add(new SelectorItemInfo("transactionType.isTotalPicking"));
        sic.add(new SelectorItemInfo("transactionType.totalPicking"));
        sic.add(new SelectorItemInfo("transactionType.isCompleteReport"));
        sic.add(new SelectorItemInfo("transactionType.isWPManagement"));
        return sic;
    }

    public static final boolean isFitQtyCheck(BigDecimal lastOPFinishedQty, ManufactureOrderInfo moInfo, int qtyPrecision) {
        Iterator moTechIt = moInfo.getTechnics().iterator();
        int lastOperNo = moInfo.getLastOperNo();
        while (moTechIt.hasNext()) {
            BigDecimal concessionQty;
            BigDecimal passQty;
            BigDecimal tempCompleteQty;
            ManufactureOrderTechnicsInfo moTechInfo = (ManufactureOrderTechnicsInfo)moTechIt.next();
            if (!moTechInfo.isIsReportPoint() || moTechInfo.getOperationNo() == lastOperNo || (tempCompleteQty = (passQty = moTechInfo.getPassQty()).add(concessionQty = moTechInfo.getConcessionQty()).setScale(qtyPrecision, 4)).compareTo(lastOPFinishedQty) >= 0) continue;
            return false;
        }
        return true;
    }

    public static final BigDecimal getLastOPFinishedQty(ManufactureOrderInfo moInfo, int qtyPrecision) {
        BigDecimal result = SCMConstant.BIGDECIMAL_ZERO;
        int lastOperNo = moInfo.getLastOperNo();
        Iterator moTechIt = moInfo.getTechnics().iterator();
        while (moTechIt.hasNext()) {
            ManufactureOrderTechnicsInfo moTechInfo = (ManufactureOrderTechnicsInfo)moTechIt.next();
            if (lastOperNo != moTechInfo.getOperationNo()) continue;
            BigDecimal totalQtyLower = moTechInfo.getTotalQtyLower();
            result = moTechInfo.getFinishedQty().multiply(SCMConstant.BIGDECIMAL_ONE.subtract(totalQtyLower.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 4, 4))).setScale(qtyPrecision, 4);
        }
        return result;
    }

    public static final BigDecimal getMOQty(ManufactureOrderInfo moInfo, int qtyPrecision) {
        return moInfo.getQty().subtract(moInfo.getTotalSplitQty()).setScale(qtyPrecision, 4);
    }

    public static final BigDecimal getLastOPCompleteQty(ManufactureOrderInfo moInfo, int qtyPrecision) {
        BigDecimal result = SCMConstant.BIGDECIMAL_ZERO;
        int lastOperNo = moInfo.getLastOperNo();
        Iterator moTechIt = moInfo.getTechnics().iterator();
        while (moTechIt.hasNext()) {
            ManufactureOrderTechnicsInfo moTechInfo = (ManufactureOrderTechnicsInfo)moTechIt.next();
            if (lastOperNo != moTechInfo.getOperationNo()) continue;
            result = moTechInfo.getPassQty().add(moTechInfo.getConcessionQty()).add(moTechInfo.getScrapQty()).setScale(qtyPrecision, 4);
        }
        return result;
    }

    public static final boolean isFitTotalPicking(ManufactureOrderInfo moInfo, ManufactureOrderStockInfo moStockInfo, BigDecimal lastOPCompleteQty, BigDecimal moQty, int stock_qtyPrecision) {
        BigDecimal plannedQty = moStockInfo.getPlannedQty();
        BigDecimal lackRatio = moStockInfo.getLackRatio();
        BigDecimal actIssueQty = moStockInfo.getActIssueQty();
        BigDecimal rejectedQty = moStockInfo.getRejectedQty();
        BigDecimal feedingQty = moStockInfo.getFeedingQty();
        BigDecimal materialFeedingQty = moStockInfo.getMaterialFeedingQty();
        BigDecimal stock_scrapQty = moStockInfo.getScrapQty();
        BigDecimal materialScrapQty = moStockInfo.getMaterialScrapQty();
        BigDecimal requireQty = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal toStroreQty = moInfo.getToStroreQty();
        requireQty = moInfo.getTransactionType().isIsWPManagement() ? lastOPCompleteQty.multiply(plannedQty).multiply(SCMConstant.BIGDECIMAL_ONE.subtract(lackRatio.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 4, 4))).divide(moQty, 8, 4).setScale(stock_qtyPrecision, 4) : toStroreQty.multiply(plannedQty).multiply(SCMConstant.BIGDECIMAL_ONE.subtract(lackRatio.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 4, 4))).divide(moQty, 8, 4).setScale(stock_qtyPrecision, 4);
        BigDecimal acturePickingQty = actIssueQty.subtract(rejectedQty).add(feedingQty).add(materialFeedingQty).subtract(stock_scrapQty).subtract(materialScrapQty).setScale(stock_qtyPrecision, 4);
        return requireQty.compareTo(acturePickingQty) <= 0;
    }

    public static final ManufactureOrderStockCollection checkIssueMode(ManufactureOrderStockCollection moStockCol, boolean isIgnoreBackflush) {
        ManufactureOrderStockCollection resultCol = new ManufactureOrderStockCollection();
        Iterator moStockIt = moStockCol.iterator();
        while (moStockIt.hasNext()) {
            ManufactureOrderStockInfo moStockInfo = (ManufactureOrderStockInfo)moStockIt.next();
            if (isIgnoreBackflush) {
                if (moStockInfo.getIssueMode() == MaterialIssueModeEnum.NOTISSMODE || moStockInfo.isIsBackflush()) continue;
                resultCol.add(moStockInfo);
                continue;
            }
            if (moStockInfo.getIssueMode() == MaterialIssueModeEnum.NOTISSMODE) continue;
            resultCol.add(moStockInfo);
        }
        return resultCol;
    }

    public static final ManufactureOrderStockCollection checkTotalPicking(String sou, ManufactureOrderStockCollection moStockCol, PickingEnum totalPicking, Map isKeyPartMap) {
        ManufactureOrderStockCollection resultCol = new ManufactureOrderStockCollection();
        Iterator moStockIt = moStockCol.iterator();
        if (totalPicking == PickingEnum.AllPicking) {
            return moStockCol;
        }
        if (totalPicking == PickingEnum.KeyPicking) {
            while (moStockIt.hasNext()) {
                ManufactureOrderStockInfo moStockInfo = (ManufactureOrderStockInfo)moStockIt.next();
                if (!((Boolean)isKeyPartMap.get(sou + moStockInfo.getMaterial().getId().toString())).booleanValue()) continue;
                resultCol.add(moStockInfo);
            }
        }
        return resultCol;
    }
}

