/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.DBBatchUtil;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class MOCostObjectUtil {
    private static int NONE = 0;
    private static int BY_LOT = 1;
    private static int BY_ORDER = 2;

    public static void removeCostObject(Context ctx, String idStr) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setSelector(MOCostObjectUtil.getOrderSic());
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        viewInfo.setFilter(filterInfo);
        ManufactureOrderCollection manuColl = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(viewInfo);
        HashSet<String> coIds = new HashSet<String>();
        ArrayList<String> removeIds = new ArrayList<String>();
        ManufactureOrderInfo manuInfo = null;
        CostObjectInfo co = null;
        String paramValue = null;
        for (int i = 0; i < manuColl.size(); ++i) {
            manuInfo = manuColl.get(i);
            if (manuInfo == null || manuInfo.getStorageOrgUnit() == null || (paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)manuInfo.getStorageOrgUnit().getId().toString())), (String)"AutoGenLotCost")) == null || !"true".equals(paramValue) || (co = manuInfo.getCostObject()) == null || !EqualsUtil.equals((IntEnum)co.getCalculateMode(), (IntEnum)CalculateModeEnum.BYORDER) && !EqualsUtil.equals((IntEnum)co.getCalculateMode(), (IntEnum)CalculateModeEnum.BYBATCH)) continue;
            coIds.add(manuInfo.getCostObject().getId().toString());
            removeIds.add(manuInfo.getId().toString());
        }
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuffer updateSql = new StringBuffer();
        if (removeIds.size() > 0) {
            String[] remIds = new String[removeIds.size()];
            String remStr = SQLUtil.arrayToString((Object[])removeIds.toArray(remIds));
            updateSql.append("update T_MM_ManufactureOrder set FCostObjectID = null ").append("where fid in (").append(remStr).append(")");
            sqls.add(updateSql.toString());
        }
        if (sqls.size() > 0) {
            DBBatchUtil.executeBatch((Context)ctx, sqls);
        }
        if (coIds.size() > 0) {
            CostObjectFactory.getLocalInstance((Context)ctx).deleteAfterOrderUnReleased(coIds);
        }
    }

    private static void resolveOutputCostObject(Context ctx, Set paramOrderIds, StringBuffer updateSql, Set coIds) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setSelector(MOCostObjectUtil.getOutputSic());
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)paramOrderIds, CompareType.INCLUDE));
        HashSet<Integer> calculateModes = new HashSet<Integer>();
        calculateModes.add(new Integer(4));
        filterInfo.getFilterItems().add(new FilterItemInfo("costObect.calculateMode", calculateModes, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        ManufactureOrderExpectOutputCollection outCol = ManufactureOrderExpectOutputFactory.getLocalInstance(ctx).getManufactureOrderExpectOutputCollection(viewInfo);
        ArrayList<String> removeIds = new ArrayList<String>();
        ManufactureOrderExpectOutputInfo outputInfo = null;
        for (int i = 0; i < outCol.size(); ++i) {
            outputInfo = outCol.get(i);
            if (outputInfo.getCostObect() == null) continue;
            coIds.add(outputInfo.getCostObect().getId().toString());
            removeIds.add(outputInfo.getId().toString());
        }
        if (removeIds.size() > 0) {
            String[] remIds = new String[removeIds.size()];
            String remStr = SQLUtil.arrayToString((Object[])removeIds.toArray(remIds));
            if (updateSql != null) {
                updateSql.append("update T_MM_MFTOrderExpectOutput set FCostObjectID = null ").append("where fid in (").append(remStr).append(")");
            }
        }
    }

    public static void updateCostObject(Context ctx, Set orderSet) throws BOSException, EASBizException {
        ManufactureOrderCollection orderCollection = null;
        IManufactureOrder order = ManufactureOrderFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orderSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        orderCollection = order.getManufactureOrderCollection(ev);
        Connection con = null;
        PreparedStatement batchStatementOrder = null;
        try {
            StringBuffer updateSql = new StringBuffer();
            con = EJBFactory.getConnection((Context)ctx);
            updateSql.append("update T_MM_ManufactureOrder set FCostObjectID=? where fid=?");
            batchStatementOrder = con.prepareStatement(updateSql.toString());
            ManufactureOrderInfo mo = null;
            MaterialInfo materialInfo = null;
            StorageOrgUnitInfo storageOrgUnit = null;
            boolean isUpdate = false;
            CostObjectInfo costObjectInfo = null;
            for (int i = 0; i < orderCollection.size(); ++i) {
                mo = (ManufactureOrderInfo)orderCollection.getObject(i);
                if (mo.getCostObject() != null || (costObjectInfo = MOCostObjectUtil.getCostObject(ctx, materialInfo = mo.getMaterial(), storageOrgUnit = mo.getStorageOrgUnit(), mo.getLot(), mo.getId().toString(), true, true)) == null) continue;
                batchStatementOrder.setString(1, costObjectInfo.getId().toString());
                batchStatementOrder.setString(2, mo.getId().toString());
                batchStatementOrder.addBatch();
                isUpdate = true;
            }
            if (isUpdate) {
                batchStatementOrder.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatementOrder, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatementOrder, (Connection)con);
    }

    public static void updateOutputCostObject(Context ctx, Set orderSet) throws BOSException, EASBizException {
        ManufactureOrderExpectOutputCollection outCol = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)orderSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(MOCostObjectUtil.getOutputSic());
        outCol = ManufactureOrderExpectOutputFactory.getLocalInstance(ctx).getManufactureOrderExpectOutputCollection(ev);
        Connection con = null;
        PreparedStatement batchStatementOrder = null;
        try {
            StringBuffer updateSql = new StringBuffer();
            con = EJBFactory.getConnection((Context)ctx);
            updateSql.append("update T_MM_MFTOrderExpectOutput set FCostObjectID=? where fid=?");
            batchStatementOrder = con.prepareStatement(updateSql.toString());
            ManufactureOrderExpectOutputInfo output = null;
            MaterialInfo materialInfo = null;
            StorageOrgUnitInfo storageOrgUnit = null;
            boolean isUpdate = false;
            CostObjectInfo costObjectInfo = null;
            for (int i = 0; i < outCol.size(); ++i) {
                output = (ManufactureOrderExpectOutputInfo)outCol.getObject(i);
                if (output.getCostObect() != null || (costObjectInfo = MOCostObjectUtil.getCostObject(ctx, materialInfo = output.getMaterial(), storageOrgUnit = output.getParent().getStorageOrgUnit(), output.getParent().getLot(), output.getParent().getId().toString(), true, false)) == null) continue;
                batchStatementOrder.setString(1, costObjectInfo.getId().toString());
                batchStatementOrder.setString(2, output.getId().toString());
                batchStatementOrder.addBatch();
                isUpdate = true;
            }
            if (isUpdate) {
                batchStatementOrder.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatementOrder, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatementOrder, (Connection)con);
    }

    public static CostObjectInfo getCostObject(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnit, String lot, String moid, boolean isNeedGen, boolean isHead) throws EASBizException, BOSException {
        if (materialInfo == null || storageOrgUnit == null) {
            return null;
        }
        OrgUnitCollection companys = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(storageOrgUnit.getId().toString(), 4, 1);
        CompanyOrgUnitInfo company = null;
        if (companys != null && companys.size() > 0) {
            company = (CompanyOrgUnitInfo)companys.get(0);
        }
        if (company == null) {
            return null;
        }
        CostObjectInfo costObjectInfo = null;
        int genCOType = MOCostObjectUtil.getGenCOType(ctx, materialInfo.getId().toString(), company.getId().toString(), isHead);
        if (genCOType == NONE) {
            costObjectInfo = MOCostObjectUtil.getDefaultCostObject(ctx, company.getId().toString(), materialInfo.getId().toString());
        } else if (isNeedGen) {
            ICostObject icostObject = CostObjectFactory.getLocalInstance((Context)ctx);
            String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnit.getId().toString())), (String)"AutoGenLotCost");
            costObjectInfo = icostObject.getCostObjectByMaterialLotAndOrder(company.getId().toString(), materialInfo.getId().toString(), lot, moid);
            if (costObjectInfo == null && paramValue != null && paramValue.equals("true")) {
                CostObjectCollection cols = new CostObjectCollection();
                CostObjectInfo newCostObjectInfo = new CostObjectInfo();
                newCostObjectInfo.setCompany(company);
                newCostObjectInfo.setRelatedId(materialInfo.getId());
                newCostObjectInfo.setBatchNumber(lot);
                newCostObjectInfo.setStdProductID(materialInfo);
                newCostObjectInfo.setOrderID(moid);
                cols.add(newCostObjectInfo);
                icostObject.addnewBybatch((IObjectCollection)cols);
                costObjectInfo = icostObject.getCostObjectByMaterialLotAndOrder(company.getId().toString(), materialInfo.getId().toString(), lot, moid);
            }
        }
        return costObjectInfo;
    }

    public static CostObjectInfo getCostObjectByMaterialLotAndOrder(Context ctx, int genCOType, String companyID, String materialID, String lot, String orderID) throws BOSException {
        CostObjectInfo co = null;
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        try {
            if (genCOType == BY_ORDER) {
                if (orderID == null || orderID.length() == 0) {
                    return null;
                }
                sql.setLength(0);
                sql.append("select co.FID,CO.FNUMBER,CO.FNAME_" + ctx.getLocale() + " \n");
                sql.append("from T_BD_CostObject co left join T_BD_CostObjectEntry coe on coe.FparentID = co.Fid \n");
                sql.append("where coe.FRelatedID = ? ");
                sql.append("and co.FOrderID = ? ");
                sql.append("and co.FCompanyID = ? ");
                sql.append("and co.FIsForbiden = 0 \n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID, orderID, companyID});
                if (rs.next()) {
                    co = new CostObjectInfo();
                    co.setId(BOSUuid.read((String)rs.getString(1)));
                    co.setNumber(rs.getString(2));
                    co.setName(rs.getString(3));
                }
            } else if (genCOType == BY_LOT) {
                sql.setLength(0);
                sql.append("select co.FID,CO.FNUMBER,CO.FNAME_" + ctx.getLocale() + " \n");
                sql.append("from T_BD_CostObject co left join T_BD_CostObjectEntry coe on coe.FparentID = co.Fid \n");
                sql.append("where coe.FRelatedID = ? \n");
                sql.append("and co.FCompanyID = ? \n");
                sql.append("and FCalculateMode = 4 \n");
                sql.append("and co.FIsForbiden = 0 \n");
                if (lot != null && lot.length() > 0) {
                    sql.append("and FBatchNumber = '" + lot + "' \n");
                } else {
                    sql.append("and FBatchNumber is null ");
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID, companyID});
                if (rs.next()) {
                    co = new CostObjectInfo();
                    co.setId(BOSUuid.read((String)rs.getString(1)));
                    co.setNumber(rs.getString(2));
                    co.setName(rs.getString(3));
                }
            } else {
                co = MOCostObjectUtil.getDefaultCostObject(ctx, companyID, materialID);
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return co;
    }

    public static CostObjectInfo getDefaultCostObject(Context ctx, String companyID, String materialID) throws BOSException {
        if (companyID == null || materialID == null) {
            return null;
        }
        CostObjectInfo co = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select bill.FID, bill.FNUMBER, bill.FNAME_" + ctx.getLocale());
        sql.append(" from T_BD_CostObject bill");
        sql.append(" inner join T_BD_CostObjectEntry entry");
        sql.append(" on bill.fid=entry.fparentid");
        sql.append(" where bill.FIsForbiden =0 and bill.FCompanyID=? and entry.FRelatedID=?");
        sql.append(" and bill.FBatchNumber is null ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyID, materialID});
        try {
            if (rs.next()) {
                co = new CostObjectInfo();
                co.setId(BOSUuid.read((String)rs.getString(1)));
                co.setNumber(rs.getString(2));
                co.setName(rs.getString(3));
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return co;
    }

    public static int getGenCOType(Context ctx, String materialID, String companyID, boolean isHead) throws BOSException {
        int flag = NONE;
        if (companyID == null || materialID == null || !isHead) {
            return flag;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT mateial.Id, mateial.number, mateial.name, mateial.status, status, accountType,calculateType,createCOByOrder ").append(" WHERE mateial.Id = '").append(materialID).append("' ").append(" AND mateial.status = '1' AND status = '1' ").append(" AND company.Id = '").append(companyID).append("'");
        MaterialCompanyInfoCollection mciColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(sql.toString());
        MaterialCompanyInfoInfo companyInfo = null;
        if (mciColl != null && mciColl.size() > 0) {
            companyInfo = mciColl.get(0);
        }
        if (companyInfo != null) {
            if (companyInfo.isCreateCOByOrder()) {
                flag = BY_ORDER;
            } else if (companyInfo.getCalculateType().getValue() == 2 && companyInfo.getAccountType().getValue() == 5) {
                flag = BY_LOT;
            }
        }
        return flag;
    }

    public static SelectorItemCollection getOrderSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("costObject.id"));
        sic.add(new SelectorItemInfo("costObject.number"));
        sic.add(new SelectorItemInfo("costObject.name"));
        sic.add(new SelectorItemInfo("costObject.calculateMode"));
        return sic;
    }

    public static SelectorItemCollection getOutputSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("parent.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("parent.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("parent.lot"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("costObect.id"));
        sic.add(new SelectorItemInfo("costObect.number"));
        sic.add(new SelectorItemInfo("costObect.name"));
        sic.add(new SelectorItemInfo("costObect.calculateMode"));
        return sic;
    }
}

