/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.app.util.MOMaterialInfoUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class MOMultiMeasureUnitUtil {
    public static Map<String, Integer> getMultiMeasureUnit(Context ctx, ManufactureOrderCollection moCol, String tempTable) throws BOSException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (MOMaterialInfoUtil.isNullCol((IObjectCollection)moCol)) {
            return result;
        }
        StringBuffer getMultiUnitSql = new StringBuffer();
        getMultiUnitSql.append("select u.fmaterialid,u.fMeasureUnitid,u.fqtyPrecision from T_BD_MultiMeasureUnit u inner join ");
        getMultiUnitSql.append(tempTable).append(" t on u.fmaterialid = t.fmaterialid and u.fMeasureUnitid = t.FUnitID where t.ftype = 1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getMultiUnitSql.toString());
        try {
            while (rowSet.next()) {
                String materialID = rowSet.getString("fmaterialid");
                String unitID = rowSet.getString("fMeasureUnitid");
                int pre = rowSet.getInt("fqtyPrecision");
                result.put(materialID + unitID, new Integer(pre));
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return result;
    }

    public static BigDecimal getConvertRate(Context ctx, String fromItemID, String fromUnitID, String toItemID, String toUnitID) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer(512);
        sqlBuffer.append("select m.FID, m.FNumber as ItemCode, ").append("  m.FBaseUnit, ").append("  u.FCoefficient, ").append("  u.FQtyPrecision, ").append("  u.FGroupID, ").append("  mu.FBaseConvsRate, ").append("  mu.FQtyPrecision, ").append("  pu.FNumber as UnitCode ").append("from T_BD_Material m ").append("  left join T_BD_MeasureUnit u ").append("    on m.FBaseUnit=u.FID ").append("  left join T_BD_MultiMeasureUnit mu ").append("    on mu.FMaterialID=m.FID ").append("       and mu.FMeasureUnitID=? ").append("  left join T_BD_MeasureUnit pu ").append("    on mu.FMeasureUnitID=pu.FID ").append("where m.FID=? ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        paramsList.add(new Object[]{fromUnitID, fromItemID});
        paramsList.add(new Object[]{toUnitID, toItemID});
        String FBaseUnit = "";
        String TBaseUnit = "";
        String FGroupID = "";
        String TGroupID = "";
        String FItemCode = "";
        String TItemCode = "";
        String FUnitCode = "";
        String TUnitCode = "";
        BigDecimal FCoefficient = new BigDecimal("1.00");
        BigDecimal TCoefficient = new BigDecimal("1.00");
        BigDecimal FBaseConvsRate = new BigDecimal("1.00");
        BigDecimal TBaseConvsRate = new BigDecimal("1.00");
        IRowSet fromRS = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{fromUnitID, fromItemID});
        try {
            if (fromRS != null && fromRS.next()) {
                FBaseUnit = fromRS.getString("FBaseUnit");
                FGroupID = fromRS.getString("FGroupID");
                FItemCode = fromRS.getString("ItemCode");
                FUnitCode = fromRS.getString("UnitCode");
                FCoefficient = fromRS.getBigDecimal("FCoefficient");
                FBaseConvsRate = fromRS.getBigDecimal("FBaseConvsRate");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        IRowSet toRS = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{toUnitID, toItemID});
        try {
            if (toRS != null && toRS.next()) {
                TBaseUnit = toRS.getString("FBaseUnit");
                TGroupID = toRS.getString("FGroupID");
                TItemCode = toRS.getString("ItemCode");
                TUnitCode = toRS.getString("UnitCode");
                TCoefficient = toRS.getBigDecimal("FCoefficient");
                TBaseConvsRate = toRS.getBigDecimal("FBaseConvsRate");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (fromUnitID.equals(toUnitID) && FBaseUnit.equals(TBaseUnit)) {
            return new BigDecimal("1.00");
        }
        if (!FGroupID.equals(TGroupID)) {
            String errorMsg = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"UNITGROUP_NOT_SAME", (String[])new String[]{FItemCode, FUnitCode, TItemCode, TUnitCode});
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{errorMsg});
        }
        return FBaseConvsRate.multiply(FCoefficient).divide(TBaseConvsRate.multiply(TCoefficient), 8, 4);
    }
}

