/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.verify.AbstractMMVerifyItem;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.util.MOMaterialInfoUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import java.math.BigDecimal;
import java.util.Map;

public class MOAutoCloseDefaultVerifyItem
extends AbstractMMVerifyItem {
    private ManufactureOrderCollection manufactureOrderColection = null;
    private Map multiMeasureUnitMap = null;
    public static final String CanNotClose_StroreQtyLessLackLowerLimit = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"CanNotClose_StroreQtyLessLackLowerLimit");
    public static final String CanNotClose_NotMatchStroreQty = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"CanNotClose_NotMatchStroreQty");
    public static final String CanNotClose_NotMatchStroreQtyinPASS_CON_SCRAP_VALUE = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"CanNotClose_NotMatchStroreQtyinPASS_CON_SCRAP_VALUE");

    protected void init(Context ctx, Map paramMap) throws EASBizException, BOSException {
        if (paramMap.get("manufactureOrderColection") != null && paramMap.get("multiMeasureUnitMap") != null) {
            this.manufactureOrderColection = (ManufactureOrderCollection)((Object)paramMap.get("manufactureOrderColection"));
            this.multiMeasureUnitMap = (Map)paramMap.get("multiMeasureUnitMap");
        }
    }

    public boolean verify(BatchActionResults batchResults) throws EASBizException, BOSException {
        boolean result = true;
        if (MOMaterialInfoUtil.isNullCol((IObjectCollection)this.manufactureOrderColection)) {
            return result;
        }
        for (int i = this.manufactureOrderColection.size() - 1; i >= 0; --i) {
            ManufactureOrderInfo moInfo = this.manufactureOrderColection.get(i);
            if (moInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.RELEASED)) {
                if (this.isPassReleasedCheck(moInfo)) continue;
                result = false;
                batchResults.addError(moInfo.getId().toString(), CanNotClose_StroreQtyLessLackLowerLimit);
                this.manufactureOrderColection.remove(moInfo);
                continue;
            }
            if (!moInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.COMPLETE) || this.isPassCompleteCheck(moInfo)) continue;
            result = false;
            batchResults.addError(moInfo.getId().toString(), CanNotClose_NotMatchStroreQtyinPASS_CON_SCRAP_VALUE);
            this.manufactureOrderColection.remove(moInfo);
        }
        return result;
    }

    private boolean isPassReleasedCheck(ManufactureOrderInfo moInfo) {
        return moInfo.getToStroreQty().compareTo(moInfo.getLackLowerLimit()) >= 0;
    }

    private boolean isPassCompleteCheck(ManufactureOrderInfo moInfo) {
        int qtyPrecision = (Integer)this.multiMeasureUnitMap.get(moInfo.getMaterial().getId().toString() + moInfo.getUnit().getId().toString());
        BigDecimal passQty = moInfo.getPassQty();
        BigDecimal concessionQty = moInfo.getConcessionQty();
        BigDecimal scrapQty = moInfo.getScrapQty();
        BigDecimal toStroreQty = moInfo.getToStroreQty();
        return passQty.add(concessionQty).add(scrapQty).setScale(qtyPrecision, 4).compareTo(toStroreQty) == 0;
    }
}

