/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.FinishedQtyEnum;
import com.kingdee.eas.mm.common.app.verify.AbstractMMVerifyItem;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.util.MOMaterialInfoUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import java.math.BigDecimal;
import java.util.Map;

public class MOAutoFinishDefaultVerifyItem
extends AbstractMMVerifyItem {
    private ManufactureOrderCollection manufactureOrderColection = null;
    private Map multiMeasureUnitMap = null;
    public static final String CanNotFinishi_NotMeetDefautCondition = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"CanNotFinishi_NotMeetDefautCondition");
    public static final String ProductTransactionNotWPManagement = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"ProductTransactionNotWPManagement");
    public static final String NotAutoFinish = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"NotAutoFinish");

    protected void init(Context ctx, Map paramMap) throws EASBizException, BOSException {
        if (paramMap.get("manufactureOrderColection") != null && paramMap.get("multiMeasureUnitMap") != null) {
            this.manufactureOrderColection = (ManufactureOrderCollection)((Object)paramMap.get("manufactureOrderColection"));
            this.multiMeasureUnitMap = (Map)paramMap.get("multiMeasureUnitMap");
        }
    }

    public boolean verify(BatchActionResults batchResults) throws EASBizException, BOSException {
        boolean result = true;
        if (MOMaterialInfoUtil.isNullCol((IObjectCollection)this.manufactureOrderColection)) {
            return result;
        }
        for (int i = this.manufactureOrderColection.size() - 1; i >= 0; --i) {
            ManufactureOrderInfo moInfo = this.manufactureOrderColection.get(i);
            if (!moInfo.getTransactionType().isIsWPManagement()) {
                batchResults.addError(moInfo.getId().toString(), ProductTransactionNotWPManagement);
                result = false;
                this.manufactureOrderColection.remove(moInfo);
                continue;
            }
            if (!moInfo.getTransactionType().isIsAutoFinish()) {
                batchResults.addError(moInfo.getId().toString(), NotAutoFinish);
                result = false;
                this.manufactureOrderColection.remove(moInfo);
                continue;
            }
            if (!moInfo.getTransactionType().isIsReachStoreQtyLLimit() || this.isFitDefaultCondition(moInfo)) continue;
            batchResults.addError(moInfo.getId().toString(), CanNotFinishi_NotMeetDefautCondition);
            result = false;
            this.manufactureOrderColection.remove(moInfo);
        }
        return result;
    }

    private boolean isFitDefaultCondition(ManufactureOrderInfo moInfo) {
        int qtyPrecision = (Integer)this.multiMeasureUnitMap.get(moInfo.getMaterial().getId().toString() + moInfo.getUnit().getId().toString());
        BigDecimal passQty = moInfo.getPassQty();
        BigDecimal concessionQty = moInfo.getConcessionQty();
        BigDecimal scrapQty = moInfo.getScrapQty();
        BigDecimal deliveryQty = moInfo.getDeliveryQty().setScale(qtyPrecision, 4);
        BigDecimal completionQty = SCMConstant.BIGDECIMAL_ZERO;
        if (moInfo.getTransactionType().getFinishedQty() == FinishedQtyEnum.PASS_CON_SCRAP) {
            completionQty = passQty.add(concessionQty).add(scrapQty).setScale(qtyPrecision, 4);
        } else if (moInfo.getTransactionType().getFinishedQty() == FinishedQtyEnum.PASS_CON) {
            completionQty = passQty.add(concessionQty).setScale(qtyPrecision, 4);
        }
        return completionQty.compareTo(deliveryQty) >= 0;
    }
}

