/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.verify.AbstractMMVerifyItem;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.util.MOMaterialInfoUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import java.util.Map;

public class MOCloseStatusVerifyItem
extends AbstractMMVerifyItem {
    private ManufactureOrderCollection manufactureOrderColection = null;
    public static final String CanNotClose_NotReleaseOrComplete = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"CanNotClose_NotReleaseOrComplete");
    public static final String CanNotClose_PTIsWPManagement = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"CanNotClose_PTIsWPManagement");
    public static final String CanNotClose_PTIsNotWPManagement = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"CanNotClose_PTIsNotWPManagement");

    protected void init(Context ctx, Map paramMap) throws EASBizException, BOSException {
        if (paramMap.get("manufactureOrderColection") != null) {
            this.manufactureOrderColection = (ManufactureOrderCollection)((Object)paramMap.get("manufactureOrderColection"));
        }
    }

    public boolean verify(BatchActionResults batchResults) throws EASBizException, BOSException {
        boolean result = true;
        if (MOMaterialInfoUtil.isNullCol((IObjectCollection)this.manufactureOrderColection)) {
            return result;
        }
        for (int i = this.manufactureOrderColection.size() - 1; i >= 0; --i) {
            ManufactureOrderInfo moInfo = this.manufactureOrderColection.get(i);
            if (!moInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.RELEASED) && !moInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.COMPLETE)) {
                result = false;
                batchResults.addError(moInfo.getId().toString(), CanNotClose_NotReleaseOrComplete);
                this.manufactureOrderColection.remove(moInfo);
                continue;
            }
            if (moInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.RELEASED)) {
                if (!moInfo.getTransactionType().isIsWPManagement()) continue;
                result = false;
                batchResults.addError(moInfo.getId().toString(), CanNotClose_PTIsWPManagement);
                this.manufactureOrderColection.remove(moInfo);
                continue;
            }
            if (!moInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.COMPLETE) || moInfo.getTransactionType().isIsWPManagement()) continue;
            result = false;
            batchResults.addError(moInfo.getId().toString(), CanNotClose_PTIsNotWPManagement);
            this.manufactureOrderColection.remove(moInfo);
        }
        return result;
    }
}

