/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.verify.AbstractMMVerifyItem;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.util.MOMaterialInfoUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Map;

public class MODownStreamAuditVerifyItem
extends AbstractMMVerifyItem {
    private ManufactureOrderCollection manufactureOrderColection = null;
    private Context ctx = null;
    public static final String OrderHasAuditDest = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"OrderHasAuditDest");

    protected void init(Context ctx, Map paramMap) throws EASBizException, BOSException {
        this.ctx = ctx;
        if (paramMap.get("manufactureOrderColection") != null) {
            this.manufactureOrderColection = (ManufactureOrderCollection)((Object)paramMap.get("manufactureOrderColection"));
        }
    }

    public boolean verify(BatchActionResults batchResults) throws EASBizException, BOSException {
        boolean result = true;
        if (MOMaterialInfoUtil.isNullCol((IObjectCollection)this.manufactureOrderColection)) {
            return result;
        }
        for (int i = this.manufactureOrderColection.size() - 1; i >= 0; --i) {
            ManufactureOrderInfo moInfo = this.manufactureOrderColection.get(i);
            if (!this.isHaveUnAuditDownSream(moInfo)) continue;
            result = false;
            batchResults.addError(moInfo.getId().toString(), OrderHasAuditDest);
            this.manufactureOrderColection.remove(moInfo);
        }
        return result;
    }

    private boolean isHaveUnAuditDownSream(ManufactureOrderInfo moInfo) throws BOSException {
        boolean result = false;
        try {
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)this.ctx);
            BOTRelationCollection botcoll = iBTPManager.getDestRelation(moInfo.getId().toString());
            BOSObjectType srcType = null;
            IMetaDataLoader imd = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
            for (int j = 0; j < botcoll.size(); ++j) {
                BOTRelationInfo botInfo = botcoll.get(j);
                String destEntityid = botInfo.getDestEntityID();
                String destObjectid = botInfo.getDestObjectID();
                srcType = BOSObjectType.create((String)destEntityid);
                EntityObjectInfo entity = imd.getEntity(srcType);
                if (!this.hasUnAuditDownBill(entity.getTable().getName(), destObjectid)) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private boolean hasUnAuditDownBill(String tableName, String destObjectid) throws BOSException, SQLException {
        String sql = "";
        sql = tableName.toUpperCase().indexOf("QM") != -1 ? " select FBillStatus from " + tableName + " where FBillStatus < 30 and fid='" + destObjectid + "'" : (tableName.toUpperCase().indexOf("SCOUTHANDOVER") != -1 ? " select cfstatus from " + tableName + " where cfstatus < 4 and fid='" + destObjectid + "'" : " select Fbasestatus from " + tableName + " where fbasestatus < " + 4 + " and fid='" + destObjectid + "'");
        IRowSet resultSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        return resultSet.next();
    }
}

