/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.verify.AbstractMMVerifyItem;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import java.util.Iterator;
import java.util.Map;

public class MOIsCanCloseVerifyItem
extends AbstractMMVerifyItem {
    private ManufactureOrderCollection manufactureOrderColection = null;
    private BatchActionEnum batchActionEnum = null;
    public static final String msg_unaudit = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ScrapOrderResource", (String)"Unaudit_Order_Is_Closed");
    public static final String msg_audit = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ScrapOrderResource", (String)"Audit_Order_Is_Closed");
    public static final String CanNotModify = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"CanNotModify");

    public boolean verify(BatchActionResults batchResults) throws EASBizException, BOSException {
        ManufactureOrderInfo moInfo;
        boolean result = true;
        Iterator it = this.manufactureOrderColection.iterator();
        if (it.hasNext() && ((moInfo = (ManufactureOrderInfo)it.next()).getBaseStatus() == BillBaseStatusEnum.BLOCKED || moInfo.getBaseStatus() == BillBaseStatusEnum.CLOSED || moInfo.getBaseStatus() == BillBaseStatusEnum.FINCLOSED)) {
            result = false;
            if (this.batchActionEnum == BatchActionEnum.AUDIT) {
                batchResults.addError(moInfo.getId().toString(), msg_audit);
            } else if (this.batchActionEnum == BatchActionEnum.UNAUDIT) {
                batchResults.addError(moInfo.getId().toString(), msg_unaudit);
            } else {
                batchResults.addError(moInfo.getId().toString(), CanNotModify);
            }
        }
        return result;
    }

    protected void init(Context ctx, Map paramMap) throws EASBizException, BOSException {
        if (paramMap.containsKey("manufactureOrderColection") && paramMap.containsKey("batchActionEnum")) {
            this.batchActionEnum = (BatchActionEnum)paramMap.get("batchActionEnum");
            this.manufactureOrderColection = (ManufactureOrderCollection)((Object)paramMap.get("manufactureOrderColection"));
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)this.allToDoIdsSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            evi.setSelector(this.getDefaultSelector());
            this.manufactureOrderColection = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(evi);
        }
    }

    private SelectorItemCollection getDefaultSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        return sic;
    }
}

