/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.verify.AbstractMMVerifyItem;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.app.util.MOAutoFinishUtil;
import com.kingdee.eas.mm.mo.app.util.MOMaterialInfoUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;

public class MOTotalPickingVerifyItem
extends AbstractMMVerifyItem {
    private ManufactureOrderCollection manufactureOrderColection = null;
    private Map multiMeasureUnitMap = null;
    private Map isKeyPartMap = null;
    private boolean isIgnoreBackflush = true;
    public static final String CanNotFinish_NotTotalPicking = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"CanNotFinish_NotTotalPicking");

    protected void init(Context ctx, Map paramMap) throws EASBizException, BOSException {
        if (paramMap.get("manufactureOrderColection") != null && paramMap.get("multiMeasureUnitMap") != null && paramMap.get("isKeyPartMap") != null && paramMap.get("isIgnoreBackflush") != null) {
            this.manufactureOrderColection = (ManufactureOrderCollection)((Object)paramMap.get("manufactureOrderColection"));
            this.multiMeasureUnitMap = (Map)paramMap.get("multiMeasureUnitMap");
            this.isKeyPartMap = (Map)paramMap.get("isKeyPartMap");
            this.isIgnoreBackflush = (Boolean)paramMap.get("isIgnoreBackflush");
        }
    }

    public boolean verify(BatchActionResults batchResults) throws EASBizException, BOSException {
        boolean result = true;
        if (MOMaterialInfoUtil.isNullCol((IObjectCollection)this.manufactureOrderColection)) {
            return result;
        }
        block0: for (int i = this.manufactureOrderColection.size() - 1; i >= 0; --i) {
            ManufactureOrderStockCollection moStockCol;
            ManufactureOrderInfo moInfo = this.manufactureOrderColection.get(i);
            if (!moInfo.getTransactionType().isIsAutoFinish() || !moInfo.getTransactionType().isIsTotalPicking() || MOMaterialInfoUtil.isNullCol((IObjectCollection)(moStockCol = moInfo.getStocks())) || MOMaterialInfoUtil.isNullCol((IObjectCollection)(moStockCol = MOAutoFinishUtil.checkTotalPicking(moInfo.getStorageOrgUnit().getId().toString(), moStockCol, moInfo.getTransactionType().getTotalPicking(), this.isKeyPartMap))) || MOMaterialInfoUtil.isNullCol((IObjectCollection)(moStockCol = MOAutoFinishUtil.checkIssueMode(moStockCol, this.isIgnoreBackflush)))) continue;
            int qtyPrecision = (Integer)this.multiMeasureUnitMap.get(moInfo.getMaterial().getId().toString() + moInfo.getUnit().getId().toString());
            BigDecimal lastOPCompleteQty = MOAutoFinishUtil.getLastOPCompleteQty(moInfo, qtyPrecision);
            BigDecimal moQty = MOAutoFinishUtil.getMOQty(moInfo, qtyPrecision);
            if (moQty.compareTo(SCMConstant.BIGDECIMAL_ZERO) <= 0) continue;
            Iterator moStockIt = moStockCol.iterator();
            while (moStockIt.hasNext()) {
                int stock_qtyPrecision;
                ManufactureOrderStockInfo moStockInfo = (ManufactureOrderStockInfo)moStockIt.next();
                if (MOAutoFinishUtil.isFitTotalPicking(moInfo, moStockInfo, lastOPCompleteQty, moQty, stock_qtyPrecision = ((Integer)this.multiMeasureUnitMap.get(moStockInfo.getMaterial().getId().toString() + moStockInfo.getUnit().getId().toString())).intValue())) continue;
                batchResults.addError(moInfo.getId().toString(), CanNotFinish_NotTotalPicking);
                result = false;
                this.manufactureOrderColection.remove(moInfo);
                continue block0;
            }
        }
        return result;
    }
}

