/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.IStandardRooting;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import java.util.HashMap;

public class MORootingUtil {
    public static final String DEFAULT_ROOTING_NUMBER = "-";
    public static final int DEFAULT_OPERNO = 999;

    public static boolean autoGenDefaultRooting(Context ctx, ManufactureOrderInfo mo, boolean isNeedCheck) throws EASBizException, BOSException {
        if (mo == null) {
            return false;
        }
        boolean isSuccess = true;
        if ((mo = MORootingUtil.genDefaultRooting(ctx, mo, isNeedCheck)).getRouting() == null && (mo.getTechnics() == null || mo.getTechnics().size() < 1)) {
            isSuccess = false;
        }
        return isSuccess;
    }

    public static boolean needAutoGenRooting(Context ctx, ManufactureOrderInfo mo, ProductTransactionTypeInfo transInfo, StandardRootingInfo rootingInfo) throws EASBizException, BOSException {
        if (mo == null) {
            return false;
        }
        boolean isNeedGen = false;
        ManufactureOrderTechnicsCollection technics = mo.getTechnics();
        if (rootingInfo == null) {
            rootingInfo = mo.getRouting();
        }
        if (transInfo == null && mo.getTransactionType() != null) {
            transInfo = mo.getTransactionType();
            transInfo = ProductTransactionTypeFactory.getLocalInstance((Context)ctx).getProductTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transInfo.getId().toString()), MORootingUtil.getSelectors4Transaction());
        }
        if (rootingInfo == null && (technics == null || technics.size() < 1) && transInfo != null && (transInfo.isIsWPManagement() && transInfo.isIsAutoGenerateWP() || !transInfo.isIsWPManagement())) {
            isNeedGen = true;
        }
        return isNeedGen;
    }

    public static ManufactureOrderInfo genDefaultRooting(Context ctx, ManufactureOrderInfo mo, boolean isNeedCheck) throws BOSException, EASBizException {
        StandardRootingInfo rootingInfo = MORootingUtil.getDefaultRooting(ctx, mo, isNeedCheck);
        MORootingUtil.genDefaultRooting(ctx, mo, rootingInfo);
        return mo;
    }

    public static boolean genDefaultRooting(Context ctx, ManufactureOrderInfo mo, StandardRootingInfo rootingInfo) throws BOSException, EASBizException {
        boolean isSuccess = true;
        if (mo != null && rootingInfo != null) {
            HashMap<String, Object> inParam = new HashMap<String, Object>();
            inParam.put("ROUTINGID", rootingInfo.getId().toString());
            inParam.put("STORAGEORG", mo.getStorageOrgUnit());
            inParam.put("BEGINTIME", mo.getPlanBeginDate());
            inParam.put("ENDTIME", mo.getPlanEndDate());
            inParam.put("BASEUNIT", mo.getBaseUnit());
            inParam.put("BILL_UNIT", mo.getUnit());
            inParam.put("BILL_QTY", mo.getQty());
            inParam.put("MATERIAL", mo.getMaterial());
            inParam.put("adminOrgUnit", mo.getAdminOrgUnit());
            ManufactureOrderTechnicsCollection techCol = ManufactureOrderFactory.getLocalInstance(ctx).routingExpand(inParam);
            mo.setRouting(rootingInfo);
            mo.put("technics", (Object)techCol);
        }
        if (rootingInfo == null && (mo.getTechnics() == null || mo.getTechnics().size() < 1)) {
            isSuccess = false;
        }
        return isSuccess;
    }

    public static StandardRootingInfo getDefaultRooting(Context ctx, ManufactureOrderInfo mo, boolean isNeedCheck) throws BOSException, EASBizException {
        if (mo == null || mo.getStorageOrgUnit() == null) {
            return null;
        }
        StandardRootingInfo routingInfo = mo.getRouting();
        boolean isNeedAutoGen = true;
        if (isNeedCheck) {
            isNeedAutoGen = MORootingUtil.needAutoGenRooting(ctx, mo, null, null);
        }
        if (isNeedAutoGen) {
            routingInfo = MORootingUtil.getDefaultRooting(ctx, mo.getStorageOrgUnit().getId().toString());
        }
        return routingInfo;
    }

    public static StandardRootingInfo getDefaultRooting(Context ctx, ProductTransactionTypeInfo transInfo, String orgID) throws BOSException, EASBizException {
        if (transInfo == null || orgID == null) {
            return null;
        }
        StandardRootingInfo routingInfo = null;
        if (transInfo.isIsWPManagement() && transInfo.isIsAutoGenerateWP() || !transInfo.isIsWPManagement()) {
            routingInfo = MORootingUtil.getDefaultRooting(ctx, orgID);
        }
        return routingInfo;
    }

    public static StandardRootingInfo getDefaultRooting(Context ctx, String orgID) throws BOSException {
        if (orgID == null) {
            return null;
        }
        StandardRootingInfo routingInfo = null;
        CoreBaseCollection col = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgID));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)DEFAULT_ROOTING_NUMBER));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(MORootingUtil.getSelectors4Routing());
        IStandardRooting iRoot = null;
        iRoot = ctx == null ? StandardRootingFactory.getRemoteInstance() : StandardRootingFactory.getLocalInstance((Context)ctx);
        col = iRoot.getCollection(viewInfo);
        if (col != null && col.size() > 0) {
            routingInfo = (StandardRootingInfo)col.get(0);
        }
        return routingInfo;
    }

    public static void setDefaultOprNo(ManufactureOrderInfo mo, StandardRootingInfo rootingInfo) {
        if (mo == null || rootingInfo == null || !DEFAULT_ROOTING_NUMBER.equals(rootingInfo.getNumber()) || mo.getTechnics() == null || mo.getTechnics().size() != 1) {
            return;
        }
        OperationInfo operInfo = mo.getTechnics().get(0).getOperation();
        int operNo = mo.getTechnics().get(0).getOperationNo();
        if (operNo == 999) {
            ManufactureOrderStockCollection stocks = mo.getStocks();
            ManufactureOrderStockInfo stock = null;
            int stockSize = stocks.size();
            for (int i = 0; i < stockSize; ++i) {
                stock = stocks.get(i);
                stock.setOperationNo(operNo);
                stock.setOperation(operInfo);
            }
            ManufactureOrderExpectOutputCollection outputs = mo.getExpectOutputs();
            ManufactureOrderExpectOutputInfo output = null;
            int outputSize = outputs.size();
            for (int i = 0; i < outputSize; ++i) {
                output = outputs.get(i);
                output.setOperationNo(operNo);
                output.setOperation(operInfo);
            }
        }
    }

    public static void setOprNo4Entry(ManufactureOrderInfo mo) {
        if (mo == null || mo.getTechnics() == null || mo.getTechnics().size() < 1) {
            return;
        }
        HashMap<Integer, OperationInfo> operMap = new HashMap<Integer, OperationInfo>();
        int firstOperNo = 0;
        OperationInfo firstOperInfo = null;
        int lastOperNo = 0;
        OperationInfo lastOperInfo = null;
        int operNo = 0;
        OperationInfo operInfo = null;
        int operNoEntry = 0;
        ManufactureOrderTechnicsCollection techs = mo.getTechnics();
        ManufactureOrderTechnicsInfo tech = null;
        int techSize = techs.size();
        for (int i = 0; i < techSize; ++i) {
            tech = techs.get(i);
            if (tech == null || tech.getOperation() == null) continue;
            operNo = tech.getOperationNo();
            operInfo = tech.getOperation();
            if (operInfo == null) continue;
            operMap.put(new Integer(operNo), operInfo);
            if (firstOperNo == 0 || firstOperNo > operNo) {
                firstOperNo = operNo;
                firstOperInfo = operInfo;
            }
            if (lastOperNo != 0 && lastOperNo >= operNo) continue;
            lastOperNo = operNo;
            lastOperInfo = operInfo;
        }
        ManufactureOrderStockCollection stocks = mo.getStocks();
        ManufactureOrderStockInfo stock = null;
        int stockSize = stocks.size();
        for (int i = 0; i < stockSize; ++i) {
            stock = stocks.get(i);
            if (stock == null) continue;
            operNoEntry = stock.getOperationNo();
            if (operMap.containsKey(new Integer(operNoEntry))) {
                stock.setOperation((OperationInfo)operMap.get(new Integer(operNoEntry)));
                continue;
            }
            if (firstOperInfo == null) continue;
            stock.setOperationNo(firstOperNo);
            stock.setOperation(firstOperInfo);
        }
        ManufactureOrderExpectOutputCollection outputs = mo.getExpectOutputs();
        ManufactureOrderExpectOutputInfo output = null;
        int outputSize = outputs.size();
        for (int i = 0; i < outputSize; ++i) {
            output = outputs.get(i);
            if (output == null) continue;
            operNoEntry = output.getOperationNo();
            if (operMap.containsKey(new Integer(operNoEntry))) {
                output.setOperation((OperationInfo)operMap.get(new Integer(operNoEntry)));
                continue;
            }
            if (lastOperInfo == null) continue;
            output.setOperationNo(lastOperNo);
            output.setOperation(lastOperInfo);
        }
    }

    public static SelectorItemCollection getSelectors4Routing() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }

    public static SelectorItemCollection getSelectors4Transaction() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isWPManagement"));
        sic.add(new SelectorItemInfo("isAutoGenerateWP"));
        return sic;
    }
}

