/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning;

import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.mm.planning.MMParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMGetParamBean;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class MMBatchCalculater {
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final int BATCH_MAX_SIZE = 3000;
    protected ICalculateContextProvider contextProvider = null;
    protected ArrayList params = new ArrayList();
    protected ArrayList[] groupedParams = null;
    protected HashMap methods = new HashMap();
    protected HashMap numberIDCache = new HashMap();

    public ICalculateContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public MMBatchCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public abstract void execute(SortedParameterArray var1) throws SQLException;

    public void initResource() throws SQLException {
    }

    public void clearResource() {
    }

    protected abstract String[] getParameterProperty();

    protected abstract String[] getParameterPropertySplit();

    public int addParam(MMParamBean paramBean) throws Exception {
        return this.parseParamBean(paramBean, 0);
    }

    protected int parseParamBean(MMParamBean paramBean, int level) throws Exception {
        int number = 0;
        String[] properties = this.getParameterProperty();
        String[] splits = this.getParameterPropertySplit();
        if (properties != null && properties.length > 0 && splits != null && splits.length > 0 && splits.length == splits.length && level < properties.length) {
            String propertyName = properties[level];
            String split = splits[level];
            String propertyLongValue = (String)this.invokeGetterMethod(paramBean, propertyName);
            String[] propertyValues = null;
            propertyValues = propertyLongValue == null || propertyLongValue.length() == 0 || split == null || split.length() == 0 || propertyLongValue.indexOf(split) < 0 ? new String[]{propertyLongValue} : propertyLongValue.split(split);
            int n = propertyValues.length;
            for (int i = 0; i < n; ++i) {
                MMParamBean tmpParamBean = (MMParamBean)paramBean.clone();
                String propertyValue = propertyValues[i].trim();
                this.invokeSetterMethod(tmpParamBean, propertyName, propertyValue);
                number += this.parseParamBean(tmpParamBean, level + 1);
            }
        } else {
            this.params.add(paramBean);
            number = 1;
        }
        return number;
    }

    private Method getGetterMethod(Class clazz, String methodName) throws Exception {
        Method method = null;
        if (this.methods.containsKey(methodName)) {
            method = (Method)this.methods.get(methodName);
        } else {
            method = clazz.getMethod(methodName, new Class[0]);
            this.methods.put(methodName, method);
        }
        return method;
    }

    private Method getSetterMethod(Class clazz, String methodName, Class parameterClazz) throws Exception {
        Method method = null;
        if (this.methods.containsKey(methodName)) {
            method = (Method)this.methods.get(methodName);
        } else {
            method = clazz.getMethod(methodName, parameterClazz);
            this.methods.put(methodName, method);
        }
        return method;
    }

    protected Object invokeGetterMethod(Object paramBean, String propertyName) throws Exception {
        String object = null;
        Class<?> clazz = paramBean.getClass();
        String methodName = "get" + propertyName;
        Method method = this.getGetterMethod(clazz, methodName);
        object = (String)method.invoke(paramBean, new Object[0]);
        return object;
    }

    protected Object invokeSetterMethod(Object paramBean, String propertyName, String propertyValue) throws Exception {
        Object object = null;
        Class<?> clazz = paramBean.getClass();
        String methodName = "set" + propertyName;
        Method method = this.getSetterMethod(clazz, methodName, String.class);
        object = method.invoke(paramBean, propertyValue);
        return object;
    }

    protected void groupByParam() throws Exception {
        String[] properties = this.getParameterProperty();
        if (properties != null && properties.length > 0) {
            this.groupedParams = new ArrayList[1 << properties.length];
            int n = this.params.size();
            for (int i = 0; i < n; ++i) {
                SCMGetParamBean paramBean = (SCMGetParamBean)this.params.get(i);
                int group = 0;
                int m = properties.length;
                for (int j = 0; j < m; ++j) {
                    String propertyName = properties[j];
                    String propertyValue = (String)this.invokeGetterMethod(paramBean, propertyName);
                    if (StringUtils.isEmpty((String)propertyValue)) continue;
                    group |= 1 << j;
                    this.initLoadNumberID(propertyName, propertyValue);
                }
                if (this.groupedParams[group] == null) {
                    this.groupedParams[group] = new ArrayList();
                }
                this.groupedParams[group].add(paramBean);
            }
        } else {
            this.groupedParams = new ArrayList[1];
            this.groupedParams[0] = new ArrayList(this.params);
        }
    }

    protected void initLoadNumberID(String propertyName, String propertyValue) {
        HashMap map = null;
        if (this.numberIDCache.containsKey(propertyName)) {
            map = (HashMap)this.numberIDCache.get(propertyName);
        } else {
            map = new HashMap();
            this.numberIDCache.put(propertyName, map);
        }
        if (!map.containsKey(propertyValue)) {
            map.put(propertyValue, null);
        }
    }

    protected void loadNumberIDCacheData() throws Exception {
        String[] properties = this.getParameterProperty();
        if (properties != null && properties.length > 0) {
            int m = properties.length;
            for (int j = 0; j < m; ++j) {
                HashMap map = (HashMap)this.numberIDCache.get(properties[j]);
                if (map == null || map.size() <= 0) continue;
                Iterator itr = map.entrySet().iterator();
                HashSet numberSet = new HashSet();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object value = entry.getValue();
                    if (value != null) continue;
                    Object key = entry.getKey();
                    numberSet.add(key);
                }
                if (numberSet.size() <= 0) continue;
                this.innerLoadNumberID(j, map, numberSet);
            }
        }
    }

    protected abstract void innerLoadNumberID(int var1, HashMap var2, Set var3) throws Exception;

    protected void setSqlParams(PreparedStatement pstmt, SCMGetParamBean paramBean, int group) throws Exception {
        int paramIndex = this.setFixedSqlParams(pstmt, paramBean, 1);
        String[] properties = this.getParameterProperty();
        if (properties != null && properties.length > 0) {
            int m = properties.length;
            for (int j = 0; j < m; ++j) {
                String propertyName = properties[j];
                if (!MMBatchCalculater.checkBit(group, j)) continue;
                String propertyValue = (String)this.invokeGetterMethod(paramBean, propertyName);
                pstmt.setString(paramIndex++, propertyValue);
            }
        }
    }

    protected void setSqlParamsByID(PreparedStatement pstmt, SCMGetParamBean paramBean, int group) throws Exception {
        int paramIndex = this.setFixedSqlParams(pstmt, paramBean, 1);
        String[] properties = this.getParameterProperty();
        if (properties != null && properties.length > 0) {
            int m = properties.length;
            for (int j = 0; j < m; ++j) {
                String propertyName = properties[j];
                if (!MMBatchCalculater.checkBit(group, j)) continue;
                String propertyValue = (String)this.invokeGetterMethod(paramBean, propertyName);
                HashMap map = (HashMap)this.numberIDCache.get(propertyName);
                String id = (String)map.get(propertyValue);
                pstmt.setString(paramIndex++, id);
            }
        }
    }

    protected int setFixedSqlParams(PreparedStatement pstmt, SCMGetParamBean paramBean, int paramIndex) throws SQLException {
        pstmt.setTimestamp(paramIndex++, paramBean.getStartTime());
        pstmt.setTimestamp(paramIndex++, paramBean.getEndTime());
        return paramIndex;
    }

    protected String getReturnField() {
        return "FAmount";
    }

    public static final boolean checkBit(int i, int index) {
        if (index < 0) {
            return false;
        }
        return (i >> index & 1) == 1;
    }
}

