/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.mm.planning.IMMSOPRptFacade;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.MMSOPRptFacadeFactory;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPSysParams;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MMQtyPlanFetchUI
extends FormulaWizardUI {
    private static final long serialVersionUID = 1L;
    protected F7ContextManager f7Manager = null;
    private KDBizPromptBox companyOrgUnitF7 = null;
    private KDBizPromptBox storeOrgUnitF7 = null;
    private KDBizPromptBox materialGroupF7 = null;
    private KDBizPromptBox materialF7 = null;
    private KDSpinner periodYear = null;
    private KDSpinner periodMonth = null;
    private DataChangeListener companyDataListener = null;
    private DataChangeListener materialGroupDataLinstener = null;
    private DataChangeListener materialDataLinstener = null;
    private List selectedCompanys = new ArrayList();
    private List selectedStorageOrgs = new ArrayList();
    private List storageOrgRange = new ArrayList();
    private List permissionFullOrgs = new ArrayList();
    private List selectedMaterialTypes = new ArrayList();
    private int horizon = 36;
    private boolean isFirstLoad = true;

    protected void onOpen() {
        this.removeListener();
        this.companyOrgUnitF7 = (KDBizPromptBox)this.getParamComponent("fiOrgUnit");
        this.storeOrgUnitF7 = (KDBizPromptBox)this.getParamComponent("storageOrgUnit");
        this.materialGroupF7 = (KDBizPromptBox)this.getParamComponent("materialGroup");
        this.materialF7 = (KDBizPromptBox)this.getParamComponent("material");
        this.periodYear = (KDSpinner)this.getParamComponent("planPeriodYear");
        this.periodMonth = (KDSpinner)this.getParamComponent("planPeriodMonth");
        this.initData();
        this.addFilter();
        this.initLinstener();
    }

    protected void initData() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("COMPANY_NUMBERS", this.companyOrgUnitF7.getValue());
        param.put("STORAGR_NUMBERS", this.storeOrgUnitF7.getValue());
        param.put("MATERIAL_GROUP_NUMBERS", this.materialGroupF7.getValue());
        Map resultMap = new HashMap();
        try {
            IMMSOPRptFacade sopFacede = MMSOPRptFacadeFactory.getRemoteInstance();
            resultMap = sopFacede.getSOPParamByNumber(param);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (resultMap.containsKey("USER_PERMISSION_COMPANY")) {
            this.permissionFullOrgs = (List)resultMap.get("USER_PERMISSION_COMPANY");
        }
        if (resultMap.containsKey("SELECTED_COMPANY")) {
            this.selectedCompanys = (List)resultMap.get("SELECTED_COMPANY");
            this.companyOrgUnitF7.setData((Object)this.selectedCompanys.toArray());
        }
        if (resultMap.containsKey("STORAGE_RANGE")) {
            this.storageOrgRange = (List)resultMap.get("STORAGE_RANGE");
        }
        if (resultMap.containsKey("SELECTED_STORAGE")) {
            this.selectedStorageOrgs = (List)resultMap.get("SELECTED_STORAGE");
            if (this.selectedStorageOrgs.toArray().length > 1) {
                this.storeOrgUnitF7.setData((Object)this.selectedStorageOrgs.toArray());
            } else {
                this.storeOrgUnitF7.setData(null);
            }
        }
        if (resultMap.containsKey("MATERIAL_GROUP")) {
            this.selectedMaterialTypes = (List)resultMap.get("MATERIAL_GROUP");
            this.materialGroupF7.setData((Object)this.selectedMaterialTypes.toArray());
        }
        if (resultMap.containsKey("SERVER_TIME")) {
            Date date = (Date)resultMap.get("SERVER_TIME");
            this.periodYear.setValue((Object)new Integer(date.getYear() + 1900));
            this.periodMonth.setValue((Object)new Integer(date.getMonth() + 1));
        }
    }

    private List treatStorageOrgWithDefCompany(List storageOrgs) throws BOSException, EASBizException {
        storageOrgs.clear();
        if (null == this.selectedCompanys || this.selectedCompanys.size() < 1) {
            return storageOrgs;
        }
        OrgUnitCollection collection = null;
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyInfo = null;
        StorageOrgUnitInfo storageInfo = null;
        for (int i = 0; i < this.selectedCompanys.size(); ++i) {
            companyInfo = (CompanyOrgUnitInfo)this.selectedCompanys.get(i);
            collection = iUnitRel.getFromUnit(companyInfo.getId().toString(), 1, 4);
            if (null == collection || collection.size() <= 0) continue;
            for (int j = 0; j < collection.size(); ++j) {
                storageInfo = (StorageOrgUnitInfo)collection.get(j);
                if (!storageInfo.isIsBizUnit()) continue;
                storageOrgs.add(storageInfo);
            }
        }
        return storageOrgs;
    }

    protected void addFilter() {
        try {
            this.setCompanyFilter();
            this.setStorageFilter();
            this.setMaterialFilter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setStorageFilter() {
        EntityViewInfo viewInfo = this.getOrgDefaultFilterById(this.storageOrgRange);
        this.storeOrgUnitF7.setEntityViewInfo(viewInfo);
    }

    private void setCompanyFilter() throws Exception {
        EntityViewInfo viewInfo = this.getOrgDefaultFilterById(this.permissionFullOrgs);
        this.companyOrgUnitF7.setEntityViewInfo(viewInfo);
    }

    private void setMaterialFilter() {
        EntityViewInfo materialView = new EntityViewInfo();
        FilterInfo materialGroupFilterInfo = new FilterInfo();
        StringBuffer groupIds = new StringBuffer();
        if (null != this.selectedMaterialTypes && this.selectedMaterialTypes.size() > 0) {
            for (int i = 0; i < this.selectedMaterialTypes.size(); ++i) {
                groupIds.append(((MaterialGroupInfo)this.selectedMaterialTypes.get(i)).getId().toString()).append(",");
            }
        } else {
            groupIds.append("null");
        }
        materialGroupFilterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.id", (Object)groupIds.toString(), CompareType.INCLUDE));
        materialView.setFilter(materialGroupFilterInfo);
        this.materialF7.setEntityViewInfo(materialView);
    }

    private EntityViewInfo getOrgDefaultFilterById(List orgList) {
        EntityViewInfo orgUnitView = new EntityViewInfo();
        FilterInfo orgFilterInfo = new FilterInfo();
        String fieldName = "id";
        StringBuffer groupIds = new StringBuffer();
        if (null != orgList && orgList.size() > 0) {
            boolean first = true;
            for (int i = 0; i < orgList.size(); ++i) {
                if (first) {
                    groupIds.append(((OrgUnitInfo)orgList.get(i)).getId().toString());
                    first = false;
                    continue;
                }
                groupIds.append(",").append(((OrgUnitInfo)orgList.get(i)).getId().toString());
            }
        } else {
            groupIds.append("null");
        }
        orgFilterInfo.getFilterItems().add(new FilterItemInfo(fieldName, (Object)groupIds.toString(), CompareType.INCLUDE));
        orgUnitView.setFilter(orgFilterInfo);
        return orgUnitView;
    }

    private void initLinstener() {
        if (null == this.companyDataListener) {
            this.companyDataListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    MMQtyPlanFetchUI.this.companyOrgUnitDataChanged(e);
                }
            };
        }
        this.companyOrgUnitF7.addDataChangeListener(this.companyDataListener);
        if (null == this.materialGroupDataLinstener) {
            this.materialGroupDataLinstener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    MMQtyPlanFetchUI.this.materialGroupChanged(e);
                }
            };
        }
        this.materialGroupF7.addDataChangeListener(this.materialGroupDataLinstener);
        if (null == this.materialDataLinstener) {
            this.materialDataLinstener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    MMQtyPlanFetchUI.this.materialChanged(e);
                }
            };
        }
        this.materialF7.addDataChangeListener(this.materialDataLinstener);
    }

    private void removeListener() {
        if (null != this.companyDataListener) {
            this.companyOrgUnitF7.removeDataChangeListener(this.companyDataListener);
        }
        if (null != this.materialGroupDataLinstener) {
            this.materialGroupF7.removeDataChangeListener(this.materialGroupDataLinstener);
        }
        if (null != this.materialDataLinstener) {
            this.materialF7.removeDataChangeListener(this.materialDataLinstener);
        }
    }

    protected void companyOrgUnitDataChanged(DataChangeEvent e) {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        this.removeListener();
        try {
            CompanyOrgUnitInfo info;
            this.selectedCompanys.clear();
            if (this.companyOrgUnitF7.getValue() instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] collection = (OrgUnitInfo[])this.companyOrgUnitF7.getValue();
                CompanyOrgUnitInfo info2 = null;
                for (int i = 0; i < collection.length; ++i) {
                    info2 = (CompanyOrgUnitInfo)collection[i];
                    if (!info2.isIsBizUnit()) continue;
                    this.selectedCompanys.add(info2);
                }
            } else if (this.companyOrgUnitF7.getValue() instanceof CompanyOrgUnitInfo && (info = (CompanyOrgUnitInfo)this.companyOrgUnitF7.getValue()).isIsBizUnit()) {
                this.selectedCompanys.add(info);
            }
            this.companyOrgUnitF7.setData((Object)this.selectedCompanys.toArray());
            this.storeOrgUnitF7.setData(null);
            if (!this.checkCompanyCur()) {
                this.storageOrgRange.clear();
            } else {
                this.treatStorageOrgWithDefCompany(this.storageOrgRange);
                this.setStorageFilter();
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        this.initLinstener();
    }

    protected void storeOrgChanged(DataChangeEvent e) {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        this.removeListener();
        try {
            this.selectedStorageOrgs.clear();
            if (this.storeOrgUnitF7.getValue() instanceof Object[]) {
                Object[] collection = (Object[])this.storeOrgUnitF7.getValue();
                for (int i = 0; i < collection.length; ++i) {
                    this.selectedStorageOrgs.add(collection[i]);
                }
            } else if (this.storeOrgUnitF7.getValue() instanceof StorageOrgUnitInfo) {
                this.selectedStorageOrgs.add(this.storeOrgUnitF7.getValue());
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        this.initLinstener();
    }

    protected void materialGroupChanged(DataChangeEvent e) {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        this.removeListener();
        try {
            this.selectedMaterialTypes.clear();
            if (this.materialGroupF7.getValue() instanceof Object[]) {
                Object[] collection = (Object[])this.materialGroupF7.getValue();
                for (int i = 0; i < collection.length; ++i) {
                    this.selectedMaterialTypes.add(collection[i]);
                }
            } else if (this.materialGroupF7.getValue() instanceof MaterialGroupInfo) {
                this.selectedMaterialTypes.add(this.materialGroupF7.getValue());
            }
            this.materialF7.setData(null);
            this.setMaterialFilter();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        this.initLinstener();
    }

    protected void materialChanged(DataChangeEvent e) {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        this.removeListener();
        if (null != e.getNewValue() && e.getNewValue() instanceof Object[] && !this.checkMaterialBaseUnit((Object[])e.getNewValue())) {
            MsgBox.showInfo((String)this.getResource("MATERIAL_BASEUNIT_DIFFERENT"));
            this.materialF7.setData(null);
        }
        this.initLinstener();
    }

    protected boolean checkCompanyCur() {
        if (this.selectedCompanys.size() < 2) {
            return true;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.selectedCompanys.get(0);
        String baseID = company.getBaseCurrency().getId().toString();
        for (int i = 1; i < this.selectedCompanys.size(); ++i) {
            company = (CompanyOrgUnitInfo)this.selectedCompanys.get(i);
            if (null == company.getBaseCurrency() || baseID.equals(company.getBaseCurrency().getId().toString())) continue;
            MsgBox.showInfo((String)this.getResource("COMPANY_CURRENCY_DIFFERENT"));
            this.companyOrgUnitF7.setData(null);
            this.selectedCompanys.clear();
            return false;
        }
        return true;
    }

    protected boolean checkStorageHorizon() throws BOSException, EASBizException {
        if (this.selectedStorageOrgs.size() < 2) {
            return true;
        }
        ISOPFacade sopFacade = SOPFacadeFactory.getRemoteInstance();
        SOPSysParams SOPParams = sopFacade.getSOPSysParams(((StorageOrgUnitInfo)this.selectedStorageOrgs.get(0)).getId().toString());
        if (null == SOPParams) {
            MsgBox.showInfo((String)this.getResource("STORAGE_HORIZON_DOFFERENT"));
            return false;
        }
        this.horizon = SOPParams.getSOPMonthHorizon();
        for (int i = 1; i < this.selectedStorageOrgs.size(); ++i) {
            SOPParams = sopFacade.getSOPSysParams(((StorageOrgUnitInfo)this.selectedStorageOrgs.get(i)).getId().toString());
            if (null != SOPParams && this.horizon == SOPParams.getSOPMonthHorizon()) continue;
            return false;
        }
        return true;
    }

    private boolean checkMaterialBaseUnit(Object[] materials) {
        if (null == materials || materials.length < 2) {
            return true;
        }
        String baseUnitId = null;
        for (int i = 0; i < materials.length; ++i) {
            if (null == baseUnitId) {
                baseUnitId = ((MaterialInfo)materials[i]).getBaseUnit().getId().toString();
                continue;
            }
            if (baseUnitId.equals(((MaterialInfo)materials[i]).getBaseUnit().getId().toString())) continue;
            return false;
        }
        return true;
    }

    private String getResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.MMReportResource", (String)sKey);
    }

    private String getResource(String key, String[] params) {
        return ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.MMReportResource", (String)key, (String[])params);
    }
}

