/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPlanVersionFactory;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class MMReportUtil {
    public static Map getRptAuthorizedCompany(Context ctx) throws BOSException, EASBizException {
        IPermission permission = null;
        IObjectPK userPK = null;
        if (ctx == null) {
            permission = PermissionFactory.getRemoteInstance();
            userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        } else {
            permission = PermissionFactory.getLocalInstance((Context)ctx);
            userPK = ctx.getCaller();
        }
        Map authorizedCompany = permission.getAuthorizedOrgs(userPK, OrgType.Company, null, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.rpt.client", "RptReportProcessUI"), (IMetaDataPK)new MetaDataPK("rpt_report_calculate"));
        return authorizedCompany;
    }

    public static EntityViewInfo getMultiEqualEntityView(EntityViewInfo ev, String fieldName, Set valueSet) {
        if (ev == null) {
            ev = new EntityViewInfo();
            ev.setFilter(new FilterInfo());
        } else if (ev.getFilter() == null) {
            ev.setFilter(new FilterInfo());
        }
        if (!StringUtils.isEmpty((String)fieldName) && valueSet != null && valueSet.size() > 0) {
            fieldName = fieldName.trim();
            StringBuffer maskString = new StringBuffer();
            int index = 0;
            boolean hasValidFieldValue = false;
            Iterator it = valueSet.iterator();
            while (it.hasNext()) {
                String fieldValue = it.next().toString().trim();
                if (StringUtils.isEmpty((String)fieldValue)) continue;
                ev.getFilter().getFilterItems().add(new FilterItemInfo(fieldName, (Object)fieldValue, CompareType.EQUALS));
                if (!hasValidFieldValue) {
                    maskString.append("#" + index++);
                } else {
                    maskString.append(" or #" + index++);
                }
                hasValidFieldValue = true;
            }
            if (hasValidFieldValue) {
                ev.getFilter().setMaskString(maskString.toString());
            }
        }
        return ev;
    }

    public static CompanyOrgUnitCollection getCompanyOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICompanyOrgUnit company = null;
        company = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return company.getCompanyOrgUnitCollection(ev);
    }

    public static String bulidFilterAndMaskString(EntityViewInfo ev, String fieldName, Set filedValueSet) {
        if (ev.getFilter() == null) {
            ev.setFilter(new FilterInfo());
        }
        int i = 0;
        StringBuffer sbMaskString = new StringBuffer();
        for (String fieldValue : filedValueSet) {
            ev.getFilter().getFilterItems().add(new FilterItemInfo(fieldName, (Object)fieldValue, CompareType.EQUALS));
            if (i == 0) {
                sbMaskString.append("#").append(i);
            } else {
                sbMaskString.append(" or #").append(i);
            }
            ++i;
        }
        return sbMaskString.toString();
    }

    protected static void treatNotBizCompany(CompanyOrgUnitInfo info, List bizCompanyList) throws BOSException {
        if (info.isIsBizUnit()) {
            bizCompanyList.add(info);
        } else {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)info.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            CoreBaseCollection companyCollection = CompanyOrgUnitFactory.getRemoteInstance().getCollection(viewInfo);
            if (null != companyCollection) {
                CompanyOrgUnitInfo company = null;
                for (int i = 0; i < companyCollection.size(); ++i) {
                    company = (CompanyOrgUnitInfo)companyCollection.get(i);
                    if (company.isIsBizUnit()) {
                        bizCompanyList.add(company);
                        continue;
                    }
                    MMReportUtil.treatNotBizCompany(company, bizCompanyList);
                }
            }
        }
    }

    protected static Object[] setPeriods(List storageOrgs, int horizon) throws BOSException, EASBizException {
        int i;
        ArrayList<SOPPeriod> periodRnage = new ArrayList<SOPPeriod>();
        SOPPeriod period = null;
        if (null == period) {
            ISOPFacade sopFacade = SOPFacadeFactory.getRemoteInstance();
            for (i = 0; i < storageOrgs.size() && null == (period = sopFacade.getCurrentPeriod(SOPEditModeEnum.MONTHLY, ((StorageOrgUnitInfo)storageOrgs.get(i)).getId().toString())); ++i) {
            }
        }
        if (horizon < 0) {
            horizon = 6;
        }
        SOPPeriod[] backwardPeriods = period.backwardPeriods(horizon);
        for (i = 1; i < backwardPeriods.length - 1; ++i) {
            periodRnage.add(backwardPeriods[i]);
        }
        SOPPeriod[] futurePeriods = period.forwardPeriods(horizon);
        for (int i2 = 0; i2 < futurePeriods.length; ++i2) {
            periodRnage.add(backwardPeriods[i2]);
        }
        return periodRnage.toArray();
    }

    protected Object getDefaultPlanVersion() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        viewInfo.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("activation", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection c = SOPPlanVersionFactory.getRemoteInstance().getCollection(viewInfo);
        if (null != c && c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    private void setSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel && max >= min) {
            ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }
}

