/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.AheadDateOptionEnum;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.ProductLineChangingEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLineChangingEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLineChangingInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.PLChooseEntryInfo;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSExectionMSGInfo;
import com.kingdee.eas.mm.planning.SchedulingException;
import com.kingdee.eas.mm.planning.app.PLSRunner;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalcPLSPriorityRunner
extends PLSRunner {
    protected List srcList;
    protected static final String SPLIT = "#";
    protected String[] orderField = null;
    protected String[] orderMode = null;

    public CalcPLSPriorityRunner(Context context, StorageOrgUnitInfo storageOrgUnit, List pLCEntryList, String currVoucherID, PLSModelInfo pLSModelInfo) {
        this.ctx = context;
        this.storageOrgUnitInfo = storageOrgUnit;
        this.srcList = pLCEntryList;
        this.voucherID = currVoucherID;
        this.lineSchedulingModelInfo = pLSModelInfo;
    }

    @Override
    public void prepareData() throws BOSException, EASBizException {
        super.prepareData();
        this.checkPLSModel();
    }

    protected void checkPLSModel() throws EASBizException {
        if (this.lineSchedulingModelInfo.getOrderField() != null) {
            this.orderField = this.lineSchedulingModelInfo.getOrderField().split(SPLIT);
        }
        if (this.lineSchedulingModelInfo.getOrderMode() != null) {
            this.orderMode = this.lineSchedulingModelInfo.getOrderMode().split(SPLIT);
        }
        if (this.orderField == null || this.orderMode == null || this.orderField.length != this.orderMode.length) {
            throw new SchedulingException(SchedulingException.PLSMODELERROR);
        }
    }

    @Override
    public void running() throws BOSException, EASBizException {
        List<PLChooseEntryInfo> tempList;
        this.prepareData();
        this.returnList = new ArrayList();
        HashMap lineMap = new HashMap();
        int n = this.srcList.size();
        for (int i = 0; i < n; ++i) {
            PLChooseEntryInfo pLCEntryInfo = (PLChooseEntryInfo)this.srcList.get(i);
            pLCEntryInfo.setSchedulingQty(PLSConstant.ZERO);
            pLCEntryInfo.setNoSchedulingQty(PLSConstant.ZERO);
            ProductLineInfo productLine = pLCEntryInfo.getProductLine();
            String productLineId = productLine.getId().toString();
            if (lineMap.containsKey(productLineId)) {
                tempList = (List)lineMap.get(productLineId);
                tempList.add(pLCEntryInfo);
                lineMap.put(productLineId, tempList);
                continue;
            }
            tempList = new ArrayList();
            tempList.add(pLCEntryInfo);
            lineMap.put(productLineId, tempList);
        }
        if (lineMap != null && lineMap.size() > 0) {
            Set keySet = lineMap.keySet();
            Map productLineMap = PLSUtil.getProductLineMapForServer(this.ctx, keySet);
            for (String productLineId : keySet) {
                PLChooseEntryInfo pLCEntryInfo;
                int i;
                ProductLineInfo productLine = (ProductLineInfo)productLineMap.get(productLineId);
                tempList = (List)lineMap.get(productLineId);
                boolean isSingle = true;
                if (tempList == null || tempList.size() <= 0) continue;
                List taskList = new ArrayList();
                String lastMaterialId = ((PLChooseEntryInfo)tempList.get(0)).getMaterial().getId().toString();
                int n2 = tempList.size();
                for (i = 1; i < n2; ++i) {
                    pLCEntryInfo = (PLChooseEntryInfo)tempList.get(i);
                    if (lastMaterialId.equals(pLCEntryInfo.getMaterial().getId().toString())) continue;
                    isSingle = false;
                    break;
                }
                if (isSingle) {
                    if (tempList != null && tempList.size() > 0) {
                        taskList = this.noLineChangingImplement(tempList, taskList);
                    }
                } else {
                    String productLineID;
                    String lineAllocateID;
                    String orgUnitID = this.lineSchedulingModelInfo.getStorageOrgUnit().getId().toString();
                    ProductLineChangingInfo productLineChangingInfo = PLSUtil.getProductLineChanging(this.ctx, orgUnitID, lineAllocateID = this.lineSchedulingModelInfo.getProductLineAllocate().getId().toString(), productLineID = productLine.getId().toString());
                    taskList = productLineChangingInfo != null ? (productLineChangingInfo.isIsStrictlyCtrl() ? this.lessChangeImplement(productLineChangingInfo, tempList) : (this.lineSchedulingModelInfo.isIsLessChange() ? this.lessChangeImplement(productLineChangingInfo, tempList) : this.noLineChangingImplement(tempList, taskList))) : this.noLineChangingImplement(tempList, taskList);
                }
                if (taskList == null || taskList.size() <= 0) continue;
                n2 = taskList.size();
                for (i = 0; i < n2; ++i) {
                    pLCEntryInfo = (PLChooseEntryInfo)taskList.get(i);
                    this.returnList.add(pLCEntryInfo);
                }
            }
        }
    }

    protected List lessChangeImplement(ProductLineChangingInfo productLineChangingInfo, List pLCEntryList) throws BOSException, EASBizException {
        String lastProduct = null;
        String currProduct = null;
        String nextProduct = null;
        int lineChangingCount = this.getLineChangingCount(productLineChangingInfo);
        BigDecimal priorityLevel = PLSConstant.ZERO;
        String orgUnitID = this.lineSchedulingModelInfo.getStorageOrgUnit().getId().toString();
        String productLineID = productLineChangingInfo.getProductLine().getId().toString();
        ArrayList<PLChooseEntryInfo> taskList = new ArrayList<PLChooseEntryInfo>();
        currProduct = this.getLastSchedulingMaterial(orgUnitID, productLineID, null);
        if (currProduct != null) {
            if (this.isInProductLineChanging(productLineChangingInfo, currProduct) && !this.isInProductLineChanging(productLineChangingInfo, lastProduct = this.getLastSchedulingMaterial(orgUnitID, productLineID, currProduct))) {
                lastProduct = null;
            }
            nextProduct = currProduct;
            currProduct = lastProduct;
            if (lineChangingCount == 2) {
                currProduct = null;
                lastProduct = null;
            }
        } else {
            nextProduct = this.getNextMaterial(productLineChangingInfo, null, null);
        }
        Collections.sort(pLCEntryList, this.getComparatorNew());
        while (pLCEntryList.size() > 0) {
            PLChooseEntryInfo pLCEntry;
            boolean isFound = false;
            Timestamp minDate = this.getMinDateInPLCList(pLCEntryList);
            Timestamp maxDate = PLSUtil.setDateTime(PLSUtil.getDateByLeadTime(minDate, 5, this.lineSchedulingModelInfo.getAheadDay()), 1);
            boolean hasInChan = this.checkMaterialInChanging(productLineChangingInfo, pLCEntryList, minDate, maxDate);
            Iterator ite = pLCEntryList.iterator();
            while (ite.hasNext()) {
                pLCEntry = (PLChooseEntryInfo)ite.next();
                if (!pLCEntry.getMaterial().getId().toString().equals(nextProduct)) continue;
                Timestamp currDate = null;
                currDate = this.lineSchedulingModelInfo.getAheadDateOption().equals((Object)AheadDateOptionEnum.startDate) ? pLCEntry.getBeginDate() : pLCEntry.getEndDate();
                if (currDate.compareTo(minDate) < 0 || currDate.compareTo(maxDate) > 0) continue;
                priorityLevel = priorityLevel.add(PLSConstant.TEN);
                pLCEntry.setPriorityLevel(priorityLevel);
                taskList.add(pLCEntry);
                ite.remove();
                isFound = true;
            }
            if (isFound || pLCEntryList.size() <= 0) continue;
            if (this.isInProductLineChanging(productLineChangingInfo, nextProduct)) {
                if (lineChangingCount == 1) {
                    if (productLineChangingInfo.isIsStrictlyCtrl()) break;
                    pLCEntry = (PLChooseEntryInfo)pLCEntryList.get(0);
                    nextProduct = pLCEntry.getMaterial().getId().toString();
                    continue;
                }
                if (lineChangingCount == 2) {
                    currProduct = nextProduct;
                    lastProduct = currProduct;
                    if (!(nextProduct = this.getNextMaterial(productLineChangingInfo, currProduct, lastProduct)).equals(lastProduct)) continue;
                    if (productLineChangingInfo.isIsStrictlyCtrl()) break;
                    pLCEntry = (PLChooseEntryInfo)pLCEntryList.get(0);
                    nextProduct = pLCEntry.getMaterial().getId().toString();
                    continue;
                }
                if (productLineChangingInfo.isIsStrictlyCtrl() && nextProduct != null && !this.isInProductLineChanging(productLineChangingInfo, nextProduct)) break;
                if (hasInChan) {
                    lastProduct = currProduct;
                    currProduct = nextProduct;
                    nextProduct = this.getNextMaterial(productLineChangingInfo, currProduct, lastProduct);
                    continue;
                }
                pLCEntry = (PLChooseEntryInfo)pLCEntryList.get(0);
                nextProduct = pLCEntry.getMaterial().getId().toString();
                continue;
            }
            nextProduct = this.getNextMaterial(productLineChangingInfo, null, null);
        }
        if (pLCEntryList.size() > 0) {
            for (int i = 0; i < pLCEntryList.size(); ++i) {
                PLChooseEntryInfo pLCEntry = (PLChooseEntryInfo)pLCEntryList.get(i);
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"CANNOTSCHEDUL_DESC");
                int exceNum = 102;
                MaterialInfo material = pLCEntry.getMaterial();
                ProductLineInfo productLine = pLCEntry.getProductLine();
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"CANNOTSCHEDUL_DEDAIL", (String[])new String[]{material.getNumber(), material.getName(), productLine.getNumber(), productLine.getName()});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
            }
        }
        return taskList;
    }

    protected boolean checkMaterialInChanging(ProductLineChangingInfo productLineChangingInfo, List pLCEntryList, Timestamp minDate, Timestamp maxDate) throws EASBizException, BOSException {
        boolean hasInChan = false;
        for (PLChooseEntryInfo pLCEntry : pLCEntryList) {
            Timestamp currDate = null;
            currDate = this.lineSchedulingModelInfo.getAheadDateOption().equals((Object)AheadDateOptionEnum.startDate) ? pLCEntry.getBeginDate() : pLCEntry.getEndDate();
            if (currDate.compareTo(minDate) < 0 || currDate.compareTo(maxDate) > 0 || !this.isInProductLineChanging(productLineChangingInfo, pLCEntry.getMaterial().getId().toString())) continue;
            hasInChan = true;
            break;
        }
        return hasInChan;
    }

    protected int getLineChangingCount(ProductLineChangingInfo productLineChangingInfo) {
        return productLineChangingInfo.getEntrys().size();
    }

    protected Timestamp getMinDateInPLCList(List pLCList) {
        PLChooseEntryInfo pLCEntryInfo = (PLChooseEntryInfo)pLCList.get(0);
        if (this.lineSchedulingModelInfo.getAheadDateOption().equals((Object)AheadDateOptionEnum.startDate)) {
            return PLSUtil.setDateTime(pLCEntryInfo.getBeginDate(), 0);
        }
        return pLCEntryInfo.getEndDate();
    }

    protected List dateSeqImplement(ProductLineChangingInfo productLineChangingInfo, List pLCEntryList) throws BOSException, EASBizException {
        String lastProduct = null;
        String currProduct = null;
        String nextProduct = null;
        BigDecimal priorityLevel = PLSConstant.ZERO;
        List<PLChooseEntryInfo> taskList = new ArrayList();
        ArrayList<PLChooseEntryInfo> pLCListInChan = new ArrayList<PLChooseEntryInfo>();
        ArrayList<PLChooseEntryInfo> pLCListNotInChan = new ArrayList<PLChooseEntryInfo>();
        for (int i = 0; i < pLCEntryList.size(); ++i) {
            PLChooseEntryInfo pLCEntry = (PLChooseEntryInfo)pLCEntryList.get(i);
            if (this.isInProductLineChanging(productLineChangingInfo, pLCEntry.getMaterial().getId().toString())) {
                pLCListInChan.add(pLCEntry);
                continue;
            }
            pLCListNotInChan.add(pLCEntry);
        }
        if (pLCListInChan != null && pLCListInChan.size() > 0) {
            HashMap dateMapInChan = new HashMap();
            for (int i = 0; i < pLCListInChan.size(); ++i) {
                List<PLChooseEntryInfo> tempList;
                PLChooseEntryInfo pLCEntry = (PLChooseEntryInfo)pLCListInChan.get(i);
                Timestamp currDate = null;
                currDate = this.lineSchedulingModelInfo.getAheadDateOption().equals((Object)AheadDateOptionEnum.startDate) ? pLCEntry.getBeginDate() : pLCEntry.getEndDate();
                if (dateMapInChan.containsKey(currDate)) {
                    tempList = (List)dateMapInChan.get(currDate);
                    tempList.add(pLCEntry);
                    dateMapInChan.put(currDate, tempList);
                    continue;
                }
                tempList = new ArrayList();
                tempList.add(pLCEntry);
                dateMapInChan.put(currDate, tempList);
            }
            Object[] dates = dateMapInChan.keySet().toArray();
            Arrays.sort(dates);
            nextProduct = this.getNextMaterial(productLineChangingInfo, null, null);
            int n = dates.length;
            for (int i = 0; i < n; ++i) {
                List pLCList = (List)dateMapInChan.get(dates[i]);
                while (pLCList != null && pLCList.size() > 0) {
                    Iterator ite = pLCList.iterator();
                    while (ite.hasNext()) {
                        PLChooseEntryInfo pLCEntry = (PLChooseEntryInfo)ite.next();
                        if (!pLCEntry.getMaterial().getId().toString().equals(nextProduct)) continue;
                        priorityLevel = priorityLevel.add(PLSConstant.TEN);
                        pLCEntry.setPriorityLevel(priorityLevel);
                        taskList.add(pLCEntry);
                        ite.remove();
                    }
                    if (pLCList.size() <= 0) continue;
                    lastProduct = currProduct;
                    currProduct = nextProduct;
                    nextProduct = this.getNextMaterial(productLineChangingInfo, currProduct, lastProduct);
                }
            }
        }
        if (pLCListNotInChan != null && pLCListNotInChan.size() > 0) {
            taskList = this.noLineChangingImplement(pLCListNotInChan, taskList);
        }
        return taskList;
    }

    private List noLineChangingImplement(List pLCEntryList, List taskList) throws BOSException, EASBizException {
        BigDecimal priorityLevel = PLSConstant.ZERO;
        Collections.sort(pLCEntryList, this.getComparatorNew());
        int n = pLCEntryList.size();
        for (int i = 0; i < n; ++i) {
            PLChooseEntryInfo pLCEntry = (PLChooseEntryInfo)pLCEntryList.get(i);
            priorityLevel = priorityLevel.add(PLSConstant.TEN);
            pLCEntry.setPriorityLevel(priorityLevel);
            taskList.add(pLCEntry);
        }
        return taskList;
    }

    protected Comparator getComparatorNew() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                PLChooseEntryInfo pLCEntry1 = (PLChooseEntryInfo)o1;
                PLChooseEntryInfo pLCEntry2 = (PLChooseEntryInfo)o2;
                int compareResult = 0;
                for (int i = 0; i < CalcPLSPriorityRunner.this.orderField.length; ++i) {
                    int orderFieldValue = Integer.valueOf(CalcPLSPriorityRunner.this.orderField[i]);
                    if (orderFieldValue == 10) {
                        compareResult = pLCEntry1.getBeginDate().compareTo(pLCEntry2.getBeginDate());
                    } else if (orderFieldValue == 20) {
                        compareResult = pLCEntry1.getEndDate().compareTo(pLCEntry2.getEndDate());
                    } else if (orderFieldValue == 30) {
                        compareResult = pLCEntry1.getQty().compareTo(pLCEntry2.getQty());
                    } else if (orderFieldValue == 40) {
                        compareResult = pLCEntry1.getNoSchedulingQty().compareTo(pLCEntry2.getNoSchedulingQty());
                    } else if (orderFieldValue == 50) {
                        compareResult = pLCEntry1.getMaterial().getNumber().compareTo(pLCEntry2.getMaterial().getNumber());
                    }
                    if (compareResult == 0) continue;
                    if (Integer.valueOf(CalcPLSPriorityRunner.this.orderMode[i]) == 10) {
                        return compareResult;
                    }
                    return -1 * compareResult;
                }
                compareResult = pLCEntry1.getSourceBillNumber() != null && pLCEntry2.getSourceBillNumber() != null ? pLCEntry1.getSourceBillNumber().compareTo(pLCEntry2.getSourceBillNumber()) : (pLCEntry1.getSourceBillNumber() != null && pLCEntry2.getSourceBillNumber() == null ? -1 : (pLCEntry1.getSourceBillNumber() == null && pLCEntry2.getSourceBillNumber() != null ? 1 : 0));
                return compareResult;
            }
        };
    }

    protected Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                PLChooseEntryInfo pLCEntry1 = (PLChooseEntryInfo)o1;
                PLChooseEntryInfo pLCEntry2 = (PLChooseEntryInfo)o2;
                Timestamp date1 = null;
                Timestamp date2 = null;
                if (CalcPLSPriorityRunner.this.lineSchedulingModelInfo.getAheadDateOption().equals((Object)AheadDateOptionEnum.startDate)) {
                    date1 = pLCEntry1.getBeginDate();
                    date2 = pLCEntry2.getBeginDate();
                } else {
                    date1 = pLCEntry1.getEndDate();
                    date2 = pLCEntry2.getEndDate();
                }
                if (date1.compareTo(date2) != 0) {
                    return date1.compareTo(date2);
                }
                if (pLCEntry1.getMaterial().getNumber().compareTo(pLCEntry2.getMaterial().getNumber()) != 0) {
                    return pLCEntry1.getMaterial().getNumber().compareTo(pLCEntry2.getMaterial().getNumber());
                }
                if (pLCEntry1.getQty().compareTo(pLCEntry2.getQty()) != 0) {
                    return pLCEntry2.getQty().compareTo(pLCEntry1.getQty());
                }
                if (pLCEntry1.getSourceBillNumber() != null && pLCEntry2.getSourceBillNumber() != null) {
                    if (pLCEntry1.getSourceBillNumber().compareTo(pLCEntry2.getSourceBillNumber()) != 0) {
                        return pLCEntry1.getSourceBillNumber().compareTo(pLCEntry2.getSourceBillNumber());
                    }
                    return 0;
                }
                if (pLCEntry1.getSourceBillNumber() != null && pLCEntry2.getSourceBillNumber() == null) {
                    return -1;
                }
                if (pLCEntry1.getSourceBillNumber() == null && pLCEntry2.getSourceBillNumber() != null) {
                    return 1;
                }
                return 0;
            }
        };
    }

    protected String getNextMaterial(ProductLineChangingInfo productLineChangingInfo, String currProduct, String lastProduct) throws BOSException, EASBizException {
        ProductLineChangingEntryInfo entry;
        int i;
        int lastSeq = -1;
        int currSeq = -1;
        int flag = -1;
        if (productLineChangingInfo == null) {
            throw new SchedulingException(SchedulingException.NOCHANGE);
        }
        ArrayList<ProductLineChangingEntryInfo> entryList = new ArrayList<ProductLineChangingEntryInfo>();
        ProductLineChangingEntryCollection entryCollection = productLineChangingInfo.getEntrys();
        if (entryCollection != null && entryCollection.size() > 0) {
            for (i = 0; i < entryCollection.size(); ++i) {
                entryList.add(entryCollection.get(i));
            }
        } else {
            throw new SchedulingException(SchedulingException.NOCHANGEENTRY, new Object[]{productLineChangingInfo.getNumber()});
        }
        Collections.sort(entryList, new Comparator(){

            public int compare(Object o1, Object o2) {
                ProductLineChangingEntryInfo entry1 = (ProductLineChangingEntryInfo)o1;
                ProductLineChangingEntryInfo entry2 = (ProductLineChangingEntryInfo)o2;
                return entry1.getProOrder().compareTo(entry2.getProOrder());
            }
        });
        if (entryList.size() == 1) {
            return ((ProductLineChangingEntryInfo)entryList.get(0)).getMaterial().getId().toString();
        }
        if (entryList.size() == 2) {
            if (currProduct != null) {
                for (i = 0; i < entryList.size(); ++i) {
                    entry = (ProductLineChangingEntryInfo)entryList.get(i);
                    String materialID = entry.getMaterial().getId().toString();
                    if (materialID.equals(currProduct)) continue;
                    return materialID;
                }
            } else {
                return ((ProductLineChangingEntryInfo)entryList.get(0)).getMaterial().getId().toString();
            }
        }
        if (currProduct != null && lastProduct != null) {
            for (i = 0; i < entryList.size(); ++i) {
                entry = (ProductLineChangingEntryInfo)entryList.get(i);
                if (entry.getMaterial().getId().toString().equals(lastProduct)) {
                    lastSeq = entry.getProOrder().intValue();
                }
                if (entry.getMaterial().getId().toString().equals(currProduct)) {
                    currSeq = entry.getProOrder().intValue();
                    flag = i;
                }
                if (lastSeq != -1 && currSeq != -1) break;
            }
            if (productLineChangingInfo.isIsCycled()) {
                if (flag == entryList.size() - 1) {
                    return ((ProductLineChangingEntryInfo)entryList.get(0)).getMaterial().getId().toString();
                }
                return ((ProductLineChangingEntryInfo)entryList.get(flag + 1)).getMaterial().getId().toString();
            }
            if (currSeq > lastSeq) {
                if (flag == entryList.size() - 1) {
                    return ((ProductLineChangingEntryInfo)entryList.get(flag - 1)).getMaterial().getId().toString();
                }
                return ((ProductLineChangingEntryInfo)entryList.get(flag + 1)).getMaterial().getId().toString();
            }
            if (currSeq < lastSeq) {
                if (flag == 0) {
                    return ((ProductLineChangingEntryInfo)entryList.get(flag + 1)).getMaterial().getId().toString();
                }
                return ((ProductLineChangingEntryInfo)entryList.get(flag - 1)).getMaterial().getId().toString();
            }
            throw new SchedulingException(SchedulingException.NOCHANGEENTRY, new Object[]{productLineChangingInfo.getNumber()});
        }
        if (currProduct != null && lastProduct == null) {
            for (i = 0; i < entryList.size(); ++i) {
                entry = (ProductLineChangingEntryInfo)entryList.get(i);
                if (entry.getMaterial().getId().toString().equals(currProduct)) {
                    currSeq = entry.getProOrder().intValue();
                    flag = i;
                }
                if (currSeq != -1) break;
            }
            if (flag == entryList.size() - 1) {
                if (productLineChangingInfo.isIsCycled()) {
                    return ((ProductLineChangingEntryInfo)entryList.get(0)).getMaterial().getId().toString();
                }
                return ((ProductLineChangingEntryInfo)entryList.get(flag - 1)).getMaterial().getId().toString();
            }
            return ((ProductLineChangingEntryInfo)entryList.get(flag + 1)).getMaterial().getId().toString();
        }
        return ((ProductLineChangingEntryInfo)entryList.get(0)).getMaterial().getId().toString();
    }

    protected String getLastSchedulingMaterial(String orgUnitID, String productLineID, String materialID) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select top 1 entry.FMaterialID as materialID ");
        sqlBuffer.append("from T_MM_PLSEntry entry inner join T_MM_ProductionLineScheduling head on head.FID = entry.FParent ");
        sqlBuffer.append("where head.FStorageOrgUnitID = '" + orgUnitID + "' ");
        sqlBuffer.append("and entry.FProductLineID = '" + productLineID + "' ");
        sqlBuffer.append("and entry.FBaseStatus <> 7 ");
        if (materialID != null) {
            sqlBuffer.append("and entry.FMaterialID <> '" + materialID + "' ");
        }
        if (this.lineSchedulingModelInfo.getAheadDateOption().equals((Object)AheadDateOptionEnum.startDate)) {
            sqlBuffer.append("order by entry.FbeginDate desc");
        } else {
            sqlBuffer.append("order by entry.FEndDate desc");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
        try {
            if (rowSet.next()) {
                return rowSet.getString("materialID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected boolean isInProductLineChanging(ProductLineChangingInfo productLineChangingInfo, String currProduct) throws BOSException, EASBizException {
        boolean isInChan = false;
        if (productLineChangingInfo == null) {
            throw new SchedulingException(SchedulingException.NOCHANGE);
        }
        ProductLineChangingEntryCollection entryCollection = productLineChangingInfo.getEntrys();
        if (entryCollection != null && entryCollection.size() > 0) {
            for (int i = 0; i < entryCollection.size(); ++i) {
                ProductLineChangingEntryInfo productLineChangingEntry = entryCollection.get(i);
                if (!productLineChangingEntry.getMaterial().getId().toString().equals(currProduct)) continue;
                isInChan = true;
                break;
            }
        } else {
            throw new SchedulingException(SchedulingException.NOCHANGEENTRY, new Object[]{productLineChangingInfo.getNumber()});
        }
        return isInChan;
    }

    protected List getReturnList() {
        return this.returnList;
    }

    protected List getExceptions() {
        return this.exceptions;
    }
}

