/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.IBOMExtend2Facade;
import com.kingdee.eas.mm.planning.CentralPurReqPlanException;
import com.kingdee.eas.mm.planning.CentralPurReqPlanInfo;
import com.kingdee.eas.mm.project.ProjectTaskCentralPurOrgCollection;
import com.kingdee.eas.mm.project.ProjectTaskCollection;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CentralPurReqPlanUtil {
    public static final int NOPLAN_VALUE = 10;
    public static final int PLANNED_VALUE = 20;
    public static final int REPLAN_VALUE = 30;
    public static final int CLOSED_VALUE = 40;
    public static final int FAILURE_VALUE = 50;
    public static final int Is_WriteOff = 1;
    public static final int Not_WriteOff = 0;
    public static final String Is_Null_Str = "999999999";

    public static List createCentralPurReqPlan(List paramLst, ProjectTaskInfo info) {
        if (info.getCentralPurStgOrg() != null) {
            paramLst.add(info.getCentralPurStgOrg().getId().toString());
        } else {
            paramLst.add("");
        }
        if (info.getMaterial() != null) {
            paramLst.add(info.getMaterial().getId().toString());
        } else {
            paramLst.add("");
        }
        if (info.getUnit() != null) {
            paramLst.add(info.getUnit().getId().toString());
        } else {
            paramLst.add("");
        }
        paramLst.add(info.getQty());
        paramLst.add(info.getPlanBeginTime());
        paramLst.add(info.getPlanEndTime());
        if (info.getStorageOrgUnit() != null) {
            paramLst.add(info.getStorageOrgUnit().getId().toString());
        } else {
            paramLst.add("");
        }
        paramLst.add(info.getNumber());
        paramLst.add(info.getId().toString());
        if (info.getProject() != null) {
            paramLst.add(info.getProject().getId().toString());
        } else {
            paramLst.add("");
        }
        if (info.getCarNumber() != null) {
            paramLst.add(info.getCarNumber().getId().toString());
        } else {
            paramLst.add("");
        }
        return paramLst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map batchTransfer(Context ctx, List idList) throws BOSException, EASBizException {
        HashMap<String, CentralPurReqPlanException> errors = new HashMap<String, CentralPurReqPlanException>();
        if (idList.size() <= 0) {
            return errors;
        }
        HashSet ids = new HashSet();
        int n = idList.size();
        for (int i = 0; i < n; ++i) {
            ids.add(idList.get(i));
        }
        StringBuffer sqlSB = new StringBuffer("");
        String clr = "\r\n";
        ArrayList paramLst = new ArrayList();
        IRowSet rs = null;
        String msg = null;
        Object messageFormat = null;
        Iterator<Object> iterator = null;
        sqlSB.setLength(0);
        sqlSB.append(" select t4.id,t4.fnumber from T_MM_CentralPurReqPlan as t3 ").append(clr).append(" inner join (select t1.fid fid, t2.fnumber fnumber, t2.fid id from t_mm_projecttask t1 ,t_mm_projecttask t2 ").append(clr).append(" where SUBSTRING(t2.fwbsnumber,0,LENGTH(t1.fwbsnumber) + 1 ) = t1.fwbsnumber || '.' ").append(clr).append(" AND t1.FLevel < t2.flevel and t2.fprojectid =t1.fprojectid ").append(clr).append(" AND t2.fid in ").append(CentralPurReqPlanUtil.getInPredicateFromList(idList)).append(" ) as t4 ").append(clr).append(" on t3.FSourceBillId=t4.fid ").append(clr);
        paramLst.clear();
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
        try {
            HashSet<String> error = new HashSet<String>();
            while (rs.next()) {
                error.add(rs.getString("id"));
                ids.remove(rs.getString("id"));
            }
            if (error.size() > 0) {
                iterator = error.iterator();
                while (iterator.hasNext()) {
                    errors.put((String)iterator.next(), new CentralPurReqPlanException(CentralPurReqPlanException.PLANTRANSFER_NOT_PARENTPROJECTTASK));
                }
            }
        }
        catch (SQLException sqlExp) {
            throw new SQLDataException(sqlExp);
        }
        if (ids.size() == 0) {
            return errors;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        ProjectTaskCollection coll = ProjectTaskFactory.getLocalInstance((Context)ctx).getProjectTaskCollection(viewInfo);
        ProjectTaskInfo info = null;
        UserInfo useInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = "";
        if (useInfo != null) {
            userId = useInfo.getId().toString();
        }
        HashMap<String, ProjectTaskInfo> pjTaskMap = new HashMap<String, ProjectTaskInfo>();
        iterator = coll.iterator();
        String projectTaskId2 = null;
        while (iterator.hasNext()) {
            info = (ProjectTaskInfo)iterator.next();
            pjTaskMap.put(info.getId().toString(), info);
        }
        sqlSB.setLength(0);
        sqlSB.append(" SELECT Fid,FSourceBillId,FStatus from T_MM_CentralPurReqPlan").append(clr).append(" WHERE FSourceBillId in ").append(CentralPurReqPlanUtil.getInPredicateFromList(new ArrayList(ids))).append(clr);
        paramLst.clear();
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
        ArrayList<String> closedList = new ArrayList<String>();
        ArrayList<String> failuretList = new ArrayList<String>();
        ArrayList<String> noPlanList = new ArrayList<String>();
        ArrayList<String> planedList = new ArrayList<String>();
        ArrayList<String> rePlanList = new ArrayList<String>();
        try {
            while (rs.next()) {
                int status = rs.getInt("FStatus");
                projectTaskId2 = rs.getString("FSourceBillId");
                info = (ProjectTaskInfo)pjTaskMap.get(projectTaskId2);
                if (40 == status) {
                    ids.remove(projectTaskId2);
                    closedList.add(projectTaskId2);
                    msg = CentralPurReqPlanUtil.getString(ctx, "PlanTransfer_NotTransfer_Closed");
                    errors.put(info.getId().toString(), new CentralPurReqPlanException(CentralPurReqPlanException.PLANUNTRANSFER_NOTTRANSFER_CLOSED));
                    continue;
                }
                if (50 == status) {
                    ids.remove(projectTaskId2);
                    failuretList.add(projectTaskId2);
                    msg = CentralPurReqPlanUtil.getString(ctx, "PlanTransfer_NotTransfer_Cancel");
                    errors.put(info.getId().toString(), new CentralPurReqPlanException(CentralPurReqPlanException.PLANUNTRANSFER_NOTTRANSFER_CANCEL));
                    continue;
                }
                if (10 == status) {
                    ids.remove(projectTaskId2);
                    noPlanList.add(projectTaskId2);
                    continue;
                }
                if (20 == status) {
                    ids.remove(projectTaskId2);
                    planedList.add(projectTaskId2);
                    continue;
                }
                if (30 != status) continue;
                ids.remove(projectTaskId2);
                rePlanList.add(projectTaskId2);
            }
        }
        catch (SQLException sqlExp) {
            throw new SQLDataException(sqlExp);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        String expandTablName = null;
        try {
            int i;
            int i2;
            conn = EJBFactory.getConnection((Context)ctx);
            if (noPlanList.size() > 0) {
                sqlSB.setLength(0);
                sqlSB.append(" UPDATE T_MM_CentralPurReqPlan").append(clr).append(" SET FStorageOrgUnitID = ?,FMaterialID = ?,FUnitID = ?,").append(clr).append(" FQty = ?,FPlanStartTime = ?,FPlanEndTime = ?, ").append(clr).append(" FSourceOrgUnitID = ?,FSourceBillNum = ?,FSourceBillId = ?, ").append(clr).append(" FProjectNumID = ?,FTrackNumID = ?,").append(clr).append(" FLastUpdateUserID = ?,FLastUpdateTime = getdate()  ").append(clr).append(" where FSourceBillId = ?").append(clr);
                stmt = conn.prepareStatement(sqlSB.toString());
                for (i2 = 0; i2 < noPlanList.size(); ++i2) {
                    info = (ProjectTaskInfo)pjTaskMap.get(noPlanList.get(i2));
                    if (info.getCentralPurStgOrg() != null) {
                        stmt.setString(1, info.getCentralPurStgOrg().getId().toString());
                    } else {
                        stmt.setString(1, "");
                    }
                    if (info.getMaterial() != null) {
                        stmt.setString(2, info.getMaterial().getId().toString());
                    } else {
                        stmt.setString(2, "");
                    }
                    if (info.getUnit() != null) {
                        stmt.setString(3, info.getUnit().getId().toString());
                    } else {
                        stmt.setString(3, "");
                    }
                    stmt.setBigDecimal(4, info.getQty());
                    stmt.setTimestamp(5, info.getPlanBeginTime());
                    stmt.setTimestamp(6, info.getPlanEndTime());
                    if (info.getStorageOrgUnit() != null) {
                        stmt.setString(7, info.getStorageOrgUnit().getId().toString());
                    } else {
                        stmt.setString(7, "");
                    }
                    stmt.setString(8, info.getNumber());
                    stmt.setString(9, info.getId().toString());
                    if (info.getProject() != null) {
                        stmt.setString(10, info.getProject().getId().toString());
                    } else {
                        stmt.setString(10, "");
                    }
                    if (info.getCarNumber() != null) {
                        stmt.setString(11, info.getCarNumber().getId().toString());
                    } else {
                        stmt.setString(11, "");
                    }
                    stmt.setString(12, userId);
                    stmt.setString(13, (String)noPlanList.get(i2));
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            if (planedList.size() > 0) {
                sqlSB.setLength(0);
                sqlSB.append(" UPDATE T_MM_CentralPurReqPlan").append(clr).append(" SET FStorageOrgUnitID = ?,FMaterialID = ?,FUnitID = ?,").append(clr).append(" FQty = ?,FPlanStartTime = ?,FPlanEndTime = ?, ").append(clr).append(" FSourceOrgUnitID = ?,FSourceBillNum = ?,FSourceBillId = ?, ").append(clr).append(" FProjectNumID = ?,FTrackNumID = ?,").append(clr).append(" FLastUpdateUserID = ?,FLastUpdateTime = getdate(),FStatus=?  ").append(clr).append(" where FSourceBillId = ?").append(clr);
                stmt = conn.prepareStatement(sqlSB.toString());
                for (i2 = 0; i2 < planedList.size(); ++i2) {
                    info = (ProjectTaskInfo)pjTaskMap.get(planedList.get(i2));
                    if (info.getCentralPurStgOrg() != null) {
                        stmt.setString(1, info.getCentralPurStgOrg().getId().toString());
                    } else {
                        stmt.setString(1, "");
                    }
                    if (info.getMaterial() != null) {
                        stmt.setString(2, info.getMaterial().getId().toString());
                    } else {
                        stmt.setString(2, "");
                    }
                    if (info.getUnit() != null) {
                        stmt.setString(3, info.getUnit().getId().toString());
                    } else {
                        stmt.setString(3, "");
                    }
                    stmt.setBigDecimal(4, info.getQty());
                    stmt.setTimestamp(5, info.getPlanBeginTime());
                    stmt.setTimestamp(6, info.getPlanEndTime());
                    if (info.getStorageOrgUnit() != null) {
                        stmt.setString(7, info.getStorageOrgUnit().getId().toString());
                    } else {
                        stmt.setString(7, "");
                    }
                    stmt.setString(8, info.getNumber());
                    stmt.setString(9, info.getId().toString());
                    if (info.getProject() != null) {
                        stmt.setString(10, info.getProject().getId().toString());
                    } else {
                        stmt.setString(10, "");
                    }
                    if (info.getCarNumber() != null) {
                        stmt.setString(11, info.getCarNumber().getId().toString());
                    } else {
                        stmt.setString(11, "");
                    }
                    stmt.setString(12, userId);
                    stmt.setInt(13, 30);
                    stmt.setString(14, (String)planedList.get(i2));
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            if (rePlanList.size() > 0) {
                sqlSB.setLength(0);
                sqlSB.append(" UPDATE T_MM_CentralPurReqPlan").append(clr).append(" SET FStorageOrgUnitID = ?,FMaterialID = ?,FUnitID = ?,").append(clr).append(" FQty = ?,FPlanStartTime = ?,FPlanEndTime = ?, ").append(clr).append(" FSourceOrgUnitID = ?,FSourceBillNum = ?,FSourceBillId = ?, ").append(clr).append(" FProjectNumID = ?,FTrackNumID = ?,").append(clr).append(" FLastUpdateUserID = ?,FLastUpdateTime = getdate()").append(clr).append(" where FSourceBillId = ?").append(clr);
                stmt = conn.prepareStatement(sqlSB.toString());
                for (i2 = 0; i2 < rePlanList.size(); ++i2) {
                    info = (ProjectTaskInfo)pjTaskMap.get(rePlanList.get(i2));
                    if (info.getCentralPurStgOrg() != null) {
                        stmt.setString(1, info.getCentralPurStgOrg().getId().toString());
                    } else {
                        stmt.setString(1, "");
                    }
                    if (info.getMaterial() != null) {
                        stmt.setString(2, info.getMaterial().getId().toString());
                    } else {
                        stmt.setString(2, "");
                    }
                    if (info.getUnit() != null) {
                        stmt.setString(3, info.getUnit().getId().toString());
                    } else {
                        stmt.setString(3, "");
                    }
                    stmt.setBigDecimal(4, info.getQty());
                    stmt.setTimestamp(5, info.getPlanBeginTime());
                    stmt.setTimestamp(6, info.getPlanEndTime());
                    if (info.getStorageOrgUnit() != null) {
                        stmt.setString(7, info.getStorageOrgUnit().getId().toString());
                    } else {
                        stmt.setString(7, "");
                    }
                    stmt.setString(8, info.getNumber());
                    stmt.setString(9, info.getId().toString());
                    if (info.getProject() != null) {
                        stmt.setString(10, info.getProject().getId().toString());
                    } else {
                        stmt.setString(10, "");
                    }
                    if (info.getCarNumber() != null) {
                        stmt.setString(11, info.getCarNumber().getId().toString());
                    } else {
                        stmt.setString(11, "");
                    }
                    stmt.setString(12, userId);
                    stmt.setString(13, (String)rePlanList.get(i2));
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            if (ids.size() == 0) {
                HashMap<String, CentralPurReqPlanException> i3 = errors;
                return i3;
            }
            for (String projectTaskId2 : ids) {
                info = (ProjectTaskInfo)pjTaskMap.get(projectTaskId2);
                if (info.getQty().compareTo(new BigDecimal("0.00")) > 0) continue;
                ids.remove(projectTaskId2);
                errors.put(info.getId().toString(), new CentralPurReqPlanException(CentralPurReqPlanException.PLANUNTRANSFER_NOTTRANSFER_QTY));
            }
            if (ids.size() == 0) {
                HashMap<String, CentralPurReqPlanException> i3 = errors;
                return i3;
            }
            iterator = ids.iterator();
            HashMap<String, Integer> centralPurStgOrgMap = new HashMap<String, Integer>();
            String centralPurStgOrg2 = null;
            Integer count = null;
            while (iterator.hasNext()) {
                info = (ProjectTaskInfo)pjTaskMap.get((String)iterator.next());
                ProjectTaskCentralPurOrgCollection purCol = info.getCentralPurStorageOrg();
                int size = purCol.size();
                for (int i4 = 0; i4 < size; ++i4) {
                    centralPurStgOrg2 = purCol.get(i4).getStorageOrgUnit().getId().toString();
                    if (!centralPurStgOrgMap.containsKey(centralPurStgOrg2)) {
                        centralPurStgOrgMap.put(centralPurStgOrg2, new Integer(1));
                        continue;
                    }
                    count = new Integer((Integer)centralPurStgOrgMap.get(centralPurStgOrg2) + 1);
                    centralPurStgOrgMap.put(centralPurStgOrg2, count);
                }
            }
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CentralPurReqPlanInfo cprpInfo = new CentralPurReqPlanInfo();
            String[] nums = null;
            HashMap<String, String[]> centralPurStgOrgCodingRuleMap = new HashMap<String, String[]>();
            HashMap<String, Integer> centralPurStgOrgCodeCountMap = new HashMap<String, Integer>();
            for (String centralPurStgOrg2 : centralPurStgOrgMap.keySet()) {
                nums = codingRuleManager.getBatchNumber((IObjectValue)cprpInfo, centralPurStgOrg2, ((Integer)centralPurStgOrgMap.get(centralPurStgOrg2)).intValue());
                centralPurStgOrgCodingRuleMap.put(centralPurStgOrg2, nums);
                centralPurStgOrgCodeCountMap.put(centralPurStgOrg2, new Integer(0));
            }
            CentralPurReqPlanInfo cInfo = new CentralPurReqPlanInfo();
            String bostype = cInfo.getBOSType().toString();
            CtrlUnitInfo cu = null;
            IMetaDataLoader loader = null;
            EntityObjectInfo entity = null;
            loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
            entity = loader.getEntity(cInfo.getBOSType());
            cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            expandTablName = CentralPurReqPlanUtil.createTempTable(ctx);
            sqlSB.setLength(0);
            sqlSB.append(" insert into ").append(clr).append(expandTablName).append(clr).append(" (FID,FProjectTaskID,FMATERIALID,FTrackNumberID,FProjectID,FStorageOrgUnitID) ").append(clr).append(" VALUES(?,?,?,?,?,?) ").append(clr);
            stmt = conn.prepareStatement(sqlSB.toString());
            int doCount = 0;
            HashMap<String, String> bomIDMap = new HashMap<String, String>();
            for (String projectTaskId2 : ids) {
                info = (ProjectTaskInfo)pjTaskMap.get(projectTaskId2);
                ProjectTaskCentralPurOrgCollection purCol = info.getCentralPurStorageOrg();
                int size = purCol.size();
                for (int i5 = 0; i5 < size; ++i5) {
                    if (info.getMaterial() != null) {
                        stmt.setString(1, info.getId().toString());
                        stmt.setString(2, info.getId().toString());
                        stmt.setString(3, info.getMaterial().getId().toString());
                        if (info.getCarNumber() != null) {
                            stmt.setString(4, info.getCarNumber().getId().toString());
                        } else {
                            stmt.setString(4, Is_Null_Str);
                        }
                        if (info.getProject() != null) {
                            stmt.setString(5, info.getProject().getId().toString());
                        } else {
                            stmt.setString(5, Is_Null_Str);
                        }
                        if (purCol.get(i5) != null) {
                            stmt.setString(6, purCol.get(i5).getStorageOrgUnit().getId().toString());
                        } else {
                            stmt.setString(6, "");
                        }
                        stmt.addBatch();
                        ++doCount;
                        continue;
                    }
                    bomIDMap.put(projectTaskId2 + purCol.get(i5).getStorageOrgUnit().getId().toString(), "");
                }
            }
            stmt.executeBatch();
            if (doCount > 0) {
                IBOMExtend2Facade iFacade = BOMExtend2FacadeFactory.getLocalInstance((Context)ctx);
                iFacade.getBomByTmpTab(expandTablName);
                sqlSB.setLength(0);
                sqlSB.append(" select FProjectTaskID,FBOMID,FStorageOrgUnitID from ").append(clr).append(expandTablName).append(clr);
                paramLst.clear();
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
                while (rs.next()) {
                    bomIDMap.put(rs.getString("FProjectTaskID") + rs.getString("FStorageOrgUnitID"), rs.getString("FBOMID"));
                }
            }
            sqlSB.setLength(0);
            sqlSB.append(" select ptPurOrg.fid as fid, pt.fid as ptId,u.FId as Funitid,mu.FBaseConvsRate,mu.FQtyPrecision from T_MM_ProjectTask pt ").append(clr).append(" INNER JOIN T_BD_Material m on m.FID = pt.FMaterialID ").append(clr).append(" INNER JOIN T_BD_MaterialPlan mp on m.FID = mp.FMaterialId AND mp.FStatus = 1 ").append(clr).append(" INNER JOIN T_BD_MultiMeasureUnit mu on mp.FProductunitid = mu.FMeasureUnitId and mp.FMaterialId = mu.FMaterialId ").append(clr).append(" INNER JOIN T_BD_MeasureUnit u on mu.FMeasureUnitId = u.FId ").append(clr).append(" INNER JOIN T_MM_ProjectTaskCentralPurOrg ptPurOrg on ptPurOrg.FParentId = pt.FId ").append(clr).append(" where mp.FOrgUnit =ptPurOrg.FStorageOrgUnitID and pt.fid in ").append(CentralPurReqPlanUtil.getInPredicateFromList(new ArrayList(ids))).append(clr);
            paramLst.clear();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
            HashMap<String, BigDecimal> proTaskIdToProductCoeffi = new HashMap<String, BigDecimal>();
            HashMap<String, Integer> proTaskIdToQtyPrecision = new HashMap<String, Integer>();
            HashMap<String, String> proTaskIdToUnit = new HashMap<String, String>();
            int qtyPrecision = 4;
            BigDecimal coefficient = new BigDecimal("1.0");
            while (rs.next()) {
                proTaskIdToProductCoeffi.put(rs.getString("fid"), rs.getBigDecimal("FBaseConvsRate"));
                proTaskIdToQtyPrecision.put(rs.getString("fid"), new Integer(rs.getInt("FQtyPrecision")));
                proTaskIdToUnit.put(rs.getString("fid"), rs.getString("Funitid"));
            }
            sqlSB.setLength(0);
            sqlSB.append(" insert into T_MM_CentralPurReqPlan").append(clr).append(" (FID,FNumber,FStorageOrgUnitID,FMaterialID,FUnitID,FQty, ").append(clr).append(" FPlanStartTime,FPlanEndTime,FSourceOrgUnitID,FSourceBillNum,").append(clr).append(" FSourceBillId,FProjectNumID,FTrackNumID,FIsWriteOff,FSourceType,").append(clr).append(" FStatus,FCreatorID,FCreateTime,FControlUnitID,FBomID,FLastUpdateUserID, FLastUpdateTime,FBaseQty,FBaseUnitID)").append(clr).append(" VALUES(NEWBOSID('").append(bostype).append("'),").append(clr).append("?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,getdate(),?,?,?,getdate(),?,?)").append(clr);
            stmt = conn.prepareStatement(sqlSB.toString());
            iterator = ids.iterator();
            int j = 0;
            while (iterator.hasNext()) {
                projectTaskId2 = (String)iterator.next();
                info = (ProjectTaskInfo)pjTaskMap.get(projectTaskId2);
                ProjectTaskCentralPurOrgCollection purCol = info.getCentralPurStorageOrg();
                int size = purCol.size();
                for (int i6 = 0; i6 < size; ++i6) {
                    String purOrgEntryId = purCol.get(i6).getId().toString();
                    if (purCol.get(i6) != null) {
                        centralPurStgOrg2 = purCol.get(i6).getStorageOrgUnit().getId().toString();
                        nums = (String[])centralPurStgOrgCodingRuleMap.get(centralPurStgOrg2);
                        j = (Integer)centralPurStgOrgCodeCountMap.get(centralPurStgOrg2);
                        stmt.setString(1, nums[j]);
                        centralPurStgOrgCodeCountMap.put(centralPurStgOrg2, new Integer(j + 1));
                    } else {
                        stmt.setString(1, "");
                    }
                    if (purCol.get(i6) != null) {
                        stmt.setString(2, purCol.get(i6).getStorageOrgUnit().getId().toString());
                    } else {
                        stmt.setString(2, "");
                    }
                    if (info.getMaterial() != null) {
                        stmt.setString(3, info.getMaterial().getId().toString());
                    } else {
                        stmt.setString(3, "");
                    }
                    if (proTaskIdToUnit.get(purOrgEntryId) != null) {
                        stmt.setString(4, (String)proTaskIdToUnit.get(purOrgEntryId));
                    } else {
                        stmt.setString(4, "");
                    }
                    if (proTaskIdToProductCoeffi.get(purOrgEntryId) != null) {
                        coefficient = (BigDecimal)proTaskIdToProductCoeffi.get(purOrgEntryId);
                    }
                    if (proTaskIdToQtyPrecision.get(purOrgEntryId) != null) {
                        qtyPrecision = (Integer)proTaskIdToQtyPrecision.get(purOrgEntryId);
                    }
                    stmt.setBigDecimal(5, info.getBaseQty().divide(coefficient, qtyPrecision, 4));
                    stmt.setTimestamp(6, info.getPlanBeginTime());
                    stmt.setTimestamp(7, info.getPlanEndTime());
                    if (info.getStorageOrgUnit() != null) {
                        stmt.setString(8, info.getStorageOrgUnit().getId().toString());
                    } else {
                        stmt.setString(8, "");
                    }
                    stmt.setString(9, info.getNumber());
                    stmt.setString(10, info.getId().toString());
                    if (info.getProject() != null) {
                        stmt.setString(11, info.getProject().getId().toString());
                    } else {
                        stmt.setString(11, "");
                    }
                    if (info.getCarNumber() != null) {
                        stmt.setString(12, info.getCarNumber().getId().toString());
                    } else {
                        stmt.setString(12, "");
                    }
                    stmt.setInt(13, 0);
                    stmt.setInt(14, 10);
                    stmt.setInt(15, 10);
                    stmt.setString(16, userId);
                    stmt.setString(17, cu.getId().toString());
                    stmt.setString(18, (String)bomIDMap.get(info.getId().toString() + centralPurStgOrg2));
                    stmt.setString(19, userId);
                    stmt.setBigDecimal(20, info.getBaseQty());
                    if (info.getBaseUnit() != null) {
                        stmt.setString(21, info.getBaseUnit().getId().toString());
                    } else {
                        stmt.setString(21, "");
                    }
                    stmt.addBatch();
                }
            }
            stmt.executeBatch();
            sqlSB.setLength(0);
            sqlSB.append(" select t4.fid,t4.fparentid,t3.FStorageOrgUnitID from T_MM_CentralPurReqPlan as t3 ").append(clr).append(" inner join (select t2.fid fid,t1.fid fparentid from t_mm_projecttask t1 ,t_mm_projecttask  t2 ").append(clr).append(" where SUBSTRING(t2.fwbsnumber,0,LENGTH(t1.fwbsnumber) + 1 ) = t1.fwbsnumber || '.' ").append(clr).append(" AND t1.FLevel < t2.flevel and t2.fprojectid =t1.fprojectid ").append(clr).append(" AND t1.fid in ").append(CentralPurReqPlanUtil.getInPredicateFromList(new ArrayList(ids))).append(" ) as t4 ").append(clr).append(" on t3.FSourceBillId=t4.fid ").append(clr).append(" where t3.FWriteOffId is null or t3.FWriteOffId='' ").append(clr);
            paramLst.clear();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
            if (rs.size() > 0) {
                sqlSB.setLength(0);
                sqlSB.append(" UPDATE T_MM_CentralPurReqPlan").append(clr).append(" SET FIsWriteOff = ?, FWriteOffNum =  ").append(clr).append(" (select Fnumber from T_MM_CentralPurReqPlan where FSourceBillId = ? and FStorageOrgUnitID = ?),").append(clr).append(" FWriteOffId = (select Fid from T_MM_CentralPurReqPlan where FSourceBillId = ? and FStorageOrgUnitID = ?),").append(clr).append(" FLastUpdateUserID = ?,FLastUpdateTime = getdate() ").append(clr).append(" where FSourceBillId = ? and FStorageOrgUnitID = ?").append(clr);
                stmt = conn.prepareStatement(sqlSB.toString());
                while (rs.next()) {
                    stmt.setInt(1, 1);
                    stmt.setString(2, rs.getString("fparentid"));
                    stmt.setString(3, rs.getString("FStorageOrgUnitID"));
                    stmt.setString(4, rs.getString("fparentid"));
                    stmt.setString(5, rs.getString("FStorageOrgUnitID"));
                    stmt.setString(6, userId);
                    stmt.setString(7, rs.getString("fid"));
                    stmt.setString(8, rs.getString("FStorageOrgUnitID"));
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            sqlSB.setLength(0);
            sqlSB.append(" select t4.fid,t4.fparentid,t3.fid CPRPfid,t3.FStatus from T_MM_CentralPurReqPlan as t3 ").append(clr).append(" inner join (select t2.fid fid,t1.fid fparentid from t_mm_projecttask t1 ,t_mm_projecttask  t2 ").append(clr).append(" where SUBSTRING(t2.fwbsnumber,0,LENGTH(t1.fwbsnumber) + 1 ) = t1.fwbsnumber || '.' ").append(clr).append(" AND t1.FLevel < t2.flevel and t2.fprojectid =t1.fprojectid ").append(clr).append(" AND t1.fid in ").append(CentralPurReqPlanUtil.getInPredicateFromList(new ArrayList(ids))).append(" ) as t4 ").append(clr).append(" on t3.FSourceBillId=t4.fid ").append(clr);
            paramLst.clear();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
            ArrayList<String> changeNoPlanList = new ArrayList<String>();
            ArrayList<String> changeRePlanList = new ArrayList<String>();
            while (rs.next()) {
                if (10 == rs.getInt("FStatus")) {
                    changeNoPlanList.add(rs.getString("CPRPfid"));
                    continue;
                }
                if (30 != rs.getInt("FStatus")) continue;
                changeRePlanList.add(rs.getString("CPRPfid"));
            }
            if (changeNoPlanList.size() > 0) {
                sqlSB.setLength(0);
                sqlSB.append(" UPDATE T_MM_CentralPurReqPlan").append(clr).append(" SET FStatus = ?, FLastUpdateUserID = ?,FLastUpdateTime = getdate()  ").append(clr).append(" where FId = ?").append(clr);
                stmt = conn.prepareStatement(sqlSB.toString());
                for (i = 0; i < changeNoPlanList.size(); ++i) {
                    stmt.setInt(1, 50);
                    stmt.setString(2, userId);
                    stmt.setString(3, (String)changeNoPlanList.get(i));
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            if (changeRePlanList.size() > 0) {
                sqlSB.setLength(0);
                sqlSB.append(" UPDATE T_MM_CentralPurReqPlan").append(clr).append(" SET FStatus = ?, FLastUpdateUserID = ?,FLastUpdateTime = getdate()  ").append(clr).append(" where FId = ?").append(clr);
                stmt = conn.prepareStatement(sqlSB.toString());
                for (i = 0; i < changeRePlanList.size(); ++i) {
                    stmt.setInt(1, 40);
                    stmt.setString(2, userId);
                    stmt.setString(3, (String)changeRePlanList.get(i));
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            if (expandTablName == null) return errors;
        }
        catch (SQLException er) {
            throw new SQLDataException(er);
        }
        finally {
            SQLUtils.cleanup(stmt, (Connection)conn);
            if (expandTablName != null) {
                TempTablePool pool = TempTablePool.getInstance((Context)ctx);
                pool.releaseTable(expandTablName);
            }
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(expandTablName);
        return errors;
    }

    public static String createTempTable(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        String cr = "\r\n";
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("create table bomexpand (").append(cr).append(" FID varchar(44) null, ").append(cr).append(" FProjectTaskID varchar(44) null, ").append(cr).append(" FBOMID varchar(44) null, ").append(cr).append(" FMATERIALID varchar(44) null, ").append(cr).append("FTrackNumberID varchar(44) null, ").append(cr).append("FProjectID varchar(44) null, ").append(cr).append("FStorageOrgUnitID varchar(44) null ").append(cr).append(")");
            expandTablName = pool.createTempTable(sqlBuf.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }

    public static String getInPredicateFromList(List idList) {
        StringBuffer ids = new StringBuffer();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            ids.append(",'").append((String)it.next()).append("'");
        }
        if (ids.length() > 0) {
            ids.setCharAt(0, '(');
            ids.append(")");
        }
        return ids.toString();
    }

    public static Map batchUnTransfer(Context ctx, List idList) throws BOSException, EASBizException {
        HashMap<String, CentralPurReqPlanException> errors = new HashMap<String, CentralPurReqPlanException>();
        ArrayList<String> errorIds = new ArrayList<String>();
        if (idList.size() <= 0) {
            return errors;
        }
        HashSet ids = new HashSet();
        int n = idList.size();
        for (int i = 0; i < n; ++i) {
            ids.add(idList.get(i));
        }
        StringBuffer sqlSB = new StringBuffer("");
        String clr = "\r\n";
        ArrayList paramLst = new ArrayList();
        IRowSet rs = null;
        String msg = null;
        Object messageFormat = null;
        Iterator iterator = null;
        sqlSB.setLength(0);
        sqlSB.append(" select t4.id,t4.fnumber from T_MM_CentralPurReqPlan as t3 ").append(clr).append(" inner join (select t1.fid fid, t2.fnumber fnumber, t2.fid id from t_mm_projecttask t1 ,t_mm_projecttask t2 ").append(clr).append(" where SUBSTRING(t2.fwbsnumber,0,LENGTH(t1.fwbsnumber) + 1 ) = t1.fwbsnumber || '.' ").append(clr).append(" AND t1.FLevel < t2.flevel and t2.fprojectid =t1.fprojectid ").append(clr).append(" AND t2.fid in ").append(CentralPurReqPlanUtil.getInPredicateFromList(idList)).append(" ) as t4 ").append(clr).append(" on t3.FSourceBillId=t4.fid ").append(clr);
        paramLst.clear();
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
        try {
            HashSet<String> error = new HashSet<String>();
            while (rs.next()) {
                error.add(rs.getString("id"));
                ids.remove(rs.getString("id"));
            }
            if (error.size() > 0) {
                iterator = error.iterator();
                while (iterator.hasNext()) {
                    msg = CentralPurReqPlanUtil.getString(ctx, "PlanUnTransfer_Not_ParentProjectTask");
                    errors.put((String)iterator.next(), new CentralPurReqPlanException(CentralPurReqPlanException.PLANUNTRANSFER_NOT_PARENTPROJECTTASK));
                }
            }
        }
        catch (SQLException sqlExp) {
            throw new SQLDataException(sqlExp);
        }
        if (ids.size() == 0) {
            return errors;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit.id"));
        ProjectTaskCollection coll = ProjectTaskFactory.getLocalInstance((Context)ctx).getProjectTaskCollection(viewInfo);
        ProjectTaskInfo info = null;
        String userId = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        HashMap<String, ProjectTaskInfo> pjTaskMap = new HashMap<String, ProjectTaskInfo>();
        iterator = coll.iterator();
        String projectTaskId = null;
        while (iterator.hasNext()) {
            info = (ProjectTaskInfo)iterator.next();
            pjTaskMap.put(info.getId().toString(), info);
        }
        sqlSB.setLength(0);
        sqlSB.append(" SELECT Fid,FStatus,fnumber,FSourceBillId from T_MM_CentralPurReqPlan ").append(clr).append(" WHERE ");
        ProjectTaskInfo projectInfo = null;
        String storageOrgUnitId = null;
        String projTaskId = null;
        if (idList.size() > 0) {
            for (int j = 0; j < idList.size() - 1; ++j) {
                projTaskId = (String)idList.get(j);
                projectInfo = (ProjectTaskInfo)pjTaskMap.get(projTaskId);
                storageOrgUnitId = projectInfo.getStorageOrgUnit().getId().toString();
                sqlSB.append("(FSourceBillId='").append(projTaskId).append("'").append(" and FSourceOrgUnitID='").append(storageOrgUnitId).append("') or ");
            }
            projTaskId = (String)idList.get(idList.size() - 1);
            projectInfo = (ProjectTaskInfo)pjTaskMap.get(projTaskId);
            storageOrgUnitId = projectInfo.getStorageOrgUnit().getId().toString();
            sqlSB.append("(FSourceBillId='").append(projTaskId).append("'").append(" and FSourceOrgUnitID='").append(storageOrgUnitId).append("')").append(clr);
        } else {
            sqlSB.append("(FSourceBillId='").append("null").append("'").append(" and FSourceOrgUnitID='").append("null").append("')").append(clr);
        }
        paramLst.clear();
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
        ArrayList<String> closedList = new ArrayList<String>();
        ArrayList<String> failuretList = new ArrayList<String>();
        ArrayList<String> noPlanList = new ArrayList<String>();
        ArrayList<String> planedList = new ArrayList<String>();
        ArrayList<String> rePlanList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            while (rs.next()) {
                int status = rs.getInt("FStatus");
                projectTaskId = rs.getString("FSourceBillId");
                info = (ProjectTaskInfo)pjTaskMap.get(projectTaskId);
                if (40 == status) {
                    ids.remove(projectTaskId);
                    closedList.add(projectTaskId);
                    errorIds.add(projectTaskId);
                    msg = CentralPurReqPlanUtil.getString(ctx, "PlanUnTransfer_NotTransfer_Closed");
                    errors.put(info.getId().toString(), new CentralPurReqPlanException(CentralPurReqPlanException.PLANUNTRANSFER_NOTTRANSFER_CLOSED));
                    continue;
                }
                if (50 == status) {
                    ids.remove(projectTaskId);
                    errorIds.add(projectTaskId);
                    failuretList.add(projectTaskId);
                    msg = CentralPurReqPlanUtil.getString(ctx, "PlanUnTransfer_NotTransfer_Cancel");
                    errors.put(info.getId().toString(), new CentralPurReqPlanException(CentralPurReqPlanException.PLANUNTRANSFER_NOTTRANSFER_CANCEL));
                    errorIds.add(projectTaskId);
                    continue;
                }
                if (10 == status) {
                    if (noPlanList.contains(projectTaskId)) continue;
                    ids.remove(projectTaskId);
                    noPlanList.add(projectTaskId);
                    continue;
                }
                if (20 == status) {
                    ids.remove(projectTaskId);
                    planedList.add(projectTaskId);
                    msg = CentralPurReqPlanUtil.getString(ctx, "PlanUnTransfer_NotTransfer_Planed");
                    errorIds.add(projectTaskId);
                    errors.put(info.getId().toString(), new CentralPurReqPlanException(CentralPurReqPlanException.PLANUNTRANSFER_NOTTRANSFER_PLANED));
                    continue;
                }
                if (30 != status) continue;
                ids.remove(projectTaskId);
                rePlanList.add(projectTaskId);
                errorIds.add(projectTaskId);
                msg = CentralPurReqPlanUtil.getString(ctx, "PlanUnTransfer_NotTransfer_RePlan");
                errors.put(info.getId().toString(), new CentralPurReqPlanException(CentralPurReqPlanException.PLANUNTRANSFER_NOTTRANSFER_REPLAN));
            }
            int size = errorIds.size();
            for (int i = 0; i < size; ++i) {
                if (!noPlanList.contains(errorIds.get(i))) continue;
                noPlanList.remove(errorIds.get(i));
            }
            if (noPlanList.size() > 0) {
                int i;
                conn = EJBFactory.getConnection((Context)ctx);
                ArrayList<String> noPlanFailureList = new ArrayList<String>();
                ArrayList<String> noPlanElseList = new ArrayList<String>();
                sqlSB.setLength(0);
                sqlSB.append(" select t1.FSourceBillId fid from T_MM_CentralPurReqPlan as t1 inner join ").append(clr).append(" T_MM_CentralPurReqPlan as t2 on t1.FWriteOffNum = t2.fnumber ").append(clr).append(" where t2.FSourceBillId in ").append(CentralPurReqPlanUtil.getInPredicateFromList(noPlanList)).append(clr).append(" and t1.FStatus = 50 ").append(clr);
                paramLst.clear();
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
                while (rs.next()) {
                    noPlanFailureList.add(rs.getString("fid"));
                }
                sqlSB.setLength(0);
                sqlSB.append(" select t1.FSourceBillId fid from T_MM_CentralPurReqPlan as t1 inner join ").append(clr).append(" T_MM_CentralPurReqPlan as t2 on t1.FWriteOffNum = t2.fnumber ").append(clr).append(" where t2.FSourceBillId in ").append(CentralPurReqPlanUtil.getInPredicateFromList(noPlanList)).append(clr).append(" and t1.FStatus <> 50 ").append(clr);
                paramLst.clear();
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
                while (rs.next()) {
                    noPlanElseList.add(rs.getString("fid"));
                }
                sqlSB.setLength(0);
                sqlSB.append(" update T_MM_CentralPurReqPlan ").append(clr).append(" SET FIsWriteOff = ?, FWriteOffNum = '',FWriteOffId = '',  ").append(clr).append(" FLastUpdateUserID = ?,FLastUpdateTime = getdate()  ").append(clr).append(" where FSourceBillId = ? ");
                stmt = conn.prepareStatement(sqlSB.toString());
                for (i = 0; i < noPlanElseList.size(); ++i) {
                    stmt.setInt(1, 0);
                    stmt.setString(2, userId);
                    stmt.setString(3, (String)noPlanElseList.get(i));
                    stmt.addBatch();
                }
                stmt.executeBatch();
                sqlSB.setLength(0);
                sqlSB.append(" update T_MM_CentralPurReqPlan ").append(clr).append(" SET FIsWriteOff = ?, FWriteOffNum = '',FWriteOffId = '',FStatus = ?, ").append(clr).append(" FLastUpdateUserID = ?,FLastUpdateTime = getdate()  ").append(clr).append(" where FSourceBillId = ? ");
                stmt = conn.prepareStatement(sqlSB.toString());
                for (i = 0; i < noPlanFailureList.size(); ++i) {
                    stmt.setInt(1, 0);
                    stmt.setInt(2, 10);
                    stmt.setString(3, userId);
                    stmt.setString(4, (String)noPlanFailureList.get(i));
                    stmt.addBatch();
                }
                stmt.executeBatch();
                sqlSB.setLength(0);
                sqlSB.append(" delete T_MM_CentralPurReqPlan").append(clr).append(" where FSourceBillId = ? ").append(clr);
                stmt = conn.prepareStatement(sqlSB.toString());
                for (i = 0; i < noPlanList.size(); ++i) {
                    stmt.setString(1, (String)noPlanList.get(i));
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            if (ids.size() > 0) {
                iterator = ids.iterator();
                while (iterator.hasNext()) {
                    info = (ProjectTaskInfo)pjTaskMap.get((String)iterator.next());
                    msg = CentralPurReqPlanUtil.getString(ctx, "PlanUnTransfer_Not_NoProjectTask");
                    errors.put(info.getId().toString(), new CentralPurReqPlanException(CentralPurReqPlanException.PLANUNTRANSFER_NOT_NOPROJECTTASK));
                }
            }
        }
        catch (SQLException sqlExp) {
            try {
                throw new SQLDataException(sqlExp);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(stmt, (Connection)conn);
        return errors;
    }

    public static String getString(Context ctx, String resourceName) {
        String path = "com.kingdee.eas.mm.planning.CentralPurReqPlanResource";
        String strTemp = ResourceBase.getString((String)path, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }
}

