/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.CooperatePlanOrderAgent;
import com.kingdee.eas.mm.planning.CooperatePlanOrderEntryInfo;
import com.kingdee.eas.mm.planning.CooperatePlanOrderInfo;
import com.kingdee.eas.mm.planning.CooperatePlanOrderSourceEnum;
import com.kingdee.eas.mm.planning.app.AbstractCooperatePlanOrderControllerBean;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CooperatePlanOrderControllerBean
extends AbstractCooperatePlanOrderControllerBean
implements IBatchExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.CooperatePlanOrderControllerBean");

    @Override
    protected IObjectValue _createNewCoPlanOrder(Context ctx, boolean isUseAgent, StorageOrgUnitInfo storageOrgUnitInfo) throws BOSException, EASBizException {
        OrgUnitInfo[] mainOrgs;
        CooperatePlanOrderInfo coPlanOrder = null;
        coPlanOrder = isUseAgent ? CooperatePlanOrderAgent.create() : new CooperatePlanOrderInfo();
        IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
        BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK(this.getBillTypeId()));
        coPlanOrder.setBillType(billTypeInfo);
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        coPlanOrder.setBizDate(curDate);
        coPlanOrder.setRequestDate(curDate);
        if (storageOrgUnitInfo == null && (mainOrgs = SCMServiceFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits(ctx.getCaller(), OrgType.Storage, "mm_COPlanOrder_addnew")) != null && mainOrgs.length > 0) {
            mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            storageOrgUnitInfo = (StorageOrgUnitInfo)mainOrgs[0];
        }
        if (storageOrgUnitInfo != null) {
            coPlanOrder.setStorageOrgUnit(storageOrgUnitInfo);
            coPlanOrder.setRequestOrgUnit(storageOrgUnitInfo);
        }
        coPlanOrder.setRequestQty(new BigDecimal("0.00"));
        coPlanOrder.setRequestBaseQty(new BigDecimal("0.00"));
        coPlanOrder.setSourceType(CooperatePlanOrderSourceEnum.MANUAL_INPUT);
        return coPlanOrder;
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            this.submitBatchCheck(ctx, batchResults);
        } else if (!batchAction.equals((Object)BatchActionEnum.AUDIT) && batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.unAuditBatchCheck(ctx, batchResults);
        }
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.getToDoIdsArray().length > 0) {
            if (batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
                this.afterSubmit(ctx, batchResults);
            } else if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                this.afterAudit(ctx, batchResults);
            } else if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
                // empty if block
            }
        }
    }

    public BatchActionResults batchSubmitRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return super.batchSubmitRelations(ctx, entries);
    }

    private void submitBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        String msg = null;
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                CooperatePlanOrderInfo coPlanOrder = (CooperatePlanOrderInfo)collection.getObject(i);
                String id = coPlanOrder.getId() == null ? "NEWID" : coPlanOrder.getId().toString();
                LinkedList<String> supplyOrgUnitList = new LinkedList<String>();
                if (!batchResults.isToDo(id)) continue;
                MaterialPlanInfo materialPlanInfo = (MaterialPlanInfo)coPlanOrder.get("materialPlan");
                if (materialPlanInfo != null && materialPlanInfo.getManufactureStrategy() != null) {
                    if ("fpPxtypCS/ihJ30GjB/UJtg0uEU=".equals(materialPlanInfo.getManufactureStrategy().getId().toString()) && coPlanOrder.getTrackNumber() == null) {
                        msg = this.getResource(ctx, "TRACKNUMBER_CANNOT_NULL");
                        batchResults.addError(id, msg);
                    }
                    if ("GE2FIa4GQ6uhdx0RDGuibtg0uEU=".equals(materialPlanInfo.getManufactureStrategy().getId().toString()) && coPlanOrder.getProject() == null) {
                        msg = this.getResource(ctx, "PROJECT_CANNOT_DUPLICATE");
                        batchResults.addError(id, msg);
                    }
                }
                for (int j = 0; j < coPlanOrder.getEntries().size(); ++j) {
                    CooperatePlanOrderEntryInfo coPlanOrderEntry = coPlanOrder.getEntries().get(j);
                    StorageOrgUnitInfo supplyOrgUnit = coPlanOrderEntry.getSupplyOrgUnit();
                    if (supplyOrgUnit != null) {
                        if (supplyOrgUnitList.size() > 0 && supplyOrgUnitList.contains(supplyOrgUnit.getId().toString())) {
                            msg = MessageFormat.format(this.getResource(ctx, "SUPPLYORGUNIT_CANNOT_DUPLICATE"), supplyOrgUnit.getName());
                            batchResults.addError(id, msg);
                        } else {
                            supplyOrgUnitList.add(supplyOrgUnit.getId().toString());
                        }
                    }
                    if (!coPlanOrderEntry.getReceiptDate().before(calendar.getTime())) continue;
                    msg = MessageFormat.format(this.getResource(ctx, "RECEIPTDATE_CANNOT_LT_CURRENTDATE"), supplyOrgUnit.getName());
                    batchResults.addError(id, msg);
                }
            }
        }
    }

    private void unAuditBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sqlBuffer = new StringBuffer();
        String msg = null;
        sqlBuffer.append("select T.FID COPOID, T.FStorageOrgUnitID StorageOrgUnitID ").append("from T_MM_CooperatePlanOrder T ").append("where T.FID in (").append(idStr).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        try {
            while (rs.next()) {
                boolean isUnAudit = false;
                String strAutoAudit = scmParam.getParamByBillTypeID("MM_Audit_02", 4, rs.getString("StorageOrgUnitID"), this.getBillTypeId());
                if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equals("1")) {
                    isUnAudit = true;
                }
                if (isUnAudit) continue;
                msg = this.getResource(ctx, "PARAM_UNAUDIT_NOT_ALLOEWED");
                batchResults.addError(rs.getString("COPOID"), msg);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void afterSubmit(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update T_MM_CooperatePlanOrderEntry as t0  ").append("set (FMaterialId, FUnitId) = ").append("(select T3.FMaterialId, T3.FProductUnitId from T_MM_CooperatePlanOrder t3 ").append(" where t0.FParentId=t3.fid) ").append("where t0.FParentID in (").append(idStr).append(") ");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    private void afterAudit(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select T.FID COPOID from T_MM_CooperatePlanOrder T ").append("where T.FID in (").append(idStr).append(") ").append("and T.FSourceType=").append(20);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        IRowSet entryResult = null;
        String updateSql = "update T_MM_CooperatePlanOrderEntry set FSeq=? where FID=?";
        try {
            while (rs.next()) {
                sqlBuffer.setLength(0);
                sqlBuffer.append("select FID from T_MM_CooperatePlanOrderEntry where FParentId='").append(rs.getString("COPOID")).append("' ");
                entryResult = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
                int i = 1;
                Object[] params = null;
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                while (entryResult.next()) {
                    params = new Object[]{new Integer(i++), entryResult.getString("FID")};
                    paramsList.add(params);
                }
                if (paramsList.size() <= 0) continue;
                DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sqlBuffer.setLength(0);
        sqlBuffer.append("update t_mm_CooperatePlanOrderEntry CoEntry set FIsSameCompanyOrgUnit = ").append("(select case when UnitRelation.FTOUnitID = EntryUnitRelation.FTOUnitID then 1 else 0 end ").append("from t_mm_CooperatePlanOrder CoPo ").append("left outer join t_mm_CooperatePlanOrderEntry Entry on CoPo.FID = Entry.FParentId ").append("left outer join T_ORG_UnitRelation UnitRelation ").append("on CoPo.FStorageOrgUnitID = UnitRelation.FFromUnitID ").append("and UnitRelation.FTypeRelationid = '").append("00000000-0000-0000-0000-0000000000070FE9F8B5").append("' left outer join T_ORG_UnitRelation EntryUnitRelation ").append("on entry.FSupplyOrgUnitID = EntryUnitRelation.FFromUnitID ").append("and EntryUnitRelation.FTypeRelationid = '").append("00000000-0000-0000-0000-0000000000070FE9F8B5").append("' where CoEntry.FID =Entry.FID ), ").append("FAssociateQty=FQty-FTransferedQty ").append("where CoEntry.FParentID in (").append(idStr).append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.planning.app.bizprocess.xml.copobizprocess.xml";
    }

    protected String getBillTypeId() {
        return "tMCsjuu0TMO+jMoUTkrsSkY+1VI=";
    }

    private String getResource(Context ctx, String resourceName) {
        String resourcePath = "com.kingdee.eas.mm.planning.CooperatePlanOrderResource";
        return ResourceBase.getString((String)resourcePath, (String)resourceName, (Locale)ctx.getLocale());
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    public BatchActionResults batchClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("CLOSED"));
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CooperatePlanOrderInfo info = (CooperatePlanOrderInfo)model;
        IObjectPK pk = super._submit(ctx, model);
        boolean isAutoAudit = false;
        String orgUnitID = info.getStorageOrgUnit().getId().toString();
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String strAutoAudit = scmParam.getParamByBillTypeID("MM_Submit_02", 4, orgUnitID, this.getBillTypeId());
        if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equals("1")) {
            isAutoAudit = true;
        }
        if (isAutoAudit) {
            this.auditAndLog(ctx, pk, info.getBOSType(), info.getNumber(), "mm_COPlanOrder_audit");
        }
        return pk;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        this.batchAudit(ctx, entrys);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        this.batchUnAudit(ctx, entrys);
    }

    protected boolean _checkOtherWhenDel(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CooperatePlanOrderInfo coPlanOrder = (CooperatePlanOrderInfo)model;
        if (BillBaseStatusEnum.RELEASED.equals((Object)coPlanOrder.getBaseStatus())) {
            throw new SCMBillException(SCMBillException.CHECKRELEASEDOK, new Object[]{coPlanOrder.getNumber(), ""});
        }
        return true;
    }

    @Override
    protected Date _getValidateCalendar(Context ctx, String storageOrgUnitId, Date srcDate, int offset) throws BOSException, EASBizException {
        Date result;
        block7: {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String sDate = null;
            result = new Date();
            if (srcDate == null) {
                return result;
            }
            sDate = sdf.format(srcDate);
            result = srcDate;
            int dateType = 0;
            int nextWorkDaySeq = 0;
            StringBuffer sql = new StringBuffer();
            sql.append("select FWorkDate, FDateType, FNextWorkDaySeq ").append("from T_MM_FactoryCalendarEntry t1 ").append("LEFT JOIN T_MM_FactoryCalendar t2 ON t1.FParentID=t2.FID ").append("where t1.FWorkDateSeq=").append("(select case when s1.FWorkDateSeq>0 then s1.FWorkDateSeq else s1.FNextWorkDaySeq end+ ").append(offset).append(" as FWorkDateSeq from T_MM_FactoryCalendarEntry s1 ").append("LEFT JOIN T_MM_FactoryCalendar s2 ON s1.FParentID=s2.FID ").append("where s2.FStorageOrgUnitID='").append(storageOrgUnitId).append("' ").append(" and s1.FworkDate=to_date('").append(sDate).append("')) ").append(" and t2.FStorageOrgUnitID='").append(storageOrgUnitId).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null) {
                return result;
            }
            try {
                if (rs.next()) {
                    dateType = rs.getInt("FDateType");
                    if (dateType == 1 || dateType == 4) {
                        result = rs.getDate("FWorkDate");
                    } else {
                        nextWorkDaySeq = rs.getInt("FNextWorkDaySeq");
                        rs = null;
                        sql.setLength(0);
                        sql.append("select FWorkDate from T_MM_FactoryCalendarEntry t1 ").append("LEFT JOIN T_MM_FactoryCalendar t2 ON t1.FParentID=t2.FID ").append("where t1.FworkDateSeq= ").append(nextWorkDaySeq).append(" and t2.FStorageOrgUnitID='").append(storageOrgUnitId).append("'");
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        rs.next();
                        result = rs.getDate("FWorkDate");
                    }
                    break block7;
                }
                return result;
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        return result;
    }

    @Override
    protected boolean _isAuditWhenSubmit(Context ctx, String coPlanOrderID) throws BOSException, EASBizException {
        boolean isAutoAudit = false;
        String orgUnitID = null;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select T.FID COPOID, T.FStorageOrgUnitID StorageOrgUnitID ").append("from T_MM_CooperatePlanOrder T ").append("where T.FID = '").append(coPlanOrderID).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        try {
            rs.next();
            orgUnitID = rs.getString("StorageOrgUnitID");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String strAutoAudit = scmParam.getParamByBillTypeNumber("MM_Submit_02", 4, orgUnitID, "MM002");
        if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equals("1")) {
            isAutoAudit = true;
        }
        return isAutoAudit;
    }

    @Override
    protected List _getValidateCalendar(Context ctx, String storageOrgUnitId, List dateParams) throws BOSException, EASBizException {
        LinkedList<Date> endDates = new LinkedList<Date>();
        Map dateParam = null;
        Date srcDate = null;
        Date endDate = null;
        int offset = 0;
        for (int i = 0; i < dateParams.size(); ++i) {
            dateParam = (Map)dateParams.get(i);
            srcDate = (Date)dateParam.get("srcDate");
            offset = (Integer)dateParam.get("offset");
            endDate = this._getValidateCalendar(ctx, storageOrgUnitId, srcDate, offset);
            endDates.add(endDate);
        }
        return endDates;
    }
}

