/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.CooperatePlanOrderCloseEnum;
import com.kingdee.eas.mm.planning.CooperatePlanOrderEntryFactory;
import com.kingdee.eas.mm.planning.CooperatePlanOrderEntryInfo;
import com.kingdee.eas.mm.planning.CooperatePlanOrderFactory;
import com.kingdee.eas.mm.planning.CooperatePlanOrderInfo;
import com.kingdee.eas.mm.planning.ICooperatePlanOrder;
import com.kingdee.eas.mm.planning.ICooperatePlanOrderEntry;
import com.kingdee.eas.mm.planning.IReqPlanReceiveReqDataFacade;
import com.kingdee.eas.mm.planning.ReqPlanReceiveReqDataFacadeFactory;
import com.kingdee.eas.mm.planning.app.AbstractCooperatePlanOrderEntryControllerBean;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CooperatePlanOrderEntryControllerBean
extends AbstractCooperatePlanOrderEntryControllerBean
implements IBatchExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.CooperatePlanOrderEntryControllerBean");

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICooperatePlanOrderEntry iCoPoEntry = CooperatePlanOrderEntryFactory.getLocalInstance(ctx);
        CooperatePlanOrderEntryInfo coPlanOrderEntry = (CooperatePlanOrderEntryInfo)iCoPoEntry.getValue(pk);
        ICooperatePlanOrder iCoPlanOrder = CooperatePlanOrderFactory.getLocalInstance(ctx);
        ObjectUuidPK orderPK = new ObjectUuidPK(coPlanOrderEntry.getParent().getId());
        CooperatePlanOrderInfo coPlanOrder = iCoPlanOrder.getCooperatePlanOrderInfo((IObjectPK)orderPK);
        String number = "";
        if (coPlanOrder != null) {
            number = coPlanOrder.getNumber() + "/" + coPlanOrderEntry.getSeq();
        }
        return number;
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.getBizAction().equalsIgnoreCase("CLOSED")) {
            this.closeBatchCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("UNCLOSED")) {
            this.unCloseBatchCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("RELEASED")) {
            this.releaseBatchCheck(ctx, batchResults);
        }
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.getToDoIdsArray().length > 0) {
            if (batchAction.getBizAction().equalsIgnoreCase("CLOSED")) {
                this.afterClose(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("UNCLOSED")) {
                this.afterUnClose(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("RELEASED")) {
                this.afterRelease(ctx, batchResults);
            }
        }
    }

    private void closeBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        String msg = null;
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                ObjectUuidPK orderPK;
                CooperatePlanOrderEntryInfo coPlanOrderEntry = (CooperatePlanOrderEntryInfo)collection.getObject(i);
                String id = coPlanOrderEntry.getId() == null ? "NEWID" : coPlanOrderEntry.getId().toString();
                ICooperatePlanOrder iCoPlanOrder = CooperatePlanOrderFactory.getLocalInstance(ctx);
                CooperatePlanOrderInfo coPlanOrder = iCoPlanOrder.getCooperatePlanOrderInfo((IObjectPK)(orderPK = new ObjectUuidPK(coPlanOrderEntry.getParent().getId())));
                if (BillBaseStatusEnum.AUDITED.equals((Object)coPlanOrder.getBaseStatus()) || BillBaseStatusEnum.RELEASED.equals((Object)coPlanOrder.getBaseStatus())) continue;
                msg = this.getResource(ctx, "BILL_NOT_AUDITED_OR_RELEASED");
                batchResults.addError(id, msg);
            }
        }
    }

    private void unCloseBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    private void releaseBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sql = new StringBuffer();
        String msgInfo = "";
        sql.append("select \n");
        sql.append("poEntry.fid as poEntryID, M.FStatus as mStatus, mp.fstatus as mpStatus, mi.fstatus as miStatus,\n");
        sql.append("storage.fname_").append(ctx.getLocale()).append(" as storageName, \n");
        sql.append("m.fname_").append(ctx.getLocale()).append(" as materialName\n");
        sql.append("from T_MM_CooperatePlanOrder po\n");
        sql.append("inner join T_MM_CooperatePlanOrderEntry poEntry on poEntry.fParentId = po.fId\n");
        sql.append("inner join T_ORG_Storage storage on storage.fid = poEntry.FSupplyOrgUnitId\n");
        sql.append("left outer join T_BD_Material M on po.fmaterialId = M.fId\n");
        sql.append("left outer join T_BD_MaterialInventory MI ").append("on MI.ForgUnit = poEntry.FSupplyOrgUnitID and po.fmaterialId = MI.fmaterialId\n");
        sql.append("left outer join T_bd_materialplan mp ").append("on MP.ForgUnit = poEntry.FSupplyOrgUnitID and po.fmaterialId = MP.fmaterialId\n");
        sql.append(" where poEntry.fid in (").append(idStr).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (1 == rs.getInt("mpStatus") && 1 == rs.getInt("miStatus") && 1 == rs.getInt("mStatus")) continue;
                msgInfo = MessageFormat.format(this.getResource(ctx, "MATERIAL_AUDIT_CHECK"), rs.getString("materialName"), rs.getString("storageName"));
                batchResults.addError(rs.getString("poEntryID"), msgInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public BatchActionResults batchClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("CLOSED"));
    }

    public BatchActionResults batchUnClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("UNCLOSED"));
    }

    public BatchActionResults batchRelease(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("RELEASED"));
    }

    @Override
    protected void _close(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        this.batchClose(ctx, entrys);
    }

    private void afterClose(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        String entryIds = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String[] sqls = new String[1];
        updateSql.append("update T_MM_CooperatePlanOrderEntry ").append("set FCloseStatus = ").append(30).append(" where FID in (").append(entryIds).append(")");
        sqls[0] = updateSql.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        this.transferRequirement(ctx, batchResults, BizActionEnum.CLOSE);
        updateSql.setLength(0);
        updateSql.append("select T.FID CoPlanOrderID from T_MM_CooperatePlanOrder T ").append("left outer join T_MM_CooperatePlanOrderEntry ENTRIES on T.FID = ENTRIES.FParentID ").append("where ENTRIES.FID in (").append(entryIds).append(") group by T.FID ");
        IRowSet coPlanOrderSet = DbUtil.executeQuery((Context)ctx, (String)updateSql.toString());
        try {
            while (coPlanOrderSet.next()) {
                boolean hasUnClosedEntry = false;
                ICooperatePlanOrder iCoPlanOrder = CooperatePlanOrderFactory.getLocalInstance(ctx);
                ObjectUuidPK orderPK = new ObjectUuidPK(coPlanOrderSet.getString("CoPlanOrderID"));
                CooperatePlanOrderInfo coPlanOrder = iCoPlanOrder.getCooperatePlanOrderInfo((IObjectPK)orderPK);
                for (int j = 0; j < coPlanOrder.getEntries().size(); ++j) {
                    if (!coPlanOrder.getEntries().get(j).getCloseStatus().equals((Object)CooperatePlanOrderCloseEnum.UNCLOSED)) continue;
                    hasUnClosedEntry = true;
                    break;
                }
                if (hasUnClosedEntry) continue;
                updateSql.setLength(0);
                updateSql.append("update T_MM_CooperatePlanOrder ").append("set FBaseStatus = ").append(7).append(" where FID = '").append(coPlanOrder.getId().toString()).append("'");
                sqls[0] = updateSql.toString();
                SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void afterUnClose(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sqlBuffer = new StringBuffer();
        String[] sqls = new String[1];
        sqlBuffer.setLength(0);
        sqlBuffer.append("UPDATE T_MM_CooperatePlanOrderEntry ").append("SET FCLOSESTATUS = ").append(10).append(" WHERE FID in (").append(idStr).append(")");
        sqls[0] = sqlBuffer.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        sqlBuffer.setLength(0);
        this.transferRequirement(ctx, batchResults, BizActionEnum.UNCLOSE);
        sqlBuffer.setLength(0);
        sqlBuffer.append("select T.FID CoPlanOrderID from T_MM_CooperatePlanOrder T ").append("left outer join T_MM_CooperatePlanOrderEntry ENTRIES on T.FID = ENTRIES.FParentID ").append("where ENTRIES.FID in (").append(idStr).append(") ").append("and T.FBaseStatus = 7 group by T.FID ");
        IRowSet coPlanOrderSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        try {
            while (coPlanOrderSet.next()) {
                int statusAfterUnClose = 4;
                boolean hasReleasedEntry = false;
                ICooperatePlanOrder iCoPlanOrder = CooperatePlanOrderFactory.getLocalInstance(ctx);
                ObjectUuidPK orderPK = new ObjectUuidPK(coPlanOrderSet.getString("CoPlanOrderID"));
                CooperatePlanOrderInfo coPlanOrder = iCoPlanOrder.getCooperatePlanOrderInfo((IObjectPK)orderPK);
                for (int j = 0; j < coPlanOrder.getEntries().size(); ++j) {
                    if (!coPlanOrder.getEntries().get(j).isIsReleased()) continue;
                    hasReleasedEntry = true;
                    break;
                }
                if (hasReleasedEntry) {
                    statusAfterUnClose = 5;
                }
                sqlBuffer.setLength(0);
                sqlBuffer.append("update T_MM_CooperatePlanOrder ").append("set FBaseStatus = ").append(statusAfterUnClose).append(" where FID = '").append(coPlanOrder.getId().toString()).append("'");
                sqls[0] = sqlBuffer.toString();
                SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void afterRelease(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sqlBuffer = new StringBuffer();
        String[] sqls = new String[1];
        this.transferRequirement(ctx, batchResults, BizActionEnum.ENTRYRELEASE);
        sqlBuffer.setLength(0);
        sqlBuffer.append("UPDATE T_MM_CooperatePlanOrderEntry ").append("SET FISRELEASED = ").append(1).append(" WHERE FID in (").append(idStr).append(")");
        sqls[0] = sqlBuffer.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        sqlBuffer.setLength(0);
        sqlBuffer.append("UPDATE T_MM_CooperatePlanOrder ").append("SET FBASESTATUS = ").append(5).append(" WHERE FID in (").append("SELECT distinct T.FID from T_MM_CooperatePlanOrder T ").append("inner join T_MM_CooperatePlanOrderEntry ENTRIES on T.FID = ENTRIES.FPARENTID ").append("WHERE ENTRIES.FID in (").append(idStr).append(")").append(")");
        sqls[0] = sqlBuffer.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    private void transferRequirement(Context ctx, BatchActionResults batchResults, BizActionEnum bizActionEnum) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        IReqPlanReceiveReqDataFacade reqPlanReceiveReqDataFacade = ReqPlanReceiveReqDataFacadeFactory.getLocalInstance(ctx);
        reqPlanReceiveReqDataFacade.receiveReqPlanDate("tMCsjuu0TMO+jMoUTkrsSkY+1VI=", idStr, bizActionEnum);
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.planning.app.bizprocess.xml.copoentrybizprocess.xml";
    }

    protected String getBillTypeId() {
        return "tMCsjuu0TMO+jMoUTkrsSkY+1VI=";
    }

    private String getResource(Context ctx, String resourceName) {
        String resourcePath = "com.kingdee.eas.mm.planning.CooperatePlanOrderResource";
        return ResourceBase.getString((String)resourcePath, (String)resourceName, (Locale)ctx.getLocale());
    }

    @Override
    protected void _release(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        this.batchRelease(ctx, entrys);
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        this.batchUnClose(ctx, entrys);
    }

    private String createTmpReqPlanDataTable(Context ctx) throws BOSException {
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append(" CREATE TABLE tmpReqPlanData (");
        createTableSQL.append(" fID varchar(44),");
        createTableSQL.append(" FSrcBillID varchar(44),");
        createTableSQL.append(" FSrcBILLTYPEID varchar(44),");
        createTableSQL.append(" FSrcEntryID varchar(44),");
        createTableSQL.append(" fStorageOrgUnitID varchar(44),");
        createTableSQL.append(" fEntryStorageOrgUnitID varchar(44),");
        createTableSQL.append(" fBillID varchar(44),");
        createTableSQL.append(" FEntryID varchar(44),");
        createTableSQL.append(" fSeq INT DEFAULT 0 NOT NULL,");
        createTableSQL.append(" fNumber NVARCHAR(80),");
        createTableSQL.append(" FBILLTYPEID varchar(44),");
        createTableSQL.append(" fRequireDate DateTime,");
        createTableSQL.append(" fMaterialID varchar(44),");
        createTableSQL.append(" fUnitID varchar(44),");
        createTableSQL.append(" fBaseUnitID varchar(44),");
        createTableSQL.append(" fQty NUMERIC(21,8) not null default 0,");
        createTableSQL.append(" fBaseQty NUMERIC(21,8) not null default 0,");
        createTableSQL.append(" fOriginType INT,");
        createTableSQL.append(" fOperationType INT,");
        createTableSQL.append(" fCreatorID varchar(44),");
        createTableSQL.append(" fCreateTime DateTime,");
        createTableSQL.append(" fFailTimes INT DEFAULT 0 NOT NULL,");
        createTableSQL.append(" fProjectID varchar(44),");
        createTableSQL.append(" fTrackNumberID varchar(44))");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            return pool.createTempTable(createTableSQL.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

