/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.planning.CounteractSetFactory;
import com.kingdee.eas.mm.planning.CounteractSetInfo;
import com.kingdee.eas.mm.planning.ICounteractSet;
import com.kingdee.eas.mm.planning.app.AbstractCounteractSetControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class CounteractSetControllerBean
extends AbstractCounteractSetControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.CounteractSetControllerBean");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected IObjectValue _getValueWithSettings(Context ctx, String id) throws BOSException {
        CounteractSetInfo cs = null;
        try {
            ICounteractSet svc = CounteractSetFactory.getLocalInstance(ctx);
            cs = (CounteractSetInfo)svc.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        }
        catch (Exception e) {
            throw new BOSException("CounterSetInfo Load Error", (Throwable)e);
        }
        if (cs == null) return cs;
        IRowSet rs = null;
        try {
            String sql = "SELECT a.FBillTypeID,c.FNumber,c.FName_L1,c.FName_L2,c.FName_L3,a.FIsCounteractPID,a.FIsDefault FROM T_MM_CounteractSet a JOIN T_MM_CounteractSet b ON (a.FStorageOrgUnitID=b.FStorageOrgUnitID and a.FManuStrategyID=b.FManuStrategyID) JOIN T_SCM_BillType c ON (a.FBillTypeID=c.FID) WHERE b.FID = ? ORDER BY c.FNumber";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
            StringBuffer strSettings = new StringBuffer();
            while (rs.next()) {
                if (strSettings.length() > 0) {
                    strSettings.append(";");
                }
                strSettings.append(rs.getString(1)).append("[").append(rs.getString(2)).append("]").append("[").append(rs.getString(3)).append("]").append("[").append(rs.getString(4)).append("]").append("[").append(rs.getString(5)).append("],").append(rs.getInt(6) > 0 ? "true," : "false,").append(rs.getInt(7) > 0 ? "true" : "false");
            }
            cs._setSettings(strSettings.toString());
            if (rs == null) return cs;
        }
        catch (Exception e) {
            try {
                throw new BOSException("SQL Execution Error", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return cs;
    }

    @Override
    protected String _submitValueWithSettings(Context ctx, CounteractSetInfo value) throws BOSException, EASBizException {
        try {
            String sql = "DELETE FROM T_MM_CounteractSet WHERE FStorageOrgUnitID=? AND FManuStrategyID=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{value.getStorageOrgUnit().getId().toString(), value.getManuStrategy().getId().toString()});
        }
        catch (Exception e) {
            throw new BOSException("SQL Execution Error", (Throwable)e);
        }
        String[] recs = value._getSettings().split(";");
        ICounteractSet svc = CounteractSetFactory.getLocalInstance(ctx);
        CoreBaseCollection css = new CoreBaseCollection();
        for (int i = 0; i < recs.length; ++i) {
            CounteractSetInfo cs = new CounteractSetInfo();
            cs.setStorageOrgUnit(value.getStorageOrgUnit());
            cs.setManuStrategy(value.getManuStrategy());
            css.add((CoreBaseInfo)cs);
        }
        svc.addnew(css);
        String returnId = null;
        try {
            String sql = "UPDATE T_MM_CounteractSet SET FBillTypeID=?, FIsCounteractPID=?, FIsDefault=? WHERE FID=?";
            for (int i = 0; i < recs.length; ++i) {
                String[] parts = recs[i].split(",");
                String billTypeID = parts[0];
                int pos = billTypeID.indexOf(91);
                if (pos >= 0) {
                    billTypeID = billTypeID.substring(0, pos);
                }
                returnId = css.get(i).getId().toString();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billTypeID, new Boolean(parts[1]), new Boolean(parts[2]), returnId});
            }
        }
        catch (Exception e) {
            throw new BOSException("SQL Execution Error", (Throwable)e);
        }
        return returnId;
    }

    @Override
    protected boolean _initData(Context ctx, Object[] storageOrgIDs) throws BOSException, EASBizException {
        boolean initialized = true;
        for (int i = 0; i < storageOrgIDs.length; ++i) {
            initialized = this._initData(ctx, (String)storageOrgIDs[i]);
        }
        return initialized;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean _initData(Context ctx, String storageOrg) throws BOSException, EASBizException {
        CoreBaseCollection css;
        ICounteractSet svc;
        block7: {
            svc = CounteractSetFactory.getLocalInstance(ctx);
            StorageOrgUnitInfo soUnit = new StorageOrgUnitInfo();
            soUnit.setId(BOSUuid.read((String)storageOrg));
            css = new CoreBaseCollection();
            IRowSet rs = null;
            try {
                StringBuffer sql_NotInited = new StringBuffer();
                sql_NotInited.append(" SELECT FManuStrategyID,FBillTypeID,FIsCounteractPID,FIsDefault ");
                sql_NotInited.append(" FROM T_MM_CounteractSet AS t1 ");
                sql_NotInited.append(" WHERE (FStorageOrgUnitID IS NULL OR FStorageOrgUnitID='')");
                sql_NotInited.append(" and NOT EXISTS (SELECT 1 FROM T_MM_CounteractSet as t2 ");
                sql_NotInited.append(" where t2.FStorageOrgUnitID = ? ");
                sql_NotInited.append(" and t1.FManuStrategyID = t2.FManuStrategyID and ((t1.FBillTypeID = t2.FBillTypeID) or t2.FBillTypeID is null or t2.FBillTypeID = ''))");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql_NotInited.toString(), (Object[])new Object[]{storageOrg});
                while (rs.next()) {
                    ManufactureStrategyInfo ms = new ManufactureStrategyInfo();
                    ms.setId(BOSUuid.read((String)rs.getString(1)));
                    BillTypeInfo bt = new BillTypeInfo();
                    if (rs.getString(2) != null) {
                        bt.setId(BOSUuid.read((String)rs.getString(2)));
                    }
                    CounteractSetInfo cs = new CounteractSetInfo();
                    cs.setStorageOrgUnit(soUnit);
                    cs.setManuStrategy(ms);
                    cs.setBillType(bt);
                    cs.setIsCounteractPID(rs.getBoolean(3));
                    cs.setIsDefault(rs.getBoolean(4));
                    css.add((CoreBaseInfo)cs);
                }
                if (rs == null) break block7;
            }
            catch (Exception e) {
                try {
                    throw new BOSException("SQL Execution Error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        SQLUtils.cleanup(rs);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        svc.addnew(css);
        return true;
    }
}

